/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.hud;

import com.mojang.blaze3d.platform.Window;
import fin.starhud.config.BaseHUDSettings;
import fin.starhud.config.ConditionalSettings;
import fin.starhud.helper.Box;
import fin.starhud.hud.HUDInterface;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public abstract class AbstractHUD
implements HUDInterface {
    private static final Window WINDOW = Minecraft.m_91087_().m_91268_();
    protected final BaseHUDSettings baseHUDSettings;
    protected int x;
    protected int y;
    protected int baseX;
    protected int baseY;
    protected final Box boundingBox = new Box(0, 0);

    public AbstractHUD(BaseHUDSettings baseHUDSettings) {
        this.baseHUDSettings = baseHUDSettings;
    }

    @Override
    public boolean shouldRender() {
        return this.getSettings().shouldRender();
    }

    @Override
    public void update() {
        this.updateX();
        this.updateY();
    }

    @Override
    public boolean render(GuiGraphics context) {
        this.modifyXY();
        if (!this.isScaled()) {
            return this.renderHUD(context);
        }
        context.m_280168_().m_85836_();
        this.setHUDScale(context);
        try {
            boolean bl = this.renderHUD(context);
            return bl;
        }
        finally {
            context.m_280168_().m_85849_();
        }
    }

    public abstract String getName();

    public abstract boolean renderHUD(GuiGraphics var1);

    public abstract int getBaseHUDWidth();

    public abstract int getBaseHUDHeight();

    public void setHUDScale(GuiGraphics context) {
        float scaleFactor = (float)this.getSettings().getScale() / (float)WINDOW.m_85449_();
        context.m_280168_().m_85841_(scaleFactor, scaleFactor, scaleFactor);
    }

    public void modifyXY() {
        int tempX = 0;
        int tempY = 0;
        for (ConditionalSettings condition : this.baseHUDSettings.getConditions()) {
            if (!condition.isConditionMet()) continue;
            tempX += condition.xOffset;
            tempY += condition.yOffset;
        }
        this.x = this.baseX + tempX;
        this.y = this.baseY + tempY;
    }

    public void updateX() {
        this.baseX = this.getSettings().getCalculatedPosX() - this.getSettings().getGrowthDirectionX().getGrowthDirection(this.getBaseHUDWidth());
    }

    public void updateY() {
        this.baseY = this.getSettings().getCalculatedPosY() - this.getSettings().getGrowthDirectionY().getGrowthDirection(this.getBaseHUDHeight());
    }

    public boolean isScaled() {
        return this.getSettings().getScale() != 0 && (double)this.getSettings().getScale() / WINDOW.m_85449_() == 1.0;
    }

    public BaseHUDSettings getSettings() {
        return this.baseHUDSettings;
    }

    public int getRawX() {
        return this.getBoundingBox().getX();
    }

    public int getRawY() {
        return this.getBoundingBox().getY();
    }

    public int width() {
        return this.getBoundingBox().width();
    }

    public int getHeight() {
        return this.getBoundingBox().getHeight();
    }

    public Box getBoundingBox() {
        return this.boundingBox;
    }

    public void copyBoundingBox(Box boundingBox) {
        if (boundingBox != null) {
            this.boundingBox.copyFrom(boundingBox);
        }
    }

    public void setBoundingBox(int x, int y, int width, int height, int color) {
        this.boundingBox.setBoundingBox(x, y, width, height, color);
    }

    public void setBoundingBox(int x, int y, int width, int height) {
        this.boundingBox.setBoundingBox(x, y, width, height);
    }
}

