/*
 * Decompiled with CFR 0.152.
 */
package fin.starhud.helper;

public class Box {
    private int x;
    private int y;
    private int width;
    private int height;
    private int color;

    public Box(int x, int y, int width, int height, int color) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
    }

    public Box(int x, int y, int width, int height) {
        this(x, y, width, height, -1);
    }

    public Box(int x, int y) {
        this(x, y, 13, 13, -1);
    }

    public Box(int x, int y, int color) {
        this(x, y, 13, 13, color);
    }

    public int getHeight() {
        return this.height;
    }

    public int width() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setEmpty(boolean empty) {
        if (empty) {
            this.setWidth(-1);
            this.setHeight(-1);
        } else {
            this.setWidth(13);
            this.setHeight(13);
        }
    }

    public boolean isEmpty() {
        return this.width < 0 || this.height < 0;
    }

    public void setBoundingBox(int x, int y, int width, int height, int color) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
        this.setColor(color);
    }

    public void setBoundingBox(int x, int y, int width, int height) {
        this.setBoundingBox(x, y, width, height, this.getColor());
    }

    public void copyFrom(Box other) {
        this.x = other.x;
        this.y = other.y;
        this.width = other.width;
        this.height = other.height;
        this.color = other.color;
    }

    public void mergeWith(Box other) {
        int minX = Math.min(this.getX(), other.getX());
        int minY = Math.min(this.getY(), other.getY());
        int maxX = Math.max(this.getX() + this.width(), other.getX() + other.width());
        int maxY = Math.max(this.getY() + this.getHeight(), other.getY() + other.getHeight());
        this.setX(minX);
        this.setY(minY);
        this.setWidth(maxX - minX);
        this.setHeight(maxY - minY);
    }

    public String toString() {
        return "Box{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", color=" + this.color + "}";
    }
}

