/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.skill;

import com.aul.legendaryreb.animation.LegendaryRebAnimations;
import com.aul.legendaryreb.skill.LegendaryRebDataKeys;
import com.aul.legendaryreb.skill.LegendaryRebSkills;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class LightningFlashSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("bc41639e-0de8-11ed-810d-1919ac114294");

    public LightningFlashSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        PlayerPatch playerPatch = container.getExecuter();
        if (playerPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            this.setConsumption(container, 0.0f);
            this.setConsumptionSynchronize(serverPlayerPatch, 0.0f);
        }
        container.setResource(0.0f);
    }

    public void onRemoved(SkillContainer container) {
        PlayerPatch playerPatch = container.getExecuter();
        if (playerPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            SkillDataManager dataManager = container.getDataManager();
            ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
            dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed1.get(), (Object)Float.valueOf(0.0f), player);
            dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed2.get(), (Object)Float.valueOf(0.0f), player);
            dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed3.get(), (Object)Float.valueOf(0.0f), player);
            dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime.get(), (Object)0, player);
            dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime1.get(), (Object)0, player);
        }
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.consumeForSkill((Skill)this, Skill.Resource.STAMINA, this.consumption) || ((ServerPlayer)executer.getOriginal()).m_7500_()) {
            ServerPlayer player = (ServerPlayer)executer.getOriginal();
            SkillDataManager dataManager = executer.getSkill(LegendaryRebSkills.LightningFlash).getDataManager();
            int time = (Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashTime.get());
            if (time > 0) {
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime.get(), (Object)0, player);
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime1.get(), (Object)8, player);
                float plspeed = ((Float)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashSpeed.get())).floatValue() + 0.3f;
                executer.playAnimationSynchronized(LegendaryRebAnimations.LIGHTNING_FLASH, -0.49f);
            } else {
                executer.playAnimationSynchronized(LegendaryRebAnimations.LIGHTNING_FLASH, 0.0f);
            }
        }
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        int time = (Integer)executer.getSkill(LegendaryRebSkills.LightningFlash).getDataManager().getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashTime.get());
        return !executer.getEntityState().movementLocked() || time > 0;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager dataManager = container.getDataManager();
        PlayerPatch playerPatch = container.getExecuter();
        if (playerPatch instanceof ServerPlayerPatch) {
            int time;
            int time1;
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            this.setConsumption(container, 0.0f);
            this.setConsumptionSynchronize(serverPlayerPatch, 0.0f);
            ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashTime1.get()) && (time1 = ((Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashTime1.get())).intValue()) > 0) {
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime1.get(), (Object)(time1 - 1), player);
            }
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashTime.get()) && (time = ((Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashTime.get())).intValue()) > 0) {
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime.get(), (Object)(time - 1), player);
            }
        }
        if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed1.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed2.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed3.get())) {
            float x = ((Float)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashSpeed1.get())).floatValue();
            float y = ((Float)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashSpeed2.get())).floatValue();
            float z = ((Float)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashSpeed3.get())).floatValue();
            Vec3 speed = new Vec3((double)x, (double)y, (double)z);
            Player player = (Player)container.getExecuter().getOriginal();
            if (speed.m_82553_() != 0.0) {
                player.m_20256_(speed);
            }
        }
        container.setResource(0.0f);
        container.deactivate();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        int size = 75;
        int time = (Integer)container.getDataManager().getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashTime.get());
        int time1 = (Integer)container.getDataManager().getDataValue((SkillDataKey)LegendaryRebDataKeys.FlashTime1.get());
        if (time1 > 0) {
            size = (int)(95.0f * (1.0f - 0.5f / (float)time1));
        }
        if (time > 0 || time1 > 0) {
            Window sr = Minecraft.m_91087_().m_91268_();
            int width = sr.m_85445_();
            int height = sr.m_85446_();
            guiGraphics.m_280411_(new ResourceLocation("legendaryreb", "textures/gui/skills/lightning_flash.png"), width / 2 + 100 - size / 2, height / 2 - size / 2, size, size, 0.0f, 0.0f, 1, 1, 1, 1);
        }
        poseStack.m_85849_();
    }
}

