/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.skill;

import com.aul.legendaryreb.gamerule.LegendaryRebGamerules;
import com.aul.legendaryreb.skill.LegendaryRebDataKeys;
import com.aul.legendaryreb.skill.LegendaryRebSkills;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LegendaryInnateSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("bc08119e-0de8-11ed-810d-1919ac114334");

    public LegendaryInnateSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            SkillDataManager dataManager = container.getDataManager();
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get())) {
                float damage = event.getDamage();
                if ((Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get()) > -1) {
                    event.setDamage(damage * 2.7f);
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID, event -> {
            SkillDataManager dataManager = container.getDataManager();
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get())) {
                float speed = event.getAttackSpeed();
                if ((Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get()) > -1) {
                    event.setAttackSpeed(speed * 1.3f);
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            SkillDataManager dataManager = container.getDataManager();
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get()) && (Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get()) > -1) {
                ServerPlayerPatch playerPatch = (ServerPlayerPatch)event.getPlayerPatch();
                ServerPlayer serverPlayer = (ServerPlayer)playerPatch.getOriginal();
                FoodData foodData = serverPlayer.m_36324_();
                int foodlevel = foodData.m_38702_();
                float stamina = playerPatch.getStamina();
                foodData.m_38705_(foodlevel - 2);
                playerPatch.setStamina(stamina - 2.0f);
            }
        });
        if (!container.getExecuter().isLogicalClient()) {
            this.setConsumption(container, 10.0f);
            this.setConsumptionSynchronize((ServerPlayerPatch)container.getExecuter(), 10.0f);
        }
        container.setResource(10.0f);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.consumeForSkill((Skill)this, Skill.Resource.STAMINA, this.consumption) || ((ServerPlayer)executer.getOriginal()).m_7500_()) {
            ServerPlayer player = (ServerPlayer)executer.getOriginal();
            ServerLevel level = (ServerLevel)player.m_9236_();
            Vec3 pos = player.m_20182_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_, pos.f_82480_ + 1.5, pos.f_82481_, 20, 0.0, 1.0, 1.0, 1.0);
            player.m_21220_().forEach(mobEffectInstance -> {
                if (mobEffectInstance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
                    player.m_21195_(mobEffectInstance.m_19544_());
                }
            });
            executer.getSkill(LegendaryRebSkills.LegendaryInnate).getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get(), (Object)340, player);
        }
        super.executeOnServer(executer, args);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        SkillDataManager dataManager = executer.getSkill(LegendaryRebSkills.LegendaryInnate).getDataManager();
        boolean canuse = false;
        if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get()) && (Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get()) < 5) {
            canuse = true;
        }
        return canuse;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        int wktime;
        SkillDataManager dataManager = container.getDataManager();
        PlayerPatch playerPatch = container.getExecuter();
        if (playerPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            this.setConsumption(container, 10.0f);
            this.setConsumptionSynchronize(serverPlayerPatch, 10.0f);
        }
        if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get()) && (wktime = ((Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get())).intValue()) > -1) {
            --wktime;
            Player player = (Player)playerPatch.getOriginal();
            Level level = player.m_9236_();
            OpenMatrix4f transformMatrix = playerPatch.getArmature().getBindedTransformFor(playerPatch.getAnimator().getPose(0.0f), Armatures.BIPED.toolR);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, -0.3f));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(player.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            Vec3 vec0 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, -0.6f));
            Vec3 z = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            transformMatrix.translate(new Vec3f(0.3f, 0.0f, 0.6f));
            Vec3 x = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            transformMatrix.translate(new Vec3f(-0.3f, 0.3f, 0.0f));
            Vec3 y = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            vec0 = vec0.m_82549_(player.m_20182_());
            x = x.m_82541_().m_82490_(0.3);
            y = y.m_82541_().m_82490_(0.7);
            z = z.m_82541_().m_82490_(0.5);
            Random random = new Random();
            DustParticleOptions options = new DustParticleOptions(new Vector3f(0.0f, 0.98f, 1.0f), 1.5f);
            for (int i = 0; i < 7; ++i) {
                Vec3 vec3 = vec0.m_82549_(x.m_82490_(random.nextDouble(-1.0, 1.0))).m_82549_(y.m_82490_(random.nextDouble(-1.0, 1.0))).m_82549_(z.m_82490_((double)i));
                level.m_7106_((ParticleOptions)options, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
                FoodData foodData = serverPlayer.m_36324_();
                int foodlevel = foodData.m_38702_();
                float stamina = serverPlayerPatch.getStamina();
                if (serverPlayerPatch.getEntityState().movementLocked()) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    boolean ifbreak = serverLevel.m_46469_().m_46207_(LegendaryRebGamerules.doLegendaryAttackBreakBlock);
                    System.out.print(ifbreak);
                    if (ifbreak) {
                        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                        for (int i = 0; i < 9; ++i) {
                            BlockState block = serverLevel.m_8055_((BlockPos)(pos = pos.m_122169_(vec0.f_82479_, vec0.f_82480_, vec0.f_82481_)));
                            if (!block.m_60795_() && !block.m_60713_(Blocks.f_50626_) && block.m_60800_((BlockGetter)serverLevel, (BlockPos)pos) > 0.0f) {
                                serverLevel.m_46961_((BlockPos)pos, true);
                            }
                            vec0 = vec0.m_82549_(z);
                        }
                    }
                }
                if (stamina * (float)foodlevel <= 0.0f) {
                    wktime = 0;
                } else if (wktime % 25 == 0) {
                    foodData.m_38705_(foodlevel - 2);
                    serverPlayerPatch.setStamina(stamina - 4.5f);
                }
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get(), (Object)wktime, serverPlayer);
            } else if (player instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)player;
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get(), (Object)wktime, localPlayer);
            }
        }
        container.setResource(10.0f);
        container.deactivate();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        int wktime = -1;
        SkillDataManager dataManager = container.getDataManager();
        if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get())) {
            wktime = (Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.LgdsWkTick.get());
        }
        if (wktime > -1) {
            String s = String.format("%.0f", Math.ceil((double)wktime / 20.0));
            guiGraphics.m_280056_(gui.font, s, width - 30 - s.length() * 2, height - 35, 64255, true);
        }
        poseStack.m_85849_();
    }
}

