/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.skill;

import com.aul.legendaryreb.animation.LegendaryRebAnimations;
import com.aul.legendaryreb.gamerule.LegendaryRebGamerules;
import com.aul.legendaryreb.net.LegendaryRebModVariables;
import com.aul.legendaryreb.particle.FireTachiFlameParticleOptions;
import com.aul.legendaryreb.skill.LegendaryRebDataKeys;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.WOMAnimations;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class FireTachiPassiveSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("bc60899e-0de8-11ed-810d-1919ac114514");

    public FireTachiPassiveSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            DamageSource damageSource = (DamageSource)event.getDamageSource();
            PlayerPatch playerPatch = event.getPlayerPatch();
            boolean invul = false;
            if (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
                invul = true;
            }
            if (playerPatch.isBattleMode() && playerPatch.getAnimator().getPlayerFor(null).getAnimation() instanceof AttackAnimation && playerPatch.getEntityState().inaction()) {
                invul = true;
            }
            if (((LegendaryRebModVariables.PlayerVariables)((ServerPlayer)playerPatch.getOriginal()).getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new LegendaryRebModVariables.PlayerVariables())).player_fire_attack < 9) {
                invul = true;
            }
            if (damageSource instanceof EpicFightDamageSource) {
                EpicFightDamageSource epicFightDamageSource = (EpicFightDamageSource)damageSource;
                epicFightDamageSource.setStunType(StunType.NONE);
                epicFightDamageSource.setImpact(0.0f);
            }
            if (invul) {
                event.setAmount(0.0f);
                event.setResult(AttackResult.ResultType.MISSED);
                event.setCanceled(true);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            SkillDataManager dataManager = container.getDataManager();
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FireSheath.get())) {
                float damage = event.getDamage();
                if (((Boolean)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FireSheath.get())).booleanValue()) {
                    event.setDamage(damage * 0.7f);
                } else {
                    event.setDamage(damage * 1.7f);
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID, event -> {
            SkillDataManager dataManager = container.getDataManager();
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FireSheath.get())) {
                float speed = event.getAttackSpeed();
                if (((Boolean)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FireSheath.get())).booleanValue()) {
                    event.setAttackSpeed(speed * 1.3f);
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID, event -> {
            PlayerPatch patt5321$temp;
            if (event.getAnimation() != WOMAnimations.KATANA_SHEATHE && (patt5321$temp = event.getPlayerPatch()) instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)patt5321$temp;
                SkillDataManager dataManager = container.getDataManager();
                if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FireChange.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FireSheath.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FireChanged.get()) && ((Boolean)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FireChanged.get())).booleanValue()) {
                    ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FireSheath.get(), (Object)true, serverPlayer);
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChange.get(), (Object)false, serverPlayer);
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChanged.get(), (Object)false, serverPlayer);
                    serverPlayer.m_21195_(MobEffects.f_19591_);
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            SkillDataManager dataManager = container.getDataManager();
            LivingEntity entity = event.getTarget();
            Level level = entity.m_9236_();
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FireSheath.get()) && !((Boolean)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FireSheath.get())).booleanValue()) {
                float damage = (int)Math.ceil((double)event.getAttackDamage() * 0.3);
                int prevInvulTime = entity.f_19802_;
                entity.f_19802_ = 0;
                entity.m_6469_(new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268631_)), damage);
                entity.f_19802_ = prevInvulTime;
            }
            entity.m_20254_(2 + entity.m_20094_() / 20);
        });
        Player entity = (Player)container.getExecuter().getOriginal();
        entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.player_last_trail = new ArrayList();
            capability.syncPlayerVariables((Entity)entity);
        });
        entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.player_fire_attack = 10;
            capability.syncPlayerVariables((Entity)entity);
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        Player entity = (Player)container.getExecuter().getOriginal();
        entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.player_last_trail = new ArrayList();
            capability.syncPlayerVariables((Entity)entity);
        });
        entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.player_fire_attack = 10;
            capability.syncPlayerVariables((Entity)entity);
        });
    }

    public void updateContainer(SkillContainer container) {
        StaticAnimation[] SkillAttackAnimations;
        Level level;
        Player entity;
        PlayerPatch playerPatch;
        block21: {
            Vec3 vec3;
            Vec3 vec2;
            Vec3 vec0;
            Vec3 vec1;
            FireTachiFlameParticleOptions options;
            float theta;
            block19: {
                block20: {
                    super.updateContainer(container);
                    playerPatch = container.getExecuter();
                    entity = (Player)playerPatch.getOriginal();
                    level = entity.m_9236_();
                    SkillAttackAnimations = new StaticAnimation[]{LegendaryRebAnimations.FIRE_DASH, LegendaryRebAnimations.FIRE_AUTO_1, LegendaryRebAnimations.FIRE_AUTO_2, LegendaryRebAnimations.FIRE_AUTO_3, LegendaryRebAnimations.FIRE_AUTO_4, LegendaryRebAnimations.FIRE_AUTO_5, LegendaryRebAnimations.FIRE_AUTO_6, LegendaryRebAnimations.FIRE_AUTO_7, LegendaryRebAnimations.FIRE_AIR_SLASH};
                    if (!playerPatch.getEntityState().inaction() && !((LegendaryRebModVariables.PlayerVariables)entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new LegendaryRebModVariables.PlayerVariables())).player_last_trail.isEmpty()) {
                        entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                            capability.player_last_trail = new ArrayList();
                            capability.syncPlayerVariables((Entity)entity);
                        });
                    }
                    theta = ((Float)container.getDataManager().getDataValue((SkillDataKey)LegendaryRebDataKeys.FireTheta.get())).floatValue();
                    options = new FireTachiFlameParticleOptions(0.45f, 1.0f, 1.0f, 1.0f);
                    if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)LegendaryRebDataKeys.FireSheath.get())).booleanValue()) break block19;
                    vec1 = Vec3.m_82498_((float)0.0f, (float)entity.f_20883_);
                    vec0 = new Vec3(entity.m_20185_() - vec1.f_82479_ * 0.6, entity.m_20186_() + 1.4, entity.m_20189_() - vec1.f_82481_ * 0.6);
                    vec2 = Vec3.m_82498_((float)0.0f, (float)(entity.f_20883_ + 90.0f));
                    for (int i = 0; i < 20; ++i) {
                        level.m_7106_((ParticleOptions)options, vec0.f_82479_ + Math.cos(theta) * vec2.f_82479_ * 0.8, vec0.f_82480_ + Math.sin(theta) * 0.8, vec0.f_82481_ + Math.cos(theta) * vec2.f_82481_ * 0.8, 0.0, 0.0, 0.0);
                        theta += 0.31415927f;
                        if (!((double)theta > Math.PI * 2)) continue;
                        theta = (float)((double)theta - Math.PI * 2);
                    }
                    if (!(entity instanceof ServerPlayer)) break block20;
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireTheta.get(), (Object)Float.valueOf(theta + 0.01308997f), serverPlayer);
                    break block21;
                }
                if (!(entity instanceof LocalPlayer)) break block21;
                LocalPlayer localPlayer = (LocalPlayer)entity;
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireTheta.get(), (Object)Float.valueOf(theta + (float)Math.PI / 360), localPlayer);
                break block21;
            }
            OpenMatrix4f transformMatrix = playerPatch.getArmature().getBindedTransformFor(playerPatch.getAnimator().getPose(0.0f), Armatures.BIPED.toolR);
            transformMatrix.translate(new Vec3f(0.0f, 0.1f, 0.0f));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            vec0 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, 0.3f));
            vec1 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            transformMatrix.translate(new Vec3f(0.3f, 0.0f, -0.3f));
            vec2 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            vec0 = vec0.m_82549_(entity.m_20182_());
            for (int i = 0; i < 8; ++i) {
                vec3 = vec1.m_82490_(Math.cos(theta)).m_82549_(vec2.m_82490_(Math.sin(theta)));
                level.m_7106_((ParticleOptions)options, vec0.f_82479_ + vec3.f_82479_, vec0.f_82480_ + vec3.f_82480_, vec0.f_82481_ + vec3.f_82481_, 0.0, 0.0, 0.0);
                theta += 0.7853982f;
                if (!((double)theta > Math.PI * 2)) continue;
                theta -= (float)Math.PI * 2;
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireTheta.get(), (Object)Float.valueOf(theta + 0.02617994f), serverPlayer);
            } else if (entity instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)entity;
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireTheta.get(), (Object)Float.valueOf(theta + (float)Math.PI / 180), localPlayer);
            }
            transformMatrix = playerPatch.getArmature().getBindedTransformFor(playerPatch.getAnimator().getPose(0.0f), Armatures.BIPED.toolL);
            transformMatrix.translate(new Vec3f(0.0f, 0.1f, 0.0f));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            vec0 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, -0.3f));
            vec1 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            transformMatrix.translate(new Vec3f(0.3f, 0.0f, 0.3f));
            vec2 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            vec0 = vec0.m_82549_(entity.m_20182_());
            for (int i = 0; i < 8; ++i) {
                vec3 = vec1.m_82490_(Math.cos(theta)).m_82549_(vec2.m_82490_(Math.sin(theta)));
                level.m_7106_((ParticleOptions)options, vec0.f_82479_ + vec3.f_82479_, vec0.f_82480_ + vec3.f_82480_, vec0.f_82481_ + vec3.f_82481_, 0.0, 0.0, 0.0);
                theta += 0.7853982f;
                if (!((double)theta > Math.PI * 2)) continue;
                theta -= (float)Math.PI * 2;
            }
        }
        int skillattack = ((LegendaryRebModVariables.PlayerVariables)entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new LegendaryRebModVariables.PlayerVariables())).player_fire_attack;
        if (skillattack < 10) {
            Vec3 center = new Vec3(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
            List<LivingEntity> entityList = level.m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(30.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(center))).toList();
            Vec3 vec4 = entity.m_20184_();
            Vec3 vec3 = new Vec3(0.0, 0.0, 0.0);
            boolean block = false;
            if (entityList.size() > 1) {
                for (LivingEntity livingEntity : entityList) {
                    if (livingEntity == entity || !livingEntity.m_6084_()) continue;
                    vec3 = new Vec3(0.0, (double)livingEntity.m_20206_() * 0.1, 0.0);
                    vec3 = livingEntity.m_20182_().m_82549_(vec3).m_82546_(entity.m_20182_()).m_82541_();
                    block = true;
                    break;
                }
            } else {
                vec3 = entity.m_20252_(1.0f);
            }
            Vec3 speed = new Vec3(vec3.f_82479_ * 1.21 + vec4.f_82479_ * 0.6, vec3.f_82480_ * 1.21 + vec4.f_82480_ * 0.3, vec3.f_82481_ * 1.21 + vec4.f_82481_ * 0.6).m_82541_();
            if (level.m_46469_().m_46207_(LegendaryRebGamerules.doLegendaryAttackBreakBlock)) {
                BlockPos pos1 = BlockPos.m_274446_((Position)entity.m_20182_().m_82549_(speed).m_82520_(0.0, 0.5, 0.0));
                BlockPos pos2 = BlockPos.m_274446_((Position)entity.m_20182_().m_82549_(speed).m_82520_(0.0, 1.5, 0.0));
                BlockState state1 = level.m_8055_(pos1);
                BlockState state2 = level.m_8055_(pos2);
                if (block && level instanceof ServerLevel) {
                    if (!state1.m_60795_() && state1.m_60800_((BlockGetter)level, pos1) > 0.0f) {
                        level.m_46961_(pos1, true);
                    }
                    if (!state2.m_60795_() && state2.m_60800_((BlockGetter)level, pos2) > 0.0f) {
                        level.m_46961_(pos2, true);
                    }
                }
            }
            if (entity.m_20184_().m_82553_() < 1.7) {
                float yrot = Mth.m_14177_((float)entity.m_146908_());
                playerPatch.setModelYRot(Mth.m_14177_((float)((float)MathUtils.getYRotOfVector((Vec3)vec3) - yrot)) + yrot, true);
                entity.m_20256_(speed.m_82490_(2.3));
            }
            if (!playerPatch.getEntityState().movementLocked()) {
                if (skillattack < 9) {
                    float yrot = Mth.m_14177_((float)entity.m_146908_());
                    playerPatch.setModelYRot(Mth.m_14177_((float)((float)MathUtils.getYRotOfVector((Vec3)vec3) - yrot)) + yrot, true);
                    playerPatch.playAnimationSynchronized(SkillAttackAnimations[skillattack], 0.0f);
                }
                entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    capability.player_fire_attack = skillattack + 1;
                    capability.syncPlayerVariables((Entity)entity);
                });
            }
        }
    }
}

