/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.skill;

import com.aul.legendaryreb.animation.LegendaryRebAnimations;
import com.aul.legendaryreb.entity.FireFakeSword;
import com.aul.legendaryreb.entity.LegendaryRebEntities;
import com.aul.legendaryreb.net.LegendaryRebModVariables;
import com.aul.legendaryreb.skill.LegendaryRebDataKeys;
import com.aul.legendaryreb.skill.LegendaryRebSkills;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class FireTachiInnateSkill
extends WeaponInnateSkill {
    int[] color = new int[]{0xFFFFFF, 16757637, 16747591, 0xFF5F00};

    public FireTachiInnateSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            this.setConsumption(container, 0.0f);
            this.setConsumptionSynchronize((ServerPlayerPatch)container.getExecuter(), 0.0f);
        }
        container.setResource(0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        LocalPlayer player = (LocalPlayer)executer.getOriginal();
        Input input = player.f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)player)), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int act = 0;
        act += input.f_108568_ ? -1 : 0;
        int n = input.f_108569_ ? 2 : 0;
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(act += n);
        return packet;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        block8: {
            ServerPlayer entity;
            block9: {
                int act;
                block11: {
                    block10: {
                        if (!executer.consumeForSkill((Skill)this, Skill.Resource.STAMINA, this.consumption) && !((ServerPlayer)executer.getOriginal()).m_7500_()) break block8;
                        entity = (ServerPlayer)executer.getOriginal();
                        if (!((Boolean)executer.getSkill(LegendaryRebSkills.FireTachiPassive).getDataManager().getDataValue((SkillDataKey)LegendaryRebDataKeys.FireSheath.get())).booleanValue()) break block9;
                        if (!entity.m_6117_()) break block10;
                        entity.m_20331_(true);
                        executer.getSkill(LegendaryRebSkills.FireTachiPassive).getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireSheath.get(), (Object)false, entity);
                        executer.playAnimationSynchronized(LegendaryRebAnimations.FIRE_OUT_DRAW, -0.4f);
                        break block8;
                    }
                    act = args.readInt();
                    if (act != 0) break block11;
                    FireTachiInnateSkill.FireFakeSwordShoot(new Vec3(entity.m_20185_(), entity.m_20188_() - 0.1, entity.m_20189_()), entity.m_20154_(), (LivingEntity)entity, entity.m_9236_(), 0, 19.0f);
                    break block8;
                }
                if (act == -1) {
                    executer.getSkill(LegendaryRebSkills.FireTachiInnate).getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireSword.get(), (Object)34, entity);
                    break block8;
                } else if (act == 1) {
                    Vec3 pos = new Vec3(entity.m_20185_(), entity.m_20188_() - 0.1, entity.m_20189_());
                    Vec3 location = this.Aim((LivingEntity)entity, pos, pos, 13.0).m_82520_(0.0, 13.0, 0.0).m_82549_(pos);
                    Random random = new Random();
                    for (int i = 0; i < 19; ++i) {
                        Vec3 loc = location.m_82520_((double)random.nextFloat(-6.0f, 6.0f), 0.0, (double)random.nextFloat(-6.0f, 6.0f));
                        Vec3 speed = location.m_82546_(loc).m_82541_().m_82490_(0.3).m_82520_(0.0, -1.0, 0.0);
                        FireTachiInnateSkill.FireFakeSwordShoot(loc, speed, (LivingEntity)entity, entity.m_9236_(), -6, 7.0f);
                    }
                    break block8;
                } else if (act != 2) {
                    // empty if block
                }
                break block8;
            }
            if (entity.m_6117_()) {
                entity.m_20331_(true);
                executer.playAnimationSynchronized(LegendaryRebAnimations.FIRE_FINAL_ATTACK, 0.0f);
                executer.setStamina(0.0f);
            } else {
                entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                    capability.player_fire_attack = 0;
                    capability.syncPlayerVariables((Entity)entity);
                });
            }
        }
        super.executeOnServer(executer, args);
    }

    private static void FireFakeSwordShoot(Vec3 pos, Vec3 dir, LivingEntity entity, Level level, int life, float damage) {
        FireFakeSword fireFakeSword = new FireFakeSword((EntityType<? extends FireFakeSword>)((EntityType)LegendaryRebEntities.FIREFAKESWORD.get()), level);
        fireFakeSword.type = 1;
        fireFakeSword.lifetime = life;
        fireFakeSword.speed = dir.m_82490_(2.0);
        fireFakeSword.attackdam = damage;
        fireFakeSword.m_146884_(pos);
        fireFakeSword.m_5602_((Entity)entity);
        fireFakeSword.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 2.0f, 0.0f);
        entity.m_9236_().m_7967_((Entity)fireFakeSword);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        int skillattack = ((LegendaryRebModVariables.PlayerVariables)((Player)executer.getOriginal()).getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new LegendaryRebModVariables.PlayerVariables())).player_fire_attack;
        DynamicAnimation animation = executer.getAnimator().getPlayerFor(null).getAnimation();
        if (animation == WOMAnimations.KATANA_SHEATHE || animation == LegendaryRebAnimations.FIRE_FINAL_ATTACK) {
            return false;
        }
        return !playerState.movementLocked() && skillattack == 10;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            this.setConsumption(container, 0.0f);
            this.setConsumptionSynchronize((ServerPlayerPatch)container.getExecuter(), 0.0f);
            SkillDataManager dataManager = container.getDataManager();
            int sword = (Integer)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FireSword.get());
            if (sword > 0) {
                ServerPlayerPatch playerPatch = (ServerPlayerPatch)container.getExecuter();
                ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
                if (sword % 3 == 0) {
                    Random random = new Random();
                    Vec3 position = new Vec3(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
                    Vec3 pos = position.m_82520_((double)random.nextFloat(-3.0f, 3.0f), (double)random.nextFloat(-0.5f, 1.5f), (double)random.nextFloat(-3.0f, 3.0f));
                    Vec3 speed = this.Aim((LivingEntity)player, pos, position, 10.0).m_82541_();
                    FireTachiInnateSkill.FireFakeSwordShoot(pos, speed, (LivingEntity)player, player.m_9236_(), -9, 9.0f);
                }
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FireSword.get(), (Object)(sword - 1), player);
            }
        }
        container.setResource(0.0f);
        container.deactivate();
    }

    private Vec3 Aim(LivingEntity player, Vec3 pos, Vec3 position, double dis) {
        LivingEntity target = player.m_21214_();
        Vec3 aim = position.m_82549_(player.m_20154_().m_82490_(dis)).m_82546_(pos);
        if (target != null && target.m_6084_() && target != player) {
            aim = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0).m_82546_(pos);
        }
        return aim;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        int text = (Integer)container.getDataManager().getDataValue((SkillDataKey)LegendaryRebDataKeys.FireText.get());
        if (text != 0) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            Window sr = Minecraft.m_91087_().m_91268_();
            Font font = gui.font;
            float lox = (float)sr.m_85445_() * 0.5f;
            float loy = (float)sr.m_85446_() * 0.27f;
            String string = Component.m_237115_((String)("skill.legendaryreb.firefinal." + text)).getString();
            float scale = 2.5f - 0.5f / (float)text;
            float width = (float)font.m_92895_(string) * 0.5f * scale;
            float heith = (float)font.m_92895_("a") * 0.5f * scale;
            poseStack.m_252880_(lox - width, loy - heith, 0.0f);
            poseStack.m_85841_(scale, scale, 0.0f);
            guiGraphics.m_280056_(font, string, 0, 0, this.color[text], true);
            poseStack.m_85849_();
        }
    }
}

