/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.skill;

import com.aul.legendaryreb.skill.LegendaryRebDataKeys;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class FightStrongerSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("bc59170e-0de1-37ed-810d-1919ac124987");

    public FightStrongerSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            SkillDataManager dataManager = container.getDataManager();
            float health = 0.0f;
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FightStr.get())) {
                health = ((Float)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FightStr.get())).floatValue() * 6.0f + 1.0f;
            }
            event.setDamage(event.getDamage() * health);
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID, event -> {
            SkillDataManager dataManager = container.getDataManager();
            float health = 0.0f;
            if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FightStr.get())) {
                health = ((Float)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FightStr.get())).floatValue() * 1.7f;
            }
            event.setAttackSpeed(event.getAttackSpeed() + health);
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_ATTACK_SPEED_EVENT, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch playerPatch = container.getExecuter();
        if (playerPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            float health = (serverPlayer.m_21233_() - serverPlayer.m_21223_()) / serverPlayer.m_21233_();
            SkillDataManager dataManager = container.getDataManager();
            dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FightStr.get(), (Object)Float.valueOf(health), serverPlayer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        SkillDataManager dataManager = container.getDataManager();
        float health = 0.0f;
        int color = 0xFFFFFF;
        if (dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FightStr.get())) {
            health = ((Float)dataManager.getDataValue((SkillDataKey)LegendaryRebDataKeys.FightStr.get())).floatValue();
            color = (int)(health * 1.6711753E7f + (1.0f - health) * 1.6777215E7f);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(-16.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - health), (float)(1.0f - health), (float)1.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x - 16, (int)y - 20, 48, 48, 0.0f, 0.0f, 1, 1, 1, 1);
        guiGraphics.drawString(gui.font, String.format("%.1f", Float.valueOf(health * 100.0f)) + "%", x, y, color, false);
        poseStack.m_85849_();
    }
}

