/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.skill;

import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class AttackGuardSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("bc59799e-0de8-11ed-810d-1919ac114514");

    public AttackGuardSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            DamageSource damageSource = (DamageSource)event.getDamageSource();
            PlayerPatch playerPatch = event.getPlayerPatch();
            if (playerPatch.isBattleMode() && playerPatch.getAnimator().getPlayerFor(null).getAnimation() instanceof AttackAnimation && playerPatch.getEntityState().inaction() && playerPatch.getStamina() > 0.5f && !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_269533_(EpicFightDamageType.PARTIAL_DAMAGE) && !damageSource.m_269533_(DamageTypeTags.f_268490_) && !damageSource.m_269533_(DamageTypeTags.f_268415_) && !damageSource.m_276093_(DamageTypes.f_268515_) && !damageSource.m_269533_(DamageTypeTags.f_268745_)) {
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.BLOCKED);
                playerPatch.playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                playerPatch.setStamina(playerPatch.getStamina() - 1.0f);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
    }
}

