/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemTracker {
    public static void TrackItem(ItemStack itemStack, String tracker, int password) {
        if (itemStack.m_41619_()) {
            return;
        }
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_(tracker, password);
        itemStack.m_41751_(tag);
    }

    public static void RemoveTracker(ItemStack itemStack, String tracker) {
        if (itemStack.m_41619_()) {
            return;
        }
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128473_(tracker);
        itemStack.m_41751_(tag);
    }

    public static List<ItemStack> checkPlayer(ServerLevel level, String type, String tracker, int password) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        List playerList = level.m_8795_(player -> true);
        for (ServerPlayer player2 : playerList) {
            NonNullList items = player2.m_150109_().f_35974_;
            for (ItemStack stack : items) {
                if (!ItemTracker.checkItem(stack, tracker, password, type)) continue;
                list.add(stack);
            }
        }
        return list;
    }

    public static List<ItemStack> checkPlayerOfPos(ServerLevel level, String type, String tracker, int password, Vec3 pos, double radius) {
        AABB aabb = new AABB(BlockPos.m_274446_((Position)pos)).m_82400_(radius);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        List playerList = level.m_45976_(ServerPlayer.class, aabb);
        for (ServerPlayer player : playerList) {
            NonNullList items = player.m_150109_().f_35974_;
            for (ItemStack stack : items) {
                if (!ItemTracker.checkItem(stack, tracker, password, type)) continue;
                list.add(stack);
            }
        }
        return list;
    }

    public static List<ItemEntity> checkItemEntity(ServerLevel level, String type, String tracker, int password, Vec3 pos, double radius) {
        AABB aabb = new AABB(BlockPos.m_274446_((Position)pos)).m_82400_(radius);
        ArrayList<ItemEntity> list = new ArrayList<ItemEntity>();
        List entities = level.m_45976_(ItemEntity.class, aabb);
        for (ItemEntity entity : entities) {
            ItemStack stack = entity.m_32055_();
            if (!ItemTracker.checkItem(stack, tracker, password, type)) continue;
            list.add(entity);
        }
        return list;
    }

    public static Map<Container, List<Integer>> checkContainer(ServerLevel level, String type, String tracker, int password, Vec3 pos, double radius) {
        HashMap<Container, List<Integer>> map = new HashMap<Container, List<Integer>>();
        ArrayList<Integer> list = new ArrayList<Integer>();
        List<Container> containers = ItemTracker.getLoadedContainers(level, pos, radius);
        for (Container container : containers) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!ItemTracker.checkItem(stack, tracker, password, type)) continue;
                list.add(i);
            }
            if (!list.isEmpty()) {
                map.put(container, list);
            }
            list = new ArrayList();
        }
        return map;
    }

    public static boolean checkItem(ItemStack stack, String tracker, int password, String type) {
        CompoundTag tag;
        if (stack.m_41778_().equals(type) && stack.m_41782_() && (tag = stack.m_41783_()) != null) {
            int id = tag.m_128451_(tracker);
            return id == password;
        }
        return false;
    }

    private static List<Container> getLoadedContainers(ServerLevel level, Vec3 pos, double radius) {
        ArrayList<Container> containers = new ArrayList<Container>();
        BlockPos center = BlockPos.m_274446_((Position)pos);
        int chunkRadius = (int)Math.ceil(radius / 16.0);
        ChunkPos playerChunk = new ChunkPos(center);
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                ChunkPos chunkPos = new ChunkPos(playerChunk.f_45578_ + x, playerChunk.f_45579_ + z);
                if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) continue;
                level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_62954_().values().forEach(be -> {
                    if (be instanceof Container) {
                        Container container = (Container)be;
                        containers.add(container);
                    }
                });
            }
        }
        return containers;
    }
}

