/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.event;

import com.aul.legendaryreb.animation.LegendaryRebAnimations;
import com.aul.legendaryreb.enchantment.LegendaryRebEnchantments;
import com.aul.legendaryreb.event.ItemTracker;
import com.aul.legendaryreb.gamerule.LegendaryRebGamerules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

@Mod.EventBusSubscriber(modid="legendaryreb", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HeavyAttackEvent {
    private static final Map<Integer, Map<Enchantment, Integer>> map = new HashMap<Integer, Map<Enchantment, Integer>>();
    private static final Map<LivingEntity, Float> damagemap = new HashMap<LivingEntity, Float>();
    private static final Map<Integer, String> uids = new HashMap<Integer, String>();
    private static Map<Integer, Integer> time = new HashMap<Integer, Integer>();
    private static Map<LivingEntity, Integer> invulmap = new HashMap<LivingEntity, Integer>();
    private static final String tracker = "trackHeavyAttack";

    public static void HeavyAttack(Player player) {
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_41619_()) {
            return;
        }
        Enchantment heavy_attack = (Enchantment)LegendaryRebEnchantments.HEAVY_ATTACK.get();
        int hea = itemStack.getEnchantmentLevel(heavy_attack);
        if (hea != 0) {
            player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).ifPresent(entityPatch -> {
                if (entityPatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                    Map enchantmentIntegerMap = itemStack.getAllEnchantments();
                    int[] heavy = new int[1];
                    if (itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("legendaryreb:magical_item")))) {
                        int uid = HeavyAttackEvent.getUid();
                        ItemTracker.TrackItem(itemStack, tracker, uid);
                        map.put(uid, enchantmentIntegerMap);
                        time.put(uid, 600);
                        uids.put(uid, itemStack.m_41778_());
                    }
                    enchantmentIntegerMap.forEach((enchantment, integer) -> {
                        heavy[0] = heavy[0] + integer;
                    });
                    HashMap map1 = new HashMap();
                    float damage = ((float)(heavy[0] * 5) + HeavyAttackEvent.getDamage(serverPlayerPatch)) * (float)hea;
                    damagemap.put((LivingEntity)player, Float.valueOf(damage));
                    invulmap.put((LivingEntity)player, -1);
                    EnchantmentHelper.m_44865_(map1, (ItemStack)itemStack);
                    serverPlayerPatch.playAnimationSynchronized(LegendaryRebAnimations.LegendaryHeavyAttack, 0.0f);
                }
            });
        }
    }

    private static int getUid() {
        boolean exist = true;
        int uid = 0;
        Random random = new Random();
        while (exist) {
            uid = (int)(random.nextLong() * 100000000L);
            if (uids.containsKey(uid)) continue;
            exist = false;
        }
        return uid;
    }

    private static float getDamage(ServerPlayerPatch serverPlayerPatch) {
        AttributeInstance attribute = ((ServerPlayer)serverPlayerPatch.getOriginal()).m_21051_(Attributes.f_22281_);
        float damage = 0.0f;
        if (attribute != null) {
            damage = (float)attribute.m_22135_();
            damage = serverPlayerPatch.getModifiedBaseDamage(damage);
        }
        return damage;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        HashMap<Integer, Integer> time1 = new HashMap<Integer, Integer>();
        time.forEach((integer, integer2) -> {
            if (integer2 <= 0) {
                Map<Enchantment, Integer> enchantmentIntegerMap = map.get(integer);
                String itemid = uids.get(integer);
                ArrayList itemStacks = new ArrayList();
                ArrayList itemEntities = new ArrayList();
                HashMap<Container, List> containerListMap = new HashMap<Container, List>();
                Vec3[] pos = new Vec3[1];
                ItemStack[] stack = new ItemStack[1];
                event.getServer().m_129785_().forEach(level -> {
                    itemStacks.addAll(ItemTracker.checkPlayer(level, itemid, tracker, integer));
                    level.m_8795_(player -> true).forEach(player -> {
                        pos[0] = player.m_20182_();
                        itemEntities.addAll(ItemTracker.checkItemEntity(level, itemid, tracker, integer, pos[0], 100.0));
                        containerListMap.putAll(ItemTracker.checkContainer(level, itemid, tracker, integer, pos[0], 100.0));
                    });
                });
                AtomicReference map1 = new AtomicReference(new HashMap());
                for (ItemStack itemStack1 : itemStacks) {
                    map1.set(itemStack1.getAllEnchantments());
                    ((Map)map1.get()).putAll(enchantmentIntegerMap);
                    EnchantmentHelper.m_44865_((Map)map1.get(), (ItemStack)itemStack1);
                    ItemTracker.RemoveTracker(itemStack1, tracker);
                }
                for (ItemEntity entity : itemEntities) {
                    stack[0] = entity.m_32055_();
                    map1.set(stack[0].getAllEnchantments());
                    ((Map)map1.get()).putAll(enchantmentIntegerMap);
                    EnchantmentHelper.m_44865_((Map)map1.get(), (ItemStack)stack[0]);
                    ItemTracker.RemoveTracker(stack[0], tracker);
                    entity.m_32045_(stack[0]);
                }
                containerListMap.forEach((container, integers) -> {
                    Iterator iterator = integers.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        stack[0] = container.m_8020_(i);
                        map1.set(stack[0].getAllEnchantments());
                        ((Map)map1.get()).putAll(enchantmentIntegerMap);
                        EnchantmentHelper.m_44865_((Map)((Map)map1.get()), (ItemStack)stack[0]);
                        ItemTracker.RemoveTracker(stack[0], tracker);
                        container.m_6836_(i, stack[0]);
                    }
                });
                map.remove(integer);
                uids.remove(integer);
            } else {
                time1.put((Integer)integer, integer2 - 1);
            }
        });
        time = time1;
        HashMap<LivingEntity, Integer> invulmapnew = new HashMap<LivingEntity, Integer>();
        invulmap.forEach((livingEntity, integer) -> {
            if (integer > 0) {
                invulmapnew.put((LivingEntity)livingEntity, integer - 1);
            } else if (integer < 0) {
                invulmapnew.put((LivingEntity)livingEntity, (Integer)integer);
            }
        });
        invulmap = invulmapnew;
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (invulmap.containsKey(livingEntity) && livingEntity != null && livingEntity.m_6084_()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    public static void DealDamage(LivingEntity entity, LivingEntityPatch<?> entityPatch, ServerLevel level, Vec3 centre) {
        float r;
        float damage = 4.0f;
        if (damagemap.containsKey(entity)) {
            damage = damagemap.get(entity).floatValue();
            damagemap.remove(entity);
            invulmap.replace(entity, 70);
        }
        if ((r = (1.0f - 20.0f / damage) * 17.0f) < 0.0f) {
            r = 0.0f;
        }
        HeavyAttackEvent.SphericalDestruction(centre, level, Float.valueOf(r));
        List entityList = level.m_6443_(LivingEntity.class, new AABB(centre, centre).m_82400_((double)(r + 1.0f)), e -> e.m_6084_() && e != entity);
        for (LivingEntity att : entityList) {
            float health = att.m_21223_();
            att.m_6469_((DamageSource)entityPatch.getDamageSource(LegendaryRebAnimations.LegendaryHeavyAttack, entityPatch.getAttackingHand()), damage);
            att.m_21153_(health - damage);
            Vec3 pos = att.m_20182_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123812_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void SphericalDestruction(Vec3 centre, ServerLevel level, Double r) {
        HeavyAttackEvent.SphericalDestruction(centre, level, (int)Math.ceil(r));
    }

    public static void SphericalDestruction(Vec3 centre, ServerLevel level, Float r) {
        HeavyAttackEvent.SphericalDestruction(centre, level, (int)Math.ceil(r.floatValue()));
    }

    public static void SphericalDestruction(Vec3 centre, ServerLevel level, int r) {
        if (level.m_46469_().m_46207_(LegendaryRebGamerules.doLegendaryAttackBreakBlock)) {
            if (r < 50) {
                HeavyAttackEvent.SphericalDestructionDrop(centre, level, r);
            } else if (r < 100) {
                HeavyAttackEvent.SphericalDestructionDestory(centre, level, r);
            } else {
                level.m_7654_().m_6846_().m_240416_((Component)Component.m_237115_((String)"event.legendaryreb.break").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    public static void SphericalDestructionDrop(Vec3 centre, ServerLevel level, Integer r) {
        int x0 = (int)centre.f_82479_;
        int y0 = (int)centre.f_82480_;
        int z0 = (int)centre.f_82481_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = -r.intValue(); x <= r; ++x) {
            for (int y = -r.intValue(); y <= r; ++y) {
                int h = r * r - x * x - y * y;
                if (h < 0) continue;
                int hSqrt = (int)Math.sqrt(h);
                for (int z = -hSqrt; z <= hSqrt; ++z) {
                    BlockState block = level.m_8055_((BlockPos)(pos = pos.m_122178_(x0 + x, y0 + y, z0 + z)));
                    if (block.m_60795_() || block.m_60713_(Blocks.f_50626_) || !(block.m_60800_((BlockGetter)level, (BlockPos)pos) > 0.0f)) continue;
                    level.m_46961_((BlockPos)pos, true);
                }
            }
        }
    }

    public static void SphericalDestructionDestory(Vec3 centre, ServerLevel level, Integer r) {
        int x0 = (int)centre.f_82479_;
        int y0 = (int)centre.f_82480_;
        int z0 = (int)centre.f_82481_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = -r.intValue(); x <= r; ++x) {
            for (int y = -r.intValue(); y <= r; ++y) {
                int h = r * r - x * x - y * y;
                if (h < 0) continue;
                int hSqrt = (int)Math.sqrt(h);
                for (int z = -hSqrt; z <= hSqrt; ++z) {
                    BlockState block = level.m_8055_((BlockPos)(pos = pos.m_122178_(x0 + x, y0 + y, z0 + z)));
                    if (block.m_60795_() || block.m_60713_(Blocks.f_50626_) || !(block.m_60800_((BlockGetter)level, (BlockPos)pos) > 0.0f)) continue;
                    level.m_7731_((BlockPos)pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }
}

