/*
 * Decompiled with CFR 0.152.
 */
package com.aul.legendaryreb.animation;

import com.aul.legendaryreb.collider.LegendaryRebWeaponColliders;
import com.aul.legendaryreb.event.HeavyAttackEvent;
import com.aul.legendaryreb.net.LegendaryRebModVariables;
import com.aul.legendaryreb.particle.FireTachiFlameParticleOptions;
import com.aul.legendaryreb.render.GlowEnchManager;
import com.aul.legendaryreb.skill.LegendaryRebDataKeys;
import com.aul.legendaryreb.skill.LegendaryRebSkills;
import com.aul.legendaryreb.sound.LegendaryRebSounds;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import reascer.wom.animation.attacks.BasicAttackNoRotAnimation;
import reascer.wom.animation.attacks.BasicMultipleAttackAnimation;
import reascer.wom.animation.attacks.SpecialAttackAnimation;
import reascer.wom.animation.attacks.SpecialAttackNoRotAnimation;
import reascer.wom.animation.attacks.UltimateAttackAnimation;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.particle.WOMParticles;
import reascer.wom.world.damagesources.WOMExtraDamageInstance;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.forgeevent.AnimationRegistryEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.StunType;

@Mod.EventBusSubscriber(modid="legendaryreb", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LegendaryRebAnimations {
    public static StaticAnimation LegendaryHeavyAttack;
    public static StaticAnimation FIRE_AUTO_1;
    public static StaticAnimation FIRE_AUTO_2;
    public static StaticAnimation FIRE_AUTO_3;
    public static StaticAnimation FIRE_AUTO_4;
    public static StaticAnimation FIRE_AUTO_5;
    public static StaticAnimation FIRE_AUTO_6;
    public static StaticAnimation FIRE_AUTO_7;
    public static StaticAnimation FIRE_DASH;
    public static StaticAnimation FIRE_AIR_SLASH;
    public static StaticAnimation FIRE_OUT_DRAW;
    public static StaticAnimation FIRE_FINAL_ATTACK;
    public static StaticAnimation LIGHTNING_FLASH;

    @SubscribeEvent
    public static void registerAnimations(AnimationRegistryEvent event) {
        event.getRegistryMap().put("legendaryreb", LegendaryRebAnimations::build);
    }

    public static void build() {
        HumanoidArmature biped = Armatures.BIPED;
        LegendaryHeavyAttack = new BasicAttackNoRotAnimation(0.25f, 0.35f, 0.8f, 1.2f, LegendaryRebWeaponColliders.LegendaryHeavyAttack, biped.rootJoint, "biped/skill/legendary_heavy_attack", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.8f)).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(DamageTypeTags.f_268738_)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)7.0f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.multiplier((float)4.0f)).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)((SoundEvent)EpicFightSounds.BLADE_RUSH_FINISHER.get())).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)WOMParticles.OVERBLOOD_HIT).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.KNOCKDOWN).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(2.6f)).addProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR, (Object)Float.valueOf(0.0f)).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, (Object)false).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
            if (elapsedTime >= 0.2f && elapsedTime <= 0.35f) {
                LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
                float dpx = (float)entity.m_20185_();
                float dpy = (float)entity.m_20186_();
                float dpz = (float)entity.m_20189_();
                BlockState block = entity.m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)dpy, (double)dpz));
                while ((block.m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_)) {
                    block = entity.m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)(dpy -= 1.0f), (double)dpz));
                }
                double plspeed = Math.abs(entity.m_20184_().f_82480_) + 1.0;
                float distanceToGround = (float)(Math.abs(entity.m_20186_() - (double)dpy) + plspeed);
                return 1.0f / (distanceToGround + 1.0f);
            }
            return speed * 1.4f;
        }).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.5f, (AnimationEvent.AnimationEventConsumer)ReuseableEvents.HEAVY_GROUNDSLAM, (AnimationEvent.Side)AnimationEvent.Side.BOTH), AnimationEvent.TimeStampedEvent.create((float)0.25f, (entitypatch, self, params) -> {
            ServerLevel level = (ServerLevel)((LivingEntity)entitypatch.getOriginal()).m_9236_();
            Vec3 position = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123767_, position.f_82479_, position.f_82480_ + 5.0, position.f_82481_, 900, 3.0, 2.5, 3.0, 1.0);
            level.m_5594_(null, BlockPos.m_274446_((Position)position), (SoundEvent)LegendaryRebSounds.Legendary_Wake.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(new AnimationEvent.TimePeriodEvent[]{AnimationEvent.TimePeriodEvent.create((float)0.0f, (float)0.2f, (entitypatch, self, params) -> {
            LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
            entity.m_20334_(entity.m_20184_().f_82479_, (double)2.1f, entity.m_20184_().f_82481_);
            Vec3 pos = entity.m_20182_();
            entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            ItemStack itemStack = ((LivingEntity)entitypatch.getOriginal()).m_21205_();
            if (!itemStack.m_41619_()) {
                GlowEnchManager.setGlow(itemStack, 0xF6FF00);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            ItemStack itemStack = ((LivingEntity)entitypatch.getOriginal()).m_21205_();
            if (!itemStack.m_41619_()) {
                GlowEnchManager.removeGlow(itemStack);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        FIRE_AUTO_1 = new BasicMultipleAttackAnimation(0.05f, 0.0f, 0.2f, 0.2f, null, biped.toolR, "biped/combat/fire_auto_1", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.8f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackAnimationProperty.EXTRA_COLLIDERS, (Object)2).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.8f)).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail}).addEvents(new AnimationEvent.TimeStampedEvent[]{ReuseableEvents.FireTachiTrailZero});
        FIRE_AUTO_2 = new BasicMultipleAttackAnimation(0.2f, 0.1f, 0.55f, 0.7f, null, biped.toolR, "biped/combat/fire_auto_2", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)1.1f)).addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0]))).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.multiplier((float)3.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)((SoundEvent)EpicFightSounds.BLADE_RUSH_FINISHER.get())).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)WOMParticles.OVERBLOOD_HIT).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(0.75f)).addProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR, (Object)Float.valueOf(1.5f)).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail}).addEvents(new AnimationEvent.TimeStampedEvent[]{ReuseableEvents.FireTachiTrailZero});
        FIRE_AUTO_3 = new BasicMultipleAttackAnimation(0.05f, "biped/combat/fire_auto_3", (Armature)biped, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, 0.3f, 0.4f, 0.45f, 0.45f, biped.toolR, null), new AttackAnimation.Phase(0.45f, 0.5f, 0.6f, 0.65f, 0.65f, biped.toolR, null), new AttackAnimation.Phase(0.65f, 0.7f, 1.0f, 1.0f, Float.MAX_VALUE, biped.toolR, null)}).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f), 1).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f), 2).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)0.4f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)0.4f), 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)0.6f), 2).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.setter((float)10.0f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.setter((float)10.0f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.setter((float)10.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE, 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE, 2).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.6f)).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail}).addEvents(new AnimationEvent.TimeStampedEvent[]{ReuseableEvents.FireTachiTrailZero});
        FIRE_AUTO_4 = new BasicMultipleAttackAnimation(0.05f, 0.25f, 0.4f, 1.0f, null, biped.toolR, "biped/combat/fire_auto_4", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.2f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.0f)).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, (Object)true).addProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.15f, 0.65f})).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (entitypatch instanceof PlayerPatch) {
                PlayerPatch playerPatch = (PlayerPatch)entitypatch;
                if (!self.getRealAnimation().getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                    TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                    Keyframe[] keyframes = transform.getKeyframes();
                    int startFrame = 0;
                    int endFrame = transform.getKeyframes().length - 1;
                    Vec3f keyLast = keyframes[endFrame].transform().translation();
                    Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                    Vec3 targetpos = attackTarget.m_20182_();
                    float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * (1.0f + 1.0f / playerPatch.getAttackSpeed(InteractionHand.MAIN_HAND)) - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()) * 0.75f, 0.0f);
                    Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                    float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                    for (int i = startFrame; i <= endFrame; ++i) {
                        Vec3f translation = keyframes[i].transform().translation();
                        translation.z *= scale;
                    }
                    transformSheet.readFrom(transform);
                } else {
                    transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
                }
            }
        }).addEvents(new AnimationEvent.TimeStampedEvent[]{ReuseableEvents.TimeFlyEvent, ReuseableEvents.FireTachiTrailZero}).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail});
        FIRE_AUTO_5 = new BasicMultipleAttackAnimation(0.05f, "biped/combat/fire_auto_5", (Armature)biped, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, 0.0f, 0.1f, 0.15f, 0.15f, biped.toolR, LegendaryRebWeaponColliders.FireBypass), new AttackAnimation.Phase(0.15f, 0.2f, 0.3f, 0.35f, 0.35f, biped.toolR, LegendaryRebWeaponColliders.FireBypass), new AttackAnimation.Phase(0.35f, 0.4f, 0.5f, 0.55f, 0.55f, biped.toolR, LegendaryRebWeaponColliders.FireBypass), new AttackAnimation.Phase(0.55f, 0.6f, 0.7f, 0.75f, 0.75f, biped.toolR, LegendaryRebWeaponColliders.FireBypass), new AttackAnimation.Phase(0.75f, 0.8f, 1.0f, 2.0f, Float.MAX_VALUE, biped.toolR, LegendaryRebWeaponColliders.FireBypass)}).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f), 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.0f), 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 1).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f), 2).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f), 2).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 2).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f), 3).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f), 3).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD, 3).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)1.0f), 4).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.0f), 4).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE, 4).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.4f)).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, (Object)true).addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.0f, 1.0f})).addEvents(new AnimationEvent.TimePeriodEvent[]{AnimationEvent.TimePeriodEvent.create((float)1.5f, (float)1.7f, (AnimationEvent.AnimationEventConsumer)ReuseableEvents.LOOPED_FALLING_MOVE, (AnimationEvent.Side)AnimationEvent.Side.BOTH)}).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)1.7f, (AnimationEvent.AnimationEventConsumer)WOMAnimations.ReuseableEvents.LOOPED_FALLING, (AnimationEvent.Side)AnimationEvent.Side.BOTH), AnimationEvent.TimeStampedEvent.create((float)1.5f, (entitypatch, self, params) -> ((LivingEntity)entitypatch.getOriginal()).m_183634_(), (AnimationEvent.Side)AnimationEvent.Side.BOTH), ReuseableEvents.FireTachiTrailZero}).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail});
        FIRE_AUTO_6 = new BasicMultipleAttackAnimation(0.05f, "biped/combat/fire_auto_6", (Armature)biped, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, 0.25f, 0.4f, 0.5f, 0.5f, biped.toolR, null), new AttackAnimation.Phase(0.5f, 0.5f, 0.75f, 0.75f, Float.MAX_VALUE, biped.toolR, null)}).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.5f), 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)0.8f), 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE, 1).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(2.0f)).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail}).addEvents(new AnimationEvent.TimeStampedEvent[]{ReuseableEvents.FireTachiTrailZero});
        FIRE_AUTO_7 = new SpecialAttackAnimation(0.15f, 0.35f, 0.5f, 0.8f, 1.05f, LegendaryRebWeaponColliders.FireDashColider, biped.rootJoint, "biped/combat/fire_auto_7", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)((SoundEvent)EpicFightSounds.WHOOSH_SHARP.get())).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageType.WEAPON_INNATE)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)WOMParticles.KATANA_SHEATHED_HIT).addProperty(AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)true).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(2.0f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.05f, (AnimationEvent.AnimationEventConsumer)WOMAnimations.ReuseableEvents.KATANA_IN, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.5f, (entitypatch, self, params) -> {
            Entity entity = entitypatch.getOriginal();
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)WOMParticles.ENTITY_AFTER_IMAGE_WEAPON.get(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Double.longBitsToDouble(entity.m_19879_()), 0.0, 0.0);
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.TimeStampedEvent.create((float)0.8f, (entitypatch, self, params) -> {
            if (entitypatch instanceof PlayerPatch) {
                entitypatch.updateMotion(true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)1.9f, (entitypatch, self, params) -> entitypatch.playSound((SoundEvent)EpicFightSounds.WHOOSH.get(), 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)3.35f, (entitypatch, self, params) -> entitypatch.playSound((SoundEvent)EpicFightSounds.SWORD_IN.get(), 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), ReuseableEvents.FireTachiTrailZero}).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail}).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiPassive)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireChange.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChange.get(), (Object)true, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiPassive)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireChange.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChange.get(), (Object)false, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        FIRE_DASH = new BasicMultipleAttackAnimation(0.05f, "biped/combat/fire_dash", (Armature)biped, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, 0.35f, 0.6f, 0.95f, Float.MAX_VALUE, biped.toolR, LegendaryRebWeaponColliders.FireAirDashColider)}).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)1.2f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)2.5f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageType.WEAPON_INNATE)).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)((SoundEvent)EpicFightSounds.BLADE_RUSH_FINISHER.get())).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.BLADE_RUSH_SKILL).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.4f)).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addEvents(new AnimationEvent.TimeStampedEvent[]{ReuseableEvents.TimeFlyEvent, ReuseableEvents.FireTachiTrailZero}).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail});
        FIRE_AIR_SLASH = new BasicMultipleAttackAnimation(0.05f, 0.25f, 0.55f, 0.75f, LegendaryRebWeaponColliders.FireAirCometColider, biped.toolR, "biped/combat/fire_air_slash", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)1.0f)).addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(WOMExtraDamageInstance.WOM_TARGET_CURRENT_HEALTH.create(new float[]{0.05f}))).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.8f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackAnimationProperty.EXTRA_COLLIDERS, (Object)20).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.25f)).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, (Object)true).addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.0f, 0.3f})).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
            if (elapsedTime >= 0.35f && elapsedTime < 0.45f) {
                float dpx = (float)((LivingEntity)entitypatch.getOriginal()).m_20185_();
                float dpy = (float)((LivingEntity)entitypatch.getOriginal()).m_20186_();
                float dpz = (float)((LivingEntity)entitypatch.getOriginal()).m_20189_();
                BlockState block = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)dpy, (double)dpz));
                while ((block.m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_)) {
                    block = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)(dpy -= 1.0f), (double)dpz));
                }
                float distanceToGround = (float)Math.max(Math.abs(((LivingEntity)entitypatch.getOriginal()).m_20186_() - (double)dpy) - 1.0, 0.0);
                LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
                Vec3f direction = new Vec3f(2.5f, -0.25f, 0.0f);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_20884_ + 90.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                AABB box = AABB.m_165882_((Vec3)((LivingEntity)entitypatch.getOriginal()).m_20318_(1.0f), (double)3.0, (double)3.0, (double)3.0);
                List list = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_45933_(entitypatch.getOriginal(), box);
                if (distanceToGround > 0.5f && list.isEmpty()) {
                    livingentity.m_6478_(MoverType.SELF, direction.toDoubleVector());
                    return 0.05f;
                }
                return 1.0f;
            }
            return 1.0f;
        }).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.25f, (AnimationEvent.AnimationEventConsumer)WOMAnimations.ReuseableEvents.RUINE_COMET_AIRBURST, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.TimeStampedEvent.create((float)0.5f, (AnimationEvent.AnimationEventConsumer)ReuseableEvents.RUINE_COMET_GROUNDTHRUST, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), ReuseableEvents.FireTachiTrailZero}).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail});
        FIRE_OUT_DRAW = new SpecialAttackNoRotAnimation(0.15f, 0.0f, 0.5f, 0.7f, 0.7f, LegendaryRebWeaponColliders.FireOutDraw, biped.rootJoint, "biped/skill/fire_out_draw", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)((SoundEvent)EpicFightSounds.WHOOSH_SHARP.get())).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.NONE).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageType.WEAPON_INNATE)).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)WOMParticles.KATANA_SHEATHED_HIT).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.05f, (AnimationEvent.AnimationEventConsumer)WOMAnimations.ReuseableEvents.KATANA_IN, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.5f, (entitypatch, self, params) -> {
            if (entitypatch instanceof PlayerPatch) {
                entitypatch.updateMotion(true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)2.05f, (entitypatch, self, params) -> entitypatch.playSound((SoundEvent)EpicFightSounds.WHOOSH.get(), 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)3.45f, (entitypatch, self, params) -> entitypatch.playSound((SoundEvent)EpicFightSounds.SWORD_IN.get(), 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), ReuseableEvents.FireTachiTrailZero}).addEvents(new AnimationEvent.TimePeriodEvent[]{ReuseableEvents.FireTachiTrail}).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiPassive)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireChange.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChange.get(), (Object)true, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiPassive)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireChange.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChange.get(), (Object)false, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        FIRE_FINAL_ATTACK = new UltimateAttackAnimation(0.05f, 2.05f, 2.1f, 5.65f, LegendaryRebWeaponColliders.FireFinalAttackColider, biped.rootJoint, "biped/skill/fire_final_attack", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)9.9f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)13.9f)).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.setter((float)Float.MAX_VALUE)).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)((SoundEvent)EpicFightSounds.NO_SOUND.get())).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)SoundEvents.f_12521_).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)WOMParticles.SOLAR_OBSCURIDAD_POLVORA_HIT).addProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR, (Object)Float.valueOf(0.0f)).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(DamageTypeTags.f_268738_, DamageTypeTags.f_268630_, DamageTypeTags.f_268490_, DamageTypeTags.f_273918_, DamageTypeTags.f_268437_, DamageTypeTags.f_268413_, DamageTypeTags.f_276146_)).addProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.0f, 5.65f})).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
            if (elapsedTime >= 0.0f && elapsedTime < 2.05f) {
                return speed * 0.4f;
            }
            return speed;
        }).addEvents(new AnimationEvent.TimePeriodEvent[]{AnimationEvent.TimePeriodEvent.create((float)0.05f, (float)2.25f, (entitypatch, self, params) -> {
            float a;
            float theta;
            AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)self);
            LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
            ServerLevel level = (ServerLevel)entity.m_9236_();
            float n = theta = player.getElapsedTime() * 5.0f;
            FireTachiFlameParticleOptions options1 = new FireTachiFlameParticleOptions(0.45f, 1.0f, 0.0f, 0.0f);
            FireTachiFlameParticleOptions options2 = new FireTachiFlameParticleOptions(1.5f, 1.0f, 1.0f, 1.0f);
            FireTachiFlameParticleOptions options3 = new FireTachiFlameParticleOptions(0.4f, 0.0f, 0.0f, 0.0f);
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getAnimator().getPose(0.0f), Armatures.BIPED.toolR);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, -0.4f));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            Vec3 vec0 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, -1.0f));
            Vec3 vec4 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            transformMatrix.translate(new Vec3f(0.0f, 0.3f, 1.0f));
            Vec3 vec1 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            transformMatrix.translate(new Vec3f(0.3f, -0.3f, 0.0f));
            Vec3 vec2 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            vec0 = vec0.m_82549_(entity.m_20182_());
            vec4 = vec4.m_82541_().m_82490_(0.8);
            int j = 0;
            while ((float)j < n) {
                a = n - (float)j;
                float r = a / 25.0f;
                int i = 0;
                while ((double)i < Math.PI * (double)a) {
                    Vec3 vec3 = vec1.m_82490_(Math.cos(theta)).m_82549_(vec2.m_82490_(Math.sin(theta)));
                    vec3 = vec3.m_82490_((double)a * 0.4);
                    level.m_8767_((ParticleOptions)options1, vec0.f_82479_ + vec3.f_82479_, vec0.f_82480_ + vec3.f_82480_, vec0.f_82481_ + vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    theta += 2.0f / a;
                    if ((double)theta > Math.PI * 2) {
                        theta = (float)((double)theta - Math.PI * 2);
                    }
                    ++i;
                }
                level.m_8767_((ParticleOptions)options3, vec0.f_82479_, vec0.f_82480_, vec0.f_82481_, 7, 0.0, (double)r, (double)r, (double)r);
                vec0 = vec0.m_82549_(vec4);
                ++j;
            }
            Vec3 view = new Vec3(entity.m_20252_((float)1.0f).f_82479_, 0.0, entity.m_20252_((float)1.0f).f_82481_).m_82541_().m_82490_(12.0);
            Vec3 center = entity.m_20182_().m_82520_(view.f_82479_, 0.0, view.f_82481_);
            a = n * 4.5f;
            float l = a * 0.4f;
            theta = n;
            int i = 0;
            while ((double)i < 2.5132741228718345 * (double)a) {
                level.m_8767_((ParticleOptions)options2, center.f_82479_ + Math.cos(theta) * (double)l, center.f_82480_, center.f_82481_ + Math.sin(theta) * (double)l, 1, 0.0, 0.0, 0.0, 0.0);
                theta += 2.5f / a;
                if ((double)theta > Math.PI * 2) {
                    theta = (float)((double)theta - Math.PI * 2);
                }
                ++i;
            }
            view = view.m_82541_().m_82490_((double)l).m_82524_(n);
            Vec3 vec5 = center.m_82549_(view);
            Vec3 vec6 = view.m_82541_().m_82490_(-1.0);
            vec6 = vec6.m_82524_(-0.5235988f);
            l *= 1.732f;
            for (i = 0; i < 2; ++i) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    for (float k = 0.0f; k < l; k += 1.0f) {
                        level.m_8767_((ParticleOptions)options2, vec5.f_82479_, vec5.f_82480_, vec5.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                        vec5 = vec5.m_82549_(vec6);
                    }
                    vec6 = vec6.m_82524_(2.0943952f);
                }
                vec5 = vec5.m_82546_(view.m_82490_(2.0));
                vec6 = vec6.m_82490_(-1.0);
            }
            center = center.m_82520_(0.0, 1.0, 0.0);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, center.f_82479_, center.f_82480_, center.f_82481_, 20, 1.0, 0.2, 0.2, 0.2);
            Vec3 finalCenter = center;
            List<LivingEntity> entityList = level.m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(50.0), e -> e.m_6084_() && e != entity).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(finalCenter))).toList();
            if (!entityList.isEmpty()) {
                for (LivingEntity livingEntity : entityList) {
                    Vec3 speed = new Vec3(center.f_82479_ - livingEntity.m_20185_(), center.f_82480_ - livingEntity.m_20186_(), center.f_82481_ - livingEntity.m_20189_());
                    livingEntity.m_20256_(speed);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimePeriodEvent.create((float)1.8f, (float)2.15f, (entitypatch, self, params) -> {
            if (entitypatch instanceof LocalPlayerPatch) {
                LocalPlayerPatch playerPatch = (LocalPlayerPatch)entitypatch;
                ReuseableEvents.ParticleTrail(playerPatch, -0.2f, -21.4f, ParticleTypes.f_123745_, ParticleTypes.f_123744_);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.05f, (entitypatch, self, params) -> ((LivingEntity)entitypatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19621_, 247, 10, true, false, false)), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.05f, (entitypatch, self, params) -> Minecraft.m_91087_().m_91397_().m_120186_(), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.TimeStampedEvent.create((float)2.05f, (entitypatch, self, params) -> {
            OpenMatrix4f rotation;
            Vec3f direction;
            int i;
            LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 65, 10, true, false, false));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 21, 0, true, false, false));
            ServerLevel level = (ServerLevel)entity.m_9236_();
            level.m_5594_(null, BlockPos.m_274446_((Position)entity.m_20182_()), SoundEvents.f_12521_, SoundSource.VOICE, 100.0f, 0.85f);
            new Vec3f(0.0f, 0.0f, 0.0f);
            for (i = 0; i < 34; ++i) {
                direction = new Vec3f(0.0f, 0.0f, 0.0f);
                rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_19859_ + 90.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.translate(new Vec3f((new Random().nextFloat() - 0.3f) * 24.0f, (new Random().nextFloat() - 0.2f) * 13.0f, (new Random().nextFloat() - 0.5f) * 20.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, ((LivingEntity)entitypatch.getOriginal()).m_20185_() + (double)direction.x, ((LivingEntity)entitypatch.getOriginal()).m_20186_() + 1.5 + (double)direction.y, ((LivingEntity)entitypatch.getOriginal()).m_20189_() + (double)direction.z, 2, 0.5, 0.0, 0.5, 0.0);
            }
            for (i = 0; i < 10; ++i) {
                direction = new Vec3f(0.0f, 0.0f, 0.0f);
                rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_19859_ + 90.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
                rotation.translate(new Vec3f((new Random().nextFloat() - 0.1f) * 24.0f, (new Random().nextFloat() - 0.2f) * 3.0f, (new Random().nextFloat() - 0.5f) * 7.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                for (int y = 2; y < 12; ++y) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, ((LivingEntity)entitypatch.getOriginal()).m_20185_() + (double)direction.x, ((LivingEntity)entitypatch.getOriginal()).m_20186_() + (double)direction.y + (double)((float)(y * y * y) * 0.003f), ((LivingEntity)entitypatch.getOriginal()).m_20189_() + (double)direction.z, 2, 0.5, 0.3, 0.3, 0.3);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), ReuseableEvents.FireTachiTrailZero, AnimationEvent.TimeStampedEvent.create((float)5.6f, (entitypatch, self, params) -> {
            float dpy;
            List list = entitypatch.getCurrenltyAttackedEntities();
            LivingEntity player = (LivingEntity)entitypatch.getOriginal();
            ServerLevel level = (ServerLevel)player.m_9236_();
            for (LivingEntity entity : list) {
                if (entity == null || !entity.m_6084_()) continue;
                float health = entity.m_21223_();
                float damage = (float)Math.max(299.0, (double)entity.m_21233_() * 0.99);
                entity.m_6469_((DamageSource)entitypatch.getDamageSource(FIRE_FINAL_ATTACK, InteractionHand.MAIN_HAND), damage);
                entity.m_21153_(Math.max(health - damage, 0.0f));
                level.m_5594_(null, BlockPos.m_274446_((Position)entity.m_20182_()), SoundEvents.f_11913_, SoundSource.VOICE, 5.0f, 1.0f);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 50, 0.1, 0.5, 0.5, 0.5);
            }
            float dpx = (float)player.m_20185_();
            float y = dpy = (float)player.m_20186_();
            float dpz = (float)player.m_20189_();
            BlockState block = level.m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)dpy, (double)dpz));
            while ((block.m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_)) {
                block = level.m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)(dpy -= 1.0f), (double)dpz));
            }
            int t = (int)Math.min(40.0f * (y - dpy) + 5.0f, 80.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, t, 0, true, false, false));
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)2.3f, (entitypatch, self, params) -> {
            List list = entitypatch.getCurrenltyHurtEntities();
            for (LivingEntity entity : list) {
                Vec3 speed = Vec3.m_82498_((float)new Random().nextFloat(-90.0f, 90.0f), (float)new Random().nextFloat(-180.0f, 180.0f));
                entity.m_20256_(speed);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.05f, (entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiInnate)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireText.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireText.get(), (Object)1, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.7f, (entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiInnate)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireText.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireText.get(), (Object)2, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)1.4f, (entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiInnate)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireText.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireText.get(), (Object)3, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)2.15f, (entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiInnate)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireText.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireText.get(), (Object)0, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiPassive)) != null && container.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireChange.get())) {
                container.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChange.get(), (Object)true, (ServerPlayer)playerPatch.getOriginal());
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            ServerPlayerPatch serverPlayerPatch;
            SkillContainer skillContainer;
            if (entitypatch instanceof ServerPlayerPatch && (skillContainer = (serverPlayerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.FireTachiPassive)) != null && skillContainer.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireChanged.get())) {
                skillContainer.getDataManager().setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChanged.get(), (Object)true, (ServerPlayer)serverPlayerPatch.getOriginal());
            }
            entitypatch.reserveAnimation(WOMAnimations.KATANA_SHEATHE.addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self1, entitypatch1, speed, prevElapsedTime, elapsedTime) -> 0.5f).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch1, self1, params1) -> {
                ServerPlayerPatch serverPlayerPatch;
                SkillContainer skillContainer;
                if (entitypatch1 instanceof ServerPlayerPatch && (skillContainer = (serverPlayerPatch = (ServerPlayerPatch)entitypatch1).getSkill(LegendaryRebSkills.FireTachiPassive)) != null && skillContainer.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireChange.get()) && skillContainer.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireSheath.get()) && skillContainer.getDataManager().hasData((SkillDataKey)LegendaryRebDataKeys.FireChanged.get())) {
                    SkillDataManager dataManager = skillContainer.getDataManager();
                    ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChange.get(), (Object)false, serverPlayer);
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FireSheath.get(), (Object)true, serverPlayer);
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FireChanged.get(), (Object)false, serverPlayer);
                }
                ((LivingEntity)entitypatch1.getOriginal()).m_21195_(MobEffects.f_19591_);
            }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH)});
        LIGHTNING_FLASH = new SpecialAttackNoRotAnimation(0.15f, 0.0f, 0.5f, 0.7f, 0.7f, LegendaryRebWeaponColliders.LightningFlash, biped.rootJoint, "biped/combat/lightning_flash", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)((SoundEvent)EpicFightSounds.WHOOSH_SHARP.get())).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)5.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG, Set.of(EpicFightDamageType.BYPASS_DODGE, DamageTypeTags.f_268725_, DamageTypeTags.f_268738_)).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)WOMParticles.KATANA_SHEATHED_HIT).addProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addProperty(AnimationProperty.StaticAnimationProperty.FIXED_HEAD_ROTATION, (Object)true).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self, entitypatch, speed, prevElapsedTime, elapsedTime) -> {
            if (elapsedTime >= 0.0f && elapsedTime < 0.4f) {
                return 0.3f;
            }
            if (elapsedTime > 0.7f && elapsedTime <= 1.2f) {
                return speed * 0.4f;
            }
            return speed;
        }).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.05f, (AnimationEvent.AnimationEventConsumer)WOMAnimations.ReuseableEvents.KATANA_IN, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.5f, (entitypatch, self, params) -> {
            if (entitypatch instanceof ServerPlayerPatch) {
                SkillDataManager dataManager;
                ServerPlayerPatch playerPatch = (ServerPlayerPatch)entitypatch;
                playerPatch.updateMotion(true);
                SkillContainer container = playerPatch.getSkill(LegendaryRebSkills.LightningFlash);
                if (container != null && container.hasSkill(LegendaryRebSkills.LightningFlash) && (dataManager = container.getDataManager()).hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed1.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed2.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed3.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed.get())) {
                    ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
                    LivingEntity target = player.m_21214_();
                    Vec3 speed = player.m_20154_();
                    if (target != null && target.m_6084_() && target != player) {
                        speed = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5 - (double)player.m_20206_() * 0.5, 0.0).m_82546_(player.m_20182_());
                    }
                    float plspeed = self.getPlaySpeed((LivingEntityPatch)playerPatch, (DynamicAnimation)self);
                    speed = speed.m_82541_().m_82490_(1.5 * (double)plspeed);
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed1.get(), (Object)Float.valueOf((float)speed.f_82479_), player);
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed2.get(), (Object)Float.valueOf((float)speed.f_82480_), player);
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed3.get(), (Object)Float.valueOf((float)speed.f_82481_), player);
                    dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed.get(), (Object)Float.valueOf(plspeed), player);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)0.7f, (entitypatch, self, params) -> {
            SkillDataManager dataManager;
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.LightningFlash)) != null && container.hasSkill(LegendaryRebSkills.LightningFlash) && (dataManager = container.getDataManager()).hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed1.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed2.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed3.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashTime.get())) {
                ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed1.get(), (Object)Float.valueOf(0.0f), player);
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed2.get(), (Object)Float.valueOf(0.0f), player);
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed3.get(), (Object)Float.valueOf(0.0f), player);
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime.get(), (Object)20, player);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)1.2f, (entitypatch, self, params) -> {
            SkillDataManager dataManager;
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.LightningFlash)) != null && container.hasSkill(LegendaryRebSkills.LightningFlash) && (dataManager = container.getDataManager()).hasData((SkillDataKey)LegendaryRebDataKeys.FlashTime.get()) && dataManager.hasData((SkillDataKey)LegendaryRebDataKeys.FlashSpeed.get())) {
                ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime.get(), (Object)0, player);
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashSpeed.get(), (Object)Float.valueOf(0.0f), player);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)2.05f, (entitypatch, self, params) -> entitypatch.playSound((SoundEvent)EpicFightSounds.WHOOSH.get(), 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.TimeStampedEvent.create((float)3.45f, (entitypatch, self, params) -> entitypatch.playSound((SoundEvent)EpicFightSounds.SWORD_IN.get(), 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).addEvents(AnimationProperty.StaticAnimationProperty.ON_END_EVENTS, new AnimationEvent[]{AnimationEvent.create((entitypatch, self, params) -> {
            SkillDataManager dataManager;
            ServerPlayerPatch playerPatch;
            SkillContainer container;
            if (entitypatch instanceof ServerPlayerPatch && (container = (playerPatch = (ServerPlayerPatch)entitypatch).getSkill(LegendaryRebSkills.LightningFlash)) != null && container.hasSkill(LegendaryRebSkills.LightningFlash) && (dataManager = container.getDataManager()).hasData((SkillDataKey)LegendaryRebDataKeys.FlashTime.get())) {
                ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
                dataManager.setDataSync((SkillDataKey)LegendaryRebDataKeys.FlashTime.get(), (Object)0, player);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
    }

    public static class ReuseableEvents {
        public static final AnimationEvent.TimeStampedEvent TimeFlyEvent = AnimationEvent.TimeStampedEvent.create((float)0.6f, (entitypatch, self, params) -> {
            List list = entitypatch.getCurrenltyAttackedEntities();
            if (!list.isEmpty()) {
                for (LivingEntity livingEntity : list) {
                    if (!livingEntity.m_6084_()) continue;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 70, 2, false, false, false));
                    livingEntity.m_20256_(new Vec3(livingEntity.m_20184_().f_82479_, livingEntity.m_20184_().f_82480_ + 1.3, livingEntity.m_20184_().f_82481_));
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
        public static final AnimationEvent.AnimationEventConsumer RUINE_COMET_GROUNDTHRUST = (entitypatch, self, params) -> {
            Vec3 floorPos = WOMAnimations.ReuseableEvents.getfloor((LivingEntityPatch)entitypatch, (StaticAnimation)self, (Vec3f)new Vec3f(0.0f, 0.0f, -1.4f), (Joint)Armatures.BIPED.toolR);
            BlockState blockState = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos(floorPos.f_82479_, floorPos.f_82480_, floorPos.f_82481_));
            if (entitypatch instanceof PlayerPatch) {
                ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_6269_((Player)entitypatch.getOriginal(), entitypatch.getOriginal(), blockState.m_60713_(Blocks.f_49990_) ? SoundEvents.f_11917_ : (SoundEvent)EpicFightSounds.GROUND_SLAM.get(), SoundSource.PLAYERS, 1.5f, 1.8f - (new Random().nextFloat() - 0.5f) * 0.2f);
            }
            ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)WOMParticles.WOM_GROUND_SLAM.get(), floorPos.f_82479_, (double)((int)floorPos.f_82480_ + 1), floorPos.f_82481_, 0.4, 25.0, 0.4);
        };
        public static final AnimationEvent.AnimationEventConsumer HEAVY_GROUNDSLAM = (entitypatch, self, params) -> {
            LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
            Vec3 position = entity.m_20182_();
            OpenMatrix4f modelTransform = entitypatch.getArmature().getBindedTransformFor(entitypatch.getAnimator().getPose(0.0f), Armatures.BIPED.toolR).mulFront(OpenMatrix4f.createTranslation((float)((float)position.f_82479_), (float)((float)position.f_82480_), (float)((float)position.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(1.0f))));
            Vec3 weaponEdge = OpenMatrix4f.transform((OpenMatrix4f)modelTransform, (Vec3)new Vec3f(0.0f, -0.0f, -2.4f).toDoubleVector());
            Level level = entity.m_9236_();
            Vec3 floorPos = WOMAnimations.ReuseableEvents.getfloor((LivingEntityPatch)entitypatch, (StaticAnimation)self, (Vec3f)new Vec3f(0.0f, 0.0f, -2.4f), (Joint)Armatures.BIPED.toolR);
            BlockState blockState = entity.m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos(floorPos.f_82479_, floorPos.f_82480_, floorPos.f_82481_));
            Vec3 centre = new Vec3(weaponEdge.f_82479_, floorPos.f_82480_, weaponEdge.f_82481_);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                HeavyAttackEvent.DealDamage(entity, entitypatch, serverLevel, centre);
            }
            if (level.m_5776_()) {
                if (entitypatch instanceof PlayerPatch) {
                    level.m_6269_((Player)entity, (Entity)entity, blockState.m_60713_(Blocks.f_49990_) ? SoundEvents.f_11917_ : (SoundEvent)EpicFightSounds.GROUND_SLAM.get(), SoundSource.PLAYERS, 1.5f, 1.1f - (new Random().nextFloat() - 0.5f) * 0.2f);
                }
                entity.m_9236_().m_7106_((ParticleOptions)WOMParticles.WOM_GROUND_SLAM.get(), floorPos.f_82479_, (double)((int)floorPos.f_82480_ + 1), floorPos.f_82481_, 1.0, 50.0, 1.0);
            }
        };
        public static final AnimationEvent.AnimationEventConsumer LOOPED_FALLING_MOVE = (entitypatch, self, params) -> {
            float dpx = (float)((LivingEntity)entitypatch.getOriginal()).m_20185_();
            float dpy = (float)((LivingEntity)entitypatch.getOriginal()).m_20186_();
            float dpz = (float)((LivingEntity)entitypatch.getOriginal()).m_20189_();
            BlockState block = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)dpy, (double)dpz));
            while ((block.m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_)) {
                block = ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_8055_((BlockPos)new BlockPos.MutableBlockPos((double)dpx, (double)(dpy -= 1.0f), (double)dpz));
            }
            dpy = (int)dpy;
            float A = 4.0f;
            float B = 0.01f;
            float vertical_distance = (float)((double)A * (1.0 - Math.exp((double)(-B) * (((LivingEntity)entitypatch.getOriginal()).m_20186_() - (double)dpy))));
            if (((LivingEntity)entitypatch.getOriginal()).m_20186_() - (double)dpy > 4.0 && ((LivingEntity)entitypatch.getOriginal()).m_20184_().f_82480_ < (double)-0.08f) {
                LivingEntity livingentity = (LivingEntity)entitypatch.getOriginal();
                Vec3f direction = new Vec3f(0.5f * vertical_distance, 0.0f, 0.0f);
                OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_20884_ + 90.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
                OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
                livingentity.m_6478_(MoverType.SELF, direction.toDoubleVector());
            }
        };
        public static final AnimationEvent.TimeStampedEvent FireTachiTrailZero = AnimationEvent.TimeStampedEvent.create((float)0.0f, (entityPatch, self, params) -> {
            if (entityPatch instanceof PlayerPatch) {
                PlayerPatch playerPatch = (PlayerPatch)entityPatch;
                Player entity = (Player)playerPatch.getOriginal();
                if (!((LegendaryRebModVariables.PlayerVariables)entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new LegendaryRebModVariables.PlayerVariables())).player_last_trail.isEmpty()) {
                    entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                        capability.player_last_trail = new ArrayList();
                        capability.syncPlayerVariables((Entity)entity);
                    });
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
        public static final AnimationEvent.TimePeriodEvent FireTachiTrail = AnimationEvent.TimePeriodEvent.create((float)0.0f, (float)Float.MAX_VALUE, (entityPatch, self, params) -> {
            if (entityPatch instanceof LocalPlayerPatch) {
                LocalPlayerPatch playerPatch = (LocalPlayerPatch)entityPatch;
                if (entityPatch.getEntityState().movementLocked()) {
                    ReuseableEvents.ParticleTrail(playerPatch, -0.4f, -3.6f, ParticleTypes.f_123745_, ParticleTypes.f_123744_);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);

        public static void ParticleTrail(LocalPlayerPatch playerPatch, float beginpos, float endpos, SimpleParticleType particleType1, SimpleParticleType particleType2) {
            Player entity = (Player)playerPatch.getOriginal();
            Level level = entity.m_9236_();
            float length = Math.abs(endpos - beginpos);
            float numberOf = length * 2.0f;
            float partialScale = 1.0f / (numberOf - 1.0f);
            OpenMatrix4f transformMatrix = playerPatch.getArmature().getBindedTransformFor(playerPatch.getAnimator().getPose(0.0f), Armatures.BIPED.toolR);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, beginpos));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            Vec3 vec0 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32);
            transformMatrix.translate(new Vec3f(0.0f, 0.0f, endpos - beginpos));
            Vec3 vec1 = new Vec3((double)transformMatrix.m30, (double)transformMatrix.m31, (double)transformMatrix.m32).m_82546_(vec0);
            vec1 = vec1.m_82541_().m_82490_((double)length);
            vec0 = vec0.m_82549_(entity.m_20182_());
            ArrayList<Vec3> vec3s = new ArrayList<Vec3>();
            ArrayList<Vec3> vec3s1 = ((LegendaryRebModVariables.PlayerVariables)entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new LegendaryRebModVariables.PlayerVariables())).player_last_trail;
            vec3s.add(vec0);
            vec3s.add(vec1);
            entity.getCapability(LegendaryRebModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                capability.player_last_trail = vec3s;
                capability.syncPlayerVariables((Entity)entity);
            });
            if (!vec3s1.isEmpty()) {
                Vec3 vec2 = vec3s1.get(0);
                Vec3 vec3 = vec3s1.get(1);
                Vec3 vec4 = vec0.m_82546_(vec2);
                double ablength = vec4.m_82553_();
                float adlength = new Random().nextFloat(0.3f, 0.7f);
                ReuseableEvents.ParticleAdd(0.0f, adlength, partialScale, ablength, length, vec0, vec1, vec2, vec3, vec4, level, (ParticleOptions)particleType1);
                ReuseableEvents.ParticleAdd(adlength, 1.0f, partialScale, ablength, length, vec0, vec1, vec2, vec3, vec4, level, (ParticleOptions)particleType2);
            }
        }

        private static void ParticleAdd(float begin, float end, float partialScale, double ablength, double aclength, Vec3 vec0, Vec3 vec1, Vec3 vec2, Vec3 vec3, Vec3 vec4, Level level, ParticleOptions particleType) {
            for (float interpolation = begin; interpolation <= end; interpolation += partialScale) {
                Vec3 vec7 = vec2;
                Vec3 vec8 = vec2.m_82549_(vec3.m_82490_((double)interpolation));
                Vec3 vec9 = vec0.m_82549_(vec1.m_82490_((double)interpolation));
                Vec3 vec5 = vec9.m_82546_(vec8);
                double aalength = vec5.m_82553_() / 0.4;
                vec4 = vec4.m_82541_().m_82490_(ablength).m_82490_(1.0 / aalength);
                double length1 = aclength * (double)interpolation;
                double length2 = aclength * (double)(1.0f - interpolation);
                double speed = 1.0 - 1.0 / aalength;
                speed *= 0.4;
                int i = 0;
                while ((double)i < aalength) {
                    Vec3 vec6 = vec1.m_82490_((double)i / aalength).m_82549_(vec3.m_82490_((aalength - (double)i) / aalength)).m_82541_();
                    Vec3 vec11 = vec6.m_82490_(length1);
                    Vec3 vec10 = vec6.m_82490_(length2).m_82546_(vec4.m_82490_(aclength * 100.0));
                    vec10 = vec10.m_82541_().m_82490_(speed);
                    level.m_7106_(particleType, vec7.f_82479_ + vec11.f_82479_, vec7.f_82480_ + vec11.f_82480_, vec7.f_82481_ + vec11.f_82481_, vec10.f_82479_, vec10.f_82480_, vec10.f_82481_);
                    vec7 = vec7.m_82549_(vec4);
                    ++i;
                }
            }
        }
    }
}

