/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.math.NumberUtils;

public record DurationInfo(String desc, long until) {
    private static final DurationInfo INDEFINITE = new DurationInfo("until further notice", -1L);
    private static final Supplier<IllegalArgumentException> INVALID_FORMAT = () -> new IllegalArgumentException("Expected format: <number>[smhdw]");
    private static final Map<Character, Integer> UNIT_MAP = Map.of(Character.valueOf('s'), 1000, Character.valueOf('m'), 60000, Character.valueOf('h'), 3600000, Character.valueOf('d'), 86400000, Character.valueOf('w'), 604800000);

    public static DurationInfo fromString(String durationStr) {
        if (durationStr.isEmpty() || durationStr.startsWith("*")) {
            return INDEFINITE;
        }
        if (durationStr.length() < 2) {
            throw INVALID_FORMAT.get();
        }
        char unit = durationStr.charAt(durationStr.length() - 1);
        String count = durationStr.substring(0, durationStr.length() - 1);
        if (!NumberUtils.isParsable((String)count) || !UNIT_MAP.containsKey(Character.valueOf(unit))) {
            throw INVALID_FORMAT.get();
        }
        long duration = Math.max(0L, (long)(Double.parseDouble(count) * (double)UNIT_MAP.get(Character.valueOf(unit)).intValue()));
        return new DurationInfo("for " + TimeUtils.prettyTimeString((long)(duration / 1000L)), System.currentTimeMillis() + duration);
    }

    public static long getSeconds(String durationStr) {
        DurationInfo info = DurationInfo.fromString(durationStr.isEmpty() ? "0s" : durationStr);
        return (info.until() - System.currentTimeMillis()) / 1000L;
    }
}

