/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class TPACommands {
    public static final HashMap<String, TPARequest> REQUESTS = new HashMap();

    public static TPARequest create(FTBEPlayerData source, FTBEPlayerData target, boolean here) {
        String key;
        while (REQUESTS.containsKey(key = String.format("%08X", new Random().nextInt()))) {
        }
        TPARequest r = new TPARequest(key, source, target, here, System.currentTimeMillis());
        REQUESTS.put(key, r);
        return r;
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.TPA.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpa").requires((Predicate)FTBEConfig.TPA)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TPACommands.tpa(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), false))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpahere").requires((Predicate)FTBEConfig.TPA)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TPACommands.tpa(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), true))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpaccept").requires((Predicate)FTBEConfig.TPA)).then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> TPACommands.tpaccept(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpdeny").requires((Predicate)FTBEConfig.TPA)).then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> TPACommands.tpdeny(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
        }
    }

    public static int tpa(ServerPlayer player, ServerPlayer target, boolean here) {
        TeleportPos.TeleportResult result;
        FTBEPlayerData dataSource = FTBEPlayerData.getOrCreate((Player)player).orElse(null);
        FTBEPlayerData dataTarget = FTBEPlayerData.getOrCreate((Player)target).orElse(null);
        if (dataSource == null || dataTarget == null) {
            return 0;
        }
        if (REQUESTS.values().stream().anyMatch(r -> r.source == dataSource && r.target == dataTarget)) {
            player.m_5661_((Component)Component.m_237113_((String)"\u8bf7\u6c42\u5df2\u7ecf\u53d1\u9001!"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = here ? dataTarget.tpaTeleporter.checkCooldown() : dataSource.tpaTeleporter.checkCooldown();
        if (!result.isSuccess()) {
            return result.runCommand(player);
        }
        TPARequest request = TPACommands.create(dataSource, dataTarget, here);
        MutableComponent component = Component.m_237113_((String)"\u4f20\u9001\u8bf7\u6c42[");
        component.m_7220_((Component)(here ? target : player).m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW));
        component.m_130946_(" \u27a1 ");
        component.m_7220_((Component)(here ? player : target).m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW));
        component.m_130946_(" ]");
        MutableComponent component2 = Component.m_237113_((String)"\u70b9\u51fb\u4e00\u4e2a\u9009\u9879:");
        component2.m_7220_((Component)Component.m_237113_((String)"\u63a5\u53d7 \u2714").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept " + request.id)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u70b9\u51fb\u63a5\u53d7")))));
        component2.m_130946_(" | ");
        component2.m_7220_((Component)Component.m_237113_((String)"\u62d2\u7edd\u274c").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny " + request.id)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u70b9\u51fb\u62d2\u7edd")))));
        component2.m_130946_(" |");
        target.m_5661_((Component)component, false);
        target.m_5661_((Component)component2, false);
        player.m_5661_((Component)Component.m_237113_((String)"\u8bf7\u6c42\u53d1\u9001!"), false);
        return 1;
    }

    public static int tpaccept(ServerPlayer player, String id) {
        TeleportPos.TeleportResult result;
        TPARequest request = REQUESTS.get(id);
        if (request == null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u65e0\u6548\u8bf7\u6c42!"), false);
            return 0;
        }
        ServerPlayer sourcePlayer = player.f_8924_.m_6846_().m_11259_(request.source.getUuid());
        if (sourcePlayer == null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u73a9\u5bb6\u79bb\u7ebf!"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = request.here ? request.target.tpaTeleporter.teleport(player, p -> new TeleportPos((Entity)sourcePlayer)) : request.source.tpaTeleporter.teleport(sourcePlayer, p -> new TeleportPos((Entity)player));
        if (result.isSuccess()) {
            REQUESTS.remove(request.id);
        }
        return result.runCommand(player);
    }

    public static int tpdeny(ServerPlayer player, String id) {
        TPARequest request = REQUESTS.get(id);
        if (request == null) {
            player.m_5661_((Component)Component.m_237113_((String)"\u65e0\u6548\u8bf7\u6c42!"), false);
            return 0;
        }
        REQUESTS.remove(request.id);
        player.m_5661_((Component)Component.m_237113_((String)"messages.ftbessentials.11"), false);
        ServerPlayer player2 = player.f_8924_.m_6846_().m_11259_(request.target.getUuid());
        if (player2 != null) {
            player2.m_5661_((Component)Component.m_237113_((String)"messages.ftbessentials.11"), false);
        }
        return 1;
    }

    public record TPARequest(String id, FTBEPlayerData source, FTBEPlayerData target, boolean here, long created) {
    }
}

