/*
 * Decompiled with CFR 0.152.
 */
package jeresources.forge.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import jeresources.config.Settings;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigValues {
    public static ForgeConfigSpec.IntValue itemsPerColumn;
    public static ForgeConfigSpec.IntValue itemsPerRow;
    public static ForgeConfigSpec.BooleanValue diyData;
    public static ForgeConfigSpec.BooleanValue showDevData;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> enchantsBlacklist;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> hiddenTabs;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> dimensionsBlacklist;
    public static ForgeConfigSpec.BooleanValue disableLootManagerReloading;

    public static ForgeConfigSpec build() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        itemsPerColumn = builder.defineInRange("itemsPerColumn", 4, 1, 4);
        itemsPerRow = builder.defineInRange("itemsPerRow", 4, 1, 4);
        diyData = builder.worldRestart().define("diyData", true);
        showDevData = builder.worldRestart().define("showDevData", false);
        enchantsBlacklist = builder.worldRestart().defineList("enchantsBlacklist", List.of("flimflam", "soulBound"), (Predicate)new TypePredicate(String.class));
        hiddenTabs = builder.worldRestart().defineList("hiddenTabs", new ArrayList(), (Predicate)new TypePredicate(String.class));
        dimensionsBlacklist = builder.worldRestart().defineList("dimensionsBlacklist", List.of(Integer.valueOf(-11)), (Predicate)new TypePredicate(Integer.class));
        disableLootManagerReloading = builder.worldRestart().define("disableLootManagerReloading", false);
        return builder.build();
    }

    public static void pushChanges() {
        Settings.ITEMS_PER_COLUMN = (Integer)itemsPerColumn.get();
        Settings.ITEMS_PER_ROW = (Integer)itemsPerRow.get();
        Settings.useDIYdata = (Boolean)diyData.get();
        Settings.showDevData = (Boolean)showDevData.get();
        Settings.disableLootManagerReloading = (Boolean)disableLootManagerReloading.get();
        Settings.excludedEnchants = ((List)enchantsBlacklist.get()).toArray(new String[0]);
        Settings.hiddenCategories = ((List)hiddenTabs.get()).toArray(new String[0]);
        Settings.excludedDimensions = new ArrayList<Integer>((Collection)dimensionsBlacklist.get());
        Settings.reload();
    }

    private static class TypePredicate
    implements Predicate<Object> {
        private Class type;

        public TypePredicate(Class type) {
            this.type = type;
        }

        @Override
        public boolean test(Object o) {
            return this.type.isInstance(o);
        }
    }
}

