/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.util.raytrace;

import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2library.util.raytrace.IGlowingTarget;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityTarget {
    public static final ArrayList<EntityTarget> LIST = new ArrayList();
    public final double max_distance;
    public final double max_angle;
    public final int max_time;
    public int time;
    public Entity target;

    public EntityTarget(double max_distance, double max_angle, int max_time) {
        this.max_distance = max_distance;
        this.max_angle = max_angle;
        this.max_time = max_time;
        LIST.add(this);
    }

    public void updateTarget(@Nullable Entity entity) {
        if (this.target != entity) {
            this.onChange(entity);
        }
        this.target = entity;
        this.time = 0;
    }

    public void onChange(@Nullable Entity entity) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickRender() {
        if (this.target == null) {
            return;
        }
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null) {
            this.updateTarget(null);
            return;
        }
        ItemStack stack = player.m_21205_();
        int distance = 0;
        Item item = stack.m_41720_();
        if (item instanceof IGlowingTarget) {
            IGlowingTarget glow = (IGlowingTarget)item;
            distance = glow.getDistance(stack);
        }
        if (distance == 0) {
            this.updateTarget(null);
            return;
        }
        Vec3 pos_a = player.m_146892_();
        Vec3 vec = player.m_20252_(1.0f);
        Vec3 pos_b = this.target.m_20318_(1.0f);
        Vec3 diff = pos_b.m_82546_(pos_a);
        double dot = diff.m_82526_(vec);
        double len_d = diff.m_82553_();
        double len_v = vec.m_82553_();
        double angle = Math.acos(dot / len_d / len_v);
        double dist = Math.sin(angle) * len_d;
        if (angle > this.max_angle && dist > this.max_distance) {
            this.updateTarget(null);
        }
        ++this.time;
        if (this.time >= this.max_time) {
            this.updateTarget(null);
        }
    }
}

