/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.xkmc.l2serial.serialization.codec.JsonCodec;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractShapelessRecipe<T extends AbstractShapelessRecipe<T>>
extends ShapelessRecipe {
    public AbstractShapelessRecipe(ResourceLocation rl, String group, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(rl, group, CraftingBookCategory.MISC, result, ingredients);
    }

    public List<ItemStack> getJEIResult() {
        return List.of(this.f_44243_);
    }

    public abstract Serializer<T> getSerializer();

    public static class Serializer<T extends AbstractShapelessRecipe<T>>
    extends ShapelessRecipe.Serializer {
        private final RecipeFactory<T> factory;

        public Serializer(RecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject obj) {
            ShapelessRecipe r = super.m_6729_(id, obj);
            return this.factory.create(r.m_6423_(), r.m_6076_(), r.f_44243_, (NonNullList<Ingredient>)r.m_7527_());
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf obj) {
            ShapelessRecipe r = super.m_8005_(id, obj);
            if (r == null) {
                return null;
            }
            return this.factory.create(r.m_6423_(), r.m_6076_(), r.f_44243_, (NonNullList<Ingredient>)r.m_7527_());
        }

        public void toJson(T recipe, JsonObject obj) {
        }
    }

    public static class SerialSerializer<T extends AbstractShapelessRecipe<T>>
    extends Serializer<T> {
        private final Class<T> cls;

        public SerialSerializer(Class<T> cls, RecipeFactory<T> factory) {
            super(factory);
            this.cls = cls;
        }

        @Override
        public T fromJson(ResourceLocation id, JsonObject obj) {
            return (T)((Object)Objects.requireNonNull((AbstractShapelessRecipe)((Object)JsonCodec.from((JsonElement)obj, this.cls, super.fromJson(id, obj)))));
        }

        public void m_6178_(FriendlyByteBuf buf, ShapelessRecipe rec) {
            super.m_6178_(buf, rec);
            PacketCodec.to((FriendlyByteBuf)buf, (Object)rec);
        }

        @Override
        public T fromNetwork(ResourceLocation id, FriendlyByteBuf obj) {
            return (T)((Object)((AbstractShapelessRecipe)((Object)PacketCodec.from((FriendlyByteBuf)obj, this.cls, super.fromNetwork(id, obj)))));
        }

        @Override
        public void toJson(T recipe, JsonObject obj) {
            JsonCodec.toJsonObject(recipe, (JsonObject)obj);
        }
    }

    @FunctionalInterface
    public static interface RecipeFactory<T extends AbstractShapelessRecipe<T>> {
        public T create(ResourceLocation var1, String var2, ItemStack var3, NonNullList<Ingredient> var4);
    }
}

