/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.init.events;

import dev.xkmc.l2library.base.effects.EffectToClient;
import dev.xkmc.l2library.init.L2Library;
import dev.xkmc.l2library.init.data.L2TagGen;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="l2library", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EffectSyncEvents {
    @Deprecated
    public static final Set<MobEffect> TRACKED = new HashSet<MobEffect>();

    public static boolean tracked(MobEffect eff) {
        return TRACKED.contains(eff) || ForgeRegistries.MOB_EFFECTS.tags().getTag(L2TagGen.TRACKED_EFFECTS).contains((Object)eff);
    }

    @SubscribeEvent
    public static void onPotionAddedEvent(MobEffectEvent.Added event) {
        if (EffectSyncEvents.tracked(event.getEffectInstance().m_19544_())) {
            EffectSyncEvents.onEffectAppear(event.getEffectInstance().m_19544_(), event.getEntity(), event.getEffectInstance().m_19564_());
        }
    }

    @SubscribeEvent
    public static void onPotionRemoveEvent(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() != null && EffectSyncEvents.tracked(event.getEffectInstance().m_19544_())) {
            EffectSyncEvents.onEffectDisappear(event.getEffectInstance().m_19544_(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPotionExpiryEvent(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && EffectSyncEvents.tracked(event.getEffectInstance().m_19544_())) {
            EffectSyncEvents.onEffectDisappear(event.getEffectInstance().m_19544_(), event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        for (MobEffect eff : le.m_21221_().keySet()) {
            if (!EffectSyncEvents.tracked(eff)) continue;
            EffectSyncEvents.onEffectAppear(eff, le, ((MobEffectInstance)le.m_21221_().get(eff)).m_19564_());
        }
    }

    @SubscribeEvent
    public static void onPlayerStopTracking(PlayerEvent.StopTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        for (MobEffect eff : le.m_21221_().keySet()) {
            if (!EffectSyncEvents.tracked(eff)) continue;
            EffectSyncEvents.onEffectDisappear(eff, le);
        }
    }

    @SubscribeEvent
    public static void onServerPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer e = (ServerPlayer)event.getEntity();
        if (e != null) {
            for (MobEffect eff : e.m_21221_().keySet()) {
                if (!EffectSyncEvents.tracked(eff)) continue;
                EffectSyncEvents.onEffectAppear(eff, (LivingEntity)e, ((MobEffectInstance)e.m_21221_().get(eff)).m_19564_());
            }
        }
    }

    @SubscribeEvent
    public static void onServerPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer e = (ServerPlayer)event.getEntity();
        if (e != null) {
            for (MobEffect eff : e.m_21221_().keySet()) {
                if (!EffectSyncEvents.tracked(eff)) continue;
                EffectSyncEvents.onEffectDisappear(eff, (LivingEntity)e);
            }
        }
    }

    private static void onEffectAppear(MobEffect eff, LivingEntity e, int lv) {
        if (e.m_9236_().m_5776_()) {
            return;
        }
        L2Library.PACKET_HANDLER.toTrackingPlayers((SimplePacketBase)new EffectToClient(e.m_19879_(), eff, true, lv), (Entity)e);
    }

    private static void onEffectDisappear(MobEffect eff, LivingEntity e) {
        if (e.m_9236_().m_5776_()) {
            return;
        }
        L2Library.PACKET_HANDLER.toTrackingPlayers((SimplePacketBase)new EffectToClient(e.m_19879_(), eff, false, 0), (Entity)e);
    }
}

