/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.path;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class SetRandomHoverTarget<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected BiFunction<E, Vec3, Float> speedModifier = (entity, targetPos) -> Float.valueOf(1.0f);
    protected SquareRadius radius = new SquareRadius(10.0, 7.0);
    protected BiPredicate<E, Vec3> positionPredicate = (entity, pos) -> true;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetRandomHoverTarget<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public SetRandomHoverTarget<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public SetRandomHoverTarget<E> speedModifier(float modifier) {
        return this.speedModifier((entity, targetPos) -> Float.valueOf(modifier));
    }

    public SetRandomHoverTarget<E> speedModifier(BiFunction<E, Vec3, Float> function) {
        this.speedModifier = function;
        return this;
    }

    public SetRandomHoverTarget<E> flightTargetPredicate(BiPredicate<E, Vec3> predicate) {
        this.positionPredicate = predicate;
        return this;
    }

    @Override
    protected void start(E entity) {
        Vec3 targetPos = this.getTargetPos(entity);
        if (!this.positionPredicate.test(entity, targetPos)) {
            targetPos = null;
        }
        if (targetPos == null) {
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26370_);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.f_26370_, new WalkTarget(targetPos, this.speedModifier.apply(entity, targetPos).floatValue(), 0));
        }
    }

    @Nullable
    protected Vec3 getTargetPos(E entity) {
        Vec3 entityFacing = entity.m_20252_(0.0f);
        Vec3 hoverPos = HoverRandomPos.m_148465_(entity, (int)((int)Math.ceil(this.radius.xzRadius())), (int)((int)Math.ceil(this.radius.yRadius())), (double)entityFacing.f_82479_, (double)entityFacing.f_82481_, (float)1.5707964f, (int)3, (int)1);
        if (hoverPos != null) {
            return hoverPos;
        }
        return AirAndWaterRandomPos.m_148357_(entity, (int)((int)Math.ceil(this.radius.xzRadius())), (int)((int)Math.ceil(this.radius.yRadius())), (int)-2, (double)entityFacing.f_82479_, (double)entityFacing.f_82481_, (double)1.5707963705062866);
    }
}

