/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class FollowTemptation<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_148197_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_148198_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_148196_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_217768_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26375_, (Object)MemoryStatus.REGISTERED)});
    protected BiFunction<E, Player, Float> speedMod = (entity, temptingPlayer) -> Float.valueOf(1.0f);
    protected BiPredicate<E, Player> shouldFollow = (entity, temptingPlayer) -> {
        Animal animal;
        return (!(entity instanceof Animal) || (animal = (Animal)entity).m_146764_() == 0) && !BrainUtils.hasMemory((LivingEntity)entity, MemoryModuleType.f_217768_);
    };
    protected BiFunction<E, Player, Float> closeEnoughWhen = (owner, temptingPlayer) -> Float.valueOf(2.5f);
    protected Object2IntFunction<E> temptationCooldown = entity -> 100;

    public FollowTemptation() {
        this.noTimeout();
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public FollowTemptation<E> speedMod(BiFunction<E, Player, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public FollowTemptation<E> followIf(BiPredicate<E, Player> predicate) {
        this.shouldFollow = predicate;
        return this;
    }

    public FollowTemptation<E> closeEnoughDist(BiFunction<E, Player, Float> closeEnoughMod) {
        this.closeEnoughWhen = closeEnoughMod;
        return this;
    }

    public FollowTemptation<E> temptationCooldown(Object2IntFunction<E> cooldownFunction) {
        this.temptationCooldown = cooldownFunction;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return this.shouldFollow.test(entity, (Player)BrainUtils.getMemory(entity, MemoryModuleType.f_148196_));
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, MemoryModuleType.f_148196_) && !BrainUtils.hasMemory(entity, MemoryModuleType.f_148197_) && !BrainUtils.hasMemory(entity, MemoryModuleType.f_26375_) && this.shouldFollow.test(entity, (Player)BrainUtils.getMemory(entity, MemoryModuleType.f_148196_));
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.f_148198_, Boolean.valueOf(true));
    }

    @Override
    protected void tick(E entity) {
        Player temptingPlayer = (Player)BrainUtils.getMemory(entity, MemoryModuleType.f_148196_);
        float closeEnough = this.closeEnoughWhen.apply(entity, temptingPlayer).floatValue();
        BrainUtils.setMemory(entity, MemoryModuleType.f_26371_, new EntityTracker((Entity)temptingPlayer, true));
        if (entity.m_20280_((Entity)temptingPlayer) < (double)(closeEnough * closeEnough)) {
            BrainUtils.clearMemory(entity, MemoryModuleType.f_26370_);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.f_26370_, new WalkTarget((PositionTracker)new EntityTracker((Entity)temptingPlayer, false), this.speedMod.apply(entity, temptingPlayer).floatValue(), (int)closeEnough));
        }
    }

    @Override
    protected void stop(E entity) {
        int cooldownTicks = (Integer)this.temptationCooldown.apply(entity);
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.f_148197_, Integer.valueOf(cooldownTicks), cooldownTicks);
        BrainUtils.setMemory(entity, MemoryModuleType.f_148198_, Boolean.valueOf(false));
        BrainUtils.clearMemories(entity, new MemoryModuleType[]{MemoryModuleType.f_26370_, MemoryModuleType.f_26371_});
    }
}

