/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.apache.commons.lang3.function.ToBooleanBiFunction;

public class InvalidateMemory<E extends LivingEntity, M>
extends ExtendedBehaviour<E> {
    private List<Pair<MemoryModuleType<?>, MemoryStatus>> memoryRequirements;
    protected ToBooleanBiFunction<E, M> customPredicate = (entity, target) -> true;
    protected MemoryModuleType<M> memory;

    public InvalidateMemory(MemoryModuleType<M> memory) {
        this.memory = memory;
        this.memoryRequirements = List.of(Pair.of(this.memory, (Object)MemoryStatus.VALUE_PRESENT));
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return this.memoryRequirements == null ? List.of() : this.memoryRequirements;
    }

    public InvalidateMemory<E, M> forMemory(MemoryModuleType<M> memory) {
        this.memory = memory;
        this.memoryRequirements = List.of(Pair.of(this.memory, (Object)MemoryStatus.VALUE_PRESENT));
        return this;
    }

    public InvalidateMemory<E, M> invalidateIf(ToBooleanBiFunction<E, M> predicate) {
        this.customPredicate = predicate;
        return this;
    }

    @Override
    protected void start(E entity) {
        M memory = BrainUtils.getMemory(entity, this.memory);
        if (memory != null && this.customPredicate.applyAsBoolean(entity, memory)) {
            BrainUtils.clearMemory(entity, this.memory);
        }
    }
}

