/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementFrame;
import de.dafuqs.paginatedadvancements.frames.AdvancementFrameTypeDataLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.FrameType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class FrameWrapper {
    public abstract ResourceLocation getId();

    public abstract int getTextureU();

    public abstract int getTextureV();

    public abstract int getItemOffsetX();

    public abstract int getItemOffsetY();

    public abstract ChatFormatting getFormatting();

    public abstract ResourceLocation getTextureSheet();

    @Nullable
    public static FrameWrapper of(ResourceLocation frame) {
        PaginatedAdvancementFrame paginatedFrame;
        String path = frame.m_135815_();
        if (frame.m_135827_().equals("minecraft")) {
            for (FrameType vanillaFrame : FrameType.values()) {
                if (!vanillaFrame.m_15548_().equals(path)) continue;
                return new VanillaFrameWrapper(vanillaFrame);
            }
        }
        return (paginatedFrame = AdvancementFrameTypeDataLoader.getFrameForAdvancement(frame)) == null ? null : new PaginatedFrameWrapper(paginatedFrame);
    }

    public static class VanillaFrameWrapper
    extends FrameWrapper {
        public final FrameType frame;

        private VanillaFrameWrapper(FrameType frame) {
            this.frame = frame;
        }

        @Override
        public ResourceLocation getId() {
            return ResourceLocation.m_135820_((String)this.frame.m_15548_());
        }

        @Override
        public int getTextureU() {
            return this.frame.m_15551_();
        }

        @Override
        public int getTextureV() {
            return 128;
        }

        @Override
        public int getItemOffsetX() {
            return 0;
        }

        @Override
        public int getItemOffsetY() {
            return 0;
        }

        @Override
        public ChatFormatting getFormatting() {
            return this.frame.m_15552_();
        }

        @Override
        public ResourceLocation getTextureSheet() {
            return ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/widgets.png");
        }
    }

    public static class PaginatedFrameWrapper
    extends FrameWrapper {
        public final PaginatedAdvancementFrame frame;

        private PaginatedFrameWrapper(PaginatedAdvancementFrame frame) {
            this.frame = frame;
        }

        @Override
        public ResourceLocation getId() {
            return this.frame.getId();
        }

        @Override
        public int getTextureU() {
            return this.frame.getTextureU();
        }

        @Override
        public int getTextureV() {
            return this.frame.getTextureV();
        }

        @Override
        public int getItemOffsetX() {
            return this.frame.getItemOffsetX();
        }

        @Override
        public int getItemOffsetY() {
            return this.frame.getItemOffsetY();
        }

        @Override
        public ChatFormatting getFormatting() {
            return this.frame.getFormatting();
        }

        @Override
        public ResourceLocation getTextureSheet() {
            return this.frame.getTextureSheet();
        }
    }
}

