/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementFrame;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameTypeDataLoader
extends SimpleJsonResourceReloadListener {
    public static final String LOCATION = "advancement_frame_types";
    public static final ResourceLocation ID = PaginatedAdvancementsClient.locate("advancement_frame_types");
    public static final AdvancementFrameTypeDataLoader INSTANCE = new AdvancementFrameTypeDataLoader();
    protected static final Map<ResourceLocation, PaginatedAdvancementFrame> FRAMES = new HashMap<ResourceLocation, PaginatedAdvancementFrame>();

    public AdvancementFrameTypeDataLoader() {
        super(new Gson(), LOCATION);
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> m_5944_(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        return super.m_5944_(resourceManager, profiler);
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        prepared.forEach((identifier, jsonElement) -> {
            JsonObject object = jsonElement.getAsJsonObject();
            ResourceLocation textureSheet = ResourceLocation.fromNamespaceAndPath((String)identifier.m_135827_(), (String)object.get("texture_sheet").getAsString());
            for (JsonElement frameEntry : object.get("frames").getAsJsonArray()) {
                JsonObject jsonObject = frameEntry.getAsJsonObject();
                ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)identifier.m_135827_(), (String)jsonObject.get("name").getAsString());
                int u = jsonObject.get("x").getAsInt();
                int v = jsonObject.get("y").getAsInt();
                int itemOffsetX = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"item_offset_x", (int)0);
                int itemOffsetY = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"item_offset_y", (int)0);
                String formattingString = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"formatting", (String)"green");
                ChatFormatting formatting = ChatFormatting.m_126657_((String)formattingString);
                if (formatting == null) {
                    PaginatedAdvancementsClient.LOGGER.error("Formatting for frame '{}' is invalid: '{}'. Will use default 'green'", (Object)name, (Object)formattingString);
                    formatting = ChatFormatting.GREEN;
                }
                PaginatedAdvancementFrame frame = new PaginatedAdvancementFrame(name, textureSheet, u, v, itemOffsetX, itemOffsetY, formatting);
                FRAMES.put(name, frame);
            }
        });
    }

    @Nullable
    public static PaginatedAdvancementFrame getFrameForAdvancement(ResourceLocation id) {
        return FRAMES.getOrDefault(id, null);
    }
}

