/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.paginatedadvancements.frames.AdvancementFrameDataLoader;
import de.dafuqs.paginatedadvancements.frames.FrameWrapper;
import de.dafuqs.paginatedadvancements.mixin.AdvancementWidgetAccessor;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PaginatedAdvancementWidget
extends AdvancementWidget {
    private static final ResourceLocation VANILLA_WIDGETS_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/widgets.png");
    protected List<FormattedCharSequence> description;
    @Nullable
    protected FrameWrapper frameWrapper;
    private final Minecraft client;
    private int debugScrollAmount;

    public PaginatedAdvancementWidget(AdvancementTab tab, Minecraft client, Advancement placedAdvancement, DisplayInfo display) {
        super(tab, client, placedAdvancement, display);
        this.client = client;
        AdvancementWidgetAccessor accessor = (AdvancementWidgetAccessor)((Object)this);
        this.frameWrapper = AdvancementFrameDataLoader.get(accessor.getAdvancement().m_138327_());
        int requirementCount = placedAdvancement.m_138329_().length;
        int k = requirementCount > 1 ? client.f_91062_.m_92895_("  ") + client.f_91062_.m_92895_("0") * String.valueOf(requirementCount).length() * 2 + client.f_91062_.m_92895_("/") : 0;
        int l = 29 + client.f_91062_.m_92724_(accessor.getTitle()) + k;
        this.description = this.frameWrapper != null ? Language.m_128107_().m_128112_(accessor.invokeWrapDescription((Component)ComponentUtils.m_130750_((MutableComponent)display.m_14985_().m_6881_(), (Style)Style.f_131099_.m_131140_(this.frameWrapper.getFormatting())), l)) : accessor.getDescription();
        for (FormattedCharSequence orderedText : this.description) {
            l = Math.max(l, client.f_91062_.m_92724_(orderedText));
        }
        this.setDebugScrollAmount(0);
    }

    public void m_280229_(@NotNull GuiGraphics context, int x, int y) {
        AdvancementWidgetAccessor accessor = (AdvancementWidgetAccessor)((Object)this);
        if (!accessor.getDisplay().m_14997_() || accessor.getProgress() != null && accessor.getProgress().m_8193_()) {
            float f = accessor.getProgress() == null ? 0.0f : accessor.getProgress().m_8213_();
            AdvancementWidgetType advancementObtainedStatus = f >= 1.0f ? AdvancementWidgetType.OBTAINED : AdvancementWidgetType.UNOBTAINED;
            ResourceLocation advancementID = accessor.getAdvancement().m_138327_();
            @Nullable FrameWrapper frameWrapper = AdvancementFrameDataLoader.get(advancementID);
            if (frameWrapper == null) {
                context.m_280218_(VANILLA_WIDGETS_TEXTURE, x + accessor.getX() + 3, y + accessor.getY(), accessor.getDisplay().m_14992_().m_15551_(), 128 + advancementObtainedStatus.m_97325_() * 26, 26, 26);
                context.m_280480_(accessor.getDisplay().m_14990_(), x + accessor.getX() + 8, y + accessor.getY() + 5);
            } else {
                context.m_280218_(frameWrapper.getTextureSheet(), x + accessor.getX() + 3, y + accessor.getY(), frameWrapper.getTextureU(), frameWrapper.getTextureV() + advancementObtainedStatus.m_97325_() * 26, 26, 26);
                context.m_280480_(accessor.getDisplay().m_14990_(), x + accessor.getX() + 8 + frameWrapper.getItemOffsetX(), y + accessor.getY() + 5 + frameWrapper.getItemOffsetY());
            }
        }
        for (AdvancementWidget advancementWidget : accessor.getChildren()) {
            advancementWidget.m_280229_(context, x, y);
        }
    }

    public void m_280255_(@NotNull GuiGraphics context, int originX, int originY, float alpha, int x, int y) {
        AdvancementWidgetType advancementObtainedStatus3;
        AdvancementWidgetType advancementObtainedStatus2;
        AdvancementWidgetType advancementObtainedStatus;
        AdvancementWidgetAccessor accessor = (AdvancementWidgetAccessor)((Object)this);
        Font textRenderer = this.client.f_91062_;
        List<FormattedCharSequence> description = this.description == null ? accessor.getDescription() : this.description;
        boolean shouldRenderToTheLeft = x + originX + accessor.getX() + accessor.getWidth() + 26 >= accessor.getTab().m_97190_().f_96543_;
        String string = accessor.getProgress() == null ? null : accessor.getProgress().m_8218_();
        int i = string == null ? 0 : textRenderer.m_92895_(string);
        int var10000 = 113 - originY - accessor.getY() - 26;
        int var10002 = description.size();
        boolean bl2 = var10000 <= 6 + var10002 * 9;
        float f = accessor.getProgress() == null ? 0.0f : accessor.getProgress().m_8213_();
        int j = Mth.m_14143_((float)(f * (float)accessor.getWidth()));
        if (f >= 1.0f) {
            j = accessor.getWidth() / 2;
            advancementObtainedStatus = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus2 = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus3 = AdvancementWidgetType.OBTAINED;
        } else if (j < 2) {
            j = accessor.getWidth() / 2;
            advancementObtainedStatus = AdvancementWidgetType.UNOBTAINED;
            advancementObtainedStatus2 = AdvancementWidgetType.UNOBTAINED;
            advancementObtainedStatus3 = AdvancementWidgetType.UNOBTAINED;
        } else if (j > accessor.getWidth() - 2) {
            j = accessor.getWidth() / 2;
            advancementObtainedStatus = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus2 = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus3 = AdvancementWidgetType.UNOBTAINED;
        } else {
            advancementObtainedStatus = AdvancementWidgetType.OBTAINED;
            advancementObtainedStatus2 = AdvancementWidgetType.UNOBTAINED;
            advancementObtainedStatus3 = AdvancementWidgetType.UNOBTAINED;
        }
        int k = accessor.getWidth() - j;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VANILLA_WIDGETS_TEXTURE);
        RenderSystem.enableBlend();
        int l = originY + accessor.getY();
        int startX = shouldRenderToTheLeft ? originX + accessor.getX() - accessor.getWidth() + 26 + 6 : originX + accessor.getX();
        int n = 32 + description.size() * 9;
        if (!description.isEmpty()) {
            if (bl2) {
                context.m_280260_(VANILLA_WIDGETS_TEXTURE, startX, l + 26 - n, accessor.getWidth(), n, 10, 200, 26, 0, 52);
            } else {
                context.m_280260_(VANILLA_WIDGETS_TEXTURE, startX, l, accessor.getWidth(), n, 10, 200, 26, 0, 52);
            }
        }
        context.m_280218_(VANILLA_WIDGETS_TEXTURE, startX, l, 0, advancementObtainedStatus.m_97325_() * 26, j, 26);
        context.m_280218_(VANILLA_WIDGETS_TEXTURE, startX + j, l, 200 - k, advancementObtainedStatus2.m_97325_() * 26, k, 26);
        if (this.frameWrapper == null) {
            context.m_280218_(VANILLA_WIDGETS_TEXTURE, originX + accessor.getX() + 3, originY + accessor.getY(), accessor.getDisplay().m_14992_().m_15551_(), 128 + advancementObtainedStatus3.m_97325_() * 26, 26, 26);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.frameWrapper.getTextureSheet());
            context.m_280218_(VANILLA_WIDGETS_TEXTURE, originX + accessor.getX() + 3, originY + accessor.getY(), this.frameWrapper.getTextureU(), this.frameWrapper.getTextureV() + advancementObtainedStatus3.m_97325_() * 26, 26, 26);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)VANILLA_WIDGETS_TEXTURE);
        }
        if (shouldRenderToTheLeft) {
            context.m_280648_(textRenderer, accessor.getTitle(), startX + 5, originY + accessor.getY() + 9, -1);
            if (string != null) {
                context.m_280488_(textRenderer, string, originX + accessor.getX() - i, originY + accessor.getY() + 9, -1);
            }
        } else {
            context.m_280648_(textRenderer, accessor.getTitle(), originX + accessor.getX() + 32, originY + accessor.getY() + 9, -1);
            if (string != null) {
                context.m_280488_(textRenderer, string, originX + accessor.getX() + accessor.getWidth() - i - 5, originY + accessor.getY() + 9, -1);
            }
        }
        if (bl2) {
            for (int o = 0; o < description.size(); ++o) {
                FormattedCharSequence orderedDescription = description.get(o);
                context.m_280649_(textRenderer, orderedDescription, startX + 5, l + 26 - n + 7 + o * 9, -5592406, false);
            }
        } else {
            for (int o = 0; o < description.size(); ++o) {
                FormattedCharSequence orderedDescription = description.get(o);
                context.m_280649_(textRenderer, orderedDescription, startX + 5, originY + accessor.getY() + 9 + 17 + o * 9, -5592406, false);
            }
        }
        if (this.frameWrapper == null) {
            context.m_280480_(accessor.getDisplay().m_14990_(), originX + accessor.getX() + 8, originY + accessor.getY() + 5);
        } else {
            context.m_280480_(accessor.getDisplay().m_14990_(), originX + accessor.getX() + 8 + this.frameWrapper.getItemOffsetX(), originY + accessor.getY() + 5 + this.frameWrapper.getItemOffsetY());
        }
    }

    public int getDebugScrollAmount() {
        return this.debugScrollAmount;
    }

    public void setDebugScrollAmount(int debugScrollAmount) {
        this.debugScrollAmount = debugScrollAmount;
    }
}

