/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import com.google.common.collect.Maps;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementScreen;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementTabType;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementWidget;
import de.dafuqs.paginatedadvancements.client.PinnedAdvancementTabType;
import de.dafuqs.paginatedadvancements.mixin.AdvancementWidgetAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementTabType;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaginatedAdvancementTab
extends AdvancementTab {
    private final Minecraft client;
    private final PaginatedAdvancementScreen screen;
    private final int index;
    private int pinnedIndex;
    private final Advancement root;
    private final DisplayInfo display;
    private final ItemStack icon;
    private final Component title;
    private final AdvancementWidget rootWidget;
    private final Map<Advancement, AdvancementWidget> widgets = Maps.newLinkedHashMap();
    private double originX;
    private double originY;
    private int minPanX = Integer.MAX_VALUE;
    private int minPanY = Integer.MAX_VALUE;
    private int maxPanX = Integer.MIN_VALUE;
    private int maxPanY = Integer.MIN_VALUE;
    private float alpha;
    private boolean initialized;
    @Nullable
    private AdvancementWidget hoveredWidget;

    public PaginatedAdvancementTab(Minecraft client, PaginatedAdvancementScreen screen, int index, int pinnedIndex, Advancement root, DisplayInfo display) {
        super(client, (AdvancementsScreen)screen, AdvancementTabType.ABOVE, index, root, display);
        this.client = client;
        this.screen = screen;
        this.index = index;
        this.pinnedIndex = pinnedIndex;
        this.root = root;
        this.display = display;
        this.icon = display.m_14990_();
        this.title = display.m_14977_();
        this.rootWidget = new PaginatedAdvancementWidget(this, client, root, display);
        this.m_97175_(this.rootWidget, root);
    }

    @NotNull
    public AdvancementTabType m_169538_() {
        return AdvancementTabType.ABOVE;
    }

    public int m_169539_() {
        return this.index;
    }

    public Advancement getRoot() {
        return this.root;
    }

    @NotNull
    public Component m_97189_() {
        return this.title;
    }

    @NotNull
    public DisplayInfo m_169540_() {
        return this.display;
    }

    public void drawBackground(GuiGraphics context, int x, int y, boolean selected, int atIndex) {
        PaginatedAdvancementTabType.drawBackground(context, x, y, selected, atIndex);
    }

    public void drawIcon(GuiGraphics context, int x, int y, int index) {
        PaginatedAdvancementTabType.drawIcon(context, x, y, index, this.icon);
    }

    public void drawPinnedBackground(GuiGraphics context, int x, int y, boolean selected, int maxPinnedIndex) {
        if (this.pinnedIndex <= maxPinnedIndex) {
            PinnedAdvancementTabType.drawBackground(context, x, y, selected, this.pinnedIndex);
        }
    }

    public void drawPinnedIcon(GuiGraphics context, int x, int y, int maxPinnedIndex) {
        if (this.pinnedIndex <= maxPinnedIndex) {
            PinnedAdvancementTabType.drawIcon(context, x, y, this.pinnedIndex, this.icon);
        }
    }

    public void render(GuiGraphics context, int startX, int startY, int endX, int endY) {
        int advancementTreeWindowWidth = endX - (startX += 9) + 32;
        int advancementTreeWindowHeight = endY - (startY += 18) + 61;
        if (!this.initialized) {
            this.originX = (double)(advancementTreeWindowWidth / 2 - (this.maxPanX + this.minPanX) / 2) - 22.0;
            this.originY = (double)(advancementTreeWindowHeight / 2 - (this.maxPanY + this.minPanY) / 2) - 32.0;
            this.initialized = true;
        }
        context.m_280588_(startX, startY, advancementTreeWindowWidth, advancementTreeWindowHeight);
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)startX, (float)startY, 0.0f);
        ResourceLocation bg = this.display.m_14991_();
        ResourceLocation identifier = bg != null ? bg : TextureManager.f_118466_;
        int i = Mth.m_14107_((double)this.originX);
        int j = Mth.m_14107_((double)this.originY);
        int k = i % 16;
        int l = j % 16;
        int textureCountX = advancementTreeWindowWidth / 16 + 1;
        int textureCountY = advancementTreeWindowHeight / 16 + 2;
        for (int m = -1; m < textureCountX; ++m) {
            for (int n = -1; n < textureCountY; ++n) {
                context.m_280163_(identifier, k + 16 * m, l + 16 * n, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.rootWidget.m_97298_(context, i, j, true);
        this.rootWidget.m_97298_(context, i, j, false);
        this.rootWidget.m_280229_(context, i, j);
        context.m_280168_().m_85849_();
        context.m_280618_();
    }

    public void drawWidgetTooltip(GuiGraphics context, int mouseX, int mouseY, int startX, int startY, int endXWindow, int endY) {
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_(0.0f, 0.0f, -200.0f);
        if (PaginatedAdvancementsClient.CONFIG.FadeOutBackgroundOnAdvancementHover) {
            context.m_280509_(0, 0, endXWindow - startX - 18, endY - startY - 26, Mth.m_14143_((float)(this.alpha * 255.0f)) << 24);
        }
        boolean hoversWidget = false;
        int i = Mth.m_14107_((double)this.originX);
        int j = Mth.m_14107_((double)this.originY);
        if (mouseX > 0 && mouseX < endXWindow - startX - 10 && mouseY > 0 && mouseY < endY - startY) {
            for (AdvancementWidget advancementWidget : this.widgets.values()) {
                if (!advancementWidget.m_97259_(i, j, mouseX, mouseY)) continue;
                hoversWidget = true;
                advancementWidget.m_280255_(context, i, j, this.alpha, startX, startY);
                this.hoveredWidget = advancementWidget;
                break;
            }
        }
        context.m_280168_().m_85849_();
        if (hoversWidget) {
            this.alpha = Mth.m_14036_((float)(this.alpha + 0.02f), (float)0.0f, (float)0.3f);
        } else {
            this.hoveredWidget = null;
            this.alpha = Mth.m_14036_((float)(this.alpha - 0.04f), (float)0.0f, (float)1.0f);
        }
    }

    public void drawDebugInfo(GuiGraphics context, int startX, int startY, int endX, int endY) {
        if (this.hoveredWidget != null) {
            int displayedRequirementLines;
            AdvancementWidgetAccessor advancementWidgetAccessor = (AdvancementWidgetAccessor)this.hoveredWidget;
            AdvancementProgress progress = advancementWidgetAccessor.getProgress();
            endY -= 60;
            startY -= 72;
            List<MutableComponent> requirements = this.getRequirements(startX -= 36, (endX -= 46) - 10, advancementWidgetAccessor.getAdvancement(), progress);
            boolean overflow = false;
            if (!PaginatedAdvancementScreen.m_96638_()) {
                overflow = requirements.size() > PaginatedAdvancementsClient.CONFIG.MaxCriterionEntries;
                displayedRequirementLines = Math.min(requirements.size(), PaginatedAdvancementsClient.CONFIG.MaxCriterionEntries);
            } else {
                displayedRequirementLines = requirements.size();
            }
            startY = Math.max(startY, endY - Math.max(18, 8 + 10 * displayedRequirementLines) - (PaginatedAdvancementsClient.CONFIG.ShowAdvancementIDInDebugTooltip ? 10 : 0));
            this.drawDebugFrame(context, startX, startY, endX, endY);
            int requirementY = startY + 15;
            if (PaginatedAdvancementsClient.CONFIG.ShowAdvancementIDInDebugTooltip) {
                MutableComponent idText = Component.m_237113_((String)("ID: " + advancementWidgetAccessor.getAdvancement().m_138327_() + " ")).m_7220_((Component)Component.m_237115_((String)"text.paginated_advancements.copy_to_clipboard"));
                context.m_280614_(this.client.f_91062_, (Component)idText, startX + 5, startY + 5, 0xFFFFFF, true);
            } else {
                requirementY = startY + 5;
            }
            if (overflow) {
                this.drawRequirementsWithOverflow(context, startX + 5, requirementY, endX - 5, endY, requirements, displayedRequirementLines);
            } else {
                this.drawRequirements(context, startX + 5, requirementY, endX - 5, endY, requirements);
            }
        }
    }

    private List<MutableComponent> getRequirements(int startX, int endX, Advancement advancement, AdvancementProgress progress) {
        Iterable obtainedCriteria = progress == null ? List.of() : progress.m_8220_();
        String[][] requirements = advancement.m_138329_();
        ArrayList<MutableComponent> requirementsDone = new ArrayList<MutableComponent>();
        ArrayList requirementsLeft = new ArrayList();
        for (String[] requirementGroup : requirements) {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            lines.add(Component.m_237115_((String)"text.paginated_advancements.group").m_130940_(ChatFormatting.DARK_RED));
            boolean anyDone = false;
            for (String requirementString : requirementGroup) {
                int newWidth;
                ChatFormatting formatting = ChatFormatting.DARK_RED;
                for (String s : obtainedCriteria) {
                    if (!s.equals(requirementString)) continue;
                    formatting = ChatFormatting.DARK_GREEN;
                    anyDone = true;
                    break;
                }
                if ((newWidth = this.client.f_91062_.m_92852_((FormattedText)lines.get(lines.size() - 1)) + this.client.f_91062_.m_92895_(requirementString)) > endX - startX) {
                    Object indent = "";
                    while (this.client.f_91062_.m_92895_((String)indent) < this.client.f_91062_.m_92852_((FormattedText)Component.m_237115_((String)"text.paginated_advancements.group"))) {
                        indent = (String)indent + " ";
                    }
                    lines.add(Component.m_237113_((String)indent).m_130940_(ChatFormatting.DARK_RED));
                }
                ((MutableComponent)lines.get(lines.size() - 1)).m_7220_((Component)Component.m_237113_((String)(requirementString + " ")).m_130940_(formatting));
            }
            if (anyDone) {
                for (MutableComponent line : lines) {
                    line.m_130940_(ChatFormatting.DARK_GREEN);
                    requirementsDone.add(line);
                }
                continue;
            }
            requirementsLeft.addAll(lines);
        }
        ArrayList<MutableComponent> combined = new ArrayList<MutableComponent>();
        combined.addAll(requirementsLeft);
        combined.addAll(requirementsDone);
        return combined;
    }

    protected void drawDebugFrame(GuiGraphics context, int startX, int startY, int endX, int endY) {
        context.m_280168_().m_85836_();
        int TOP_ELEMENT_HEIGHT = 15;
        context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, startY, 0.0f, 0.0f, 15, TOP_ELEMENT_HEIGHT, 256, 256);
        context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, startY, 237.0f, 0.0f, 15, TOP_ELEMENT_HEIGHT, 256, 256);
        context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, endY - 15, 0.0f, 125.0f, 15, 15, 256, 256);
        context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, endY - 15, 237.0f, 125.0f, 15, 15, 256, 256);
        int maxTopHeightInOneDrawCall = 100;
        int middleHeight = endY - startY - TOP_ELEMENT_HEIGHT - 15;
        int currentY = startY + TOP_ELEMENT_HEIGHT;
        while (middleHeight > 0) {
            int currentDrawHeight = Math.min(middleHeight, maxTopHeightInOneDrawCall);
            context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, currentY, 0.0f, (float)TOP_ELEMENT_HEIGHT, 15, currentDrawHeight, 256, 256);
            context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, currentY, 237.0f, (float)TOP_ELEMENT_HEIGHT, 15, currentDrawHeight, 256, 256);
            middleHeight -= currentDrawHeight;
            currentY += currentDrawHeight;
        }
        int maxTopWidthInOneDrawCall = 220;
        int middleWidth = endX - startX - 15 - 15;
        int currentX = startX + 15;
        while (middleWidth > 0) {
            int currentDrawWidth = Math.min(middleWidth, maxTopWidthInOneDrawCall);
            context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, currentX, startY, 15.0f, 0.0f, currentDrawWidth, TOP_ELEMENT_HEIGHT, 256, 256);
            context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, currentX, endY - 15, 15.0f, 125.0f, currentDrawWidth, 15, 256, 256);
            middleWidth -= currentDrawWidth;
            currentX += currentDrawWidth;
        }
        int centerStartX = startX + 6;
        int centerEndX = endX - 6;
        int centerStartY = startY + 3;
        int centerEndY = endY - 6;
        int drawStartY = centerStartY;
        int drawHeight = centerEndY - centerStartY;
        while (drawHeight > 0) {
            int drawStartX = centerStartX;
            int currentHeight = Math.min(drawHeight, 10);
            int drawWidth = centerEndX - centerStartX;
            while (drawWidth > 0) {
                int currentWidth = Math.min(200, drawWidth);
                context.m_280163_(PaginatedAdvancementScreen.WINDOW_TEXTURE, drawStartX, drawStartY, 4.0f, 4.0f, currentWidth, currentHeight, 256, 256);
                drawWidth -= currentWidth;
                drawStartX += currentWidth;
            }
            drawHeight -= currentHeight;
            drawStartY += currentHeight;
        }
        context.m_280168_().m_85849_();
    }

    protected void drawRequirementsWithOverflow(GuiGraphics context, int startX, int startY, int endX, int endY, List<MutableComponent> requirements, int lines) {
        for (int i = 0; i < lines; ++i) {
            if (i == lines - 1) {
                context.m_280614_(this.client.f_91062_, (Component)Component.m_237115_((String)"text.paginated_advancements.expand_debug"), startX, startY, 0x999999, false);
            } else {
                context.m_280614_(this.client.f_91062_, (Component)requirements.get(i), startX, startY, 65280, false);
            }
            startY += 10;
        }
    }

    protected void drawRequirements(GuiGraphics context, int startX, int startY, int endX, int endY, List<MutableComponent> requirements) {
        int scrollAmount = 0;
        assert (this.hoveredWidget != null);
        AdvancementWidget advancementWidget = this.hoveredWidget;
        if (advancementWidget instanceof PaginatedAdvancementWidget) {
            PaginatedAdvancementWidget paginatedAdvancementWidget = (PaginatedAdvancementWidget)advancementWidget;
            scrollAmount = paginatedAdvancementWidget.getDebugScrollAmount();
            int maxLines = (endY - startY) / 10;
            scrollAmount = Math.max(0, Math.min(requirements.size() - maxLines, scrollAmount));
            paginatedAdvancementWidget.setDebugScrollAmount(scrollAmount);
        }
        if (scrollAmount > 0) {
            context.m_280614_(this.client.f_91062_, (Component)Component.m_237115_((String)"text.paginated_advancements.scroll_debug"), startX, startY, 0x999999, false);
            ++scrollAmount;
            startY += 10;
        }
        for (int i = scrollAmount; i < requirements.size() && startY + 10 < endY; ++i) {
            if (startY + 20 >= endY && i + 1 != requirements.size()) {
                context.m_280614_(this.client.f_91062_, (Component)Component.m_237115_((String)"text.paginated_advancements.scroll_debug"), startX, startY, 0x999999, false);
                break;
            }
            context.m_280614_(this.client.f_91062_, (Component)requirements.get(i), startX, startY, 65280, false);
            startY += 10;
        }
    }

    public boolean scrollDebug(int diff) {
        AdvancementWidget advancementWidget;
        if (this.hoveredWidget != null && (advancementWidget = this.hoveredWidget) instanceof PaginatedAdvancementWidget) {
            PaginatedAdvancementWidget paginatedAdvancementWidget = (PaginatedAdvancementWidget)advancementWidget;
            int value = paginatedAdvancementWidget.getDebugScrollAmount();
            paginatedAdvancementWidget.setDebugScrollAmount(value + diff);
            return true;
        }
        return false;
    }

    public int getPaginatedDisplayedPage(int maxDisplayedTabs) {
        return this.index / maxDisplayedTabs;
    }

    public int getPaginatedDisplayedPosition(int maxDisplayedTabs, int currentPage) {
        return 1 + this.index - maxDisplayedTabs * currentPage;
    }

    public boolean isClickOnTab(int screenX, int screenY, double mouseX, double mouseY, boolean paginated, int maxDisplayedTabs, int currentPage) {
        if (paginated) {
            if (this.getPaginatedDisplayedPage(maxDisplayedTabs) != currentPage) {
                return false;
            }
            int pageIndex = this.getPaginatedDisplayedPosition(maxDisplayedTabs, currentPage);
            if (pageIndex <= maxDisplayedTabs) {
                return PaginatedAdvancementTabType.isClickOnTab(screenX, screenY, pageIndex, mouseX, mouseY);
            }
        } else {
            return PaginatedAdvancementTabType.isClickOnTab(screenX, screenY, this.index, mouseX, mouseY);
        }
        return false;
    }

    public boolean isClickOnPinnedTab(int screenX, int screenY, double mouseX, double mouseY, int maxPinnedTabs) {
        if (this.pinnedIndex > -1 && this.pinnedIndex <= maxPinnedTabs) {
            return PinnedAdvancementTabType.isClickOnTab(screenX, screenY, this.pinnedIndex, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    public static PaginatedAdvancementTab create(Minecraft client, PaginatedAdvancementScreen screen, int index, int pinnedIndex, Advancement root) {
        if (root.m_138320_() != null) {
            return new PaginatedAdvancementTab(client, screen, index, pinnedIndex, root, root.m_138320_());
        }
        return null;
    }

    public void move(double offsetX, double offsetY, int endX, int endY) {
        if (this.maxPanX - this.minPanX > endX) {
            this.originX = Mth.m_14008_((double)(this.originX + offsetX), (double)(-(this.maxPanX - endX)), (double)0.0);
        }
        if (this.maxPanY - this.minPanY > endY) {
            this.originY = Mth.m_14008_((double)(this.originY + offsetY), (double)(-(this.maxPanY - endY)), (double)0.0);
        }
    }

    public void m_97178_(Advancement advancement) {
        DisplayInfo display = advancement.m_138320_();
        if (display != null) {
            PaginatedAdvancementWidget advancementWidget = new PaginatedAdvancementWidget(this, this.client, advancement, display);
            this.m_97175_(advancementWidget, advancement);
        }
    }

    private void m_97175_(AdvancementWidget widget, Advancement advancement) {
        this.widgets.put(advancement, widget);
        for (AdvancementWidget advancementWidget : this.widgets.values()) {
            advancementWidget.m_97313_();
        }
        this.calculatePan();
    }

    public void calculatePan() {
        for (AdvancementWidget widget : this.widgets.values()) {
            int widgetStartX = widget.m_97315_();
            int widgetEndX = widgetStartX + 28;
            int widgetStartY = widget.m_97314_();
            int widgetEndY = widgetStartY + 27;
            this.minPanX = Math.min(this.minPanX, widgetStartX);
            this.maxPanX = Math.max(this.maxPanX, widgetEndX);
            this.minPanY = Math.min(this.minPanY, widgetStartY);
            this.maxPanY = Math.max(this.maxPanY, widgetEndY);
        }
    }

    @Nullable
    public AdvancementWidget m_97180_(@NotNull Advancement advancement) {
        return this.widgets.get(advancement);
    }

    @NotNull
    public PaginatedAdvancementScreen getScreen() {
        return this.screen;
    }

    public void setPinIndex(int index) {
        this.pinnedIndex = index;
    }

    public int getPinIndex() {
        return this.pinnedIndex;
    }

    public void copyHoveredAdvancementID() {
        if (this.hoveredWidget != null) {
            AdvancementWidgetAccessor awa = (AdvancementWidgetAccessor)this.hoveredWidget;
            Minecraft.m_91087_().f_91068_.m_90911_(awa.getAdvancement().m_138327_().toString());
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"text.paginated_advancements.copied_to_clipboard"), false);
        }
    }
}

