/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements;

import de.dafuqs.paginatedadvancements.config.PaginatedAdvancementsConfig;
import de.dafuqs.paginatedadvancements.frames.AdvancementFrameDataLoader;
import de.dafuqs.paginatedadvancements.frames.AdvancementFrameTypeDataLoader;
import java.util.List;
import me.shedaniel.autoconfig.ConfigManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedAdvancementsClient {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PaginatedAdvancements");
    public static final String MOD_ID = "paginatedadvancements";
    public static ConfigManager<PaginatedAdvancementsConfig> CONFIG_MANAGER;
    public static PaginatedAdvancementsConfig CONFIG;

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ResourceLocation locate(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void registerResources(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)AdvancementFrameTypeDataLoader.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)AdvancementFrameDataLoader.INSTANCE);
    }

    public static void saveSelectedTab(ResourceLocation tabResourceLocation) {
        if (PaginatedAdvancementsClient.CONFIG.SaveLastSelectedTab) {
            PaginatedAdvancementsClient.CONFIG.LastSelectedTab = tabResourceLocation.toString();
            CONFIG_MANAGER.save();
        }
    }

    public static void pinTab(ResourceLocation tabResourceLocation) {
        String identifierString = tabResourceLocation.toString();
        if (!PaginatedAdvancementsClient.CONFIG.PinnedTabs.contains(identifierString)) {
            PaginatedAdvancementsClient.CONFIG.PinnedTabs.add(identifierString);
            CONFIG_MANAGER.save();
        }
    }

    public static void unpinTab(ResourceLocation tabResourceLocation) {
        String identifierString = tabResourceLocation.toString();
        if (PaginatedAdvancementsClient.CONFIG.PinnedTabs.contains(identifierString)) {
            PaginatedAdvancementsClient.CONFIG.PinnedTabs.remove(identifierString);
            CONFIG_MANAGER.save();
        }
    }

    public static boolean isPinned(ResourceLocation tabResourceLocation) {
        return PaginatedAdvancementsClient.CONFIG.PinningEnabled && PaginatedAdvancementsClient.CONFIG.PinnedTabs.contains(tabResourceLocation.toString());
    }

    public static boolean hasPins() {
        return PaginatedAdvancementsClient.CONFIG.PinningEnabled && !PaginatedAdvancementsClient.CONFIG.PinnedTabs.isEmpty();
    }

    public static List<String> getPinnedTabs() {
        return PaginatedAdvancementsClient.CONFIG.PinnedTabs;
    }

    public static int getPinIndex(ResourceLocation tabResourceLocation) {
        return PaginatedAdvancementsClient.CONFIG.PinnedTabs.indexOf(tabResourceLocation.toString());
    }
}

