#version 150

#moj_import <light.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;
in vec3 Normal;
in vec3 InSize;
in float Time;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat3 IViewRotMat;
uniform mat4 ProjMat;
uniform vec3 ChunkOffset;
uniform float RealTime;

out vec4 vertexColor;
out vec2 texCoord0;
out vec3 position;
out vec3 inSize;
out float newTime;

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position + ChunkOffset, 1.0);
    position = gl_Position.xyz;
    vertexColor = Color * minecraft_sample_lightmap(Sampler2, UV2);
    texCoord0 = UV0;
    inSize = InSize;
    newTime = Time;
}
