#version 150

#moj_import <fog.glsl>

#moj_import <light.glsl>

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;
uniform sampler2D Sampler6;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform float GameTime;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec3 position;
in vec4 lightlevel;
in vec3 lightPos;
in vec3 goodPosition;
in vec3 light0;
in vec3 light1;
in vec3 normal;

out vec4 fragColor;

void main() {
//    vec3 normal = normalize(cross(dFdx(goodPosition), dFdy(goodPosition)));
    vec3 calculated_tangent = dFdx(goodPosition);
    vec3 calculated_bitangent = dFdy(goodPosition);
    mat3 TBN = mat3(normalize(calculated_tangent), normalize(calculated_bitangent), normal);

    vec4 normalMap = texture(Sampler0, texCoord0);
    vec3 normalTexture = normalMap.rgb;
    normalTexture = normalTexture * 2.0 - 1.0;
    normalTexture = normalize(TBN * normalTexture);

    vec4 standardTexture = texture(Sampler6, texCoord0);
    vec3 lightDir = normalize(vec3(1, 1, 1));
    float diffuse = max(dot(normalTexture, goodPosition), 0.0);

    fragColor = minecraft_mix_light(light0, light1, normalTexture, (vertexColor * ColorModulator * standardTexture));
}
