#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat3 IViewRotMat;
uniform mat4 ProjMat;
uniform vec3 ChunkOffset;
uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

out vec3 normal;
out vec3 position;
out vec4 viewPosition;
out vec2 uv;


void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position + ChunkOffset, 1.0);
    viewPosition = gl_Position;
    position = vec3(ModelViewMat * vec4(Position + ChunkOffset, 1.0));
    normal = Normal;
    uv = UV0;
}
