#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

uniform vec4 FresnelColor;

in vec3 position;
in vec3 normal;
in vec4 viewPos;
in vec2 uv;

out vec4 fragColor;

void main() {
    vec3 norm = normalize(normal);
    vec3 lightDir = normalize(vec3(0,0,0) - position);

    // Cel shading steps
    float diff = max(dot(norm, lightDir), 0.0);
    float intensity = 5.0;
    diff = floor(diff * intensity) / intensity;

    // Specular lighting
    vec3 viewDir = normalize(viewPos.xyz - position).xyz;
    vec3 reflectDir = reflect(-Light0_Direction, norm);
    float spec = pow(max(dot(viewDir, reflectDir), 0.0), 32.0);

    // Combine results
    vec3 color = vec3(1.0, 1.0, 1.0);
    vec3 ambient = 0.1 * color;
    vec3 diffuse = diff * color;
    vec3 specular = spec * vec3(0.5);
    vec4 textureColor = texture(Sampler0, uv);

    fragColor = vec4((ambient + diffuse + specular) * textureColor.rgb, textureColor.a);
}
