#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat3 IViewRotMat;
uniform mat4 ProjMat;
uniform vec3 ChunkOffset;
uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;
out vec3 normal;
out vec3 position;
out vec4 lightlevel;
out vec3 lightPos;
out vec3 goodPosition;
out vec3 light0;
out vec3 light1;

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position + ChunkOffset, 1.0);
    position = Position + ChunkOffset;
    vertexDistance = length((ModelViewMat * vec4(Position + ChunkOffset, 1.0)).xyz);
    vertexColor = Color * minecraft_sample_lightmap(Sampler2, UV2);
    texCoord0 = UV0;
    normal = Normal;
    lightlevel = minecraft_sample_lightmap(Sampler2, UV2);
    lightPos = Light0_Direction;
    goodPosition = Position * IViewRotMat;
    light0 = Light0_Direction;
    light1 = Light1_Direction;
}
