#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

uniform vec4 FresnelColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;
in vec4 normal;

in float fresnel;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    float gray = 0.21 * color.r + 0.72 * color.g + 0.07 * color.b;

    fragColor = vec4(vec3(gray), 1.0);
}
