/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.mclanguageprovider;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.forgespi.language.ILifecycleEvent;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftModLanguageProvider
implements IModLanguageProvider {
    private static final Logger LOGGER = LogManager.getLogger();

    public String name() {
        return "minecraft";
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        return sd -> sd.addLanguageLoader(Map.of("minecraft", new MinecraftModTarget()));
    }

    public <R extends ILifecycleEvent<R>> void consumeLifecycleEvent(Supplier<R> consumeEvent) {
    }

    public static class MinecraftModTarget
    implements IModLanguageProvider.IModLanguageLoader {
        public <T> T loadMod(IModInfo info, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
            try {
                Module module = gameLayer.findModule("minecraft").orElseThrow();
                Class<?> mcModClass = Class.forName(this.getClass().getModule(), "net.minecraftforge.fml.mclanguageprovider.MinecraftModContainer");
                return (T)mcModClass.getConstructor(IModInfo.class).newInstance(info);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.fatal(Logging.LOADING, "Unable to load MinecraftModContainer, wut?", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

