/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class CopyNbtFunction
extends LootItemConditionalFunction {
    public static final Codec<CopyNbtFunction> f_291213_ = RecordCodecBuilder.create(p_297081_ -> CopyNbtFunction.m_294820_(p_297081_).and(p_297081_.group((App)NbtProviders.f_290907_.fieldOf("source").forGetter(p_297083_ -> p_297083_.f_80234_), (App)CopyOperation.f_290329_.listOf().fieldOf("ops").forGetter(p_297082_ -> p_297082_.f_80235_))).apply((Applicative)p_297081_, CopyNbtFunction::new));
    private final NbtProvider f_80234_;
    private final List<CopyOperation> f_80235_;

    CopyNbtFunction(List<LootItemCondition> p_165177_, NbtProvider p_165176_, List<CopyOperation> p_299800_) {
        super(p_165177_);
        this.f_80234_ = p_165176_;
        this.f_80235_ = List.copyOf(p_299800_);
    }

    @Override
    public LootItemFunctionType m_7162_() {
        return LootItemFunctions.f_80755_;
    }

    @Override
    public Set<LootContextParam<?>> m_6231_() {
        return this.f_80234_.m_142677_();
    }

    @Override
    public ItemStack m_7372_(ItemStack p_80250_, LootContext p_80251_) {
        Tag $$2 = this.f_80234_.m_142301_(p_80251_);
        if ($$2 != null) {
            this.f_80235_.forEach(p_80255_ -> p_80255_.m_80305_(p_80250_::m_41784_, $$2));
        }
        return p_80250_;
    }

    public static Builder m_165180_(NbtProvider p_165181_) {
        return new Builder(p_165181_);
    }

    public static Builder m_165178_(LootContext.EntityTarget p_165179_) {
        return new Builder(ContextNbtProvider.m_165570_(p_165179_));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NbtProvider f_80271_;
        private final List<CopyOperation> f_80272_ = Lists.newArrayList();

        Builder(NbtProvider p_165183_) {
            this.f_80271_ = p_165183_;
        }

        public Builder m_80282_(String p_80283_, String p_80284_, MergeStrategy p_80285_) {
            try {
                this.f_80272_.add(new CopyOperation(Path.m_295785_(p_80283_), Path.m_295785_(p_80284_), p_80285_));
            }
            catch (CommandSyntaxException $$3) {
                throw new IllegalArgumentException($$3);
            }
            return this;
        }

        public Builder m_80279_(String p_80280_, String p_80281_) {
            return this.m_80282_(p_80280_, p_80281_, MergeStrategy.REPLACE);
        }

        @Override
        protected Builder m_6477_() {
            return this;
        }

        @Override
        public LootItemFunction m_7453_() {
            return new CopyNbtFunction(this.m_80699_(), this.f_80271_, this.f_80272_);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder m_6477_() {
            return this.m_6477_();
        }
    }

    record CopyOperation(Path f_80289_, Path f_80291_, MergeStrategy f_80292_) {
        public static final Codec<CopyOperation> f_290329_ = RecordCodecBuilder.create(p_298742_ -> p_298742_.group((App)Path.f_290751_.fieldOf("source").forGetter(CopyOperation::f_80289_), (App)Path.f_290751_.fieldOf("target").forGetter(CopyOperation::f_80291_), (App)MergeStrategy.f_291218_.fieldOf("op").forGetter(CopyOperation::f_80292_)).apply((Applicative)p_298742_, CopyOperation::new));

        public void m_80305_(Supplier<Tag> p_80306_, Tag p_80307_) {
            try {
                List<Tag> $$2 = this.f_80289_.f_290958_().m_99638_(p_80307_);
                if (!$$2.isEmpty()) {
                    this.f_80292_.m_6706_(p_80306_.get(), this.f_80291_.f_290958_(), $$2);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CopyOperation.class, "sourcePath;targetPath;op", "f_80289_", "f_80291_", "f_80292_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CopyOperation.class, "sourcePath;targetPath;op", "f_80289_", "f_80291_", "f_80292_"}, this);
        }

        @Override
        public final boolean equals(Object p_299046_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CopyOperation.class, "sourcePath;targetPath;op", "f_80289_", "f_80291_", "f_80292_"}, this, p_299046_);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class MergeStrategy
    extends Enum<MergeStrategy>
    implements StringRepresentable {
        public static final /* enum */ MergeStrategy REPLACE = new MergeStrategy("replace"){

            @Override
            public void m_6706_(Tag p_80362_, NbtPathArgument.NbtPath p_80363_, List<Tag> p_80364_) throws CommandSyntaxException {
                p_80363_.m_169535_(p_80362_, (Tag)Iterables.getLast(p_80364_));
            }
        };
        public static final /* enum */ MergeStrategy APPEND = new MergeStrategy("append"){

            @Override
            public void m_6706_(Tag p_80373_, NbtPathArgument.NbtPath p_80374_, List<Tag> p_80375_) throws CommandSyntaxException {
                List<Tag> $$3 = p_80374_.m_99640_(p_80373_, ListTag::new);
                $$3.forEach(p_80371_ -> {
                    if (p_80371_ instanceof ListTag) {
                        p_80375_.forEach(p_165187_ -> ((ListTag)p_80371_).add(p_165187_.m_6426_()));
                    }
                });
            }
        };
        public static final /* enum */ MergeStrategy MERGE = new MergeStrategy("merge"){

            @Override
            public void m_6706_(Tag p_80387_, NbtPathArgument.NbtPath p_80388_, List<Tag> p_80389_) throws CommandSyntaxException {
                List<Tag> $$3 = p_80388_.m_99640_(p_80387_, CompoundTag::new);
                $$3.forEach(p_80385_ -> {
                    if (p_80385_ instanceof CompoundTag) {
                        p_80389_.forEach(p_165190_ -> {
                            if (p_165190_ instanceof CompoundTag) {
                                ((CompoundTag)p_80385_).m_128391_((CompoundTag)p_165190_);
                            }
                        });
                    }
                });
            }
        };
        public static final Codec<MergeStrategy> f_291218_;
        private final String f_80335_;
        private static final /* synthetic */ MergeStrategy[] $VALUES;

        public static MergeStrategy[] values() {
            return (MergeStrategy[])$VALUES.clone();
        }

        public static MergeStrategy valueOf(String p_80355_) {
            return Enum.valueOf(MergeStrategy.class, p_80355_);
        }

        public abstract void m_6706_(Tag var1, NbtPathArgument.NbtPath var2, List<Tag> var3) throws CommandSyntaxException;

        MergeStrategy(String p_80341_) {
            this.f_80335_ = p_80341_;
        }

        @Override
        public String m_7912_() {
            return this.f_80335_;
        }

        private static /* synthetic */ MergeStrategy[] m_165184_() {
            return new MergeStrategy[]{REPLACE, APPEND, MERGE};
        }

        static {
            $VALUES = MergeStrategy.m_165184_();
            f_291218_ = StringRepresentable.m_216439_(MergeStrategy::values);
        }
    }

    record Path(String f_291466_, NbtPathArgument.NbtPath f_290958_) {
        public static final Codec<Path> f_290751_ = Codec.STRING.comapFlatMap(p_300717_ -> {
            try {
                return DataResult.success((Object)Path.m_295785_(p_300717_));
            }
            catch (CommandSyntaxException $$1) {
                return DataResult.error(() -> "Failed to parse path " + p_300717_ + ": " + $$1.getMessage());
            }
        }, Path::f_291466_);

        public static Path m_295785_(String p_297516_) throws CommandSyntaxException {
            NbtPathArgument.NbtPath $$1 = new NbtPathArgument().parse(new StringReader(p_297516_));
            return new Path(p_297516_, $$1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Path.class, "string;path", "f_291466_", "f_290958_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Path.class, "string;path", "f_291466_", "f_290958_"}, this);
        }

        @Override
        public final boolean equals(Object p_298109_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Path.class, "string;path", "f_291466_", "f_290958_"}, this, p_298109_);
        }
    }
}

