/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootPool {
    public static final Codec<LootPool> f_290497_ = RecordCodecBuilder.create(p_297005_ -> p_297005_.group((App)LootPoolEntries.f_291877_.listOf().fieldOf("entries").forGetter(p_297007_ -> p_297007_.f_79023_), (App)ExtraCodecs.m_295827_(LootItemConditions.f_290534_.listOf(), "conditions", List.of()).forGetter(p_297008_ -> p_297008_.f_79024_), (App)ExtraCodecs.m_295827_(LootItemFunctions.f_291699_.listOf(), "functions", List.of()).forGetter(p_297009_ -> p_297009_.f_79026_), (App)NumberProviders.f_291751_.fieldOf("rolls").forGetter(p_297004_ -> p_297004_.f_79028_), (App)NumberProviders.f_291751_.fieldOf("bonus_rolls").orElse((Object)ConstantValue.m_165692_(0.0f)).forGetter(p_297006_ -> p_297006_.f_79029_)).apply((Applicative)p_297005_, LootPool::new));
    private final List<LootPoolEntryContainer> f_79023_;
    private final List<LootItemCondition> f_79024_;
    private final Predicate<LootContext> f_79025_;
    private final List<LootItemFunction> f_79026_;
    private final BiFunction<ItemStack, LootContext, ItemStack> f_79027_;
    private final NumberProvider f_79028_;
    private final NumberProvider f_79029_;

    LootPool(List<LootPoolEntryContainer> p_298341_, List<LootItemCondition> p_297697_, List<LootItemFunction> p_299722_, NumberProvider p_165131_, NumberProvider p_165132_) {
        this.f_79023_ = p_298341_;
        this.f_79024_ = p_297697_;
        this.f_79025_ = LootItemConditions.m_81834_(p_297697_);
        this.f_79026_ = p_299722_;
        this.f_79027_ = LootItemFunctions.m_80770_(p_299722_);
        this.f_79028_ = p_165131_;
        this.f_79029_ = p_165132_;
    }

    private void m_79058_(Consumer<ItemStack> p_79059_, LootContext p_79060_) {
        RandomSource $$2 = p_79060_.m_230907_();
        ArrayList $$3 = Lists.newArrayList();
        MutableInt $$4 = new MutableInt();
        for (LootPoolEntryContainer $$5 : this.f_79023_) {
            $$5.m_6562_(p_79060_, p_79048_ -> {
                int $$4 = p_79048_.m_7067_(p_79060_.m_78945_());
                if ($$4 > 0) {
                    $$3.add(p_79048_);
                    $$4.add($$4);
                }
            });
        }
        int $$6 = $$3.size();
        if ($$4.intValue() == 0 || $$6 == 0) {
            return;
        }
        if ($$6 == 1) {
            ((LootPoolEntry)$$3.get(0)).m_6941_(p_79059_, p_79060_);
            return;
        }
        int $$7 = $$2.m_188503_($$4.intValue());
        for (LootPoolEntry $$8 : $$3) {
            if (($$7 -= $$8.m_7067_(p_79060_.m_78945_())) >= 0) continue;
            $$8.m_6941_(p_79059_, p_79060_);
            return;
        }
    }

    public void m_79053_(Consumer<ItemStack> p_79054_, LootContext p_79055_) {
        if (!this.f_79025_.test(p_79055_)) {
            return;
        }
        Consumer<ItemStack> $$2 = LootItemFunction.m_80724_(this.f_79027_, p_79054_, p_79055_);
        int $$3 = this.f_79028_.m_142683_(p_79055_) + Mth.m_14143_(this.f_79029_.m_142688_(p_79055_) * p_79055_.m_78945_());
        for (int $$4 = 0; $$4 < $$3; ++$$4) {
            this.m_79058_($$2, p_79055_);
        }
    }

    public void m_79051_(ValidationContext p_79052_) {
        for (int $$1 = 0; $$1 < this.f_79024_.size(); ++$$1) {
            this.f_79024_.get($$1).m_6169_(p_79052_.m_79365_(".condition[" + $$1 + "]"));
        }
        for (int $$2 = 0; $$2 < this.f_79026_.size(); ++$$2) {
            this.f_79026_.get($$2).m_6169_(p_79052_.m_79365_(".functions[" + $$2 + "]"));
        }
        for (int $$3 = 0; $$3 < this.f_79023_.size(); ++$$3) {
            this.f_79023_.get($$3).m_6165_(p_79052_.m_79365_(".entries[" + $$3 + "]"));
        }
        this.f_79028_.m_6169_(p_79052_.m_79365_(".rolls"));
        this.f_79029_.m_6169_(p_79052_.m_79365_(".bonusRolls"));
    }

    public static Builder m_79043_() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> f_79067_ = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemCondition> f_79068_ = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> f_79069_ = ImmutableList.builder();
        private NumberProvider f_79070_ = ConstantValue.m_165692_(1.0f);
        private NumberProvider f_79071_ = ConstantValue.m_165692_(0.0f);

        public Builder m_165133_(NumberProvider p_165134_) {
            this.f_79070_ = p_165134_;
            return this;
        }

        @Override
        public Builder m_79073_() {
            return this;
        }

        public Builder m_165135_(NumberProvider p_165136_) {
            this.f_79071_ = p_165136_;
            return this;
        }

        public Builder m_79076_(LootPoolEntryContainer.Builder<?> p_79077_) {
            this.f_79067_.add((Object)p_79077_.m_7512_());
            return this;
        }

        @Override
        public Builder m_79080_(LootItemCondition.Builder p_79081_) {
            this.f_79068_.add((Object)p_79081_.m_6409_());
            return this;
        }

        @Override
        public Builder m_79078_(LootItemFunction.Builder p_79079_) {
            this.f_79069_.add((Object)p_79079_.m_7453_());
            return this;
        }

        public LootPool m_79082_() {
            return new LootPool((List<LootPoolEntryContainer>)this.f_79067_.build(), (List<LootItemCondition>)this.f_79068_.build(), (List<LootItemFunction>)this.f_79069_.build(), this.f_79070_, this.f_79071_);
        }

        @Override
        public /* synthetic */ FunctionUserBuilder m_79073_() {
            return this.m_79073_();
        }

        @Override
        public /* synthetic */ FunctionUserBuilder m_79078_(LootItemFunction.Builder builder) {
            return this.m_79078_(builder);
        }

        @Override
        public /* synthetic */ ConditionUserBuilder m_79073_() {
            return this.m_79073_();
        }

        @Override
        public /* synthetic */ ConditionUserBuilder m_79080_(LootItemCondition.Builder builder) {
            return this.m_79080_(builder);
        }
    }
}

