/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public abstract class BaseSpawner {
    public static final String f_254624_ = "SpawnData";
    private static final Logger f_45441_ = LogUtils.getLogger();
    private static final int f_151303_ = 1;
    private int f_45442_ = 20;
    private SimpleWeightedRandomList<SpawnData> f_45443_ = SimpleWeightedRandomList.m_185864_();
    @Nullable
    private SpawnData f_45444_;
    private double f_45445_;
    private double f_45446_;
    private int f_45447_ = 200;
    private int f_45448_ = 800;
    private int f_45449_ = 4;
    @Nullable
    private Entity f_45450_;
    private int f_45451_ = 6;
    private int f_45452_ = 16;
    private int f_45453_ = 4;

    public void m_253197_(EntityType<?> p_253682_, @Nullable Level p_254041_, RandomSource p_254221_, BlockPos p_254050_) {
        this.m_253144_(p_254041_, p_254221_, p_254050_).m_186567_().m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(p_253682_).toString());
    }

    private boolean m_151343_(Level p_151344_, BlockPos p_151345_) {
        return p_151344_.m_45914_((double)p_151345_.m_123341_() + 0.5, (double)p_151345_.m_123342_() + 0.5, (double)p_151345_.m_123343_() + 0.5, this.f_45452_);
    }

    public void m_151319_(Level p_151320_, BlockPos p_151321_) {
        if (!this.m_151343_(p_151320_, p_151321_)) {
            this.f_45446_ = this.f_45445_;
        } else if (this.f_45450_ != null) {
            RandomSource $$2 = p_151320_.m_213780_();
            double $$3 = (double)p_151321_.m_123341_() + $$2.m_188500_();
            double $$4 = (double)p_151321_.m_123342_() + $$2.m_188500_();
            double $$5 = (double)p_151321_.m_123343_() + $$2.m_188500_();
            p_151320_.m_7106_(ParticleTypes.f_123762_, $$3, $$4, $$5, 0.0, 0.0, 0.0);
            p_151320_.m_7106_(ParticleTypes.f_123744_, $$3, $$4, $$5, 0.0, 0.0, 0.0);
            if (this.f_45442_ > 0) {
                --this.f_45442_;
            }
            this.f_45446_ = this.f_45445_;
            this.f_45445_ = (this.f_45445_ + (double)(1000.0f / ((float)this.f_45442_ + 200.0f))) % 360.0;
        }
    }

    public void m_151311_(ServerLevel p_151312_, BlockPos p_151313_) {
        if (!this.m_151343_(p_151312_, p_151313_)) {
            return;
        }
        if (this.f_45442_ == -1) {
            this.m_151350_(p_151312_, p_151313_);
        }
        if (this.f_45442_ > 0) {
            --this.f_45442_;
            return;
        }
        boolean $$2 = false;
        RandomSource $$3 = p_151312_.m_213780_();
        SpawnData $$4 = this.m_253144_(p_151312_, $$3, p_151313_);
        for (int $$5 = 0; $$5 < this.f_45449_; ++$$5) {
            SpawnData.CustomSpawnRules $$14;
            double $$12;
            CompoundTag $$6 = $$4.m_186567_();
            Optional<EntityType<?>> $$7 = EntityType.m_20637_($$6);
            if ($$7.isEmpty()) {
                this.m_151350_(p_151312_, p_151313_);
                return;
            }
            ListTag $$8 = $$6.m_128437_("Pos", 6);
            int $$9 = $$8.size();
            double $$10 = $$9 >= 1 ? $$8.m_128772_(0) : (double)p_151313_.m_123341_() + ($$3.m_188500_() - $$3.m_188500_()) * (double)this.f_45453_ + 0.5;
            double $$11 = $$9 >= 2 ? $$8.m_128772_(1) : (double)(p_151313_.m_123342_() + $$3.m_188503_(3) - 1);
            double d = $$12 = $$9 >= 3 ? $$8.m_128772_(2) : (double)p_151313_.m_123343_() + ($$3.m_188500_() - $$3.m_188500_()) * (double)this.f_45453_ + 0.5;
            if (!p_151312_.m_45772_($$7.get().m_20585_($$10, $$11, $$12))) continue;
            BlockPos $$13 = BlockPos.m_274561_($$10, $$11, $$12);
            if (!$$4.m_186574_().isPresent() ? !SpawnPlacements.m_217074_($$7.get(), p_151312_, MobSpawnType.SPAWNER, $$13, p_151312_.m_213780_()) : !$$7.get().m_20674_().m_21609_() && p_151312_.m_46791_() == Difficulty.PEACEFUL || !($$14 = $$4.m_186574_().get()).f_186584_().m_184578_(p_151312_.m_45517_(LightLayer.BLOCK, $$13)) || !$$14.f_186585_().m_184578_(p_151312_.m_45517_(LightLayer.SKY, $$13))) continue;
            Entity $$15 = EntityType.m_20645_($$6, p_151312_, p_151310_ -> {
                p_151310_.m_7678_($$10, $$11, $$12, p_151310_.m_146908_(), p_151310_.m_146909_());
                return p_151310_;
            });
            if ($$15 == null) {
                this.m_151350_(p_151312_, p_151313_);
                return;
            }
            int $$16 = p_151312_.m_45976_($$15.getClass(), new AABB(p_151313_.m_123341_(), p_151313_.m_123342_(), p_151313_.m_123343_(), p_151313_.m_123341_() + 1, p_151313_.m_123342_() + 1, p_151313_.m_123343_() + 1).m_82400_(this.f_45453_)).size();
            if ($$16 >= this.f_45451_) {
                this.m_151350_(p_151312_, p_151313_);
                return;
            }
            $$15.m_7678_($$15.m_20185_(), $$15.m_20186_(), $$15.m_20189_(), $$3.m_188501_() * 360.0f, 0.0f);
            if ($$15 instanceof Mob) {
                Mob $$17 = (Mob)$$15;
                if ($$4.m_186574_().isEmpty() && !$$17.m_5545_(p_151312_, MobSpawnType.SPAWNER) || !$$17.m_6914_(p_151312_)) continue;
                if ($$4.m_186567_().m_128440_() == 1 && $$4.m_186567_().m_128425_("id", 8)) {
                    ((Mob)$$15).m_6518_(p_151312_, p_151312_.m_6436_($$15.m_20183_()), MobSpawnType.SPAWNER, null, null);
                }
            }
            if (!p_151312_.m_8860_($$15)) {
                this.m_151350_(p_151312_, p_151313_);
                return;
            }
            p_151312_.m_46796_(2004, p_151313_, 0);
            p_151312_.m_142346_($$15, GameEvent.f_157810_, $$13);
            if ($$15 instanceof Mob) {
                ((Mob)$$15).m_21373_();
            }
            $$2 = true;
        }
        if ($$2) {
            this.m_151350_(p_151312_, p_151313_);
        }
    }

    private void m_151350_(Level p_151351_, BlockPos p_151352_) {
        RandomSource $$2 = p_151351_.f_46441_;
        this.f_45442_ = this.f_45448_ <= this.f_45447_ ? this.f_45447_ : this.f_45447_ + $$2.m_188503_(this.f_45448_ - this.f_45447_);
        this.f_45443_.m_216829_($$2).ifPresent(p_186386_ -> this.m_142667_(p_151351_, p_151352_, (SpawnData)p_186386_.m_146310_()));
        this.m_142523_(p_151351_, p_151352_, 1);
    }

    public void m_151328_(@Nullable Level p_151329_, BlockPos p_151330_, CompoundTag p_151331_) {
        boolean $$5;
        this.f_45442_ = p_151331_.m_128448_("Delay");
        boolean $$3 = p_151331_.m_128425_(f_254624_, 10);
        if ($$3) {
            SpawnData $$4 = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_151331_.m_128469_(f_254624_)).resultOrPartial(p_186391_ -> f_45441_.warn("Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new);
            this.m_142667_(p_151329_, p_151330_, $$4);
        }
        if ($$5 = p_151331_.m_128425_("SpawnPotentials", 9)) {
            ListTag $$6 = p_151331_.m_128437_("SpawnPotentials", 10);
            this.f_45443_ = SpawnData.f_186560_.parse((DynamicOps)NbtOps.f_128958_, (Object)$$6).resultOrPartial(p_186388_ -> f_45441_.warn("Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::m_185864_);
        } else {
            this.f_45443_ = SimpleWeightedRandomList.m_185862_(this.f_45444_ != null ? this.f_45444_ : new SpawnData());
        }
        if (p_151331_.m_128425_("MinSpawnDelay", 99)) {
            this.f_45447_ = p_151331_.m_128448_("MinSpawnDelay");
            this.f_45448_ = p_151331_.m_128448_("MaxSpawnDelay");
            this.f_45449_ = p_151331_.m_128448_("SpawnCount");
        }
        if (p_151331_.m_128425_("MaxNearbyEntities", 99)) {
            this.f_45451_ = p_151331_.m_128448_("MaxNearbyEntities");
            this.f_45452_ = p_151331_.m_128448_("RequiredPlayerRange");
        }
        if (p_151331_.m_128425_("SpawnRange", 99)) {
            this.f_45453_ = p_151331_.m_128448_("SpawnRange");
        }
        this.f_45450_ = null;
    }

    public CompoundTag m_186381_(CompoundTag p_186382_) {
        p_186382_.m_128376_("Delay", (short)this.f_45442_);
        p_186382_.m_128376_("MinSpawnDelay", (short)this.f_45447_);
        p_186382_.m_128376_("MaxSpawnDelay", (short)this.f_45448_);
        p_186382_.m_128376_("SpawnCount", (short)this.f_45449_);
        p_186382_.m_128376_("MaxNearbyEntities", (short)this.f_45451_);
        p_186382_.m_128376_("RequiredPlayerRange", (short)this.f_45452_);
        p_186382_.m_128376_("SpawnRange", (short)this.f_45453_);
        if (this.f_45444_ != null) {
            p_186382_.m_128365_(f_254624_, (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.f_45444_).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        }
        p_186382_.m_128365_("SpawnPotentials", (Tag)SpawnData.f_186560_.encodeStart((DynamicOps)NbtOps.f_128958_, this.f_45443_).result().orElseThrow());
        return p_186382_;
    }

    @Nullable
    public Entity m_253067_(Level p_254323_, RandomSource p_254353_, BlockPos p_254313_) {
        if (this.f_45450_ == null) {
            CompoundTag $$3 = this.m_253144_(p_254323_, p_254353_, p_254313_).m_186567_();
            if (!$$3.m_128425_("id", 8)) {
                return null;
            }
            this.f_45450_ = EntityType.m_20645_($$3, p_254323_, Function.identity());
            if ($$3.m_128440_() != 1 || this.f_45450_ instanceof Mob) {
                // empty if block
            }
        }
        return this.f_45450_;
    }

    public boolean m_151316_(Level p_151317_, int p_151318_) {
        if (p_151318_ == 1) {
            if (p_151317_.f_46443_) {
                this.f_45442_ = this.f_45447_;
            }
            return true;
        }
        return false;
    }

    protected void m_142667_(@Nullable Level p_151325_, BlockPos p_151326_, SpawnData p_151327_) {
        this.f_45444_ = p_151327_;
    }

    private SpawnData m_253144_(@Nullable Level p_254503_, RandomSource p_253892_, BlockPos p_254487_) {
        if (this.f_45444_ != null) {
            return this.f_45444_;
        }
        this.m_142667_(p_254503_, p_254487_, this.f_45443_.m_216829_(p_253892_).map(WeightedEntry.Wrapper::m_146310_).orElseGet(SpawnData::new));
        return this.f_45444_;
    }

    public abstract void m_142523_(Level var1, BlockPos var2, int var3);

    public double m_45473_() {
        return this.f_45445_;
    }

    public double m_45474_() {
        return this.f_45446_;
    }
}

