/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;

public class SkinManager {
    private static final String f_174841_ = "textures";
    private final LoadingCache<CacheKey, CompletableFuture<PlayerSkin>> f_291642_;
    private final TextureCache f_291663_;
    private final TextureCache f_291885_;
    private final TextureCache f_290946_;

    public SkinManager(TextureManager p_118812_, Path p_299617_, final MinecraftSessionService p_118814_, final Executor p_299732_) {
        this.f_291663_ = new TextureCache(p_118812_, p_299617_, MinecraftProfileTexture.Type.SKIN);
        this.f_291885_ = new TextureCache(p_118812_, p_299617_, MinecraftProfileTexture.Type.CAPE);
        this.f_290946_ = new TextureCache(p_118812_, p_299617_, MinecraftProfileTexture.Type.ELYTRA);
        this.f_291642_ = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(15L)).build((CacheLoader)new CacheLoader<CacheKey, CompletableFuture<PlayerSkin>>(){

            public CompletableFuture<PlayerSkin> load(CacheKey p_298169_) {
                GameProfile $$1 = p_298169_.f_290972_();
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        try {
                            return TextureInfo.m_295091_(p_118814_.getTextures($$1, true), true);
                        }
                        catch (InsecurePublicKeyException $$2) {
                            return TextureInfo.m_295091_(p_118814_.getTextures($$1, false), false);
                        }
                    }
                    catch (Throwable $$3) {
                        return TextureInfo.f_290478_;
                    }
                }, Util.m_183991_()).thenComposeAsync(p_301039_ -> SkinManager.this.m_292851_($$1, (TextureInfo)p_301039_), p_299732_);
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((CacheKey)object);
            }
        });
    }

    public Supplier<PlayerSkin> m_293884_(GameProfile p_298295_) {
        CompletableFuture<PlayerSkin> $$1 = this.m_293351_(p_298295_);
        PlayerSkin $$2 = DefaultPlayerSkin.m_295210_(p_298295_);
        return () -> $$1.getNow($$2);
    }

    public PlayerSkin m_293307_(GameProfile p_298019_) {
        PlayerSkin $$1 = this.m_293351_(p_298019_).getNow(null);
        if ($$1 != null) {
            return $$1;
        }
        return DefaultPlayerSkin.m_295210_(p_298019_);
    }

    public CompletableFuture<PlayerSkin> m_293351_(GameProfile p_298661_) {
        return (CompletableFuture)this.f_291642_.getUnchecked((Object)new CacheKey(p_298661_));
    }

    CompletableFuture<PlayerSkin> m_292851_(GameProfile p_299268_, TextureInfo p_298597_) {
        PlayerSkin.Model $$7;
        CompletableFuture<ResourceLocation> $$6;
        MinecraftProfileTexture $$2 = p_298597_.f_291085_();
        if ($$2 != null) {
            CompletableFuture<ResourceLocation> $$3 = this.f_291663_.m_293756_($$2);
            PlayerSkin.Model $$4 = PlayerSkin.Model.m_293021_($$2.getMetadata("model"));
        } else {
            PlayerSkin $$5 = DefaultPlayerSkin.m_295210_(p_299268_);
            $$6 = CompletableFuture.completedFuture($$5.f_290339_());
            $$7 = $$5.f_290793_();
        }
        String $$8 = Optionull.m_269382_($$2, MinecraftProfileTexture::getUrl);
        MinecraftProfileTexture $$9 = p_298597_.f_290982_();
        CompletableFuture<Object> $$10 = $$9 != null ? this.f_291885_.m_293756_($$9) : CompletableFuture.completedFuture(null);
        MinecraftProfileTexture $$11 = p_298597_.f_291745_();
        CompletableFuture<Object> $$12 = $$11 != null ? this.f_290946_.m_293756_($$11) : CompletableFuture.completedFuture(null);
        return CompletableFuture.allOf($$6, $$10, $$12).thenApply(p_296316_ -> new PlayerSkin((ResourceLocation)$$6.join(), $$8, (ResourceLocation)$$10.join(), (ResourceLocation)$$12.join(), $$7, p_298597_.f_291448_()));
    }

    @Nullable
    static Property m_295659_(GameProfile p_300071_) {
        return (Property)Iterables.getFirst((Iterable)p_300071_.getProperties().get((Object)f_174841_), null);
    }

    static class TextureCache {
        private final TextureManager f_291040_;
        private final Path f_291514_;
        private final MinecraftProfileTexture.Type f_291290_;
        private final Map<String, CompletableFuture<ResourceLocation>> f_291229_ = new Object2ObjectOpenHashMap();

        TextureCache(TextureManager p_298110_, Path p_297921_, MinecraftProfileTexture.Type p_298775_) {
            this.f_291040_ = p_298110_;
            this.f_291514_ = p_297921_;
            this.f_291290_ = p_298775_;
        }

        public CompletableFuture<ResourceLocation> m_293756_(MinecraftProfileTexture p_300959_) {
            String $$1 = p_300959_.getHash();
            CompletableFuture<ResourceLocation> $$2 = this.f_291229_.get($$1);
            if ($$2 == null) {
                $$2 = this.m_294542_(p_300959_);
                this.f_291229_.put($$1, $$2);
            }
            return $$2;
        }

        private CompletableFuture<ResourceLocation> m_294542_(MinecraftProfileTexture p_300607_) {
            String $$1 = Hashing.sha1().hashUnencodedChars((CharSequence)p_300607_.getHash()).toString();
            ResourceLocation $$2 = this.m_293729_($$1);
            Path $$3 = this.f_291514_.resolve($$1.length() > 2 ? $$1.substring(0, 2) : "xx").resolve($$1);
            CompletableFuture<ResourceLocation> $$4 = new CompletableFuture<ResourceLocation>();
            HttpTexture $$5 = new HttpTexture($$3.toFile(), p_300607_.getUrl(), DefaultPlayerSkin.m_293779_(), this.f_291290_ == MinecraftProfileTexture.Type.SKIN, () -> $$4.complete($$2));
            this.f_291040_.m_118495_($$2, $$5);
            return $$4;
        }

        private ResourceLocation m_293729_(String p_297392_) {
            String $$1 = switch (this.f_291290_) {
                default -> throw new IncompatibleClassChangeError();
                case MinecraftProfileTexture.Type.SKIN -> "skins";
                case MinecraftProfileTexture.Type.CAPE -> "capes";
                case MinecraftProfileTexture.Type.ELYTRA -> "elytra";
            };
            return new ResourceLocation($$1 + "/" + p_297392_);
        }
    }

    record CacheKey(GameProfile f_290972_) {
        @Override
        public boolean equals(Object p_299382_) {
            if (p_299382_ instanceof CacheKey) {
                CacheKey $$1 = (CacheKey)p_299382_;
                return this.f_290972_.getId().equals($$1.f_290972_.getId()) && Objects.equals(this.m_294601_(), $$1.m_294601_());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.f_290972_.getId().hashCode() + Objects.hashCode(this.m_294601_()) * 31;
        }

        @Nullable
        private String m_294601_() {
            Property $$0 = SkinManager.m_295659_(this.f_290972_);
            return $$0 != null ? $$0.value() : null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CacheKey.class, "profile", "f_290972_"}, this);
        }
    }

    record TextureInfo(@Nullable MinecraftProfileTexture f_291085_, @Nullable MinecraftProfileTexture f_290982_, @Nullable MinecraftProfileTexture f_291745_, boolean f_291448_) {
        public static final TextureInfo f_290478_ = new TextureInfo(null, null, null, true);

        public static TextureInfo m_295091_(Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> p_297479_, boolean p_297713_) {
            if (p_297479_.isEmpty()) {
                return f_290478_;
            }
            return new TextureInfo(p_297479_.get(MinecraftProfileTexture.Type.SKIN), p_297479_.get(MinecraftProfileTexture.Type.CAPE), p_297479_.get(MinecraftProfileTexture.Type.ELYTRA), p_297713_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TextureInfo.class, "skin;cape;elytra;secure", "f_291085_", "f_290982_", "f_291745_", "f_291448_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TextureInfo.class, "skin;cape;elytra;secure", "f_291085_", "f_290982_", "f_291745_", "f_291448_"}, this);
        }

        @Override
        public final boolean equals(Object p_299211_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TextureInfo.class, "skin;cape;elytra;secure", "f_291085_", "f_290982_", "f_291745_", "f_291448_"}, this, p_299211_);
        }
    }
}

