/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.hash.Hashing;
import com.mojang.logging.LogUtils;
import com.mojang.util.UndashedUuid;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;

public class DownloadedPackSource
implements RepositorySource {
    private static final Logger f_243667_ = LogUtils.getLogger();
    private static final Pattern f_244551_ = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final int f_243735_ = 0xFA00000;
    private static final int f_244627_ = 10;
    private static final String f_244475_ = "server";
    private static final Component f_243792_ = Component.m_237115_("resourcePack.server.name");
    private static final Component f_244023_ = Component.m_237115_("multiplayer.applyingPack");
    private final File f_244074_;
    private final ReentrantLock f_244572_ = new ReentrantLock();
    @Nullable
    private CompletableFuture<?> f_243680_;
    @Nullable
    private Pack f_244082_;

    public DownloadedPackSource(File p_249798_) {
        this.f_244074_ = p_249798_;
    }

    @Override
    public void m_7686_(Consumer<Pack> p_251994_) {
        if (this.f_244082_ != null) {
            p_251994_.accept(this.f_244082_);
        }
    }

    private static Map<String, String> m_245308_() {
        return Map.of("X-Minecraft-Username", Minecraft.m_91087_().m_91094_().m_92546_(), "X-Minecraft-UUID", UndashedUuid.toString((UUID)Minecraft.m_91087_().m_91094_().m_240411_()), "X-Minecraft-Version", SharedConstants.m_183709_().m_132493_(), "X-Minecraft-Version-ID", SharedConstants.m_183709_().m_132492_(), "X-Minecraft-Pack-Format", String.valueOf(SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES)), "User-Agent", "Minecraft Java/" + SharedConstants.m_183709_().m_132493_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> m_246254_(URL p_249839_, String p_249218_, boolean p_251033_) {
        String $$3 = Hashing.sha1().hashString((CharSequence)p_249839_.toString(), StandardCharsets.UTF_8).toString();
        String $$4 = f_244551_.matcher(p_249218_).matches() ? p_249218_ : "";
        this.f_244572_.lock();
        try {
            CompletableFuture<?> $$10;
            Minecraft $$5 = Minecraft.m_91087_();
            File $$6 = new File(this.f_244074_, $$3);
            if ($$6.exists()) {
                CompletableFuture<String> $$7 = CompletableFuture.completedFuture("");
            } else {
                ProgressScreen $$8 = new ProgressScreen(p_251033_);
                Map<String, String> $$9 = DownloadedPackSource.m_245308_();
                $$5.m_18709_(() -> $$5.m_91152_($$8));
                $$10 = HttpUtil.m_216225_($$6, p_249839_, $$9, 0xFA00000, $$8, $$5.m_91096_());
            }
            CompletableFuture<?> completableFuture = this.f_243680_ = ((CompletableFuture)((CompletableFuture)$$10.thenCompose(p_251155_ -> {
                if (!this.m_245350_($$4, $$6)) {
                    return CompletableFuture.failedFuture(new RuntimeException("Hash check failure for file " + $$6 + ", see log"));
                }
                $$5.execute(() -> {
                    if (!p_251033_) {
                        $$5.m_91152_(new GenericDirtMessageScreen(f_244023_));
                    }
                });
                return this.m_247526_($$6, PackSource.f_10530_);
            })).exceptionallyCompose(p_249744_ -> ((CompletableFuture)this.m_246151_().thenAcceptAsync(p_251750_ -> {
                f_243667_.warn("Pack application failed: {}, deleting file {}", (Object)p_249744_.getMessage(), (Object)$$6);
                DownloadedPackSource.m_246169_($$6);
            }, (Executor)Util.m_183992_())).thenAcceptAsync(p_248937_ -> $$5.m_91152_(new ConfirmScreen(p_249339_ -> {
                if (p_249339_) {
                    $$5.m_91152_(null);
                } else {
                    ClientPacketListener $$2 = $$5.m_91403_();
                    if ($$2 != null) {
                        $$2.m_104910_().m_129507_(Component.m_237115_("connect.aborted"));
                    }
                }
            }, Component.m_237115_("multiplayer.texturePrompt.failure.line1"), Component.m_237115_("multiplayer.texturePrompt.failure.line2"), CommonComponents.f_130659_, Component.m_237115_("menu.disconnect"))), (Executor)$$5))).thenAcceptAsync(p_250279_ -> this.m_245559_(), (Executor)Util.m_183992_());
            return completableFuture;
        }
        finally {
            this.f_244572_.unlock();
        }
    }

    private static void m_246169_(File p_251727_) {
        try {
            Files.delete(p_251727_.toPath());
        }
        catch (IOException $$1) {
            f_243667_.warn("Failed to delete file {}: {}", (Object)p_251727_, (Object)$$1.getMessage());
        }
    }

    public CompletableFuture<Void> m_246151_() {
        this.f_244572_.lock();
        try {
            if (this.f_243680_ != null) {
                this.f_243680_.cancel(true);
            }
            this.f_243680_ = null;
            if (this.f_244082_ != null) {
                this.f_244082_ = null;
                CompletableFuture<Void> completableFuture = Minecraft.m_91087_().m_91088_();
                return completableFuture;
            }
        }
        finally {
            this.f_244572_.unlock();
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean m_245350_(String p_251365_, File p_249356_) {
        try {
            String $$2 = com.google.common.io.Files.asByteSource((File)p_249356_).hash(Hashing.sha1()).toString();
            if (p_251365_.isEmpty()) {
                f_243667_.info("Found file {} without verification hash", (Object)p_249356_);
                return true;
            }
            if ($$2.toLowerCase(Locale.ROOT).equals(p_251365_.toLowerCase(Locale.ROOT))) {
                f_243667_.info("Found file {} matching requested hash {}", (Object)p_249356_, (Object)p_251365_);
                return true;
            }
            f_243667_.warn("File {} had wrong hash (expected {}, found {}).", new Object[]{p_249356_, p_251365_, $$2});
        }
        catch (IOException $$3) {
            f_243667_.warn("File {} couldn't be hashed.", (Object)p_249356_, (Object)$$3);
        }
        return false;
    }

    private void m_245559_() {
        if (!this.f_244074_.isDirectory()) {
            return;
        }
        try {
            ArrayList $$0 = new ArrayList(FileUtils.listFiles((File)this.f_244074_, (IOFileFilter)TrueFileFilter.TRUE, null));
            $$0.sort(LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            int $$1 = 0;
            for (File $$2 : $$0) {
                if ($$1++ < 10) continue;
                f_243667_.info("Deleting old server resource pack {}", (Object)$$2.getName());
                FileUtils.deleteQuietly((File)$$2);
            }
        }
        catch (Exception $$3) {
            f_243667_.error("Error while deleting old server resource pack : {}", (Object)$$3.getMessage());
        }
    }

    public CompletableFuture<Void> m_247526_(File p_249885_, PackSource p_251105_) {
        FilePackResources.FileResourcesSupplier $$2 = new FilePackResources.FileResourcesSupplier(p_249885_, false);
        int $$3 = SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES);
        Pack.Info $$4 = Pack.m_246334_(f_244475_, $$2, $$3);
        if ($$4 == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid pack metadata at " + p_249885_));
        }
        f_243667_.info("Applying server pack {}", (Object)p_249885_);
        this.f_244082_ = Pack.m_245512_(f_244475_, f_243792_, true, $$2, $$4, Pack.Position.TOP, true, p_251105_);
        return Minecraft.m_91087_().m_91088_();
    }

    public CompletableFuture<Void> m_247400_(LevelStorageSource.LevelStorageAccess p_248756_) {
        Path $$1 = p_248756_.m_78283_(LevelResource.f_78181_);
        if (Files.exists($$1, new LinkOption[0]) && !Files.isDirectory($$1, new LinkOption[0])) {
            return this.m_247526_($$1.toFile(), PackSource.f_10529_);
        }
        return CompletableFuture.completedFuture(null);
    }
}

