/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas.sources;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.FastColor;
import org.slf4j.Logger;

public class PalettedPermutations
implements SpriteSource {
    static final Logger f_265853_ = LogUtils.getLogger();
    public static final Codec<PalettedPermutations> f_266028_ = RecordCodecBuilder.create(p_266838_ -> p_266838_.group((App)Codec.list(ResourceLocation.f_135803_).fieldOf("textures").forGetter(p_267300_ -> p_267300_.f_265956_), (App)ResourceLocation.f_135803_.fieldOf("palette_key").forGetter(p_266732_ -> p_266732_.f_265884_), (App)Codec.unboundedMap((Codec)Codec.STRING, ResourceLocation.f_135803_).fieldOf("permutations").forGetter(p_267234_ -> p_267234_.f_266003_)).apply((Applicative)p_266838_, PalettedPermutations::new));
    private final List<ResourceLocation> f_265956_;
    private final Map<String, ResourceLocation> f_266003_;
    private final ResourceLocation f_265884_;

    private PalettedPermutations(List<ResourceLocation> p_267282_, ResourceLocation p_266681_, Map<String, ResourceLocation> p_266741_) {
        this.f_265956_ = p_267282_;
        this.f_266003_ = p_266741_;
        this.f_265884_ = p_266681_;
    }

    @Override
    public void m_260891_(ResourceManager p_267219_, SpriteSource.Output p_267250_) {
        Supplier $$2 = Suppliers.memoize(() -> PalettedPermutations.m_266592_(p_267219_, this.f_265884_));
        HashMap $$3 = new HashMap();
        this.f_266003_.forEach((arg_0, arg_1) -> PalettedPermutations.m_266309_($$3, (java.util.function.Supplier)$$2, p_267219_, arg_0, arg_1));
        for (ResourceLocation $$4 : this.f_265956_) {
            ResourceLocation $$5 = f_266012_.m_245698_($$4);
            Optional<Resource> $$6 = p_267219_.m_213713_($$5);
            if ($$6.isEmpty()) {
                f_265853_.warn("Unable to find texture {}", (Object)$$5);
                continue;
            }
            LazyLoadedImage $$7 = new LazyLoadedImage($$5, $$6.get(), $$3.size());
            for (Map.Entry $$8 : $$3.entrySet()) {
                ResourceLocation $$9 = $$4.m_266382_("_" + (String)$$8.getKey());
                p_267250_.m_260840_($$9, new PalettedSpriteSupplier($$7, (java.util.function.Supplier)$$8.getValue(), $$9));
            }
        }
    }

    private static IntUnaryOperator m_266217_(int[] p_266839_, int[] p_266776_) {
        if (p_266776_.length != p_266839_.length) {
            f_265853_.warn("Palette mapping has different sizes: {} and {}", (Object)p_266839_.length, (Object)p_266776_.length);
            throw new IllegalArgumentException();
        }
        Int2IntOpenHashMap $$2 = new Int2IntOpenHashMap(p_266776_.length);
        for (int $$3 = 0; $$3 < p_266839_.length; ++$$3) {
            int $$4 = p_266839_[$$3];
            if (FastColor.ABGR32.m_266503_($$4) == 0) continue;
            $$2.put(FastColor.ABGR32.m_266533_($$4), p_266776_[$$3]);
        }
        return arg_0 -> PalettedPermutations.m_267542_((Int2IntMap)$$2, arg_0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int[] m_266592_(ResourceManager p_267184_, ResourceLocation p_267059_) {
        Optional<Resource> $$2 = p_267184_.m_213713_(f_266012_.m_245698_(p_267059_));
        if ($$2.isEmpty()) {
            f_265853_.error("Failed to load palette image {}", (Object)p_267059_);
            throw new IllegalArgumentException();
        }
        try (InputStream $$3 = $$2.get().m_215507_();){
            NativeImage $$4 = NativeImage.m_85058_($$3);
            try {
                int[] nArray = $$4.m_266370_();
                if ($$4 != null) {
                    $$4.close();
                }
                return nArray;
            }
            catch (Throwable throwable) {
                if ($$4 != null) {
                    try {
                        $$4.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Exception $$5) {
            f_265853_.error("Couldn't load texture {}", (Object)p_267059_, (Object)$$5);
            throw new IllegalArgumentException();
        }
    }

    @Override
    public SpriteSourceType m_260850_() {
        return SpriteSources.f_266099_;
    }

    private static /* synthetic */ int m_267542_(Int2IntMap p_267898_, int p_267899_) {
        int $$2 = FastColor.ABGR32.m_266503_(p_267899_);
        if ($$2 == 0) {
            return p_267899_;
        }
        int $$3 = FastColor.ABGR32.m_266533_(p_267899_);
        int $$4 = p_267898_.getOrDefault($$3, FastColor.ABGR32.m_267818_($$3));
        int $$5 = FastColor.ABGR32.m_266503_($$4);
        return FastColor.ABGR32.m_266498_($$2 * $$5 / 255, $$4);
    }

    private static /* synthetic */ void m_266309_(Map p_266771_, java.util.function.Supplier p_266716_, ResourceManager p_266763_, String p_267108_, ResourceLocation p_266969_) {
        p_266771_.put(p_267108_, Suppliers.memoize(() -> PalettedPermutations.m_266448_((java.util.function.Supplier)p_266716_, p_266763_, p_266969_)));
    }

    private static /* synthetic */ IntUnaryOperator m_266448_(java.util.function.Supplier p_267012_, ResourceManager p_266968_, ResourceLocation p_267020_) {
        return PalettedPermutations.m_266217_((int[])p_267012_.get(), PalettedPermutations.m_266592_(p_266968_, p_267020_));
    }

    record PalettedSpriteSupplier(LazyLoadedImage f_266004_, java.util.function.Supplier<IntUnaryOperator> f_266059_, ResourceLocation f_265892_) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public SpriteContents apply(SpriteResourceLoader p_300667_) {
            try {
                NativeImage $$1 = this.f_266004_.m_266167_().m_266528_(this.f_266059_.get());
                SpriteContents spriteContents = new SpriteContents(this.f_265892_, new FrameSize($$1.m_84982_(), $$1.m_85084_()), $$1, ResourceMetadata.f_215577_);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException $$2) {
                f_265853_.error("unable to apply palette to {}", (Object)this.f_265892_, (Object)$$2);
                SpriteContents spriteContents = null;
                return spriteContents;
            }
            finally {
                this.f_266004_.m_266458_();
            }
        }

        @Override
        public void m_260986_() {
            this.f_266004_.m_266458_();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PalettedSpriteSupplier.class, "baseImage;palette;permutationLocation", "f_266004_", "f_266059_", "f_265892_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PalettedSpriteSupplier.class, "baseImage;palette;permutationLocation", "f_266004_", "f_266059_", "f_265892_"}, this);
        }

        @Override
        public final boolean equals(Object p_267202_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PalettedSpriteSupplier.class, "baseImage;palette;permutationLocation", "f_266004_", "f_266059_", "f_265892_"}, this, p_267202_);
        }

        @Override
        @Nullable
        public /* synthetic */ Object apply(Object object) {
            return this.apply((SpriteResourceLoader)object);
        }
    }
}

