/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import org.slf4j.Logger;

public class TextureAtlas
extends AbstractTexture
implements Dumpable,
Tickable {
    private static final Logger f_118261_ = LogUtils.getLogger();
    @Deprecated
    public static final ResourceLocation f_118259_ = InventoryMenu.f_39692_;
    @Deprecated
    public static final ResourceLocation f_118260_ = new ResourceLocation("textures/atlas/particles.png");
    private List<SpriteContents> f_118263_ = List.of();
    private List<TextureAtlasSprite.Ticker> f_118262_ = List.of();
    private Map<ResourceLocation, TextureAtlasSprite> f_118264_ = Map.of();
    @Nullable
    private TextureAtlasSprite f_301625_;
    private final ResourceLocation f_118265_;
    private final int f_118266_;
    private int f_276067_;
    private int f_276070_;
    private int f_276072_;

    public TextureAtlas(ResourceLocation p_118269_) {
        this.f_118265_ = p_118269_;
        this.f_118266_ = RenderSystem.maxSupportedTextureSize();
    }

    @Override
    public void m_6704_(ResourceManager p_118282_) {
    }

    public void m_247065_(SpriteLoader.Preparations p_250662_) {
        f_118261_.info("Created: {}x{}x{} {}-atlas", new Object[]{p_250662_.f_243669_(), p_250662_.f_244632_(), p_250662_.f_244353_(), this.f_118265_});
        TextureUtil.prepareImage(this.m_117963_(), p_250662_.f_244353_(), p_250662_.f_243669_(), p_250662_.f_244632_());
        this.f_276067_ = p_250662_.f_243669_();
        this.f_276070_ = p_250662_.f_244632_();
        this.f_276072_ = p_250662_.f_244353_();
        this.m_118329_();
        this.f_118264_ = Map.copyOf(p_250662_.f_243807_());
        this.f_301625_ = this.f_118264_.get(MissingTextureAtlasSprite.m_118071_());
        if (this.f_301625_ == null) {
            throw new IllegalStateException("Atlas '" + this.f_118265_ + "' (" + this.f_118264_.size() + " sprites) has no missing texture sprite");
        }
        ArrayList<SpriteContents> $$1 = new ArrayList<SpriteContents>();
        ArrayList<TextureAtlasSprite.Ticker> $$2 = new ArrayList<TextureAtlasSprite.Ticker>();
        for (TextureAtlasSprite $$3 : p_250662_.f_243807_().values()) {
            $$1.add($$3.m_245424_());
            try {
                $$3.m_118416_();
            }
            catch (Throwable $$4) {
                CrashReport $$5 = CrashReport.m_127521_($$4, "Stitching texture atlas");
                CrashReportCategory $$6 = $$5.m_127514_("Texture being stitched together");
                $$6.m_128159_("Atlas path", this.f_118265_);
                $$6.m_128159_("Sprite", $$3);
                throw new ReportedException($$5);
            }
            TextureAtlasSprite.Ticker $$7 = $$3.m_247406_();
            if ($$7 == null) continue;
            $$2.add($$7);
        }
        this.f_118263_ = List.copyOf($$1);
        this.f_118262_ = List.copyOf($$2);
    }

    @Override
    public void m_276079_(ResourceLocation p_276106_, Path p_276127_) throws IOException {
        String $$2 = p_276106_.m_179910_();
        TextureUtil.writeAsPNG(p_276127_, $$2, this.m_117963_(), this.f_276072_, this.f_276067_, this.f_276070_);
        TextureAtlas.m_260988_(p_276127_, $$2, this.f_118264_);
    }

    private static void m_260988_(Path p_261769_, String p_262102_, Map<ResourceLocation, TextureAtlasSprite> p_261722_) {
        Path $$3 = p_261769_.resolve(p_262102_ + ".txt");
        try (BufferedWriter $$4 = Files.newBufferedWriter($$3, new OpenOption[0]);){
            for (Map.Entry $$5 : p_261722_.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                TextureAtlasSprite $$6 = (TextureAtlasSprite)$$5.getValue();
                $$4.write(String.format(Locale.ROOT, "%s\tx=%d\ty=%d\tw=%d\th=%d%n", $$5.getKey(), $$6.m_174743_(), $$6.m_174744_(), $$6.m_245424_().m_246492_(), $$6.m_245424_().m_245330_()));
            }
        }
        catch (IOException $$7) {
            f_118261_.warn("Failed to write file {}", (Object)$$3, (Object)$$7);
        }
    }

    public void m_118270_() {
        this.m_117966_();
        for (TextureAtlasSprite.Ticker $$0 : this.f_118262_) {
            $$0.m_245385_();
        }
    }

    @Override
    public void m_7673_() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::m_118270_);
        } else {
            this.m_118270_();
        }
    }

    public TextureAtlasSprite m_118316_(ResourceLocation p_118317_) {
        TextureAtlasSprite $$1 = this.f_118264_.getOrDefault(p_118317_, this.f_301625_);
        if ($$1 == null) {
            throw new IllegalStateException("Tried to lookup sprite, but atlas is not initialized");
        }
        return $$1;
    }

    public void m_118329_() {
        this.f_118263_.forEach(SpriteContents::close);
        this.f_118262_.forEach(TextureAtlasSprite.Ticker::close);
        this.f_118263_ = List.of();
        this.f_118262_ = List.of();
        this.f_118264_ = Map.of();
        this.f_301625_ = null;
    }

    public ResourceLocation m_118330_() {
        return this.f_118265_;
    }

    public int m_245285_() {
        return this.f_118266_;
    }

    int m_276092_() {
        return this.f_276067_;
    }

    int m_276095_() {
        return this.f_276070_;
    }

    public void m_247255_(SpriteLoader.Preparations p_251993_) {
        this.m_117960_(false, p_251993_.f_244353_() > 0);
    }
}

