/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class SpriteContents
implements Stitcher.Entry,
AutoCloseable {
    private static final Logger f_243663_ = LogUtils.getLogger();
    private final ResourceLocation f_243877_;
    final int f_244302_;
    final int f_244600_;
    private final NativeImage f_243904_;
    NativeImage[] f_243731_;
    @Nullable
    private final AnimatedTexture f_244575_;
    private final ResourceMetadata f_290652_;

    public SpriteContents(ResourceLocation p_249787_, FrameSize p_251031_, NativeImage p_252131_, ResourceMetadata p_299427_) {
        this.f_243877_ = p_249787_;
        this.f_244302_ = p_251031_.f_244129_();
        this.f_244600_ = p_251031_.f_244503_();
        this.f_290652_ = p_299427_;
        AnimationMetadataSection $$4 = p_299427_.m_214059_(AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
        this.f_244575_ = this.m_247391_(p_251031_, p_252131_.m_84982_(), p_252131_.m_85084_(), $$4);
        this.f_243904_ = p_252131_;
        this.f_243731_ = new NativeImage[]{this.f_243904_};
    }

    public void m_246368_(int p_248864_) {
        try {
            this.f_243731_ = MipmapGenerator.m_246246_(this.f_243731_, p_248864_);
        }
        catch (Throwable $$1) {
            CrashReport $$2 = CrashReport.m_127521_($$1, "Generating mipmaps for frame");
            CrashReportCategory $$3 = $$2.m_127514_("Sprite being mipmapped");
            $$3.m_128165_("First frame", () -> {
                StringBuilder $$0 = new StringBuilder();
                if ($$0.length() > 0) {
                    $$0.append(", ");
                }
                $$0.append(this.f_243904_.m_84982_()).append("x").append(this.f_243904_.m_85084_());
                return $$0.toString();
            });
            CrashReportCategory $$4 = $$2.m_127514_("Frame being iterated");
            $$4.m_128159_("Sprite name", this.f_243877_);
            $$4.m_128165_("Sprite size", () -> this.f_244302_ + " x " + this.f_244600_);
            $$4.m_128165_("Sprite frames", () -> this.m_245088_() + " frames");
            $$4.m_128159_("Mipmap levels", p_248864_);
            throw new ReportedException($$2);
        }
    }

    private int m_245088_() {
        return this.f_244575_ != null ? this.f_244575_.f_243714_.size() : 1;
    }

    @Nullable
    private AnimatedTexture m_247391_(FrameSize p_250817_, int p_249792_, int p_252353_, AnimationMetadataSection p_250947_) {
        int $$4 = p_249792_ / p_250817_.f_244129_();
        int $$5 = p_252353_ / p_250817_.f_244503_();
        int $$6 = $$4 * $$5;
        ArrayList<FrameInfo> $$7 = new ArrayList<FrameInfo>();
        p_250947_.m_174861_((p_251291_, p_251837_) -> $$7.add(new FrameInfo(p_251291_, p_251837_)));
        if ($$7.isEmpty()) {
            for (int $$8 = 0; $$8 < $$6; ++$$8) {
                $$7.add(new FrameInfo($$8, p_250947_.m_119030_()));
            }
        } else {
            int $$9 = 0;
            IntOpenHashSet $$10 = new IntOpenHashSet();
            Iterator $$11 = $$7.iterator();
            while ($$11.hasNext()) {
                FrameInfo $$12 = (FrameInfo)$$11.next();
                boolean $$13 = true;
                if ($$12.f_244553_ <= 0) {
                    f_243663_.warn("Invalid frame duration on sprite {} frame {}: {}", new Object[]{this.f_243877_, $$9, $$12.f_244553_});
                    $$13 = false;
                }
                if ($$12.f_243751_ < 0 || $$12.f_243751_ >= $$6) {
                    f_243663_.warn("Invalid frame index on sprite {} frame {}: {}", new Object[]{this.f_243877_, $$9, $$12.f_243751_});
                    $$13 = false;
                }
                if ($$13) {
                    $$10.add($$12.f_243751_);
                } else {
                    $$11.remove();
                }
                ++$$9;
            }
            int[] $$14 = IntStream.range(0, $$6).filter(arg_0 -> SpriteContents.m_247508_((IntSet)$$10, arg_0)).toArray();
            if ($$14.length > 0) {
                f_243663_.warn("Unused frames in sprite {}: {}", (Object)this.f_243877_, (Object)Arrays.toString($$14));
            }
        }
        if ($$7.size() <= 1) {
            return null;
        }
        return new AnimatedTexture((List<FrameInfo>)ImmutableList.copyOf($$7), $$4, p_250947_.m_119036_());
    }

    void m_247381_(int p_248895_, int p_250245_, int p_250458_, int p_251337_, NativeImage[] p_248825_) {
        for (int $$5 = 0; $$5 < this.f_243731_.length; ++$$5) {
            p_248825_[$$5].m_85003_($$5, p_248895_ >> $$5, p_250245_ >> $$5, p_250458_ >> $$5, p_251337_ >> $$5, this.f_244302_ >> $$5, this.f_244600_ >> $$5, this.f_243731_.length > 1, false);
        }
    }

    @Override
    public int m_246492_() {
        return this.f_244302_;
    }

    @Override
    public int m_245330_() {
        return this.f_244600_;
    }

    @Override
    public ResourceLocation m_246162_() {
        return this.f_243877_;
    }

    public IntStream m_245638_() {
        return this.f_244575_ != null ? this.f_244575_.m_246130_() : IntStream.of(1);
    }

    @Nullable
    public SpriteTicker m_246786_() {
        return this.f_244575_ != null ? this.f_244575_.m_246690_() : null;
    }

    public ResourceMetadata m_293312_() {
        return this.f_290652_;
    }

    @Override
    public void close() {
        for (NativeImage $$0 : this.f_243731_) {
            $$0.close();
        }
    }

    public String toString() {
        return "SpriteContents{name=" + this.f_243877_ + ", frameCount=" + this.m_245088_() + ", height=" + this.f_244600_ + ", width=" + this.f_244302_ + "}";
    }

    public boolean m_245970_(int p_250374_, int p_250934_, int p_249573_) {
        int $$3 = p_250934_;
        int $$4 = p_249573_;
        if (this.f_244575_ != null) {
            $$3 += this.f_244575_.m_245080_(p_250374_) * this.f_244302_;
            $$4 += this.f_244575_.m_246436_(p_250374_) * this.f_244600_;
        }
        return (this.f_243904_.m_84985_($$3, $$4) >> 24 & 0xFF) == 0;
    }

    public void m_246850_(int p_252315_, int p_248634_) {
        if (this.f_244575_ != null) {
            this.f_244575_.m_247129_(p_252315_, p_248634_);
        } else {
            this.m_247381_(p_252315_, p_248634_, 0, 0, this.f_243731_);
        }
    }

    private static /* synthetic */ boolean m_247508_(IntSet p_251708_, int p_251185_) {
        return !p_251708_.contains(p_251185_);
    }

    class AnimatedTexture {
        final List<FrameInfo> f_243714_;
        private final int f_244229_;
        private final boolean f_244317_;

        AnimatedTexture(List<FrameInfo> p_250968_, int p_251686_, boolean p_251832_) {
            this.f_243714_ = p_250968_;
            this.f_244229_ = p_251686_;
            this.f_244317_ = p_251832_;
        }

        int m_245080_(int p_249475_) {
            return p_249475_ % this.f_244229_;
        }

        int m_246436_(int p_251327_) {
            return p_251327_ / this.f_244229_;
        }

        void m_245074_(int p_250449_, int p_248877_, int p_249060_) {
            int $$3 = this.m_245080_(p_249060_) * SpriteContents.this.f_244302_;
            int $$4 = this.m_246436_(p_249060_) * SpriteContents.this.f_244600_;
            SpriteContents.this.m_247381_(p_250449_, p_248877_, $$3, $$4, SpriteContents.this.f_243731_);
        }

        public SpriteTicker m_246690_() {
            return new Ticker(this, this.f_244317_ ? new InterpolationData() : null);
        }

        public void m_247129_(int p_251807_, int p_248676_) {
            this.m_245074_(p_251807_, p_248676_, this.f_243714_.get((int)0).f_243751_);
        }

        public IntStream m_246130_() {
            return this.f_243714_.stream().mapToInt(p_249981_ -> p_249981_.f_243751_).distinct();
        }
    }

    static class FrameInfo {
        final int f_243751_;
        final int f_244553_;

        FrameInfo(int p_248909_, int p_250552_) {
            this.f_243751_ = p_248909_;
            this.f_244553_ = p_250552_;
        }
    }

    class Ticker
    implements SpriteTicker {
        int f_244631_;
        int f_244511_;
        final AnimatedTexture f_243921_;
        @Nullable
        private final InterpolationData f_244570_;

        Ticker(@Nullable AnimatedTexture p_249618_, InterpolationData p_251097_) {
            this.f_243921_ = p_249618_;
            this.f_244570_ = p_251097_;
        }

        @Override
        public void m_247697_(int p_249105_, int p_249676_) {
            ++this.f_244511_;
            FrameInfo $$2 = this.f_243921_.f_243714_.get(this.f_244631_);
            if (this.f_244511_ >= $$2.f_244553_) {
                int $$3 = $$2.f_243751_;
                this.f_244631_ = (this.f_244631_ + 1) % this.f_243921_.f_243714_.size();
                this.f_244511_ = 0;
                int $$4 = this.f_243921_.f_243714_.get((int)this.f_244631_).f_243751_;
                if ($$3 != $$4) {
                    this.f_243921_.m_245074_(p_249105_, p_249676_, $$4);
                }
            } else if (this.f_244570_ != null) {
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.f_244570_.m_245152_(p_249105_, p_249676_, this));
                } else {
                    this.f_244570_.m_245152_(p_249105_, p_249676_, this);
                }
            }
        }

        @Override
        public void close() {
            if (this.f_244570_ != null) {
                this.f_244570_.close();
            }
        }
    }

    final class InterpolationData
    implements AutoCloseable {
        private final NativeImage[] f_244527_;

        InterpolationData() {
            this.f_244527_ = new NativeImage[SpriteContents.this.f_243731_.length];
            for (int $$0 = 0; $$0 < this.f_244527_.length; ++$$0) {
                int $$1 = SpriteContents.this.f_244302_ >> $$0;
                int $$2 = SpriteContents.this.f_244600_ >> $$0;
                this.f_244527_[$$0] = new NativeImage($$1, $$2, false);
            }
        }

        void m_245152_(int p_250513_, int p_251644_, Ticker p_248626_) {
            AnimatedTexture $$3 = p_248626_.f_243921_;
            List<FrameInfo> $$4 = $$3.f_243714_;
            FrameInfo $$5 = $$4.get(p_248626_.f_244631_);
            double $$6 = 1.0 - (double)p_248626_.f_244511_ / (double)$$5.f_244553_;
            int $$7 = $$5.f_243751_;
            int $$8 = $$4.get((int)((p_248626_.f_244631_ + 1) % $$4.size())).f_243751_;
            if ($$7 != $$8) {
                for (int $$9 = 0; $$9 < this.f_244527_.length; ++$$9) {
                    int $$10 = SpriteContents.this.f_244302_ >> $$9;
                    int $$11 = SpriteContents.this.f_244600_ >> $$9;
                    for (int $$12 = 0; $$12 < $$11; ++$$12) {
                        for (int $$13 = 0; $$13 < $$10; ++$$13) {
                            int $$14 = this.m_246491_($$3, $$7, $$9, $$13, $$12);
                            int $$15 = this.m_246491_($$3, $$8, $$9, $$13, $$12);
                            int $$16 = this.m_247111_($$6, $$14 >> 16 & 0xFF, $$15 >> 16 & 0xFF);
                            int $$17 = this.m_247111_($$6, $$14 >> 8 & 0xFF, $$15 >> 8 & 0xFF);
                            int $$18 = this.m_247111_($$6, $$14 & 0xFF, $$15 & 0xFF);
                            this.f_244527_[$$9].m_84988_($$13, $$12, $$14 & 0xFF000000 | $$16 << 16 | $$17 << 8 | $$18);
                        }
                    }
                }
                SpriteContents.this.m_247381_(p_250513_, p_251644_, 0, 0, this.f_244527_);
            }
        }

        private int m_246491_(AnimatedTexture p_251976_, int p_250761_, int p_250049_, int p_250004_, int p_251489_) {
            return SpriteContents.this.f_243731_[p_250049_].m_84985_(p_250004_ + (p_251976_.m_245080_(p_250761_) * SpriteContents.this.f_244302_ >> p_250049_), p_251489_ + (p_251976_.m_246436_(p_250761_) * SpriteContents.this.f_244600_ >> p_250049_));
        }

        private int m_247111_(double p_250974_, int p_252151_, int p_249832_) {
            return (int)(p_250974_ * (double)p_252151_ + (1.0 - p_250974_) * (double)p_249832_);
        }

        @Override
        public void close() {
            for (NativeImage $$0 : this.f_244527_) {
                $$0.close();
            }
        }
    }
}

