/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class SectionRenderDispatcher {
    private static final Logger f_291440_ = LogUtils.getLogger();
    private static final int f_290396_ = 4;
    private static final int f_291537_ = 2;
    private final PriorityBlockingQueue<RenderSection.CompileTask> f_290449_ = Queues.newPriorityBlockingQueue();
    private final Queue<RenderSection.CompileTask> f_291696_ = Queues.newLinkedBlockingDeque();
    private int f_291840_ = 2;
    private final Queue<SectionBufferBuilderPack> f_290858_;
    private final Queue<Runnable> f_290841_ = Queues.newConcurrentLinkedQueue();
    private volatile int f_290603_;
    private volatile int f_291113_;
    final SectionBufferBuilderPack f_290794_;
    private final ProcessorMailbox<Runnable> f_290713_;
    private final Executor f_291206_;
    ClientLevel f_291400_;
    final LevelRenderer f_290611_;
    private Vec3 f_290602_ = Vec3.f_82478_;

    public SectionRenderDispatcher(ClientLevel p_299878_, LevelRenderer p_299032_, Executor p_298480_, boolean p_298587_, SectionBufferBuilderPack p_299187_) {
        this.f_291400_ = p_299878_;
        this.f_290611_ = p_299032_;
        int $$5 = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.m_110506_().stream().mapToInt(RenderType::m_110507_).sum() * 4) - 1);
        int $$6 = Runtime.getRuntime().availableProcessors();
        int $$7 = p_298587_ ? $$6 : Math.min($$6, 4);
        int $$8 = Math.max(1, Math.min($$7, $$5));
        this.f_290794_ = p_299187_;
        ArrayList $$9 = Lists.newArrayListWithExpectedSize((int)$$8);
        try {
            for (int $$10 = 0; $$10 < $$8; ++$$10) {
                $$9.add(new SectionBufferBuilderPack());
            }
        }
        catch (OutOfMemoryError $$11) {
            f_291440_.warn("Allocated only {}/{} buffers", (Object)$$9.size(), (Object)$$8);
            int $$12 = Math.min($$9.size() * 2 / 3, $$9.size() - 1);
            for (int $$13 = 0; $$13 < $$12; ++$$13) {
                $$9.remove($$9.size() - 1);
            }
            System.gc();
        }
        this.f_290858_ = Queues.newArrayDeque((Iterable)$$9);
        this.f_291113_ = this.f_290858_.size();
        this.f_291206_ = p_298480_;
        this.f_290713_ = ProcessorMailbox.m_18751_(p_298480_, "Section Renderer");
        this.f_290713_.m_6937_(this::m_293371_);
    }

    public void m_293166_(ClientLevel p_298968_) {
        this.f_291400_ = p_298968_;
    }

    private void m_293371_() {
        if (this.f_290858_.isEmpty()) {
            return;
        }
        RenderSection.CompileTask $$0 = this.m_293164_();
        if ($$0 == null) {
            return;
        }
        SectionBufferBuilderPack $$1 = this.f_290858_.poll();
        this.f_290603_ = this.f_290449_.size() + this.f_291696_.size();
        this.f_291113_ = this.f_290858_.size();
        ((CompletableFuture)CompletableFuture.supplyAsync(Util.m_183946_($$0.m_294775_(), () -> $$0.m_294443_($$1)), this.f_291206_).thenCompose(p_298155_ -> p_298155_)).whenComplete((p_299295_, p_297995_) -> {
            if (p_297995_ != null) {
                Minecraft.m_91087_().m_231412_(CrashReport.m_127521_(p_297995_, "Batching sections"));
                return;
            }
            this.f_290713_.m_6937_(() -> {
                if (p_299295_ == SectionTaskResult.SUCCESSFUL) {
                    $$1.m_294577_();
                } else {
                    $$1.m_293358_();
                }
                this.f_290858_.add($$1);
                this.f_291113_ = this.f_290858_.size();
                this.m_293371_();
            });
        });
    }

    @Nullable
    private RenderSection.CompileTask m_293164_() {
        RenderSection.CompileTask $$0;
        if (this.f_291840_ <= 0 && ($$0 = this.f_291696_.poll()) != null) {
            this.f_291840_ = 2;
            return $$0;
        }
        RenderSection.CompileTask $$1 = this.f_290449_.poll();
        if ($$1 != null) {
            --this.f_291840_;
            return $$1;
        }
        this.f_291840_ = 2;
        return this.f_291696_.poll();
    }

    public String m_292950_() {
        return String.format(Locale.ROOT, "pC: %03d, pU: %02d, aB: %02d", this.f_290603_, this.f_290841_.size(), this.f_291113_);
    }

    public int m_293066_() {
        return this.f_290603_;
    }

    public int m_294057_() {
        return this.f_290841_.size();
    }

    public int m_293327_() {
        return this.f_291113_;
    }

    public void m_294870_(Vec3 p_297762_) {
        this.f_290602_ = p_297762_;
    }

    public Vec3 m_293014_() {
        return this.f_290602_;
    }

    public void m_295287_() {
        Runnable $$0;
        while (($$0 = this.f_290841_.poll()) != null) {
            $$0.run();
        }
    }

    public void m_295202_(RenderSection p_299640_, RenderRegionCache p_297835_) {
        p_299640_.m_295370_(p_297835_);
    }

    public void m_295714_() {
        this.m_295487_();
    }

    public void m_294204_(RenderSection.CompileTask p_297747_) {
        this.f_290713_.m_6937_(() -> {
            if (p_298819_.f_290632_) {
                this.f_290449_.offer(p_297747_);
            } else {
                this.f_291696_.offer(p_297747_);
            }
            this.f_290603_ = this.f_290449_.size() + this.f_291696_.size();
            this.m_293371_();
        });
    }

    public CompletableFuture<Void> m_292947_(BufferBuilder.RenderedBuffer p_299767_, VertexBuffer p_298938_) {
        return CompletableFuture.runAsync(() -> {
            if (p_298938_.m_231230_()) {
                return;
            }
            p_298938_.m_85921_();
            p_298938_.m_231221_(p_299767_);
            VertexBuffer.m_85931_();
        }, this.f_290841_::add);
    }

    private void m_295487_() {
        while (!this.f_290449_.isEmpty()) {
            RenderSection.CompileTask $$0 = this.f_290449_.poll();
            if ($$0 == null) continue;
            $$0.m_292880_();
        }
        while (!this.f_291696_.isEmpty()) {
            RenderSection.CompileTask $$1 = this.f_291696_.poll();
            if ($$1 == null) continue;
            $$1.m_292880_();
        }
        this.f_290603_ = 0;
    }

    public boolean m_293214_() {
        return this.f_290603_ == 0 && this.f_290841_.isEmpty();
    }

    public void m_294449_() {
        this.m_295487_();
        this.f_290713_.close();
        this.f_290858_.clear();
    }

    public class RenderSection {
        public static final int f_291071_ = 16;
        public final int f_290488_;
        public final AtomicReference<CompiledSection> f_290312_ = new AtomicReference<CompiledSection>(CompiledSection.f_290410_);
        final AtomicInteger f_291503_ = new AtomicInteger(0);
        @Nullable
        private RebuildTask f_291315_;
        @Nullable
        private ResortTransparencyTask f_291330_;
        private final Set<BlockEntity> f_291787_ = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> f_291754_ = RenderType.m_110506_().stream().collect(Collectors.toMap(p_298649_ -> p_298649_, p_299941_ -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
        private AABB f_290371_;
        private boolean f_291619_ = true;
        final BlockPos.MutableBlockPos f_291850_ = new BlockPos.MutableBlockPos(-1, -1, -1);
        private final BlockPos.MutableBlockPos[] f_291827_ = Util.m_137469_(new BlockPos.MutableBlockPos[6], p_300613_ -> {
            for (int $$1 = 0; $$1 < ((BlockPos.MutableBlockPos[])p_300613_).length; ++$$1) {
                p_300613_[$$1] = new BlockPos.MutableBlockPos();
            }
        });
        private boolean f_291709_;

        public RenderSection(int p_299358_, int p_299044_, int p_300810_, int p_299840_) {
            this.f_290488_ = p_299358_;
            this.m_292814_(p_299044_, p_300810_, p_299840_);
        }

        private boolean m_294104_(BlockPos p_297611_) {
            return SectionRenderDispatcher.this.f_291400_.m_6522_(SectionPos.m_123171_(p_297611_.m_123341_()), SectionPos.m_123171_(p_297611_.m_123343_()), ChunkStatus.f_62326_, false) != null;
        }

        public boolean m_294718_() {
            int $$0 = 24;
            if (this.m_293828_() > 576.0) {
                return this.m_294104_(this.f_291827_[Direction.WEST.ordinal()]) && this.m_294104_(this.f_291827_[Direction.NORTH.ordinal()]) && this.m_294104_(this.f_291827_[Direction.EAST.ordinal()]) && this.m_294104_(this.f_291827_[Direction.SOUTH.ordinal()]);
            }
            return true;
        }

        public AABB m_293301_() {
            return this.f_290371_;
        }

        public VertexBuffer m_294581_(RenderType p_298748_) {
            return this.f_291754_.get(p_298748_);
        }

        public void m_292814_(int p_298099_, int p_299019_, int p_299020_) {
            this.m_293096_();
            this.f_291850_.m_122178_(p_298099_, p_299019_, p_299020_);
            this.f_290371_ = new AABB(p_298099_, p_299019_, p_299020_, p_298099_ + 16, p_299019_ + 16, p_299020_ + 16);
            for (Direction $$3 : Direction.values()) {
                this.f_291827_[$$3.ordinal()].m_122190_(this.f_291850_).m_122175_($$3, 16);
            }
        }

        protected double m_293828_() {
            Camera $$0 = Minecraft.m_91087_().f_91063_.m_109153_();
            double $$1 = this.f_290371_.f_82288_ + 8.0 - $$0.m_90583_().f_82479_;
            double $$2 = this.f_290371_.f_82289_ + 8.0 - $$0.m_90583_().f_82480_;
            double $$3 = this.f_290371_.f_82290_ + 8.0 - $$0.m_90583_().f_82481_;
            return $$1 * $$1 + $$2 * $$2 + $$3 * $$3;
        }

        void m_293308_(BufferBuilder p_300604_) {
            p_300604_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        }

        public CompiledSection m_293175_() {
            return this.f_290312_.get();
        }

        private void m_293096_() {
            this.m_294642_();
            this.f_290312_.set(CompiledSection.f_290410_);
            this.f_291619_ = true;
        }

        public void m_294345_() {
            this.m_293096_();
            this.f_291754_.values().forEach(VertexBuffer::close);
        }

        public BlockPos m_295500_() {
            return this.f_291850_;
        }

        public void m_292780_(boolean p_298731_) {
            boolean $$1 = this.f_291619_;
            this.f_291619_ = true;
            this.f_291709_ = p_298731_ | ($$1 && this.f_291709_);
        }

        public void m_294599_() {
            this.f_291619_ = false;
            this.f_291709_ = false;
        }

        public boolean m_295586_() {
            return this.f_291619_;
        }

        public boolean m_295878_() {
            return this.f_291619_ && this.f_291709_;
        }

        public BlockPos m_292593_(Direction p_299060_) {
            return this.f_291827_[p_299060_.ordinal()];
        }

        public boolean m_294021_(RenderType p_301074_, SectionRenderDispatcher p_298196_) {
            CompiledSection $$2 = this.m_293175_();
            if (this.f_291330_ != null) {
                this.f_291330_.m_292880_();
            }
            if (!$$2.f_290391_.contains(p_301074_)) {
                return false;
            }
            this.f_291330_ = new ResortTransparencyTask(this.m_293828_(), $$2);
            p_298196_.m_294204_(this.f_291330_);
            return true;
        }

        protected boolean m_294642_() {
            boolean $$0 = false;
            if (this.f_291315_ != null) {
                this.f_291315_.m_292880_();
                this.f_291315_ = null;
                $$0 = true;
            }
            if (this.f_291330_ != null) {
                this.f_291330_.m_292880_();
                this.f_291330_ = null;
            }
            return $$0;
        }

        public CompileTask m_295128_(RenderRegionCache p_300037_) {
            boolean $$5;
            boolean $$1 = this.m_294642_();
            BlockPos $$2 = this.f_291850_.m_7949_();
            boolean $$3 = true;
            RenderChunkRegion $$4 = p_300037_.m_200465_(SectionRenderDispatcher.this.f_291400_, $$2.m_7918_(-1, -1, -1), $$2.m_7918_(16, 16, 16), 1);
            boolean bl = $$5 = this.f_290312_.get() == CompiledSection.f_290410_;
            if ($$5 && $$1) {
                this.f_291503_.incrementAndGet();
            }
            this.f_291315_ = new RebuildTask(this.m_293828_(), $$4, !$$5 || this.f_291503_.get() > 2);
            return this.f_291315_;
        }

        public void m_294845_(SectionRenderDispatcher p_299090_, RenderRegionCache p_297331_) {
            CompileTask $$2 = this.m_295128_(p_297331_);
            p_299090_.m_294204_($$2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        void m_295492_(Collection<BlockEntity> p_300373_) {
            void $$3;
            HashSet $$1 = Sets.newHashSet(p_300373_);
            Set<BlockEntity> set = this.f_291787_;
            synchronized (set) {
                HashSet $$2 = Sets.newHashSet(this.f_291787_);
                $$1.removeAll(this.f_291787_);
                $$2.removeAll(p_300373_);
                this.f_291787_.clear();
                this.f_291787_.addAll(p_300373_);
            }
            SectionRenderDispatcher.this.f_290611_.m_109762_((Collection<BlockEntity>)$$3, $$1);
        }

        public void m_295370_(RenderRegionCache p_298605_) {
            CompileTask $$1 = this.m_295128_(p_298605_);
            $$1.m_294443_(SectionRenderDispatcher.this.f_290794_);
        }

        public boolean m_292850_(int p_297900_, int p_299871_, int p_299328_) {
            BlockPos $$3 = this.m_295500_();
            return p_297900_ == SectionPos.m_123171_($$3.m_123341_()) || p_299328_ == SectionPos.m_123171_($$3.m_123343_()) || p_299871_ == SectionPos.m_123171_($$3.m_123342_());
        }

        class ResortTransparencyTask
        extends CompileTask {
            private final CompiledSection f_291899_;

            public ResortTransparencyTask(double p_300619_, CompiledSection p_297742_) {
                super(p_300619_, true);
                this.f_291899_ = p_297742_;
            }

            @Override
            protected String m_294775_() {
                return "rend_chk_sort";
            }

            @Override
            public CompletableFuture<SectionTaskResult> m_294443_(SectionBufferBuilderPack p_297366_) {
                if (this.f_291175_.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.m_294718_()) {
                    this.f_291175_.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.f_291175_.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                Vec3 $$1 = SectionRenderDispatcher.this.m_293014_();
                float $$2 = (float)$$1.f_82479_;
                float $$3 = (float)$$1.f_82480_;
                float $$4 = (float)$$1.f_82481_;
                BufferBuilder.SortState $$5 = this.f_291899_.f_291674_;
                if ($$5 == null || this.f_291899_.m_294492_(RenderType.m_110466_())) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                BufferBuilder $$6 = p_297366_.m_294384_(RenderType.m_110466_());
                RenderSection.this.m_293308_($$6);
                $$6.m_166775_($$5);
                $$6.m_277127_(VertexSorting.m_277071_($$2 - (float)RenderSection.this.f_291850_.m_123341_(), $$3 - (float)RenderSection.this.f_291850_.m_123342_(), $$4 - (float)RenderSection.this.f_291850_.m_123343_()));
                this.f_291899_.f_291674_ = $$6.m_166770_();
                BufferBuilder.RenderedBuffer $$7 = $$6.m_231175_();
                if (this.f_291175_.get()) {
                    $$7.m_231200_();
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompletionStage $$8 = SectionRenderDispatcher.this.m_292947_($$7, RenderSection.this.m_294581_(RenderType.m_110466_())).thenApply(p_297230_ -> SectionTaskResult.CANCELLED);
                return ((CompletableFuture)$$8).handle((p_301037_, p_300486_) -> {
                    if (p_300486_ != null && !(p_300486_ instanceof CancellationException) && !(p_300486_ instanceof InterruptedException)) {
                        Minecraft.m_91087_().m_231412_(CrashReport.m_127521_(p_300486_, "Rendering section"));
                    }
                    return this.f_291175_.get() ? SectionTaskResult.CANCELLED : SectionTaskResult.SUCCESSFUL;
                });
            }

            @Override
            public void m_292880_() {
                this.f_291175_.set(true);
            }
        }

        abstract class CompileTask
        implements Comparable<CompileTask> {
            protected final double f_290350_;
            protected final AtomicBoolean f_291175_ = new AtomicBoolean(false);
            protected final boolean f_290632_;

            public CompileTask(double p_300617_, boolean p_299251_) {
                this.f_290350_ = p_300617_;
                this.f_290632_ = p_299251_;
            }

            public abstract CompletableFuture<SectionTaskResult> m_294443_(SectionBufferBuilderPack var1);

            public abstract void m_292880_();

            protected abstract String m_294775_();

            @Override
            public int compareTo(CompileTask p_298947_) {
                return Doubles.compare((double)this.f_290350_, (double)p_298947_.f_290350_);
            }

            @Override
            public /* synthetic */ int compareTo(Object object) {
                return this.compareTo((CompileTask)object);
            }
        }

        class RebuildTask
        extends CompileTask {
            @Nullable
            protected RenderChunkRegion f_290484_;

            public RebuildTask(@Nullable double p_301300_, RenderChunkRegion p_300496_, boolean p_299891_) {
                super(p_301300_, p_299891_);
                this.f_290484_ = p_300496_;
            }

            @Override
            protected String m_294775_() {
                return "rend_chk_rebuild";
            }

            @Override
            public CompletableFuture<SectionTaskResult> m_294443_(SectionBufferBuilderPack p_299595_) {
                if (this.f_291175_.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.m_294718_()) {
                    this.f_290484_ = null;
                    RenderSection.this.m_292780_(false);
                    this.f_291175_.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.f_291175_.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                Vec3 $$1 = SectionRenderDispatcher.this.m_293014_();
                float $$2 = (float)$$1.f_82479_;
                float $$3 = (float)$$1.f_82480_;
                float $$4 = (float)$$1.f_82481_;
                CompileResults $$5 = this.m_293979_($$2, $$3, $$4, p_299595_);
                RenderSection.this.m_295492_($$5.f_291894_);
                if (this.f_291175_.get()) {
                    $$5.f_291255_.values().forEach(BufferBuilder.RenderedBuffer::m_231200_);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompiledSection $$6 = new CompiledSection();
                $$6.f_290920_ = $$5.f_291589_;
                $$6.f_290409_.addAll($$5.f_290796_);
                $$6.f_291674_ = $$5.f_291842_;
                ArrayList $$7 = Lists.newArrayList();
                $$5.f_291255_.forEach((p_301240_, p_299440_) -> {
                    $$7.add(SectionRenderDispatcher.this.m_292947_((BufferBuilder.RenderedBuffer)p_299440_, RenderSection.this.m_294581_((RenderType)p_301240_)));
                    p_297511_.f_290391_.add((RenderType)p_301240_);
                });
                return Util.m_143840_($$7).handle((p_297447_, p_298622_) -> {
                    if (p_298622_ != null && !(p_298622_ instanceof CancellationException) && !(p_298622_ instanceof InterruptedException)) {
                        Minecraft.m_91087_().m_231412_(CrashReport.m_127521_(p_298622_, "Rendering section"));
                    }
                    if (this.f_291175_.get()) {
                        return SectionTaskResult.CANCELLED;
                    }
                    RenderSection.this.f_290312_.set($$6);
                    RenderSection.this.f_291503_.set(0);
                    SectionRenderDispatcher.this.f_290611_.m_294499_(RenderSection.this);
                    return SectionTaskResult.SUCCESSFUL;
                });
            }

            private CompileResults m_293979_(float p_297372_, float p_300511_, float p_298415_, SectionBufferBuilderPack p_300020_) {
                CompileResults $$4 = new CompileResults();
                boolean $$5 = true;
                BlockPos $$6 = RenderSection.this.f_291850_.m_7949_();
                BlockPos $$7 = $$6.m_7918_(15, 15, 15);
                VisGraph $$8 = new VisGraph();
                RenderChunkRegion $$9 = this.f_290484_;
                this.f_290484_ = null;
                PoseStack $$10 = new PoseStack();
                if ($$9 != null) {
                    BufferBuilder $$22;
                    ModelBlockRenderer.m_111000_();
                    ReferenceArraySet $$11 = new ReferenceArraySet(RenderType.m_110506_().size());
                    RandomSource $$12 = RandomSource.m_216327_();
                    BlockRenderDispatcher $$13 = Minecraft.m_91087_().m_91289_();
                    for (BlockPos $$14 : BlockPos.m_121940_($$6, $$7)) {
                        FluidState $$17;
                        BlockEntity $$16;
                        BlockState $$15 = $$9.m_8055_($$14);
                        if ($$15.m_60804_($$9, $$14)) {
                            $$8.m_112971_($$14);
                        }
                        if ($$15.m_155947_() && ($$16 = $$9.m_7702_($$14)) != null) {
                            this.m_293240_($$4, $$16);
                        }
                        if (!($$17 = $$15.m_60819_()).m_76178_()) {
                            RenderType $$18 = ItemBlockRenderTypes.m_109287_($$17);
                            BufferBuilder $$19 = p_300020_.m_294384_($$18);
                            if ($$11.add($$18)) {
                                RenderSection.this.m_293308_($$19);
                            }
                            $$13.m_234363_($$14, $$9, $$19, $$15, $$17);
                        }
                        if ($$15.m_60799_() == RenderShape.INVISIBLE) continue;
                        RenderType $$20 = ItemBlockRenderTypes.m_109282_($$15);
                        BufferBuilder $$21 = p_300020_.m_294384_($$20);
                        if ($$11.add($$20)) {
                            RenderSection.this.m_293308_($$21);
                        }
                        $$10.m_85836_();
                        $$10.m_252880_($$14.m_123341_() & 0xF, $$14.m_123342_() & 0xF, $$14.m_123343_() & 0xF);
                        $$13.m_234355_($$15, $$14, $$9, $$10, $$21, true, $$12);
                        $$10.m_85849_();
                    }
                    if ($$11.contains(RenderType.m_110466_()) && !($$22 = p_300020_.m_294384_(RenderType.m_110466_())).m_231164_()) {
                        $$22.m_277127_(VertexSorting.m_277071_(p_297372_ - (float)$$6.m_123341_(), p_300511_ - (float)$$6.m_123342_(), p_298415_ - (float)$$6.m_123343_()));
                        $$4.f_291842_ = $$22.m_166770_();
                    }
                    for (RenderType $$23 : $$11) {
                        BufferBuilder.RenderedBuffer $$24 = p_300020_.m_294384_($$23).m_231168_();
                        if ($$24 == null) continue;
                        $$4.f_291255_.put($$23, $$24);
                    }
                    ModelBlockRenderer.m_111077_();
                }
                $$4.f_291589_ = $$8.m_112958_();
                return $$4;
            }

            private <E extends BlockEntity> void m_293240_(CompileResults p_297364_, E p_299361_) {
                BlockEntityRenderer<E> $$2 = Minecraft.m_91087_().m_167982_().m_112265_(p_299361_);
                if ($$2 != null) {
                    p_297364_.f_290796_.add(p_299361_);
                    if ($$2.m_5932_(p_299361_)) {
                        p_297364_.f_291894_.add(p_299361_);
                    }
                }
            }

            @Override
            public void m_292880_() {
                this.f_290484_ = null;
                if (this.f_291175_.compareAndSet(false, true)) {
                    RenderSection.this.m_292780_(false);
                }
            }

            static final class CompileResults {
                public final List<BlockEntity> f_291894_ = new ArrayList<BlockEntity>();
                public final List<BlockEntity> f_290796_ = new ArrayList<BlockEntity>();
                public final Map<RenderType, BufferBuilder.RenderedBuffer> f_291255_ = new Reference2ObjectArrayMap();
                public VisibilitySet f_291589_ = new VisibilitySet();
                @Nullable
                public BufferBuilder.SortState f_291842_;

                CompileResults() {
                }
            }
        }
    }

    static final class SectionTaskResult
    extends Enum<SectionTaskResult> {
        public static final /* enum */ SectionTaskResult SUCCESSFUL = new SectionTaskResult();
        public static final /* enum */ SectionTaskResult CANCELLED = new SectionTaskResult();
        private static final /* synthetic */ SectionTaskResult[] $VALUES;

        public static SectionTaskResult[] values() {
            return (SectionTaskResult[])$VALUES.clone();
        }

        public static SectionTaskResult valueOf(String p_298276_) {
            return Enum.valueOf(SectionTaskResult.class, p_298276_);
        }

        private static /* synthetic */ SectionTaskResult[] m_294124_() {
            return new SectionTaskResult[]{SUCCESSFUL, CANCELLED};
        }

        static {
            $VALUES = SectionTaskResult.m_294124_();
        }
    }

    public static class CompiledSection {
        public static final CompiledSection f_290410_ = new CompiledSection(){

            @Override
            public boolean m_293115_(Direction p_301280_, Direction p_299155_) {
                return false;
            }
        };
        final Set<RenderType> f_290391_ = new ObjectArraySet(RenderType.m_110506_().size());
        final List<BlockEntity> f_290409_ = Lists.newArrayList();
        VisibilitySet f_290920_ = new VisibilitySet();
        @Nullable
        BufferBuilder.SortState f_291674_;

        public boolean m_295467_() {
            return this.f_290391_.isEmpty();
        }

        public boolean m_294492_(RenderType p_300861_) {
            return !this.f_290391_.contains(p_300861_);
        }

        public List<BlockEntity> m_293674_() {
            return this.f_290409_;
        }

        public boolean m_293115_(Direction p_301006_, Direction p_300193_) {
            return this.f_290920_.m_112983_(p_301006_, p_300193_);
        }
    }
}

