/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.multiplayer.LegacyServerPinger;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import org.slf4j.Logger;

public class ServerStatusPinger {
    private static final Logger f_105449_ = LogUtils.getLogger();
    private static final Component f_171810_ = Component.m_237115_("multiplayer.status.cannot_connect").m_130938_(p_265659_ -> p_265659_.m_178520_(-65536));
    private final List<Connection> f_105450_ = Collections.synchronizedList(Lists.newArrayList());

    public void m_105459_(final ServerData p_105460_, final Runnable p_105461_) throws UnknownHostException {
        final ServerAddress $$2 = ServerAddress.m_171864_(p_105460_.f_105363_);
        Optional<InetSocketAddress> $$3 = ServerNameResolver.f_171881_.m_171890_($$2).map(ResolvedServerAddress::m_142641_);
        if ($$3.isEmpty()) {
            this.m_171814_(ConnectScreen.f_169260_, p_105460_);
            return;
        }
        final InetSocketAddress $$4 = $$3.get();
        final Connection $$5 = Connection.m_178300_($$4, false, null);
        this.f_105450_.add($$5);
        p_105460_.f_105365_ = Component.m_237115_("multiplayer.status.pinging");
        p_105460_.f_105366_ = -1L;
        p_105460_.f_105370_ = Collections.emptyList();
        ClientStatusPacketListener $$6 = new ClientStatusPacketListener(){
            private boolean f_105475_;
            private boolean f_105476_;
            private long f_105477_;

            @Override
            public void m_6440_(ClientboundStatusResponsePacket p_105489_) {
                if (this.f_105476_) {
                    $$5.m_129507_(Component.m_237115_("multiplayer.status.unrequested"));
                    return;
                }
                this.f_105476_ = true;
                ServerStatus $$1 = p_105489_.f_134886_();
                p_105460_.f_105365_ = $$1.f_134900_();
                $$1.f_134902_().ifPresentOrElse(p_273307_ -> {
                    p_272776_.f_105368_ = Component.m_237113_(p_273307_.f_134962_());
                    p_272776_.f_105367_ = p_273307_.f_134963_();
                }, () -> {
                    p_273651_.f_105368_ = Component.m_237115_("multiplayer.status.old");
                    p_273651_.f_105367_ = 0;
                });
                $$1.f_134901_().ifPresentOrElse(p_273230_ -> {
                    p_272779_.f_105364_ = ServerStatusPinger.m_105466_(p_273230_.f_271178_(), p_273230_.f_271503_());
                    p_272779_.f_263840_ = p_273230_;
                    if (!p_273230_.f_134919_().isEmpty()) {
                        ArrayList<Component> $$22 = new ArrayList<Component>(p_273230_.f_134919_().size());
                        for (GameProfile $$3 : p_273230_.f_134919_()) {
                            $$22.add(Component.m_237113_($$3.getName()));
                        }
                        if (p_273230_.f_134919_().size() < p_273230_.f_271178_()) {
                            $$22.add(Component.m_237110_("multiplayer.status.and_more", p_273230_.f_271178_() - p_273230_.f_134919_().size()));
                        }
                        p_272779_.f_105370_ = $$22;
                    } else {
                        p_272779_.f_105370_ = List.of();
                    }
                }, () -> {
                    p_273287_.f_105364_ = Component.m_237115_("multiplayer.status.unknown").m_130940_(ChatFormatting.DARK_GRAY);
                });
                $$1.f_134903_().ifPresent(p_272704_ -> {
                    if (!Arrays.equals(p_272704_.f_271462_(), p_105460_.m_271916_())) {
                        p_105460_.m_271813_(ServerData.m_301662_(p_272704_.f_271462_()));
                        p_105461_.run();
                    }
                });
                this.f_105477_ = Util.m_137550_();
                $$5.m_129512_(new ServerboundPingRequestPacket(this.f_105477_));
                this.f_105475_ = true;
            }

            @Override
            public void m_105486_(ClientboundPongResponsePacket p_105487_) {
                long $$1 = this.f_105477_;
                long $$22 = Util.m_137550_();
                p_105460_.f_105366_ = $$22 - $$1;
                $$5.m_129507_(Component.m_237115_("multiplayer.status.finished"));
            }

            @Override
            public void m_7026_(Component p_105485_) {
                if (!this.f_105475_) {
                    ServerStatusPinger.this.m_171814_(p_105485_, p_105460_);
                    ServerStatusPinger.this.m_171811_($$4, $$2, p_105460_);
                }
            }

            @Override
            public boolean m_6198_() {
                return $$5.m_129536_();
            }
        };
        try {
            $$5.m_292894_($$2.m_171863_(), $$2.m_171866_(), $$6);
            $$5.m_129512_(new ServerboundStatusRequestPacket());
        }
        catch (Throwable $$7) {
            f_105449_.error("Failed to ping server {}", (Object)$$2, (Object)$$7);
        }
    }

    void m_171814_(Component p_171815_, ServerData p_171816_) {
        f_105449_.error("Can't ping {}: {}", (Object)p_171816_.f_105363_, (Object)p_171815_.getString());
        p_171816_.f_105365_ = f_171810_;
        p_171816_.f_105364_ = CommonComponents.f_237098_;
    }

    void m_171811_(InetSocketAddress p_171812_, final ServerAddress p_300887_, final ServerData p_171813_) {
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)Connection.f_129462_.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_105498_) {
                try {
                    p_105498_.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                p_105498_.pipeline().addLast(new ChannelHandler[]{new LegacyServerPinger(p_300887_, (p_298744_, p_300358_, p_297298_, p_299389_, p_297985_) -> {
                    p_298695_.f_105367_ = -1;
                    p_298695_.f_105368_ = Component.m_237113_(p_300358_);
                    p_298695_.f_105365_ = Component.m_237113_(p_297298_);
                    p_298695_.f_105364_ = ServerStatusPinger.m_105466_(p_299389_, p_297985_);
                    p_298695_.f_263840_ = new ServerStatus.Players(p_297985_, p_299389_, List.of());
                })});
            }
        })).channel(NioSocketChannel.class)).connect(p_171812_.getAddress(), p_171812_.getPort());
    }

    public static Component m_105466_(int p_105467_, int p_105468_) {
        MutableComponent $$2 = Component.m_237113_(Integer.toString(p_105467_)).m_130940_(ChatFormatting.GRAY);
        MutableComponent $$3 = Component.m_237113_(Integer.toString(p_105468_)).m_130940_(ChatFormatting.GRAY);
        return Component.m_237110_("multiplayer.status.player_count", $$2, $$3).m_130940_(ChatFormatting.DARK_GRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_105453_() {
        List<Connection> list = this.f_105450_;
        synchronized (list) {
            Iterator<Connection> $$0 = this.f_105450_.iterator();
            while ($$0.hasNext()) {
                Connection $$1 = $$0.next();
                if ($$1.m_129536_()) {
                    $$1.m_129483_();
                    continue;
                }
                $$0.remove();
                $$1.m_129541_();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_105465_() {
        List<Connection> list = this.f_105450_;
        synchronized (list) {
            Iterator<Connection> $$0 = this.f_105450_.iterator();
            while ($$0.hasNext()) {
                Connection $$1 = $$0.next();
                if (!$$1.m_129536_()) continue;
                $$0.remove();
                $$1.m_129507_(Component.m_237115_("multiplayer.status.cancelled"));
            }
        }
    }
}

