/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.DebugQueryHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.DemoIntroScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerReconfigScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.multiplayer.ChunkBatchSizeCalculator;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.PingDebugMonitor;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateRenderer;
import net.minecraft.client.renderer.debug.VillageSectionsDebugRenderer;
import net.minecraft.client.renderer.debug.WorldGenAttemptRenderer;
import net.minecraft.client.resources.sounds.BeeAggressiveSoundInstance;
import net.minecraft.client.resources.sounds.BeeFlyingSoundInstance;
import net.minecraft.client.resources.sounds.GuardianAttackSoundInstance;
import net.minecraft.client.resources.sounds.MinecartSoundInstance;
import net.minecraft.client.resources.sounds.SnifferSoundInstance;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.LastSeenMessagesTracker;
import net.minecraft.network.chat.LocalChatSession;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.custom.BeeDebugPayload;
import net.minecraft.network.protocol.common.custom.BrainDebugPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameEventDebugPayload;
import net.minecraft.network.protocol.common.custom.GameEventListenerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.HiveDebugPayload;
import net.minecraft.network.protocol.common.custom.NeighborUpdatesDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiAddedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiRemovedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiTicketCountDebugPayload;
import net.minecraft.network.protocol.common.custom.RaidsDebugPayload;
import net.minecraft.network.protocol.common.custom.StructuresDebugPayload;
import net.minecraft.network.protocol.common.custom.VillageSectionsDebugPayload;
import net.minecraft.network.protocol.common.custom.WorldGenAttemptDebugPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundRecipePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Crypt;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfileKeyPair;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.slf4j.Logger;

public class ClientPacketListener
extends ClientCommonPacketListenerImpl
implements TickablePacketListener,
ClientGamePacketListener {
    private static final Logger f_104883_ = LogUtils.getLogger();
    private static final Component f_242953_ = Component.m_237115_("multiplayer.unsecureserver.toast.title");
    private static final Component f_242949_ = Component.m_237115_("multiplayer.unsecureserver.toast");
    private static final Component f_244321_ = Component.m_237115_("multiplayer.disconnect.invalid_packet");
    private static final Component f_243809_ = Component.m_237115_("multiplayer.disconnect.chat_validation_failed");
    private static final Component f_291494_ = Component.m_237115_("connect.reconfiguring");
    private static final int f_243949_ = 64;
    private final GameProfile f_104886_;
    private ClientLevel f_104889_;
    private ClientLevel.ClientLevelData f_104890_;
    private final Map<UUID, PlayerInfo> f_104892_ = Maps.newHashMap();
    private final Set<PlayerInfo> f_244156_ = new ReferenceOpenHashSet();
    private final ClientAdvancements f_104893_;
    private final ClientSuggestionProvider f_104894_;
    private final DebugQueryHandler f_104896_ = new DebugQueryHandler(this);
    private int f_104897_ = 3;
    private int f_194190_ = 3;
    private final RandomSource f_104898_ = RandomSource.m_216337_();
    private CommandDispatcher<SharedSuggestionProvider> f_104899_ = new CommandDispatcher();
    private final RecipeManager f_104900_ = new RecipeManager();
    private final UUID f_104901_ = UUID.randomUUID();
    private Set<ResourceKey<Level>> f_104902_;
    private final RegistryAccess.Frozen f_104903_;
    private final FeatureFlagSet f_244039_;
    @Nullable
    private LocalChatSession f_252517_;
    private SignedMessageChain.Encoder f_240902_ = SignedMessageChain.Encoder.f_243849_;
    private LastSeenMessagesTracker f_244346_ = new LastSeenMessagesTracker(20);
    private MessageSignatureCache f_244113_ = MessageSignatureCache.m_246587_();
    private final ChunkBatchSizeCalculator f_291253_ = new ChunkBatchSizeCalculator();
    private final PingDebugMonitor f_290671_;
    private boolean f_291332_ = false;
    private volatile boolean f_291533_;

    public ClientPacketListener(Minecraft p_253924_, Connection p_253614_, CommonListenerCookie p_298329_) {
        super(p_253924_, p_253614_, p_298329_);
        this.f_104886_ = p_298329_.f_291743_();
        this.f_104903_ = p_298329_.f_291549_();
        this.f_244039_ = p_298329_.f_290859_();
        this.f_104893_ = new ClientAdvancements(p_253924_, this.f_291019_);
        this.f_104894_ = new ClientSuggestionProvider(this, p_253924_);
        this.f_290671_ = new PingDebugMonitor(this, p_253924_.m_293199_().m_294664_());
    }

    public ClientSuggestionProvider m_105137_() {
        return this.f_104894_;
    }

    public void m_261044_() {
        this.f_291533_ = true;
        this.f_104889_ = null;
        this.f_291019_.m_261027_();
    }

    public RecipeManager m_105141_() {
        return this.f_104900_;
    }

    @Override
    public void m_5998_(ClientboundLoginPacket p_105030_) {
        ClientLevel.ClientLevelData $$7;
        PacketUtils.m_131363_(p_105030_, this, this.f_291812_);
        this.m_295411_();
        this.f_291812_.f_91072_ = new MultiPlayerGameMode(this.f_291812_, this);
        CommonPlayerSpawnInfo $$1 = p_105030_.f_291078_();
        ArrayList $$2 = Lists.newArrayList(p_105030_.f_132365_());
        Collections.shuffle($$2);
        this.f_104902_ = Sets.newLinkedHashSet((Iterable)$$2);
        ResourceKey<Level> $$3 = $$1.f_290731_();
        Holder.Reference<DimensionType> $$4 = this.f_104903_.m_175515_(Registries.f_256787_).m_246971_($$1.f_291865_());
        this.f_104897_ = p_105030_.f_132370_();
        this.f_194190_ = p_105030_.f_195761_();
        boolean $$5 = $$1.f_290330_();
        boolean $$6 = $$1.f_290486_();
        this.f_104890_ = $$7 = new ClientLevel.ClientLevelData(Difficulty.NORMAL, p_105030_.f_132362_(), $$6);
        this.f_104889_ = new ClientLevel(this, $$7, $$3, $$4, this.f_104897_, this.f_194190_, this.f_291812_::m_91307_, this.f_291812_.f_91060_, $$5, $$1.f_290589_());
        this.f_291812_.m_91156_(this.f_104889_);
        if (this.f_291812_.f_91074_ == null) {
            this.f_291812_.f_91074_ = this.f_291812_.f_91072_.m_105246_(this.f_104889_, new StatsCounter(), new ClientRecipeBook());
            this.f_291812_.f_91074_.m_146922_(-180.0f);
            if (this.f_291812_.m_91092_() != null) {
                this.f_291812_.m_91092_().m_120046_(this.f_291812_.f_91074_.m_20148_());
            }
        }
        this.f_291812_.f_91064_.m_113434_();
        this.f_291812_.f_91074_.m_172530_();
        this.f_291812_.f_91074_.m_20234_(p_105030_.f_132360_());
        this.f_104889_.m_104739_(this.f_291812_.f_91074_);
        this.f_291812_.f_91074_.f_108618_ = new KeyboardInput(this.f_291812_.f_91066_);
        this.f_291812_.f_91072_.m_105221_(this.f_291812_.f_91074_);
        this.f_291812_.f_91075_ = this.f_291812_.f_91074_;
        this.f_291812_.m_91152_(new ReceivingLevelScreen());
        this.f_291812_.f_91074_.m_36393_(p_105030_.f_132371_());
        this.f_291812_.f_91074_.m_108711_(p_105030_.f_132372_());
        this.f_291812_.f_91074_.m_294300_(p_105030_.f_291478_());
        this.f_291812_.f_91074_.m_219749_($$1.f_290601_());
        this.f_291812_.f_91074_.m_287199_($$1.f_291470_());
        this.f_291812_.f_91072_.m_171805_($$1.f_291098_(), $$1.f_290730_());
        this.f_291812_.f_91066_.m_193770_(p_105030_.f_132370_());
        this.f_252517_ = null;
        this.f_244346_ = new LastSeenMessagesTracker(20);
        this.f_244113_ = MessageSignatureCache.m_246587_();
        if (this.f_290549_.m_129535_()) {
            this.f_291812_.m_231465_().m_252904_().thenAcceptAsync(p_253341_ -> p_253341_.ifPresent(this::m_260951_), (Executor)this.f_291812_);
        }
        this.f_291019_.m_260888_($$1.f_291098_(), p_105030_.f_132362_());
        this.f_291812_.m_278644_().m_278768_(this.f_291812_);
    }

    @Override
    public void m_6771_(ClientboundAddEntityPacket p_104958_) {
        PacketUtils.m_131363_(p_104958_, this, this.f_291812_);
        Entity $$1 = this.m_301496_(p_104958_);
        if ($$1 != null) {
            $$1.m_141965_(p_104958_);
            this.f_104889_.m_104739_($$1);
            this.m_233663_($$1);
        } else {
            f_104883_.warn("Skipping Entity with id {}", p_104958_.m_131508_());
        }
    }

    @Nullable
    private Entity m_301496_(ClientboundAddEntityPacket p_301611_) {
        EntityType<?> $$1 = p_301611_.m_131508_();
        if ($$1 == EntityType.f_20532_) {
            PlayerInfo $$2 = this.m_104949_(p_301611_.m_131499_());
            if ($$2 == null) {
                f_104883_.warn("Server attempted to add player prior to sending player info (Player id {})", (Object)p_301611_.m_131499_());
                return null;
            }
            return new RemotePlayer(this.f_104889_, $$2.m_105312_());
        }
        return $$1.m_20615_(this.f_104889_);
    }

    private void m_233663_(Entity p_233664_) {
        if (p_233664_ instanceof AbstractMinecart) {
            AbstractMinecart $$1 = (AbstractMinecart)p_233664_;
            this.f_291812_.m_91106_().m_120367_(new MinecartSoundInstance($$1));
        } else if (p_233664_ instanceof Bee) {
            BeeFlyingSoundInstance $$5;
            Bee $$2 = (Bee)p_233664_;
            boolean $$3 = $$2.m_21660_();
            if ($$3) {
                BeeAggressiveSoundInstance $$4 = new BeeAggressiveSoundInstance($$2);
            } else {
                $$5 = new BeeFlyingSoundInstance($$2);
            }
            this.f_291812_.m_91106_().m_120372_($$5);
        }
    }

    @Override
    public void m_7708_(ClientboundAddExperienceOrbPacket p_104960_) {
        PacketUtils.m_131363_(p_104960_, this, this.f_291812_);
        double $$1 = p_104960_.m_131527_();
        double $$2 = p_104960_.m_131528_();
        double $$3 = p_104960_.m_131529_();
        ExperienceOrb $$4 = new ExperienceOrb(this.f_104889_, $$1, $$2, $$3, p_104960_.m_131530_());
        $$4.m_217006_($$1, $$2, $$3);
        $$4.m_146922_(0.0f);
        $$4.m_146926_(0.0f);
        $$4.m_20234_(p_104960_.m_131524_());
        this.f_104889_.m_104739_($$4);
    }

    @Override
    public void m_8048_(ClientboundSetEntityMotionPacket p_105092_) {
        PacketUtils.m_131363_(p_105092_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105092_.m_133192_());
        if ($$1 == null) {
            return;
        }
        $$1.m_6001_((double)p_105092_.m_133195_() / 8000.0, (double)p_105092_.m_133196_() / 8000.0, (double)p_105092_.m_133197_() / 8000.0);
    }

    @Override
    public void m_6455_(ClientboundSetEntityDataPacket p_105088_) {
        PacketUtils.m_131363_(p_105088_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105088_.f_133143_());
        if ($$1 != null) {
            $$1.m_20088_().m_135356_(p_105088_.f_133144_());
        }
    }

    @Override
    public void m_6435_(ClientboundTeleportEntityPacket p_105124_) {
        PacketUtils.m_131363_(p_105124_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105124_.m_133545_());
        if ($$1 == null) {
            return;
        }
        double $$2 = p_105124_.m_133548_();
        double $$3 = p_105124_.m_133549_();
        double $$4 = p_105124_.m_133550_();
        $$1.m_217006_($$2, $$3, $$4);
        if (!$$1.m_6109_()) {
            float $$5 = (float)(p_105124_.m_133551_() * 360) / 256.0f;
            float $$6 = (float)(p_105124_.m_133552_() * 360) / 256.0f;
            $$1.m_6453_($$2, $$3, $$4, $$5, $$6, 3);
            $$1.m_6853_(p_105124_.m_133553_());
        }
    }

    @Override
    public void m_5612_(ClientboundSetCarriedItemPacket p_105078_) {
        PacketUtils.m_131363_(p_105078_, this, this.f_291812_);
        if (Inventory.m_36045_(p_105078_.m_133079_())) {
            this.f_291812_.f_91074_.m_150109_().f_35977_ = p_105078_.m_133079_();
        }
    }

    @Override
    public void m_7865_(ClientboundMoveEntityPacket p_105036_) {
        PacketUtils.m_131363_(p_105036_, this, this.f_291812_);
        Entity $$1 = p_105036_.m_132519_(this.f_104889_);
        if ($$1 == null) {
            return;
        }
        if (!$$1.m_6109_()) {
            if (p_105036_.m_132534_()) {
                VecDeltaCodec $$2 = $$1.m_217001_();
                Vec3 $$3 = $$2.m_238021_(p_105036_.m_178997_(), p_105036_.m_178998_(), p_105036_.m_178999_());
                $$2.m_238033_($$3);
                float $$4 = p_105036_.m_132533_() ? (float)(p_105036_.m_132531_() * 360) / 256.0f : $$1.m_293582_();
                float $$5 = p_105036_.m_132533_() ? (float)(p_105036_.m_132532_() * 360) / 256.0f : $$1.m_293123_();
                $$1.m_6453_($$3.m_7096_(), $$3.m_7098_(), $$3.m_7094_(), $$4, $$5, 3);
            } else if (p_105036_.m_132533_()) {
                float $$6 = (float)(p_105036_.m_132531_() * 360) / 256.0f;
                float $$7 = (float)(p_105036_.m_132532_() * 360) / 256.0f;
                $$1.m_6453_($$1.m_293268_(), $$1.m_293950_(), $$1.m_292720_(), $$6, $$7, 3);
            }
            $$1.m_6853_(p_105036_.m_132535_());
        }
    }

    @Override
    public void m_6176_(ClientboundRotateHeadPacket p_105068_) {
        PacketUtils.m_131363_(p_105068_, this, this.f_291812_);
        Entity $$1 = p_105068_.m_132969_(this.f_104889_);
        if ($$1 == null) {
            return;
        }
        float $$2 = (float)(p_105068_.m_132977_() * 360) / 256.0f;
        $$1.m_6541_($$2, 3);
    }

    @Override
    public void m_182047_(ClientboundRemoveEntitiesPacket p_182633_) {
        PacketUtils.m_131363_(p_182633_, this, this.f_291812_);
        p_182633_.m_182730_().forEach(p_205521_ -> this.f_104889_.m_171642_(p_205521_, Entity.RemovalReason.DISCARDED));
    }

    @Override
    public void m_5682_(ClientboundPlayerPositionPacket p_105056_) {
        double $$17;
        double $$16;
        double $$13;
        double $$12;
        double $$9;
        double $$8;
        PacketUtils.m_131363_(p_105056_, this, this.f_291812_);
        LocalPlayer $$1 = this.f_291812_.f_91074_;
        Vec3 $$2 = $$1.m_20184_();
        boolean $$3 = p_105056_.m_132826_().contains((Object)RelativeMovement.X);
        boolean $$4 = p_105056_.m_132826_().contains((Object)RelativeMovement.Y);
        boolean $$5 = p_105056_.m_132826_().contains((Object)RelativeMovement.Z);
        if ($$3) {
            double $$6 = $$2.m_7096_();
            double $$7 = $$1.m_20185_() + p_105056_.m_132818_();
            $$1.f_19790_ += p_105056_.m_132818_();
            $$1.f_19854_ += p_105056_.m_132818_();
        } else {
            $$8 = 0.0;
            $$1.f_19790_ = $$9 = p_105056_.m_132818_();
            $$1.f_19854_ = $$9;
        }
        if ($$4) {
            double $$10 = $$2.m_7098_();
            double $$11 = $$1.m_20186_() + p_105056_.m_132821_();
            $$1.f_19791_ += p_105056_.m_132821_();
            $$1.f_19855_ += p_105056_.m_132821_();
        } else {
            $$12 = 0.0;
            $$1.f_19791_ = $$13 = p_105056_.m_132821_();
            $$1.f_19855_ = $$13;
        }
        if ($$5) {
            double $$14 = $$2.m_7094_();
            double $$15 = $$1.m_20189_() + p_105056_.m_132822_();
            $$1.f_19792_ += p_105056_.m_132822_();
            $$1.f_19856_ += p_105056_.m_132822_();
        } else {
            $$16 = 0.0;
            $$1.f_19792_ = $$17 = p_105056_.m_132822_();
            $$1.f_19856_ = $$17;
        }
        $$1.m_6034_($$9, $$13, $$17);
        $$1.m_20334_($$8, $$12, $$16);
        float $$18 = p_105056_.m_132823_();
        float $$19 = p_105056_.m_132824_();
        if (p_105056_.m_132826_().contains((Object)RelativeMovement.X_ROT)) {
            $$1.m_146926_($$1.m_146909_() + $$19);
            $$1.f_19860_ += $$19;
        } else {
            $$1.m_146926_($$19);
            $$1.f_19860_ = $$19;
        }
        if (p_105056_.m_132826_().contains((Object)RelativeMovement.Y_ROT)) {
            $$1.m_146922_($$1.m_146908_() + $$18);
            $$1.f_19859_ += $$18;
        } else {
            $$1.m_146922_($$18);
            $$1.f_19859_ = $$18;
        }
        this.f_290549_.m_129512_(new ServerboundAcceptTeleportationPacket(p_105056_.m_132825_()));
        this.f_290549_.m_129512_(new ServerboundMovePlayerPacket.PosRot($$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), $$1.m_146908_(), $$1.m_146909_(), false));
    }

    @Override
    public void m_5771_(ClientboundSectionBlocksUpdatePacket p_105070_) {
        PacketUtils.m_131363_(p_105070_, this, this.f_291812_);
        p_105070_.m_132992_((p_284633_, p_284634_) -> this.f_104889_.m_233653_((BlockPos)p_284633_, (BlockState)p_284634_, 19));
    }

    @Override
    public void m_183388_(ClientboundLevelChunkWithLightPacket p_194241_) {
        PacketUtils.m_131363_(p_194241_, this, this.f_291812_);
        int $$1 = p_194241_.m_195717_();
        int $$2 = p_194241_.m_195718_();
        this.m_194198_($$1, $$2, p_194241_.m_195719_());
        ClientboundLightUpdatePacketData $$3 = p_194241_.m_195720_();
        this.f_104889_.m_194171_(() -> {
            this.m_194248_($$1, $$2, $$3);
            LevelChunk $$3 = this.f_104889_.m_7726_().m_62227_($$1, $$2, false);
            if ($$3 != null) {
                this.m_194212_($$3, $$1, $$2);
            }
        });
    }

    @Override
    public void m_274374_(ClientboundChunksBiomesPacket p_275437_) {
        PacketUtils.m_131363_(p_275437_, this, this.f_291812_);
        for (ClientboundChunksBiomesPacket.ChunkBiomeData $$1 : p_275437_.f_273816_()) {
            this.f_104889_.m_7726_().m_274444_($$1.f_273927_().f_45578_, $$1.f_273927_().f_45579_, $$1.m_274543_());
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData $$2 : p_275437_.f_273816_()) {
            this.f_104889_.m_171649_(new ChunkPos($$2.f_273927_().f_45578_, $$2.f_273927_().f_45579_));
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData $$3 : p_275437_.f_273816_()) {
            for (int $$4 = -1; $$4 <= 1; ++$$4) {
                for (int $$5 = -1; $$5 <= 1; ++$$5) {
                    for (int $$6 = this.f_104889_.m_151560_(); $$6 < this.f_104889_.m_151561_(); ++$$6) {
                        this.f_291812_.f_91060_.m_109770_($$3.f_273927_().f_45578_ + $$4, $$6, $$3.f_273927_().f_45579_ + $$5);
                    }
                }
            }
        }
    }

    private void m_194198_(int p_194199_, int p_194200_, ClientboundLevelChunkPacketData p_194201_) {
        this.f_104889_.m_7726_().m_194116_(p_194199_, p_194200_, p_194201_.m_195656_(), p_194201_.m_195678_(), p_194201_.m_195657_(p_194199_, p_194200_));
    }

    private void m_194212_(LevelChunk p_194213_, int p_194214_, int p_194215_) {
        LevelLightEngine $$3 = this.f_104889_.m_7726_().m_7827_();
        LevelChunkSection[] $$4 = p_194213_.m_7103_();
        ChunkPos $$5 = p_194213_.m_7697_();
        for (int $$6 = 0; $$6 < $$4.length; ++$$6) {
            LevelChunkSection $$7 = $$4[$$6];
            int $$8 = this.f_104889_.m_151568_($$6);
            $$3.m_6191_(SectionPos.m_123196_($$5, $$8), $$7.m_188008_());
            this.f_104889_.m_104793_(p_194214_, $$8, p_194215_);
        }
    }

    @Override
    public void m_5729_(ClientboundForgetLevelChunkPacket p_105014_) {
        PacketUtils.m_131363_(p_105014_, this, this.f_291812_);
        this.f_104889_.m_7726_().m_104455_(p_105014_.f_290761_());
        this.m_194252_(p_105014_);
    }

    private void m_194252_(ClientboundForgetLevelChunkPacket p_194253_) {
        ChunkPos $$1 = p_194253_.f_290761_();
        this.f_104889_.m_194171_(() -> {
            LevelLightEngine $$1 = this.f_104889_.m_5518_();
            $$1.m_9335_($$1, false);
            for (int $$2 = $$1.m_164447_(); $$2 < $$1.m_164448_(); ++$$2) {
                SectionPos $$3 = SectionPos.m_123196_($$1, $$2);
                $$1.m_284126_(LightLayer.BLOCK, $$3, null);
                $$1.m_284126_(LightLayer.SKY, $$3, null);
            }
            for (int $$4 = this.f_104889_.m_151560_(); $$4 < this.f_104889_.m_151561_(); ++$$4) {
                $$1.m_6191_(SectionPos.m_123196_($$1, $$4), true);
            }
        });
    }

    @Override
    public void m_6773_(ClientboundBlockUpdatePacket p_104980_) {
        PacketUtils.m_131363_(p_104980_, this, this.f_291812_);
        this.f_104889_.m_233653_(p_104980_.m_131749_(), p_104980_.m_131746_(), 19);
    }

    @Override
    public void m_292634_(ClientboundStartConfigurationPacket p_298839_) {
        this.f_290549_.m_294044_();
        PacketUtils.m_131363_(p_298839_, this, this.f_291812_);
        this.f_291812_.m_294188_(new ServerReconfigScreen(f_291494_, this.f_290549_));
        this.f_290549_.m_129505_(new ClientConfigurationPacketListenerImpl(this.f_291812_, this.f_290549_, new CommonListenerCookie(this.f_104886_, this.f_291019_, this.f_104903_, this.f_244039_, this.f_291180_, this.f_291024_, this.f_291028_)));
        this.f_290549_.m_294304_();
        this.m_295327_(new ServerboundConfigurationAcknowledgedPacket());
    }

    @Override
    public void m_8001_(ClientboundTakeItemEntityPacket p_105122_) {
        PacketUtils.m_131363_(p_105122_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105122_.m_133524_());
        LivingEntity $$2 = (LivingEntity)this.f_104889_.m_6815_(p_105122_.m_133527_());
        if ($$2 == null) {
            $$2 = this.f_291812_.f_91074_;
        }
        if ($$1 != null) {
            if ($$1 instanceof ExperienceOrb) {
                this.f_104889_.m_7785_($$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (this.f_104898_.m_188501_() - this.f_104898_.m_188501_()) * 0.35f + 0.9f, false);
            } else {
                this.f_104889_.m_7785_($$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (this.f_104898_.m_188501_() - this.f_104898_.m_188501_()) * 1.4f + 2.0f, false);
            }
            this.f_291812_.f_91061_.m_107344_(new ItemPickupParticle(this.f_291812_.m_91290_(), this.f_291812_.m_91269_(), this.f_104889_, $$1, $$2));
            if ($$1 instanceof ItemEntity) {
                ItemEntity $$3 = (ItemEntity)$$1;
                ItemStack $$4 = $$3.m_32055_();
                if (!$$4.m_41619_()) {
                    $$4.m_41774_(p_105122_.m_133528_());
                }
                if ($$4.m_41619_()) {
                    this.f_104889_.m_171642_(p_105122_.m_133524_(), Entity.RemovalReason.DISCARDED);
                }
            } else if (!($$1 instanceof ExperienceOrb)) {
                this.f_104889_.m_171642_(p_105122_.m_133524_(), Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public void m_213990_(ClientboundSystemChatPacket p_233708_) {
        PacketUtils.m_131363_(p_233708_, this, this.f_291812_);
        this.f_291812_.m_240442_().m_240494_(p_233708_.f_237849_(), p_233708_.f_240374_());
    }

    @Override
    public void m_213629_(ClientboundPlayerChatPacket p_233702_) {
        SignedMessageLink $$7;
        PacketUtils.m_131363_(p_233702_, this, this.f_291812_);
        Optional<SignedMessageBody> $$1 = p_233702_.f_244090_().m_252762_(this.f_244113_);
        Optional<ChatType.Bound> $$2 = p_233702_.f_240897_().m_242652_(this.f_104903_);
        if ($$1.isEmpty() || $$2.isEmpty()) {
            this.f_290549_.m_129507_(f_244321_);
            return;
        }
        UUID $$3 = p_233702_.f_243918_();
        PlayerInfo $$4 = this.m_104949_($$3);
        if ($$4 == null) {
            f_104883_.error("Received player chat packet for unknown player with ID: {}", (Object)$$3);
            this.f_290549_.m_129507_(f_243809_);
            return;
        }
        RemoteChatSession $$5 = $$4.m_247593_();
        if ($$5 != null) {
            SignedMessageLink $$6 = new SignedMessageLink(p_233702_.f_244283_(), $$3, $$5.f_244448_());
        } else {
            $$7 = SignedMessageLink.m_245187_($$3);
        }
        PlayerChatMessage $$8 = new PlayerChatMessage($$7, p_233702_.f_243836_(), $$1.get(), p_233702_.f_243686_(), p_233702_.f_243744_());
        if (!$$4.m_241043_().m_241126_($$8)) {
            this.f_291812_.m_240442_().m_294071_($$3, $$2.get());
            return;
        }
        this.f_291812_.m_240442_().m_247425_($$8, $$4.m_105312_(), $$2.get());
        this.f_244113_.m_247208_($$8);
    }

    @Override
    public void m_7039_(ClientboundDisguisedChatPacket p_251920_) {
        PacketUtils.m_131363_(p_251920_, this, this.f_291812_);
        Optional<ChatType.Bound> $$1 = p_251920_.f_244252_().m_242652_(this.f_104903_);
        if ($$1.isEmpty()) {
            this.f_290549_.m_129507_(f_244321_);
            return;
        }
        this.f_291812_.m_240442_().m_245141_(p_251920_.f_244491_(), $$1.get());
    }

    @Override
    public void m_241037_(ClientboundDeleteChatPacket p_241325_) {
        PacketUtils.m_131363_(p_241325_, this, this.f_291812_);
        Optional<MessageSignature> $$1 = p_241325_.f_240904_().m_253223_(this.f_244113_);
        if ($$1.isEmpty()) {
            this.f_290549_.m_129507_(f_244321_);
            return;
        }
        this.f_244346_.m_246067_($$1.get());
        if (!this.f_291812_.m_240442_().m_240956_($$1.get())) {
            this.f_291812_.f_91065_.m_93076_().m_240953_($$1.get());
        }
    }

    @Override
    public void m_7791_(ClientboundAnimatePacket p_104968_) {
        PacketUtils.m_131363_(p_104968_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_104968_.m_131624_());
        if ($$1 == null) {
            return;
        }
        if (p_104968_.m_131627_() == 0) {
            LivingEntity $$2 = (LivingEntity)$$1;
            $$2.m_6674_(InteractionHand.MAIN_HAND);
        } else if (p_104968_.m_131627_() == 3) {
            LivingEntity $$3 = (LivingEntity)$$1;
            $$3.m_6674_(InteractionHand.OFF_HAND);
        } else if (p_104968_.m_131627_() == 2) {
            Player $$4 = (Player)$$1;
            $$4.m_6145_(false, false);
        } else if (p_104968_.m_131627_() == 4) {
            this.f_291812_.f_91061_.m_107329_($$1, ParticleTypes.f_123797_);
        } else if (p_104968_.m_131627_() == 5) {
            this.f_291812_.f_91061_.m_107329_($$1, ParticleTypes.f_123808_);
        }
    }

    @Override
    public void m_264143_(ClientboundHurtAnimationPacket p_265581_) {
        PacketUtils.m_131363_(p_265581_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_265581_.f_263825_());
        if ($$1 == null) {
            return;
        }
        $$1.m_6053_(p_265581_.f_263826_());
    }

    @Override
    public void m_7885_(ClientboundSetTimePacket p_105108_) {
        PacketUtils.m_131363_(p_105108_, this, this.f_291812_);
        this.f_291812_.f_91073_.m_104637_(p_105108_.m_133358_());
        this.f_291812_.f_91073_.m_104746_(p_105108_.m_133361_());
        this.f_291019_.m_261206_(p_105108_.m_133358_());
    }

    @Override
    public void m_6571_(ClientboundSetDefaultSpawnPositionPacket p_105084_) {
        PacketUtils.m_131363_(p_105084_, this, this.f_291812_);
        this.f_291812_.f_91073_.m_104752_(p_105084_.m_133123_(), p_105084_.m_133126_());
        Screen screen = this.f_291812_.f_91080_;
        if (screen instanceof ReceivingLevelScreen) {
            ReceivingLevelScreen $$1 = (ReceivingLevelScreen)screen;
            $$1.m_202375_();
        }
    }

    @Override
    public void m_6403_(ClientboundSetPassengersPacket p_105102_) {
        PacketUtils.m_131363_(p_105102_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105102_.m_133286_());
        if ($$1 == null) {
            f_104883_.warn("Received passengers for unknown entity");
            return;
        }
        boolean $$2 = $$1.m_20367_(this.f_291812_.f_91074_);
        $$1.m_20153_();
        for (int $$3 : p_105102_.m_133283_()) {
            Entity $$4 = this.f_104889_.m_6815_($$3);
            if ($$4 == null) continue;
            $$4.m_7998_($$1, true);
            if ($$4 != this.f_291812_.f_91074_ || $$2) continue;
            if ($$1 instanceof Boat) {
                this.f_291812_.f_91074_.f_19859_ = $$1.m_146908_();
                this.f_291812_.f_91074_.m_146922_($$1.m_146908_());
                this.f_291812_.f_91074_.m_5616_($$1.m_146908_());
            }
            MutableComponent $$5 = Component.m_237110_("mount.onboard", this.f_291812_.f_91066_.f_92090_.m_90863_());
            this.f_291812_.f_91065_.m_93063_($$5, false);
            this.f_291812_.m_240477_().m_168785_($$5);
        }
    }

    @Override
    public void m_5599_(ClientboundSetEntityLinkPacket p_105090_) {
        PacketUtils.m_131363_(p_105090_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105090_.m_133172_());
        if ($$1 instanceof Mob) {
            ((Mob)$$1).m_21506_(p_105090_.m_133175_());
        }
    }

    private static ItemStack m_104927_(Player p_104928_) {
        for (InteractionHand $$1 : InteractionHand.values()) {
            ItemStack $$2 = p_104928_.m_21120_($$1);
            if (!$$2.m_150930_(Items.f_42747_)) continue;
            return $$2;
        }
        return new ItemStack(Items.f_42747_);
    }

    @Override
    public void m_7628_(ClientboundEntityEventPacket p_105010_) {
        PacketUtils.m_131363_(p_105010_, this, this.f_291812_);
        Entity $$1 = p_105010_.m_132094_(this.f_104889_);
        if ($$1 != null) {
            switch (p_105010_.m_132102_()) {
                case 63: {
                    this.f_291812_.m_91106_().m_120367_(new SnifferSoundInstance((Sniffer)$$1));
                    break;
                }
                case 21: {
                    this.f_291812_.m_91106_().m_120367_(new GuardianAttackSoundInstance((Guardian)$$1));
                    break;
                }
                case 35: {
                    int $$2 = 40;
                    this.f_291812_.f_91061_.m_107332_($$1, ParticleTypes.f_123767_, 30);
                    this.f_104889_.m_7785_($$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), SoundEvents.f_12513_, $$1.m_5720_(), 1.0f, 1.0f, false);
                    if ($$1 != this.f_291812_.f_91074_) break;
                    this.f_291812_.f_91063_.m_109113_(ClientPacketListener.m_104927_(this.f_291812_.f_91074_));
                    break;
                }
                default: {
                    $$1.m_7822_(p_105010_.m_132102_());
                }
            }
        }
    }

    @Override
    public void m_269082_(ClientboundDamageEventPacket p_270800_) {
        PacketUtils.m_131363_(p_270800_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_270800_.f_268504_());
        if ($$1 == null) {
            return;
        }
        $$1.m_269138_(p_270800_.m_269591_(this.f_104889_));
    }

    @Override
    public void m_5547_(ClientboundSetHealthPacket p_105098_) {
        PacketUtils.m_131363_(p_105098_, this, this.f_291812_);
        this.f_291812_.f_91074_.m_108760_(p_105098_.m_133247_());
        this.f_291812_.f_91074_.m_36324_().m_38705_(p_105098_.m_133250_());
        this.f_291812_.f_91074_.m_36324_().m_38717_(p_105098_.m_133251_());
    }

    @Override
    public void m_6747_(ClientboundSetExperiencePacket p_105096_) {
        PacketUtils.m_131363_(p_105096_, this, this.f_291812_);
        this.f_291812_.f_91074_.m_108644_(p_105096_.m_133228_(), p_105096_.m_133231_(), p_105096_.m_133232_());
    }

    @Override
    public void m_7992_(ClientboundRespawnPacket p_105066_) {
        List<SynchedEntityData.DataValue<?>> $$12;
        LocalPlayer $$11;
        PacketUtils.m_131363_(p_105066_, this, this.f_291812_);
        CommonPlayerSpawnInfo $$1 = p_105066_.f_290899_();
        ResourceKey<Level> $$2 = $$1.f_290731_();
        Holder.Reference<DimensionType> $$3 = this.f_104903_.m_175515_(Registries.f_256787_).m_246971_($$1.f_291865_());
        LocalPlayer $$4 = this.f_291812_.f_91074_;
        if ($$2 != $$4.m_9236_().m_46472_()) {
            ClientLevel.ClientLevelData $$9;
            Scoreboard $$5 = this.f_104889_.m_6188_();
            Map<String, MapItemSavedData> $$6 = this.f_104889_.m_171684_();
            boolean $$7 = $$1.f_290330_();
            boolean $$8 = $$1.f_290486_();
            this.f_104890_ = $$9 = new ClientLevel.ClientLevelData(this.f_104890_.m_5472_(), this.f_104890_.m_5466_(), $$8);
            this.f_104889_ = new ClientLevel(this, $$9, $$2, $$3, this.f_104897_, this.f_194190_, this.f_291812_::m_91307_, this.f_291812_.f_91060_, $$7, $$1.f_290589_());
            this.f_104889_.m_104669_($$5);
            this.f_104889_.m_171672_($$6);
            this.f_291812_.m_91156_(this.f_104889_);
            this.f_291812_.m_91152_(new ReceivingLevelScreen());
        }
        this.f_291812_.f_91075_ = null;
        if ($$4.m_242612_()) {
            $$4.m_6915_();
        }
        if (p_105066_.m_263558_((byte)2)) {
            LocalPlayer $$10 = this.f_291812_.f_91072_.m_105250_(this.f_104889_, $$4.m_108630_(), $$4.m_108631_(), $$4.m_6144_(), $$4.m_20142_());
        } else {
            $$11 = this.f_291812_.f_91072_.m_105246_(this.f_104889_, $$4.m_108630_(), $$4.m_108631_());
        }
        $$11.m_20234_($$4.m_19879_());
        this.f_291812_.f_91074_ = $$11;
        if ($$2 != $$4.m_9236_().m_46472_()) {
            this.f_291812_.m_91397_().m_120186_();
        }
        this.f_291812_.f_91075_ = $$11;
        if (p_105066_.m_263558_((byte)2) && ($$12 = $$4.m_20088_().m_252804_()) != null) {
            $$11.m_20088_().m_135356_($$12);
        }
        if (p_105066_.m_263558_((byte)1)) {
            $$11.m_21204_().m_22159_($$4.m_21204_());
        }
        $$11.m_172530_();
        this.f_104889_.m_104739_($$11);
        $$11.m_146922_(-180.0f);
        $$11.f_108618_ = new KeyboardInput(this.f_291812_.f_91066_);
        this.f_291812_.f_91072_.m_105221_($$11);
        $$11.m_36393_($$4.m_36330_());
        $$11.m_108711_($$4.m_108632_());
        $$11.m_219749_($$1.f_290601_());
        $$11.m_287199_($$1.f_291470_());
        $$11.f_108589_ = $$4.f_108589_;
        $$11.f_108590_ = $$4.f_108590_;
        if (this.f_291812_.f_91080_ instanceof DeathScreen || this.f_291812_.f_91080_ instanceof DeathScreen.TitleConfirmScreen) {
            this.f_291812_.m_91152_(null);
        }
        this.f_291812_.f_91072_.m_171805_($$1.f_291098_(), $$1.f_290730_());
    }

    @Override
    public void m_7345_(ClientboundExplodePacket p_105012_) {
        PacketUtils.m_131363_(p_105012_, this, this.f_291812_);
        Explosion $$1 = new Explosion(this.f_291812_.f_91073_, null, p_105012_.m_132132_(), p_105012_.m_132133_(), p_105012_.m_132134_(), p_105012_.m_132135_(), p_105012_.m_132136_());
        $$1.m_46075_(true);
        this.f_291812_.f_91074_.m_20256_(this.f_291812_.f_91074_.m_20184_().m_82520_(p_105012_.m_132127_(), p_105012_.m_132130_(), p_105012_.m_132131_()));
    }

    @Override
    public void m_6905_(ClientboundHorseScreenOpenPacket p_105018_) {
        PacketUtils.m_131363_(p_105018_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105018_.m_132208_());
        if ($$1 instanceof AbstractHorse) {
            AbstractHorse $$2 = (AbstractHorse)$$1;
            LocalPlayer $$3 = this.f_291812_.f_91074_;
            SimpleContainer $$4 = new SimpleContainer(p_105018_.m_132207_());
            HorseInventoryMenu $$5 = new HorseInventoryMenu(p_105018_.m_132204_(), $$3.m_150109_(), $$4, $$2);
            $$3.f_36096_ = $$5;
            this.f_291812_.m_91152_(new HorseInventoryScreen($$5, $$3.m_150109_(), $$2));
        }
    }

    @Override
    public void m_5980_(ClientboundOpenScreenPacket p_105042_) {
        PacketUtils.m_131363_(p_105042_, this, this.f_291812_);
        MenuScreens.m_96201_(p_105042_.m_132628_(), this.f_291812_, p_105042_.m_132625_(), p_105042_.m_132629_());
    }

    @Override
    public void m_5735_(ClientboundContainerSetSlotPacket p_105000_) {
        PacketUtils.m_131363_(p_105000_, this, this.f_291812_);
        LocalPlayer $$1 = this.f_291812_.f_91074_;
        ItemStack $$2 = p_105000_.m_131995_();
        int $$3 = p_105000_.m_131994_();
        this.f_291812_.m_91301_().m_120568_($$2);
        if (p_105000_.m_131991_() == -1) {
            if (!(this.f_291812_.f_91080_ instanceof CreativeModeInventoryScreen)) {
                $$1.f_36096_.m_142503_($$2);
            }
        } else if (p_105000_.m_131991_() == -2) {
            $$1.m_150109_().m_6836_($$3, $$2);
        } else {
            boolean $$4 = false;
            Screen screen = this.f_291812_.f_91080_;
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen $$5 = (CreativeModeInventoryScreen)screen;
                boolean bl = $$4 = !$$5.m_258017_();
            }
            if (p_105000_.m_131991_() == 0 && InventoryMenu.m_150592_($$3)) {
                ItemStack $$6;
                if (!$$2.m_41619_() && (($$6 = $$1.f_36095_.m_38853_($$3).m_7993_()).m_41619_() || $$6.m_41613_() < $$2.m_41613_())) {
                    $$2.m_41754_(5);
                }
                $$1.f_36095_.m_182406_($$3, p_105000_.m_182716_(), $$2);
            } else if (!(p_105000_.m_131991_() != $$1.f_36096_.f_38840_ || p_105000_.m_131991_() == 0 && $$4)) {
                $$1.f_36096_.m_182406_($$3, p_105000_.m_182716_(), $$2);
            }
        }
    }

    @Override
    public void m_6837_(ClientboundContainerSetContentPacket p_104996_) {
        PacketUtils.m_131363_(p_104996_, this, this.f_291812_);
        LocalPlayer $$1 = this.f_291812_.f_91074_;
        if (p_104996_.m_131954_() == 0) {
            $$1.f_36095_.m_182410_(p_104996_.m_182709_(), p_104996_.m_131957_(), p_104996_.m_182708_());
        } else if (p_104996_.m_131954_() == $$1.f_36096_.f_38840_) {
            $$1.f_36096_.m_182410_(p_104996_.m_182709_(), p_104996_.m_131957_(), p_104996_.m_182708_());
        }
    }

    @Override
    public void m_8047_(ClientboundOpenSignEditorPacket p_105044_) {
        PacketUtils.m_131363_(p_105044_, this, this.f_291812_);
        BlockPos $$1 = p_105044_.m_132640_();
        BlockEntity blockEntity = this.f_104889_.m_7702_($$1);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity $$2 = (SignBlockEntity)blockEntity;
            this.f_291812_.f_91074_.m_7739_($$2, p_105044_.m_276774_());
        } else {
            BlockState $$3 = this.f_104889_.m_8055_($$1);
            SignBlockEntity $$4 = new SignBlockEntity($$1, $$3);
            $$4.m_142339_(this.f_104889_);
            this.f_291812_.f_91074_.m_7739_($$4, p_105044_.m_276774_());
        }
    }

    @Override
    public void m_7545_(ClientboundBlockEntityDataPacket p_104976_) {
        PacketUtils.m_131363_(p_104976_, this, this.f_291812_);
        BlockPos $$1 = p_104976_.m_131704_();
        this.f_291812_.f_91073_.m_141902_($$1, p_104976_.m_195645_()).ifPresent(p_205557_ -> {
            CompoundTag $$2 = p_104976_.m_131708_();
            if ($$2 != null) {
                p_205557_.m_142466_($$2);
            }
            if (p_205557_ instanceof CommandBlockEntity && this.f_291812_.f_91080_ instanceof CommandBlockEditScreen) {
                ((CommandBlockEditScreen)this.f_291812_.f_91080_).m_98398_();
            }
        });
    }

    @Override
    public void m_7257_(ClientboundContainerSetDataPacket p_104998_) {
        PacketUtils.m_131363_(p_104998_, this, this.f_291812_);
        LocalPlayer $$1 = this.f_291812_.f_91074_;
        if ($$1.f_36096_ != null && $$1.f_36096_.f_38840_ == p_104998_.m_131972_()) {
            $$1.f_36096_.m_7511_(p_104998_.m_131975_(), p_104998_.m_131976_());
        }
    }

    @Override
    public void m_7277_(ClientboundSetEquipmentPacket p_105094_) {
        PacketUtils.m_131363_(p_105094_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105094_.m_133210_());
        if ($$1 != null) {
            p_105094_.m_133213_().forEach(p_205528_ -> $$1.m_8061_((EquipmentSlot)p_205528_.getFirst(), (ItemStack)p_205528_.getSecond()));
        }
    }

    @Override
    public void m_7776_(ClientboundContainerClosePacket p_104994_) {
        PacketUtils.m_131363_(p_104994_, this, this.f_291812_);
        this.f_291812_.f_91074_.m_108763_();
    }

    @Override
    public void m_7364_(ClientboundBlockEventPacket p_104978_) {
        PacketUtils.m_131363_(p_104978_, this, this.f_291812_);
        this.f_291812_.f_91073_.m_7696_(p_104978_.m_131725_(), p_104978_.m_131730_(), p_104978_.m_131728_(), p_104978_.m_131729_());
    }

    @Override
    public void m_5943_(ClientboundBlockDestructionPacket p_104974_) {
        PacketUtils.m_131363_(p_104974_, this, this.f_291812_);
        this.f_291812_.f_91073_.m_6801_(p_104974_.m_131685_(), p_104974_.m_131688_(), p_104974_.m_131689_());
    }

    @Override
    public void m_7616_(ClientboundGameEventPacket p_105016_) {
        PacketUtils.m_131363_(p_105016_, this, this.f_291812_);
        LocalPlayer $$1 = this.f_291812_.f_91074_;
        ClientboundGameEventPacket.Type $$2 = p_105016_.m_132178_();
        float $$3 = p_105016_.m_132181_();
        int $$4 = Mth.m_14143_($$3 + 0.5f);
        if ($$2 == ClientboundGameEventPacket.f_132153_) {
            ((Player)$$1).m_5661_(Component.m_237115_("block.minecraft.spawn.not_valid"), false);
        } else if ($$2 == ClientboundGameEventPacket.f_132154_) {
            this.f_104889_.m_6106_().m_5565_(true);
            this.f_104889_.m_46734_(0.0f);
        } else if ($$2 == ClientboundGameEventPacket.f_132155_) {
            this.f_104889_.m_6106_().m_5565_(false);
            this.f_104889_.m_46734_(1.0f);
        } else if ($$2 == ClientboundGameEventPacket.f_132156_) {
            this.f_291812_.f_91072_.m_105279_(GameType.m_46393_($$4));
        } else if ($$2 == ClientboundGameEventPacket.f_132157_) {
            if ($$4 == 0) {
                this.f_291812_.f_91074_.f_108617_.m_295327_(new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
                this.f_291812_.m_91152_(new ReceivingLevelScreen());
            } else if ($$4 == 1) {
                this.f_291812_.m_91152_(new WinScreen(true, () -> {
                    this.f_291812_.f_91074_.f_108617_.m_295327_(new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
                    this.f_291812_.m_91152_(null);
                }));
            }
        } else if ($$2 == ClientboundGameEventPacket.f_132158_) {
            Options $$5 = this.f_291812_.f_91066_;
            if ($$3 == 0.0f) {
                this.f_291812_.m_91152_(new DemoIntroScreen());
            } else if ($$3 == 101.0f) {
                this.f_291812_.f_91065_.m_93076_().m_93785_(Component.m_237110_("demo.help.movement", $$5.f_92085_.m_90863_(), $$5.f_92086_.m_90863_(), $$5.f_92087_.m_90863_(), $$5.f_92088_.m_90863_()));
            } else if ($$3 == 102.0f) {
                this.f_291812_.f_91065_.m_93076_().m_93785_(Component.m_237110_("demo.help.jump", $$5.f_92089_.m_90863_()));
            } else if ($$3 == 103.0f) {
                this.f_291812_.f_91065_.m_93076_().m_93785_(Component.m_237110_("demo.help.inventory", $$5.f_92092_.m_90863_()));
            } else if ($$3 == 104.0f) {
                this.f_291812_.f_91065_.m_93076_().m_93785_(Component.m_237110_("demo.day.6", $$5.f_92102_.m_90863_()));
            }
        } else if ($$2 == ClientboundGameEventPacket.f_132159_) {
            this.f_104889_.m_6263_($$1, $$1.m_20185_(), $$1.m_20188_(), $$1.m_20189_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.18f, 0.45f);
        } else if ($$2 == ClientboundGameEventPacket.f_132160_) {
            this.f_104889_.m_46734_($$3);
        } else if ($$2 == ClientboundGameEventPacket.f_132161_) {
            this.f_104889_.m_46707_($$3);
        } else if ($$2 == ClientboundGameEventPacket.f_132162_) {
            this.f_104889_.m_6263_($$1, $$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), SoundEvents.f_12295_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if ($$2 == ClientboundGameEventPacket.f_132163_) {
            this.f_104889_.m_7106_(ParticleTypes.f_123807_, $$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), 0.0, 0.0, 0.0);
            if ($$4 == 1) {
                this.f_104889_.m_6263_($$1, $$1.m_20185_(), $$1.m_20186_(), $$1.m_20189_(), SoundEvents.f_11880_, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        } else if ($$2 == ClientboundGameEventPacket.f_132164_) {
            this.f_291812_.f_91074_.m_108711_($$3 == 0.0f);
        } else if ($$2 == ClientboundGameEventPacket.f_290437_) {
            this.f_291812_.f_91074_.m_294300_($$3 == 1.0f);
        }
    }

    @Override
    public void m_7633_(ClientboundMapItemDataPacket p_105032_) {
        PacketUtils.m_131363_(p_105032_, this, this.f_291812_);
        MapRenderer $$1 = this.f_291812_.f_91063_.m_109151_();
        int $$2 = p_105032_.m_132445_();
        String $$3 = MapItem.m_42848_($$2);
        MapItemSavedData $$4 = this.f_291812_.f_91073_.m_7489_($$3);
        if ($$4 == null) {
            $$4 = MapItemSavedData.m_164776_(p_105032_.m_178982_(), p_105032_.m_178983_(), this.f_291812_.f_91073_.m_46472_());
            this.f_291812_.f_91073_.m_257583_($$3, $$4);
        }
        p_105032_.m_132437_($$4);
        $$1.m_168765_($$2, $$4);
    }

    @Override
    public void m_7704_(ClientboundLevelEventPacket p_105024_) {
        PacketUtils.m_131363_(p_105024_, this, this.f_291812_);
        if (p_105024_.m_132274_()) {
            this.f_291812_.f_91073_.m_6798_(p_105024_.m_132277_(), p_105024_.m_132279_(), p_105024_.m_132278_());
        } else {
            this.f_291812_.f_91073_.m_46796_(p_105024_.m_132277_(), p_105024_.m_132279_(), p_105024_.m_132278_());
        }
    }

    @Override
    public void m_5498_(ClientboundUpdateAdvancementsPacket p_105126_) {
        PacketUtils.m_131363_(p_105126_, this, this.f_291812_);
        this.f_104893_.m_104399_(p_105126_);
    }

    @Override
    public void m_7553_(ClientboundSelectAdvancementsTabPacket p_105072_) {
        PacketUtils.m_131363_(p_105072_, this, this.f_291812_);
        ResourceLocation $$1 = p_105072_.m_133013_();
        if ($$1 == null) {
            this.f_104893_.m_104401_(null, false);
        } else {
            AdvancementHolder $$2 = this.f_104893_.m_295984_($$1);
            this.f_104893_.m_104401_($$2, false);
        }
    }

    @Override
    public void m_7443_(ClientboundCommandsPacket p_104990_) {
        PacketUtils.m_131363_(p_104990_, this, this.f_291812_);
        this.f_104899_ = new CommandDispatcher(p_104990_.m_237624_(CommandBuildContext.m_255418_(this.f_104903_, this.f_244039_)));
    }

    @Override
    public void m_7183_(ClientboundStopSoundPacket p_105116_) {
        PacketUtils.m_131363_(p_105116_, this, this.f_291812_);
        this.f_291812_.m_91106_().m_120386_(p_105116_.m_133476_(), p_105116_.m_133479_());
    }

    @Override
    public void m_7589_(ClientboundCommandSuggestionsPacket p_104988_) {
        PacketUtils.m_131363_(p_104988_, this, this.f_291812_);
        this.f_104894_.m_105171_(p_104988_.m_131854_(), p_104988_.m_131857_());
    }

    @Override
    public void m_6327_(ClientboundUpdateRecipesPacket p_105132_) {
        PacketUtils.m_131363_(p_105132_, this, this.f_291812_);
        this.f_104900_.m_44024_(p_105132_.m_133644_());
        ClientRecipeBook $$1 = this.f_291812_.f_91074_.m_108631_();
        $$1.m_266394_(this.f_104900_.m_44051_(), this.f_291812_.f_91073_.m_9598_());
        this.f_291812_.m_231374_(SearchRegistry.f_301428_, $$1.m_90639_());
    }

    @Override
    public void m_7244_(ClientboundPlayerLookAtPacket p_105054_) {
        PacketUtils.m_131363_(p_105054_, this, this.f_291812_);
        Vec3 $$1 = p_105054_.m_132785_(this.f_104889_);
        if ($$1 != null) {
            this.f_291812_.f_91074_.m_7618_(p_105054_.m_132793_(), $$1);
        }
    }

    @Override
    public void m_6148_(ClientboundTagQueryPacket p_105120_) {
        PacketUtils.m_131363_(p_105120_, this, this.f_291812_);
        if (!this.f_104896_.m_90705_(p_105120_.m_133506_(), p_105120_.m_133509_())) {
            f_104883_.debug("Got unhandled response to tag query {}", (Object)p_105120_.m_133506_());
        }
    }

    @Override
    public void m_7271_(ClientboundAwardStatsPacket p_104970_) {
        PacketUtils.m_131363_(p_104970_, this, this.f_291812_);
        for (Map.Entry<Stat<?>, Integer> $$1 : p_104970_.m_131643_().entrySet()) {
            Stat<?> $$2 = $$1.getKey();
            int $$3 = $$1.getValue();
            this.f_291812_.f_91074_.m_108630_().m_6085_(this.f_291812_.f_91074_, $$2, $$3);
        }
        if (this.f_291812_.f_91080_ instanceof StatsUpdateListener) {
            ((StatsUpdateListener)((Object)this.f_291812_.f_91080_)).m_7819_();
        }
    }

    @Override
    public void m_8076_(ClientboundRecipePacket p_105058_) {
        PacketUtils.m_131363_(p_105058_, this, this.f_291812_);
        ClientRecipeBook $$1 = this.f_291812_.f_91074_.m_108631_();
        $$1.m_12687_(p_105058_.m_132869_());
        ClientboundRecipePacket.State $$2 = p_105058_.m_132870_();
        switch ($$2) {
            case REMOVE: {
                for (ResourceLocation $$3 : p_105058_.m_132865_()) {
                    this.f_104900_.m_44043_($$3).ifPresent($$1::m_12713_);
                }
                break;
            }
            case INIT: {
                for (ResourceLocation $$4 : p_105058_.m_132865_()) {
                    this.f_104900_.m_44043_($$4).ifPresent($$1::m_12700_);
                }
                for (ResourceLocation $$5 : p_105058_.m_132868_()) {
                    this.f_104900_.m_44043_($$5).ifPresent($$1::m_12723_);
                }
                break;
            }
            case ADD: {
                for (ResourceLocation $$6 : p_105058_.m_132865_()) {
                    this.f_104900_.m_44043_($$6).ifPresent(p_296226_ -> {
                        $$1.m_12700_((RecipeHolder<?>)p_296226_);
                        $$1.m_12723_((RecipeHolder<?>)p_296226_);
                        if (p_296226_.f_291008_().m_271738_()) {
                            RecipeToast.m_94817_(this.f_291812_.m_91300_(), p_296226_);
                        }
                    });
                }
                break;
            }
        }
        $$1.m_90639_().forEach(p_205540_ -> p_205540_.m_100499_($$1));
        if (this.f_291812_.f_91080_ instanceof RecipeUpdateListener) {
            ((RecipeUpdateListener)((Object)this.f_291812_.f_91080_)).m_6916_();
        }
    }

    @Override
    public void m_7915_(ClientboundUpdateMobEffectPacket p_105130_) {
        PacketUtils.m_131363_(p_105130_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105130_.m_133622_());
        if (!($$1 instanceof LivingEntity)) {
            return;
        }
        MobEffect $$2 = p_105130_.m_237878_();
        if ($$2 == null) {
            return;
        }
        MobEffectInstance $$3 = new MobEffectInstance($$2, p_105130_.m_133625_(), p_105130_.m_133624_(), p_105130_.m_133627_(), p_105130_.m_133626_(), p_105130_.m_133628_(), null, Optional.ofNullable(p_105130_.m_237879_()));
        ((LivingEntity)$$1).m_147215_($$3, null);
    }

    @Override
    public void m_105133_(ClientboundUpdateTagsPacket p_298004_) {
        super.m_105133_(p_298004_);
        this.m_295411_();
    }

    private void m_295411_() {
        if (!this.f_290549_.m_129531_()) {
            Blocks.m_50758_();
        }
        CreativeModeTabs.m_258007_().m_257466_();
    }

    @Override
    public void m_142234_(ClientboundPlayerCombatEndPacket p_171771_) {
    }

    @Override
    public void m_142058_(ClientboundPlayerCombatEnterPacket p_171773_) {
    }

    @Override
    public void m_142747_(ClientboundPlayerCombatKillPacket p_171775_) {
        PacketUtils.m_131363_(p_171775_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_171775_.m_179078_());
        if ($$1 == this.f_291812_.f_91074_) {
            if (this.f_291812_.f_91074_.m_108632_()) {
                this.f_291812_.m_91152_(new DeathScreen(p_171775_.m_179079_(), this.f_104889_.m_6106_().m_5466_()));
            } else {
                this.f_291812_.f_91074_.m_7583_();
            }
        }
    }

    @Override
    public void m_6664_(ClientboundChangeDifficultyPacket p_104984_) {
        PacketUtils.m_131363_(p_104984_, this, this.f_291812_);
        this.f_104890_.m_104851_(p_104984_.m_131820_());
        this.f_104890_.m_104858_(p_104984_.m_131817_());
    }

    @Override
    public void m_6447_(ClientboundSetCameraPacket p_105076_) {
        PacketUtils.m_131363_(p_105076_, this, this.f_291812_);
        Entity $$1 = p_105076_.m_133059_(this.f_104889_);
        if ($$1 != null) {
            this.f_291812_.m_91118_($$1);
        }
    }

    @Override
    public void m_142237_(ClientboundInitializeBorderPacket p_171767_) {
        PacketUtils.m_131363_(p_171767_, this, this.f_291812_);
        WorldBorder $$1 = this.f_104889_.m_6857_();
        $$1.m_61949_(p_171767_.m_178886_(), p_171767_.m_178887_());
        long $$2 = p_171767_.m_178890_();
        if ($$2 > 0L) {
            $$1.m_61919_(p_171767_.m_178889_(), p_171767_.m_178888_(), $$2);
        } else {
            $$1.m_61917_(p_171767_.m_178888_());
        }
        $$1.m_61923_(p_171767_.m_178891_());
        $$1.m_61952_(p_171767_.m_178893_());
        $$1.m_61944_(p_171767_.m_178892_());
    }

    @Override
    public void m_142612_(ClientboundSetBorderCenterPacket p_171781_) {
        PacketUtils.m_131363_(p_171781_, this, this.f_291812_);
        this.f_104889_.m_6857_().m_61949_(p_171781_.m_179224_(), p_171781_.m_179223_());
    }

    @Override
    public void m_142686_(ClientboundSetBorderLerpSizePacket p_171783_) {
        PacketUtils.m_131363_(p_171783_, this, this.f_291812_);
        this.f_104889_.m_6857_().m_61919_(p_171783_.m_179238_(), p_171783_.m_179239_(), p_171783_.m_179240_());
    }

    @Override
    public void m_142238_(ClientboundSetBorderSizePacket p_171785_) {
        PacketUtils.m_131363_(p_171785_, this, this.f_291812_);
        this.f_104889_.m_6857_().m_61917_(p_171785_.m_179252_());
    }

    @Override
    public void m_142696_(ClientboundSetBorderWarningDistancePacket p_171789_) {
        PacketUtils.m_131363_(p_171789_, this, this.f_291812_);
        this.f_104889_.m_6857_().m_61952_(p_171789_.m_179276_());
    }

    @Override
    public void m_142056_(ClientboundSetBorderWarningDelayPacket p_171787_) {
        PacketUtils.m_131363_(p_171787_, this, this.f_291812_);
        this.f_104889_.m_6857_().m_61944_(p_171787_.m_179264_());
    }

    @Override
    public void m_142766_(ClientboundClearTitlesPacket p_171765_) {
        PacketUtils.m_131363_(p_171765_, this, this.f_291812_);
        this.f_291812_.f_91065_.m_168713_();
        if (p_171765_.m_178788_()) {
            this.f_291812_.f_91065_.m_93006_();
        }
    }

    @Override
    public void m_213672_(ClientboundServerDataPacket p_233704_) {
        PacketUtils.m_131363_(p_233704_, this, this.f_291812_);
        if (this.f_291024_ == null) {
            return;
        }
        this.f_291024_.f_105365_ = p_233704_.m_271805_();
        p_233704_.m_271815_().map(ServerData::m_301662_).ifPresent(this.f_291024_::m_271813_);
        this.f_291024_.m_242965_(p_233704_.m_242957_());
        ServerList.m_105446_(this.f_291024_);
        if (!this.f_291332_ && !p_233704_.m_242957_()) {
            SystemToast $$1 = SystemToast.m_94847_(this.f_291812_, SystemToast.SystemToastIds.UNSECURE_SERVER_WARNING, f_242953_, f_242949_);
            this.f_291812_.m_91300_().m_94922_($$1);
            this.f_291332_ = true;
        }
    }

    @Override
    public void m_240695_(ClientboundCustomChatCompletionsPacket p_240832_) {
        PacketUtils.m_131363_(p_240832_, this, this.f_291812_);
        this.f_104894_.m_240713_(p_240832_.f_240661_(), p_240832_.f_240663_());
    }

    @Override
    public void m_142456_(ClientboundSetActionBarTextPacket p_171779_) {
        PacketUtils.m_131363_(p_171779_, this, this.f_291812_);
        this.f_291812_.f_91065_.m_93063_(p_171779_.m_179210_(), false);
    }

    @Override
    public void m_142442_(ClientboundSetTitleTextPacket p_171793_) {
        PacketUtils.m_131363_(p_171793_, this, this.f_291812_);
        this.f_291812_.f_91065_.m_168714_(p_171793_.m_179399_());
    }

    @Override
    public void m_141913_(ClientboundSetSubtitleTextPacket p_171791_) {
        PacketUtils.m_131363_(p_171791_, this, this.f_291812_);
        this.f_291812_.f_91065_.m_168711_(p_171791_.m_179385_());
    }

    @Override
    public void m_142185_(ClientboundSetTitlesAnimationPacket p_171795_) {
        PacketUtils.m_131363_(p_171795_, this, this.f_291812_);
        this.f_291812_.f_91065_.m_168684_(p_171795_.m_179415_(), p_171795_.m_179416_(), p_171795_.m_179417_());
    }

    @Override
    public void m_6235_(ClientboundTabListPacket p_105118_) {
        PacketUtils.m_131363_(p_105118_, this, this.f_291812_);
        this.f_291812_.f_91065_.m_93088_().m_94558_(p_105118_.m_133489_().getString().isEmpty() ? null : p_105118_.m_133489_());
        this.f_291812_.f_91065_.m_93088_().m_94554_(p_105118_.m_133492_().getString().isEmpty() ? null : p_105118_.m_133492_());
    }

    @Override
    public void m_6476_(ClientboundRemoveMobEffectPacket p_105062_) {
        PacketUtils.m_131363_(p_105062_, this, this.f_291812_);
        Entity $$1 = p_105062_.m_132901_(this.f_104889_);
        if ($$1 instanceof LivingEntity) {
            ((LivingEntity)$$1).m_6234_(p_105062_.m_132909_());
        }
    }

    @Override
    public void m_213565_(ClientboundPlayerInfoRemovePacket p_248731_) {
        PacketUtils.m_131363_(p_248731_, this, this.f_291812_);
        for (UUID $$1 : p_248731_.f_244383_()) {
            this.f_291812_.m_91266_().m_100690_($$1);
            PlayerInfo $$2 = this.f_104892_.remove($$1);
            if ($$2 == null) continue;
            this.f_244156_.remove($$2);
        }
    }

    @Override
    public void m_214045_(ClientboundPlayerInfoUpdatePacket p_250115_) {
        PacketUtils.m_131363_(p_250115_, this, this.f_291812_);
        for (ClientboundPlayerInfoUpdatePacket.Entry $$1 : p_250115_.m_245290_()) {
            PlayerInfo $$2 = new PlayerInfo(Objects.requireNonNull($$1.f_243688_()), this.m_253150_());
            if (this.f_104892_.putIfAbsent($$1.f_244142_(), $$2) != null) continue;
            this.f_291812_.m_91266_().m_100676_($$2);
        }
        for (ClientboundPlayerInfoUpdatePacket.Entry $$3 : p_250115_.m_246778_()) {
            PlayerInfo $$4 = this.f_104892_.get($$3.f_244142_());
            if ($$4 == null) {
                f_104883_.warn("Ignoring player info update for unknown player {}", (Object)$$3.f_244142_());
                continue;
            }
            for (ClientboundPlayerInfoUpdatePacket.Action $$5 : p_250115_.m_246097_()) {
                this.m_247639_($$5, $$3, $$4);
            }
        }
    }

    private void m_247639_(ClientboundPlayerInfoUpdatePacket.Action p_248954_, ClientboundPlayerInfoUpdatePacket.Entry p_251310_, PlayerInfo p_251146_) {
        switch (p_248954_) {
            case INITIALIZE_CHAT: {
                this.m_245842_(p_251310_, p_251146_);
                break;
            }
            case UPDATE_GAME_MODE: {
                if (p_251146_.m_105325_() != p_251310_.f_244162_() && this.f_291812_.f_91074_ != null && this.f_291812_.f_91074_.m_20148_().equals(p_251310_.f_244142_())) {
                    this.f_291812_.f_91074_.m_287171_(p_251310_.f_244162_());
                }
                p_251146_.m_105317_(p_251310_.f_244162_());
                break;
            }
            case UPDATE_LISTED: {
                if (p_251310_.f_243700_()) {
                    this.f_244156_.add(p_251146_);
                    break;
                }
                this.f_244156_.remove(p_251146_);
                break;
            }
            case UPDATE_LATENCY: {
                p_251146_.m_105313_(p_251310_.f_244322_());
                break;
            }
            case UPDATE_DISPLAY_NAME: {
                p_251146_.m_105323_(p_251310_.f_244512_());
            }
        }
    }

    private void m_245842_(ClientboundPlayerInfoUpdatePacket.Entry p_248806_, PlayerInfo p_251136_) {
        GameProfile $$2 = p_251136_.m_105312_();
        SignatureValidator $$3 = this.f_291812_.m_231417_();
        if ($$3 == null) {
            f_104883_.warn("Ignoring chat session from {} due to missing Services public key", (Object)$$2.getName());
            p_251136_.m_253204_(this.m_253150_());
            return;
        }
        RemoteChatSession.Data $$4 = p_248806_.f_244153_();
        if ($$4 != null) {
            try {
                RemoteChatSession $$5 = $$4.m_247588_($$2, $$3);
                p_251136_.m_246479_($$5);
            }
            catch (ProfilePublicKey.ValidationException $$6) {
                f_104883_.error("Failed to validate profile key for player: '{}'", (Object)$$2.getName(), (Object)$$6);
                p_251136_.m_253204_(this.m_253150_());
            }
        } else {
            p_251136_.m_253204_(this.m_253150_());
        }
    }

    private boolean m_253150_() {
        return this.f_291024_ != null && this.f_291024_.m_242962_();
    }

    @Override
    public void m_5767_(ClientboundPlayerAbilitiesPacket p_105048_) {
        PacketUtils.m_131363_(p_105048_, this, this.f_291812_);
        LocalPlayer $$1 = this.f_291812_.f_91074_;
        $$1.m_150110_().f_35935_ = p_105048_.m_132677_();
        $$1.m_150110_().f_35937_ = p_105048_.m_132679_();
        $$1.m_150110_().f_35934_ = p_105048_.m_132674_();
        $$1.m_150110_().f_35936_ = p_105048_.m_132678_();
        $$1.m_150110_().m_35943_(p_105048_.m_132680_());
        $$1.m_150110_().m_35948_(p_105048_.m_132681_());
    }

    @Override
    public void m_8068_(ClientboundSoundPacket p_105114_) {
        PacketUtils.m_131363_(p_105114_, this, this.f_291812_);
        this.f_291812_.f_91073_.m_262808_(this.f_291812_.f_91074_, p_105114_.m_133459_(), p_105114_.m_133460_(), p_105114_.m_133461_(), p_105114_.m_263229_(), p_105114_.m_133458_(), p_105114_.m_133462_(), p_105114_.m_133463_(), p_105114_.m_237848_());
    }

    @Override
    public void m_5863_(ClientboundSoundEntityPacket p_105112_) {
        PacketUtils.m_131363_(p_105112_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105112_.m_133430_());
        if ($$1 == null) {
            return;
        }
        this.f_291812_.f_91073_.m_213890_(this.f_291812_.f_91074_, $$1, p_105112_.m_263456_(), p_105112_.m_133429_(), p_105112_.m_133431_(), p_105112_.m_133432_(), p_105112_.m_237837_());
    }

    @Override
    public void m_7685_(ClientboundBossEventPacket p_104982_) {
        PacketUtils.m_131363_(p_104982_, this, this.f_291812_);
        this.f_291812_.f_91065_.m_93090_().m_93711_(p_104982_);
    }

    @Override
    public void m_7701_(ClientboundCooldownPacket p_105002_) {
        PacketUtils.m_131363_(p_105002_, this, this.f_291812_);
        if (p_105002_.m_132011_() == 0) {
            this.f_291812_.f_91074_.m_36335_().m_41527_(p_105002_.m_132008_());
        } else {
            this.f_291812_.f_91074_.m_36335_().m_41524_(p_105002_.m_132008_(), p_105002_.m_132011_());
        }
    }

    @Override
    public void m_7410_(ClientboundMoveVehiclePacket p_105038_) {
        PacketUtils.m_131363_(p_105038_, this, this.f_291812_);
        Entity $$1 = this.f_291812_.f_91074_.m_20201_();
        if ($$1 != this.f_291812_.f_91074_ && $$1.m_6109_()) {
            $$1.m_19890_(p_105038_.m_132591_(), p_105038_.m_132594_(), p_105038_.m_132595_(), p_105038_.m_132596_(), p_105038_.m_132597_());
            this.f_290549_.m_129512_(new ServerboundMoveVehiclePacket($$1));
        }
    }

    @Override
    public void m_6503_(ClientboundOpenBookPacket p_105040_) {
        PacketUtils.m_131363_(p_105040_, this, this.f_291812_);
        ItemStack $$1 = this.f_291812_.f_91074_.m_21120_(p_105040_.m_132608_());
        if ($$1.m_150930_(Items.f_42615_)) {
            this.f_291812_.m_91152_(new BookViewScreen(new BookViewScreen.WrittenBookAccess($$1)));
        }
    }

    @Override
    public void m_105003_(CustomPacketPayload p_300286_) {
        if (p_300286_ instanceof PathfindingDebugPayload) {
            PathfindingDebugPayload $$1 = (PathfindingDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113413_.m_113611_($$1.f_290536_(), $$1.f_291873_(), $$1.f_291217_());
        } else if (p_300286_ instanceof NeighborUpdatesDebugPayload) {
            NeighborUpdatesDebugPayload $$2 = (NeighborUpdatesDebugPayload)p_300286_;
            ((NeighborsUpdateRenderer)this.f_291812_.f_91064_.f_113418_).m_113596_($$2.f_291308_(), $$2.f_290702_());
        } else if (p_300286_ instanceof StructuresDebugPayload) {
            StructuresDebugPayload $$3 = (StructuresDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113420_.m_113682_($$3.f_291102_(), $$3.f_291713_(), $$3.f_291455_());
        } else if (p_300286_ instanceof WorldGenAttemptDebugPayload) {
            WorldGenAttemptDebugPayload $$4 = (WorldGenAttemptDebugPayload)p_300286_;
            ((WorldGenAttemptRenderer)this.f_291812_.f_91064_.f_113422_).m_113737_($$4.f_291689_(), $$4.f_290326_(), $$4.f_291188_(), $$4.f_290800_(), $$4.f_291344_(), $$4.f_291261_());
        } else if (p_300286_ instanceof PoiTicketCountDebugPayload) {
            PoiTicketCountDebugPayload $$5 = (PoiTicketCountDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113425_.m_113230_($$5.f_291600_(), $$5.f_291747_());
        } else if (p_300286_ instanceof PoiAddedDebugPayload) {
            PoiAddedDebugPayload $$6 = (PoiAddedDebugPayload)p_300286_;
            BrainDebugRenderer.PoiInfo $$7 = new BrainDebugRenderer.PoiInfo($$6.f_290840_(), $$6.f_291238_(), $$6.f_290692_());
            this.f_291812_.f_91064_.f_113425_.m_113226_($$7);
        } else if (p_300286_ instanceof PoiRemovedDebugPayload) {
            PoiRemovedDebugPayload $$8 = (PoiRemovedDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113425_.m_113228_($$8.f_290491_());
        } else if (p_300286_ instanceof VillageSectionsDebugPayload) {
            VillageSectionsDebugPayload $$9 = (VillageSectionsDebugPayload)p_300286_;
            VillageSectionsDebugRenderer $$10 = this.f_291812_.f_91064_.f_113426_;
            $$9.f_290824_().forEach($$10::m_113709_);
            $$9.f_291861_().forEach($$10::m_113711_);
        } else if (p_300286_ instanceof GoalDebugPayload) {
            GoalDebugPayload $$11 = (GoalDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113429_.m_113548_($$11.f_290936_(), $$11.f_290389_(), $$11.f_290879_());
        } else if (p_300286_ instanceof BrainDebugPayload) {
            BrainDebugPayload $$12 = (BrainDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113425_.m_113219_($$12.f_291293_());
        } else if (p_300286_ instanceof BeeDebugPayload) {
            BeeDebugPayload $$13 = (BeeDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113427_.m_113066_($$13.f_291784_());
        } else if (p_300286_ instanceof HiveDebugPayload) {
            HiveDebugPayload $$14 = (HiveDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113427_.m_113071_($$14.f_291746_(), this.f_104889_.m_46467_());
        } else if (p_300286_ instanceof GameTestAddMarkerDebugPayload) {
            GameTestAddMarkerDebugPayload $$15 = (GameTestAddMarkerDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113430_.m_113524_($$15.f_291551_(), $$15.f_290458_(), $$15.f_291302_(), $$15.f_290945_());
        } else if (p_300286_ instanceof GameTestClearMarkersDebugPayload) {
            this.f_291812_.f_91064_.f_113430_.m_5630_();
        } else if (p_300286_ instanceof RaidsDebugPayload) {
            RaidsDebugPayload $$16 = (RaidsDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_113428_.m_113663_($$16.f_291474_());
        } else if (p_300286_ instanceof GameEventDebugPayload) {
            GameEventDebugPayload $$17 = (GameEventDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_173815_.m_234513_($$17.f_290975_(), $$17.f_291471_());
        } else if (p_300286_ instanceof GameEventListenerDebugPayload) {
            GameEventListenerDebugPayload $$18 = (GameEventListenerDebugPayload)p_300286_;
            this.f_291812_.f_91064_.f_173815_.m_173830_($$18.f_290887_(), $$18.f_291067_());
        } else {
            this.m_292823_(p_300286_);
        }
    }

    private void m_292823_(CustomPacketPayload p_301051_) {
        f_104883_.warn("Unknown custom packet payload: {}", (Object)p_301051_.m_292644_());
    }

    @Override
    public void m_7957_(ClientboundSetObjectivePacket p_105100_) {
        PacketUtils.m_131363_(p_105100_, this, this.f_291812_);
        Scoreboard $$1 = this.f_104889_.m_6188_();
        String $$2 = p_105100_.m_133266_();
        if (p_105100_.m_133270_() == 0) {
            $$1.m_83436_($$2, ObjectiveCriteria.f_83588_, p_105100_.m_133269_(), p_105100_.m_133271_());
        } else {
            Objective $$3 = $$1.m_83477_($$2);
            if ($$3 != null) {
                if (p_105100_.m_133270_() == 1) {
                    $$1.m_83502_($$3);
                } else if (p_105100_.m_133270_() == 2) {
                    $$3.m_83314_(p_105100_.m_133271_());
                    $$3.m_83316_(p_105100_.m_133269_());
                }
            }
        }
    }

    @Override
    public void m_7519_(ClientboundSetScorePacket p_105106_) {
        PacketUtils.m_131363_(p_105106_, this, this.f_291812_);
        Scoreboard $$1 = this.f_104889_.m_6188_();
        String $$2 = p_105106_.m_133342_();
        switch (p_105106_.m_133344_()) {
            case CHANGE: {
                Objective $$3 = $$1.m_83477_($$2);
                if ($$3 != null) {
                    Score $$4 = $$1.m_83471_(p_105106_.m_133339_(), $$3);
                    $$4.m_83402_(p_105106_.m_133343_());
                    break;
                }
                f_104883_.warn("Received packet for unknown scoreboard: {}", (Object)$$2);
                break;
            }
            case REMOVE: {
                $$1.m_83479_(p_105106_.m_133339_(), $$1.m_83477_($$2));
            }
        }
    }

    @Override
    public void m_5556_(ClientboundSetDisplayObjectivePacket p_105086_) {
        PacketUtils.m_131363_(p_105086_, this, this.f_291812_);
        Scoreboard $$1 = this.f_104889_.m_6188_();
        String $$2 = p_105086_.m_133142_();
        Objective $$3 = $$2 == null ? null : $$1.m_83477_($$2);
        $$1.m_7136_(p_105086_.m_133139_(), $$3);
    }

    @Override
    public void m_5582_(ClientboundSetPlayerTeamPacket p_105104_) {
        PlayerTeam $$4;
        PacketUtils.m_131363_(p_105104_, this, this.f_291812_);
        Scoreboard $$1 = this.f_104889_.m_6188_();
        ClientboundSetPlayerTeamPacket.Action $$2 = p_105104_.m_179338_();
        if ($$2 == ClientboundSetPlayerTeamPacket.Action.ADD) {
            PlayerTeam $$3 = $$1.m_83492_(p_105104_.m_133311_());
        } else {
            $$4 = $$1.m_83489_(p_105104_.m_133311_());
            if ($$4 == null) {
                f_104883_.warn("Received packet for unknown team {}: team action: {}, player action: {}", new Object[]{p_105104_.m_133311_(), p_105104_.m_179338_(), p_105104_.m_179335_()});
                return;
            }
        }
        Optional<ClientboundSetPlayerTeamPacket.Parameters> $$5 = p_105104_.m_179339_();
        $$5.ifPresent(p_233670_ -> {
            Team.CollisionRule $$3;
            $$4.m_83353_(p_233670_.m_179363_());
            $$4.m_83351_(p_233670_.m_179367_());
            $$4.m_83342_(p_233670_.m_179366_());
            Team.Visibility $$2 = Team.Visibility.m_83579_(p_233670_.m_179368_());
            if ($$2 != null) {
                $$4.m_83346_($$2);
            }
            if (($$3 = Team.CollisionRule.m_83555_(p_233670_.m_179369_())) != null) {
                $$4.m_83344_($$3);
            }
            $$4.m_83360_(p_233670_.m_179370_());
            $$4.m_83365_(p_233670_.m_179371_());
        });
        ClientboundSetPlayerTeamPacket.Action $$6 = p_105104_.m_179335_();
        if ($$6 == ClientboundSetPlayerTeamPacket.Action.ADD) {
            for (String $$7 : p_105104_.m_133315_()) {
                $$1.m_6546_($$7, $$4);
            }
        } else if ($$6 == ClientboundSetPlayerTeamPacket.Action.REMOVE) {
            for (String $$8 : p_105104_.m_133315_()) {
                $$1.m_6519_($$8, $$4);
            }
        }
        if ($$2 == ClientboundSetPlayerTeamPacket.Action.REMOVE) {
            $$1.m_83475_($$4);
        }
    }

    @Override
    public void m_7406_(ClientboundLevelParticlesPacket p_105026_) {
        PacketUtils.m_131363_(p_105026_, this, this.f_291812_);
        if (p_105026_.m_132321_() == 0) {
            double $$1 = p_105026_.m_132320_() * p_105026_.m_132317_();
            double $$2 = p_105026_.m_132320_() * p_105026_.m_132318_();
            double $$3 = p_105026_.m_132320_() * p_105026_.m_132319_();
            try {
                this.f_104889_.m_6493_(p_105026_.m_132322_(), p_105026_.m_132311_(), p_105026_.m_132314_(), p_105026_.m_132315_(), p_105026_.m_132316_(), $$1, $$2, $$3);
            }
            catch (Throwable $$4) {
                f_104883_.warn("Could not spawn particle effect {}", (Object)p_105026_.m_132322_());
            }
        } else {
            for (int $$5 = 0; $$5 < p_105026_.m_132321_(); ++$$5) {
                double $$6 = this.f_104898_.m_188583_() * (double)p_105026_.m_132317_();
                double $$7 = this.f_104898_.m_188583_() * (double)p_105026_.m_132318_();
                double $$8 = this.f_104898_.m_188583_() * (double)p_105026_.m_132319_();
                double $$9 = this.f_104898_.m_188583_() * (double)p_105026_.m_132320_();
                double $$10 = this.f_104898_.m_188583_() * (double)p_105026_.m_132320_();
                double $$11 = this.f_104898_.m_188583_() * (double)p_105026_.m_132320_();
                try {
                    this.f_104889_.m_6493_(p_105026_.m_132322_(), p_105026_.m_132311_(), p_105026_.m_132314_() + $$6, p_105026_.m_132315_() + $$7, p_105026_.m_132316_() + $$8, $$9, $$10, $$11);
                    continue;
                }
                catch (Throwable $$12) {
                    f_104883_.warn("Could not spawn particle effect {}", (Object)p_105026_.m_132322_());
                    return;
                }
            }
        }
    }

    @Override
    public void m_7710_(ClientboundUpdateAttributesPacket p_105128_) {
        PacketUtils.m_131363_(p_105128_, this, this.f_291812_);
        Entity $$1 = this.f_104889_.m_6815_(p_105128_.m_133588_());
        if ($$1 == null) {
            return;
        }
        if (!($$1 instanceof LivingEntity)) {
            throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + $$1 + ")");
        }
        AttributeMap $$2 = ((LivingEntity)$$1).m_21204_();
        for (ClientboundUpdateAttributesPacket.AttributeSnapshot $$3 : p_105128_.m_133591_()) {
            AttributeInstance $$4 = $$2.m_22146_($$3.m_133601_());
            if ($$4 == null) {
                f_104883_.warn("Entity {} does not have attribute {}", (Object)$$1, (Object)BuiltInRegistries.f_256951_.m_7981_($$3.m_133601_()));
                continue;
            }
            $$4.m_22100_($$3.m_133602_());
            $$4.m_22132_();
            for (AttributeModifier $$5 : $$3.m_133603_()) {
                $$4.m_22118_($$5);
            }
        }
    }

    @Override
    public void m_7339_(ClientboundPlaceGhostRecipePacket p_105046_) {
        PacketUtils.m_131363_(p_105046_, this, this.f_291812_);
        AbstractContainerMenu $$1 = this.f_291812_.f_91074_.f_36096_;
        if ($$1.f_38840_ != p_105046_.m_132658_()) {
            return;
        }
        this.f_104900_.m_44043_(p_105046_.m_132655_()).ifPresent(p_296228_ -> {
            if (this.f_291812_.f_91080_ instanceof RecipeUpdateListener) {
                RecipeBookComponent $$2 = ((RecipeUpdateListener)((Object)this.f_291812_.f_91080_)).m_5564_();
                $$2.m_7173_((RecipeHolder<?>)p_296228_, (List<Slot>)p_296227_.f_38839_);
            }
        });
    }

    @Override
    public void m_183514_(ClientboundLightUpdatePacket p_194243_) {
        PacketUtils.m_131363_(p_194243_, this, this.f_291812_);
        int $$1 = p_194243_.m_132349_();
        int $$2 = p_194243_.m_132352_();
        ClientboundLightUpdatePacketData $$3 = p_194243_.m_195722_();
        this.f_104889_.m_194171_(() -> this.m_194248_($$1, $$2, $$3));
    }

    private void m_194248_(int p_194249_, int p_194250_, ClientboundLightUpdatePacketData p_194251_) {
        LevelLightEngine $$3 = this.f_104889_.m_7726_().m_7827_();
        BitSet $$4 = p_194251_.m_195740_();
        BitSet $$5 = p_194251_.m_195751_();
        Iterator<byte[]> $$6 = p_194251_.m_195754_().iterator();
        this.m_171734_(p_194249_, p_194250_, $$3, LightLayer.SKY, $$4, $$5, $$6);
        BitSet $$7 = p_194251_.m_195757_();
        BitSet $$8 = p_194251_.m_195758_();
        Iterator<byte[]> $$9 = p_194251_.m_195759_().iterator();
        this.m_171734_(p_194249_, p_194250_, $$3, LightLayer.BLOCK, $$7, $$8, $$9);
        $$3.m_9335_(new ChunkPos(p_194249_, p_194250_), true);
    }

    @Override
    public void m_7330_(ClientboundMerchantOffersPacket p_105034_) {
        PacketUtils.m_131363_(p_105034_, this, this.f_291812_);
        AbstractContainerMenu $$1 = this.f_291812_.f_91074_.f_36096_;
        if (p_105034_.m_132468_() == $$1.f_38840_ && $$1 instanceof MerchantMenu) {
            MerchantMenu $$2 = (MerchantMenu)$$1;
            $$2.m_40046_(p_105034_.m_132471_());
            $$2.m_40066_(p_105034_.m_132473_());
            $$2.m_40069_(p_105034_.m_132472_());
            $$2.m_40048_(p_105034_.m_132474_());
            $$2.m_40058_(p_105034_.m_132475_());
        }
    }

    @Override
    public void m_7299_(ClientboundSetChunkCacheRadiusPacket p_105082_) {
        PacketUtils.m_131363_(p_105082_, this, this.f_291812_);
        this.f_104897_ = p_105082_.m_133108_();
        this.f_291812_.f_91066_.m_193770_(this.f_104897_);
        this.f_104889_.m_7726_().m_104416_(p_105082_.m_133108_());
    }

    @Override
    public void m_183623_(ClientboundSetSimulationDistancePacket p_194245_) {
        PacketUtils.m_131363_(p_194245_, this, this.f_291812_);
        this.f_194190_ = p_194245_.f_195796_();
        this.f_104889_.m_194174_(this.f_194190_);
    }

    @Override
    public void m_8065_(ClientboundSetChunkCacheCenterPacket p_105080_) {
        PacketUtils.m_131363_(p_105080_, this, this.f_291812_);
        this.f_104889_.m_7726_().m_104459_(p_105080_.m_133094_(), p_105080_.m_133097_());
    }

    @Override
    public void m_214108_(ClientboundBlockChangedAckPacket p_233698_) {
        PacketUtils.m_131363_(p_233698_, this, this.f_291812_);
        this.f_104889_.m_233651_(p_233698_.f_237578_());
    }

    @Override
    public void m_264308_(ClientboundBundlePacket p_265195_) {
        PacketUtils.m_131363_(p_265195_, this, this.f_291812_);
        for (Packet<ClientPacketListener> packet : p_265195_.m_264216_()) {
            packet.m_5797_(this);
        }
    }

    @Override
    public void m_292715_(ClientboundChunkBatchStartPacket p_297740_) {
        this.f_291253_.m_293630_();
    }

    @Override
    public void m_293721_(ClientboundChunkBatchFinishedPacket p_300262_) {
        this.f_291253_.m_293201_(p_300262_.f_291136_());
        this.m_295327_(new ServerboundChunkBatchReceivedPacket(this.f_291253_.m_293338_()));
    }

    @Override
    public void m_105486_(ClientboundPongResponsePacket p_297651_) {
        this.f_290671_.m_295898_(p_297651_);
    }

    private void m_171734_(int p_171735_, int p_171736_, LevelLightEngine p_171737_, LightLayer p_171738_, BitSet p_171739_, BitSet p_171740_, Iterator<byte[]> p_171741_) {
        for (int $$7 = 0; $$7 < p_171737_.m_164446_(); ++$$7) {
            int $$8 = p_171737_.m_164447_() + $$7;
            boolean $$9 = p_171739_.get($$7);
            boolean $$10 = p_171740_.get($$7);
            if (!$$9 && !$$10) continue;
            p_171737_.m_284126_(p_171738_, SectionPos.m_123173_(p_171735_, $$8, p_171736_), $$9 ? new DataLayer((byte[])p_171741_.next().clone()) : new DataLayer());
            this.f_104889_.m_104793_(p_171735_, $$8, p_171736_);
        }
    }

    public Connection m_104910_() {
        return this.f_290549_;
    }

    @Override
    public boolean m_6198_() {
        return this.f_290549_.m_129536_() && !this.f_291533_;
    }

    public Collection<PlayerInfo> m_246170_() {
        return this.f_244156_;
    }

    public Collection<PlayerInfo> m_105142_() {
        return this.f_104892_.values();
    }

    public Collection<UUID> m_105143_() {
        return this.f_104892_.keySet();
    }

    @Nullable
    public PlayerInfo m_104949_(UUID p_104950_) {
        return this.f_104892_.get(p_104950_);
    }

    @Nullable
    public PlayerInfo m_104938_(String p_104939_) {
        for (PlayerInfo $$1 : this.f_104892_.values()) {
            if (!$$1.m_105312_().getName().equals(p_104939_)) continue;
            return $$1;
        }
        return null;
    }

    public GameProfile m_105144_() {
        return this.f_104886_;
    }

    public ClientAdvancements m_105145_() {
        return this.f_104893_;
    }

    public CommandDispatcher<SharedSuggestionProvider> m_105146_() {
        return this.f_104899_;
    }

    public ClientLevel m_105147_() {
        return this.f_104889_;
    }

    public DebugQueryHandler m_105149_() {
        return this.f_104896_;
    }

    public UUID m_105150_() {
        return this.f_104901_;
    }

    public Set<ResourceKey<Level>> m_105151_() {
        return this.f_104902_;
    }

    @Override
    public RegistryAccess.Frozen m_105152_() {
        return this.f_104903_;
    }

    public void m_242011_(PlayerChatMessage p_242356_, boolean p_242455_) {
        MessageSignature $$2 = p_242356_.f_244279_();
        if ($$2 != null && this.f_244346_.m_245220_($$2, p_242455_) && this.f_244346_.m_245480_() > 64) {
            this.m_247711_();
        }
    }

    private void m_247711_() {
        int $$0 = this.f_244346_.m_245313_();
        if ($$0 > 0) {
            this.m_295327_(new ServerboundChatAckPacket($$0));
        }
    }

    public void m_246175_(String p_249888_) {
        Instant $$1 = Instant.now();
        long $$2 = Crypt.SaltSupplier.m_216113_();
        LastSeenMessagesTracker.Update $$3 = this.f_244346_.m_246442_();
        MessageSignature $$4 = this.f_240902_.m_240988_(new SignedMessageBody(p_249888_, $$1, $$2, $$3.f_243872_()));
        this.m_295327_(new ServerboundChatPacket(p_249888_, $$1, $$2, $$4, $$3.f_244473_()));
    }

    public void m_246623_(String p_250092_) {
        Instant $$1 = Instant.now();
        long $$2 = Crypt.SaltSupplier.m_216113_();
        LastSeenMessagesTracker.Update $$3 = this.f_244346_.m_246442_();
        ArgumentSignatures $$4 = ArgumentSignatures.m_245158_(SignableCommand.m_246497_(this.m_245186_(p_250092_)), p_247875_ -> {
            SignedMessageBody $$4 = new SignedMessageBody(p_247875_, $$1, $$2, $$3.f_243872_());
            return this.f_240902_.m_240988_($$4);
        });
        this.m_295327_(new ServerboundChatCommandPacket(p_250092_, $$1, $$2, $$4, $$3.f_244473_()));
    }

    public boolean m_246979_(String p_251509_) {
        if (SignableCommand.m_246497_(this.m_245186_(p_251509_)).f_244150_().isEmpty()) {
            LastSeenMessagesTracker.Update $$1 = this.f_244346_.m_246442_();
            this.m_295327_(new ServerboundChatCommandPacket(p_251509_, Instant.now(), 0L, ArgumentSignatures.f_240907_, $$1.f_244473_()));
            return true;
        }
        return false;
    }

    private ParseResults<SharedSuggestionProvider> m_245186_(String p_249982_) {
        return this.f_104899_.parse(p_249982_, (Object)this.f_104894_);
    }

    @Override
    public void m_9933_() {
        ProfileKeyPairManager $$0;
        if (this.f_290549_.m_129535_() && ($$0 = this.f_291812_.m_231465_()).m_253130_()) {
            $$0.m_252904_().thenAcceptAsync(p_253339_ -> p_253339_.ifPresent(this::m_260951_), (Executor)this.f_291812_);
        }
        this.m_295826_();
        if (this.f_291812_.m_293199_().m_295643_()) {
            this.f_290671_.m_295617_();
        }
        this.f_291019_.m_261056_();
    }

    public void m_260951_(ProfileKeyPair p_261475_) {
        if (!this.f_291812_.m_292661_(this.f_104886_.getId())) {
            return;
        }
        if (this.f_252517_ != null && this.f_252517_.f_243926_().equals(p_261475_)) {
            return;
        }
        this.f_252517_ = LocalChatSession.m_245157_(p_261475_);
        this.f_240902_ = this.f_252517_.m_247507_(this.f_104886_.getId());
        this.m_295327_(new ServerboundChatSessionUpdatePacket(this.f_252517_.m_245584_().m_245986_()));
    }

    @Nullable
    public ServerData m_245416_() {
        return this.f_291024_;
    }

    public FeatureFlagSet m_247016_() {
        return this.f_244039_;
    }

    public boolean m_246351_(FeatureFlagSet p_250605_) {
        return p_250605_.m_247715_(this.m_247016_());
    }
}

