/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagNetworkSerialization;
import org.slf4j.Logger;

public abstract class ClientCommonPacketListenerImpl
implements ClientCommonPacketListener {
    private static final Component f_291297_ = Component.m_237115_("disconnect.lost");
    private static final Logger f_290426_ = LogUtils.getLogger();
    protected final Minecraft f_291812_;
    protected final Connection f_290549_;
    @Nullable
    protected final ServerData f_291024_;
    @Nullable
    protected String f_291180_;
    protected final WorldSessionTelemetryManager f_291019_;
    @Nullable
    protected final Screen f_291028_;
    private final List<DeferredPacket> f_291530_ = new ArrayList<DeferredPacket>();

    protected ClientCommonPacketListenerImpl(Minecraft p_300051_, Connection p_300688_, CommonListenerCookie p_300429_) {
        this.f_291812_ = p_300051_;
        this.f_290549_ = p_300688_;
        this.f_291024_ = p_300429_.f_290465_();
        this.f_291180_ = p_300429_.f_291604_();
        this.f_291019_ = p_300429_.f_290317_();
        this.f_291028_ = p_300429_.f_291050_();
    }

    @Override
    public void m_292764_(ClientboundKeepAlivePacket p_301155_) {
        this.m_292916_(new ServerboundKeepAlivePacket(p_301155_.m_295012_()), () -> !RenderSystem.isFrozenAtPollEvents(), Duration.ofMinutes(1L));
    }

    @Override
    public void m_293992_(ClientboundPingPacket p_300922_) {
        PacketUtils.m_131363_(p_300922_, this, this.f_291812_);
        this.m_295327_(new ServerboundPongPacket(p_300922_.m_293261_()));
    }

    @Override
    public void m_293213_(ClientboundCustomPayloadPacket p_298103_) {
        CustomPacketPayload $$1 = p_298103_.f_291001_();
        if ($$1 instanceof DiscardedPayload) {
            return;
        }
        PacketUtils.m_131363_(p_298103_, this, this.f_291812_);
        if ($$1 instanceof BrandPayload) {
            BrandPayload $$2 = (BrandPayload)$$1;
            this.f_291180_ = $$2.f_291526_();
            this.f_291019_.m_260918_($$2.f_291526_());
        } else {
            this.m_105003_($$1);
        }
    }

    protected abstract void m_105003_(CustomPacketPayload var1);

    protected abstract RegistryAccess.Frozen m_105152_();

    @Override
    public void m_292941_(ClientboundResourcePackPacket p_300555_) {
        URL $$1 = ClientCommonPacketListenerImpl.m_295112_(p_300555_.m_293033_());
        if ($$1 == null) {
            this.m_294472_(ServerboundResourcePackPacket.Action.FAILED_DOWNLOAD);
            return;
        }
        String $$2 = p_300555_.m_295050_();
        boolean $$3 = p_300555_.m_294040_();
        if (this.f_291024_ != null && this.f_291024_.m_105387_() == ServerData.ServerPackStatus.ENABLED) {
            this.m_294472_(ServerboundResourcePackPacket.Action.ACCEPTED);
            this.m_294017_(this.f_291812_.m_247489_().m_246254_($$1, $$2, true));
        } else if (this.f_291024_ == null || this.f_291024_.m_105387_() == ServerData.ServerPackStatus.PROMPT || $$3 && this.f_291024_.m_105387_() == ServerData.ServerPackStatus.DISABLED) {
            this.f_291812_.execute(() -> this.m_295892_($$1, $$2, $$3, p_300555_.m_292957_()));
        } else {
            this.m_294472_(ServerboundResourcePackPacket.Action.DECLINED);
            if ($$3) {
                this.f_290549_.m_129507_(Component.m_237115_("multiplayer.requiredTexturePrompt.disconnect"));
            }
        }
    }

    private void m_295892_(URL p_299293_, String p_297795_, boolean p_297484_, @Nullable Component p_300186_) {
        Screen $$4 = this.f_291812_.f_91080_;
        this.f_291812_.m_91152_(new ConfirmScreen(p_298595_ -> {
            this.f_291812_.m_91152_($$4);
            if (p_298595_) {
                if (this.f_291024_ != null) {
                    this.f_291024_.m_105379_(ServerData.ServerPackStatus.ENABLED);
                }
                this.m_294472_(ServerboundResourcePackPacket.Action.ACCEPTED);
                this.m_294017_(this.f_291812_.m_247489_().m_246254_(p_299293_, p_297795_, true));
            } else {
                this.m_294472_(ServerboundResourcePackPacket.Action.DECLINED);
                if (p_297484_) {
                    this.f_290549_.m_129507_(Component.m_237115_("multiplayer.requiredTexturePrompt.disconnect"));
                } else if (this.f_291024_ != null) {
                    this.f_291024_.m_105379_(ServerData.ServerPackStatus.DISABLED);
                }
            }
            if (this.f_291024_ != null) {
                ServerList.m_105446_(this.f_291024_);
            }
        }, p_297484_ ? Component.m_237115_("multiplayer.requiredTexturePrompt.line1") : Component.m_237115_("multiplayer.texturePrompt.line1"), ClientCommonPacketListenerImpl.m_294992_(p_297484_ ? Component.m_237115_("multiplayer.requiredTexturePrompt.line2").m_130944_(ChatFormatting.YELLOW, ChatFormatting.BOLD) : Component.m_237115_("multiplayer.texturePrompt.line2"), p_300186_), p_297484_ ? CommonComponents.f_130659_ : CommonComponents.f_130657_, p_297484_ ? Component.m_237115_("menu.disconnect") : CommonComponents.f_130658_));
    }

    private static Component m_294992_(Component p_299226_, @Nullable Component p_298885_) {
        if (p_298885_ == null) {
            return p_299226_;
        }
        return Component.m_237110_("multiplayer.texturePrompt.serverPrompt", p_299226_, p_298885_);
    }

    @Nullable
    private static URL m_295112_(String p_298850_) {
        try {
            URL $$1 = new URL(p_298850_);
            String $$2 = $$1.getProtocol();
            if ("http".equals($$2) || "https".equals($$2)) {
                return $$1;
            }
        }
        catch (MalformedURLException $$3) {
            return null;
        }
        return null;
    }

    private void m_294017_(CompletableFuture<?> p_297539_) {
        ((CompletableFuture)p_297539_.thenRun(() -> this.m_294472_(ServerboundResourcePackPacket.Action.SUCCESSFULLY_LOADED))).exceptionally(p_299077_ -> {
            this.m_294472_(ServerboundResourcePackPacket.Action.FAILED_DOWNLOAD);
            return null;
        });
    }

    @Override
    public void m_105133_(ClientboundUpdateTagsPacket p_299537_) {
        PacketUtils.m_131363_(p_299537_, this, this.f_291812_);
        p_299537_.m_294928_().forEach(this::m_294832_);
    }

    private <T> void m_294832_(ResourceKey<? extends Registry<? extends T>> p_301094_, TagNetworkSerialization.NetworkPayload p_297701_) {
        if (p_297701_.m_203966_()) {
            return;
        }
        Registry $$2 = this.m_105152_().m_6632_(p_301094_).orElseThrow(() -> new IllegalStateException("Unknown registry " + p_301094_));
        ResourceKey $$3 = p_301094_;
        HashMap $$4 = new HashMap();
        TagNetworkSerialization.m_203952_($$3, $$2, p_297701_, $$4::put);
        $$2.m_203652_($$4);
    }

    private void m_294472_(ServerboundResourcePackPacket.Action p_299758_) {
        this.f_290549_.m_129512_(new ServerboundResourcePackPacket(p_299758_));
    }

    @Override
    public void m_293975_(ClientboundDisconnectPacket p_298016_) {
        this.f_290549_.m_129507_(p_298016_.m_295854_());
    }

    protected void m_295826_() {
        Iterator<DeferredPacket> $$0 = this.f_291530_.iterator();
        while ($$0.hasNext()) {
            DeferredPacket $$1 = $$0.next();
            if ($$1.f_291727_().getAsBoolean()) {
                this.m_295327_($$1.f_291164_);
                $$0.remove();
                continue;
            }
            if ($$1.f_291012_() > Util.m_137550_()) continue;
            $$0.remove();
        }
    }

    public void m_295327_(Packet<?> p_300175_) {
        this.f_290549_.m_129512_(p_300175_);
    }

    @Override
    public void m_7026_(Component p_298766_) {
        this.f_291019_.m_261027_();
        this.f_291812_.m_91320_(this.m_295606_(p_298766_));
        f_290426_.warn("Client disconnected with reason: {}", (Object)p_298766_.getString());
    }

    protected Screen m_295606_(Component p_299787_) {
        Screen $$1 = Objects.requireNonNullElseGet(this.f_291028_, () -> new JoinMultiplayerScreen(new TitleScreen()));
        if (this.f_291024_ != null && this.f_291024_.m_295074_()) {
            return new DisconnectedRealmsScreen($$1, f_291297_, p_299787_);
        }
        return new DisconnectedScreen($$1, f_291297_, p_299787_);
    }

    @Nullable
    public String m_295034_() {
        return this.f_291180_;
    }

    private void m_292916_(Packet<? extends ServerboundPacketListener> p_300852_, BooleanSupplier p_299754_, Duration p_299011_) {
        if (p_299754_.getAsBoolean()) {
            this.m_295327_(p_300852_);
        } else {
            this.f_291530_.add(new DeferredPacket(p_300852_, p_299754_, Util.m_137550_() + p_299011_.toMillis()));
        }
    }

    record DeferredPacket(Packet<? extends ServerboundPacketListener> f_291164_, BooleanSupplier f_291727_, long f_291012_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this);
        }

        @Override
        public final boolean equals(Object p_297419_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this, p_297419_);
        }
    }
}

