/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.Strings;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.response.KeyPairResponse;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.world.entity.player.ProfileKeyPair;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.slf4j.Logger;

public class AccountProfileKeyPairManager
implements ProfileKeyPairManager {
    private static final Logger f_252448_ = LogUtils.getLogger();
    private static final Duration f_252471_ = Duration.ofHours(1L);
    private static final Path f_252484_ = Path.of("profilekeys", new String[0]);
    private final UserApiService f_252526_;
    private final Path f_252423_;
    private CompletableFuture<Optional<ProfileKeyPair>> f_252428_;
    private Instant f_252478_ = Instant.EPOCH;

    public AccountProfileKeyPairManager(UserApiService p_253640_, UUID p_254415_, Path p_253813_) {
        this.f_252526_ = p_253640_;
        this.f_252423_ = p_253813_.resolve(f_252484_).resolve(p_254415_ + ".json");
        this.f_252428_ = CompletableFuture.supplyAsync(() -> this.m_252827_().filter(p_254127_ -> !p_254127_.f_219763_().f_219781_().m_219810_()), Util.m_183991_()).thenCompose(this::m_253041_);
    }

    @Override
    public CompletableFuture<Optional<ProfileKeyPair>> m_252904_() {
        this.f_252478_ = Instant.now().plus(f_252471_);
        this.f_252428_ = this.f_252428_.thenCompose(this::m_253041_);
        return this.f_252428_;
    }

    @Override
    public boolean m_253130_() {
        if (this.f_252428_.isDone() && Instant.now().isAfter(this.f_252478_)) {
            return this.f_252428_.join().map(ProfileKeyPair::m_219770_).orElse(true);
        }
        return false;
    }

    private CompletableFuture<Optional<ProfileKeyPair>> m_253041_(Optional<ProfileKeyPair> p_254074_) {
        return CompletableFuture.supplyAsync(() -> {
            if (p_254074_.isPresent() && !((ProfileKeyPair)p_254074_.get()).m_219770_()) {
                if (!SharedConstants.f_136183_) {
                    this.m_253216_(null);
                }
                return p_254074_;
            }
            try {
                ProfileKeyPair $$1 = this.m_253252_(this.f_252526_);
                this.m_253216_($$1);
                return Optional.of($$1);
            }
            catch (MinecraftClientException | IOException | CryptException $$2) {
                f_252448_.error("Failed to retrieve profile key pair", $$2);
                this.m_253216_(null);
                return p_254074_;
            }
        }, Util.m_183991_());
    }

    private Optional<ProfileKeyPair> m_252827_() {
        Optional optional;
        block9: {
            if (Files.notExists(this.f_252423_, new LinkOption[0])) {
                return Optional.empty();
            }
            BufferedReader $$0 = Files.newBufferedReader(this.f_252423_);
            try {
                optional = ProfileKeyPair.f_219761_.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)$$0)).result();
                if ($$0 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if ($$0 != null) {
                        try {
                            $$0.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception $$1) {
                    f_252448_.error("Failed to read profile key pair file {}", (Object)this.f_252423_, (Object)$$1);
                    return Optional.empty();
                }
            }
            $$0.close();
        }
        return optional;
    }

    private void m_253216_(@Nullable ProfileKeyPair p_254227_) {
        try {
            Files.deleteIfExists(this.f_252423_);
        }
        catch (IOException $$1) {
            f_252448_.error("Failed to delete profile key pair file {}", (Object)this.f_252423_, (Object)$$1);
        }
        if (p_254227_ == null) {
            return;
        }
        if (!SharedConstants.f_136183_) {
            return;
        }
        ProfileKeyPair.f_219761_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)p_254227_).result().ifPresent(p_254406_ -> {
            try {
                Files.createDirectories(this.f_252423_.getParent(), new FileAttribute[0]);
                Files.writeString(this.f_252423_, (CharSequence)p_254406_.toString(), new OpenOption[0]);
            }
            catch (Exception $$1) {
                f_252448_.error("Failed to write profile key pair file {}", (Object)this.f_252423_, (Object)$$1);
            }
        });
    }

    private ProfileKeyPair m_253252_(UserApiService p_253844_) throws CryptException, IOException {
        KeyPairResponse $$1 = p_253844_.getKeyPair();
        if ($$1 != null) {
            ProfilePublicKey.Data $$2 = AccountProfileKeyPairManager.m_253196_($$1);
            return new ProfileKeyPair(Crypt.m_216069_($$1.keyPair().privateKey()), new ProfilePublicKey($$2), Instant.parse($$1.refreshedAfter()));
        }
        throw new IOException("Could not retrieve profile key pair");
    }

    private static ProfilePublicKey.Data m_253196_(KeyPairResponse p_253834_) throws CryptException {
        KeyPairResponse.KeyPair $$1 = p_253834_.keyPair();
        if (Strings.isNullOrEmpty((String)$$1.publicKey()) || p_253834_.publicKeySignature() == null || p_253834_.publicKeySignature().array().length == 0) {
            throw new CryptException((Throwable)new InsecurePublicKeyException.MissingException());
        }
        try {
            Instant $$2 = Instant.parse(p_253834_.expiresAt());
            PublicKey $$3 = Crypt.m_216080_($$1.publicKey());
            ByteBuffer $$4 = p_253834_.publicKeySignature();
            return new ProfilePublicKey.Data($$2, $$3, $$4.array());
        }
        catch (IllegalArgumentException | DateTimeException $$5) {
            throw new CryptException($$5);
        }
    }
}

