/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class WorldSelectionList
extends ObjectSelectionList<Entry> {
    static final ResourceLocation f_291416_ = new ResourceLocation("world_list/error_highlighted");
    static final ResourceLocation f_291432_ = new ResourceLocation("world_list/error");
    static final ResourceLocation f_290451_ = new ResourceLocation("world_list/marked_join_highlighted");
    static final ResourceLocation f_291750_ = new ResourceLocation("world_list/marked_join");
    static final ResourceLocation f_291467_ = new ResourceLocation("world_list/warning_highlighted");
    static final ResourceLocation f_290779_ = new ResourceLocation("world_list/warning");
    static final ResourceLocation f_290682_ = new ResourceLocation("world_list/join_highlighted");
    static final ResourceLocation f_291405_ = new ResourceLocation("world_list/join");
    static final Logger f_101645_ = LogUtils.getLogger();
    static final DateFormat f_101646_ = new SimpleDateFormat();
    private static final ResourceLocation f_101647_ = new ResourceLocation("textures/misc/unknown_server.png");
    static final Component f_101649_ = Component.m_237115_("selectWorld.tooltip.fromNewerVersion1").m_130940_(ChatFormatting.RED);
    static final Component f_101650_ = Component.m_237115_("selectWorld.tooltip.fromNewerVersion2").m_130940_(ChatFormatting.RED);
    static final Component f_101651_ = Component.m_237115_("selectWorld.tooltip.snapshot1").m_130940_(ChatFormatting.GOLD);
    static final Component f_101652_ = Component.m_237115_("selectWorld.tooltip.snapshot2").m_130940_(ChatFormatting.GOLD);
    static final Component f_101653_ = Component.m_237115_("selectWorld.locked").m_130940_(ChatFormatting.RED);
    static final Component f_194113_ = Component.m_237115_("selectWorld.conversion.tooltip").m_130940_(ChatFormatting.RED);
    static final Component f_291265_ = Component.m_237115_("selectWorld.experimental");
    private final SelectWorldScreen f_101654_;
    private CompletableFuture<List<LevelSummary>> f_238666_;
    @Nullable
    private List<LevelSummary> f_238575_;
    private String f_238624_;
    private final LoadingHeader f_233184_;

    public WorldSelectionList(SelectWorldScreen p_239540_, Minecraft p_239541_, int p_239542_, int p_239543_, int p_239544_, int p_239545_, int p_239546_, String p_239547_, @Nullable WorldSelectionList p_239548_) {
        super(p_239541_, p_239542_, p_239543_, p_239544_, p_239545_, p_239546_);
        this.f_101654_ = p_239540_;
        this.f_233184_ = new LoadingHeader(p_239541_);
        this.f_238624_ = p_239547_;
        this.f_238666_ = p_239548_ != null ? p_239548_.f_238666_ : this.m_233213_();
        this.m_239664_(this.m_239987_());
    }

    @Override
    protected void m_93516_() {
        this.m_6702_().forEach(Entry::close);
        super.m_93516_();
    }

    @Nullable
    private List<LevelSummary> m_239987_() {
        try {
            return this.f_238666_.getNow(null);
        }
        catch (CancellationException | CompletionException $$0) {
            return null;
        }
    }

    void m_233206_() {
        this.f_238666_ = this.m_233213_();
    }

    @Override
    public boolean m_7933_(int p_289017_, int p_288966_, int p_289020_) {
        Optional<WorldListEntry> $$3;
        if (CommonInputs.m_278691_(p_289017_) && ($$3 = this.m_101684_()).isPresent()) {
            $$3.get().m_101704_();
            return true;
        }
        return super.m_7933_(p_289017_, p_288966_, p_289020_);
    }

    @Override
    public void m_88315_(GuiGraphics p_283323_, int p_282039_, int p_283339_, float p_281472_) {
        List<LevelSummary> $$4 = this.m_239987_();
        if ($$4 != this.f_238575_) {
            this.m_239664_($$4);
        }
        super.m_88315_(p_283323_, p_282039_, p_283339_, p_281472_);
    }

    private void m_239664_(@Nullable List<LevelSummary> p_239665_) {
        if (p_239665_ == null) {
            this.m_233214_();
        } else {
            this.m_233198_(this.f_238624_, p_239665_);
        }
        this.f_238575_ = p_239665_;
    }

    public void m_239900_(String p_239901_) {
        if (this.f_238575_ != null && !p_239901_.equals(this.f_238624_)) {
            this.m_233198_(p_239901_, this.f_238575_);
        }
        this.f_238624_ = p_239901_;
    }

    /*
     * WARNING - void declaration
     */
    private CompletableFuture<List<LevelSummary>> m_233213_() {
        void $$2;
        try {
            LevelStorageSource.LevelCandidates $$0 = this.f_93386_.m_91392_().m_230833_();
        }
        catch (LevelStorageException $$1) {
            f_101645_.error("Couldn't load level list", (Throwable)$$1);
            this.m_233211_($$1.m_230806_());
            return CompletableFuture.completedFuture(List.of());
        }
        if ($$2.m_230843_()) {
            CreateWorldScreen.m_232896_(this.f_93386_, null);
            return CompletableFuture.completedFuture(List.of());
        }
        return this.f_93386_.m_91392_().m_230813_((LevelStorageSource.LevelCandidates)$$2).exceptionally(p_233202_ -> {
            this.f_93386_.m_231412_(CrashReport.m_127521_(p_233202_, "Couldn't load level list"));
            return List.of();
        });
    }

    private void m_233198_(String p_233199_, List<LevelSummary> p_233200_) {
        this.m_93516_();
        p_233199_ = p_233199_.toLowerCase(Locale.ROOT);
        for (LevelSummary $$2 : p_233200_) {
            if (!this.m_233195_(p_233199_, $$2)) continue;
            this.m_7085_(new WorldListEntry(this, $$2));
        }
        this.m_233215_();
    }

    private boolean m_233195_(String p_233196_, LevelSummary p_233197_) {
        return p_233197_.m_78361_().toLowerCase(Locale.ROOT).contains(p_233196_) || p_233197_.m_78358_().toLowerCase(Locale.ROOT).contains(p_233196_);
    }

    private void m_233214_() {
        this.m_93516_();
        this.m_7085_(this.f_233184_);
        this.m_233215_();
    }

    private void m_233215_() {
        this.f_101654_.m_169407_(true);
    }

    private void m_233211_(Component p_233212_) {
        this.f_93386_.m_91152_(new ErrorScreen(Component.m_237115_("selectWorld.unable_to_load"), p_233212_));
    }

    @Override
    protected int m_5756_() {
        return super.m_5756_() + 20;
    }

    @Override
    public int m_5759_() {
        return super.m_5759_() + 50;
    }

    @Override
    public void m_6987_(@Nullable Entry p_233190_) {
        super.m_6987_(p_233190_);
        this.f_101654_.m_276090_(p_233190_ != null && p_233190_.m_214209_(), p_233190_ != null);
    }

    public Optional<WorldListEntry> m_101684_() {
        Entry $$0 = (Entry)this.m_93511_();
        if ($$0 instanceof WorldListEntry) {
            WorldListEntry $$1 = (WorldListEntry)$$0;
            return Optional.of($$1);
        }
        return Optional.empty();
    }

    public SelectWorldScreen m_101685_() {
        return this.f_101654_;
    }

    @Override
    public void m_142291_(NarrationElementOutput p_233188_) {
        if (this.m_6702_().contains(this.f_233184_)) {
            this.f_233184_.m_142291_(p_233188_);
            return;
        }
        super.m_142291_(p_233188_);
    }

    public static class LoadingHeader
    extends Entry {
        private static final Component f_233218_ = Component.m_237115_("selectWorld.loading_list");
        private final Minecraft f_233219_;

        public LoadingHeader(Minecraft p_233222_) {
            this.f_233219_ = p_233222_;
        }

        @Override
        public void m_6311_(GuiGraphics p_282319_, int p_283207_, int p_281352_, int p_283332_, int p_282400_, int p_282912_, int p_282760_, int p_281344_, boolean p_283655_, float p_283696_) {
            int $$10 = (this.f_233219_.f_91080_.f_96543_ - this.f_233219_.f_91062_.m_92852_(f_233218_)) / 2;
            int $$11 = p_281352_ + (p_282912_ - this.f_233219_.f_91062_.f_92710_) / 2;
            p_282319_.m_280614_(this.f_233219_.f_91062_, f_233218_, $$10, $$11, 0xFFFFFF, false);
            String $$12 = LoadingDotsText.m_232744_(Util.m_137550_());
            int $$13 = (this.f_233219_.f_91080_.f_96543_ - this.f_233219_.f_91062_.m_92895_($$12)) / 2;
            int $$14 = $$11 + this.f_233219_.f_91062_.f_92710_;
            p_282319_.m_280056_(this.f_233219_.f_91062_, $$12, $$13, $$14, -8355712, false);
        }

        @Override
        public Component m_142172_() {
            return f_233218_;
        }

        @Override
        public boolean m_214209_() {
            return false;
        }
    }

    public final class WorldListEntry
    extends Entry
    implements AutoCloseable {
        private static final int f_170312_ = 32;
        private static final int f_170313_ = 32;
        private final Minecraft f_101693_;
        private final SelectWorldScreen f_101694_;
        private final LevelSummary f_101695_;
        private final FaviconTexture f_101698_;
        @Nullable
        private Path f_101697_;
        private long f_101699_;

        public WorldListEntry(WorldSelectionList p_101702_, LevelSummary p_101703_) {
            this.f_101693_ = p_101702_.f_93386_;
            this.f_101694_ = p_101702_.m_101685_();
            this.f_101695_ = p_101703_;
            this.f_101698_ = FaviconTexture.m_289210_(this.f_101693_.m_91097_(), p_101703_.m_78358_());
            this.f_101697_ = p_101703_.m_230875_();
            this.m_289856_();
            this.m_101746_();
        }

        private void m_289856_() {
            if (this.f_101697_ == null) {
                return;
            }
            try {
                BasicFileAttributes $$0 = Files.readAttributes(this.f_101697_, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if ($$0.isSymbolicLink()) {
                    List<ForbiddenSymlinkInfo> $$1 = this.f_101693_.m_294312_().m_295373_(this.f_101697_);
                    if (!$$1.isEmpty()) {
                        f_101645_.warn("{}", (Object)ContentValidationException.m_289907_(this.f_101697_, $$1));
                        this.f_101697_ = null;
                    } else {
                        $$0 = Files.readAttributes(this.f_101697_, BasicFileAttributes.class, new LinkOption[0]);
                    }
                }
                if (!$$0.isRegularFile()) {
                    this.f_101697_ = null;
                }
            }
            catch (NoSuchFileException $$2) {
                this.f_101697_ = null;
            }
            catch (IOException $$3) {
                f_101645_.error("could not validate symlink", (Throwable)$$3);
                this.f_101697_ = null;
            }
        }

        @Override
        public Component m_142172_() {
            MutableComponent $$0 = Component.m_237110_("narrator.select.world_info", this.f_101695_.m_78361_(), new Date(this.f_101695_.m_78366_()), this.f_101695_.m_78376_());
            if (this.f_101695_.m_78375_()) {
                $$0 = CommonComponents.m_267603_($$0, f_101653_);
            }
            if (this.f_101695_.m_246454_()) {
                $$0 = CommonComponents.m_267603_($$0, f_291265_);
            }
            return Component.m_237110_("narrator.select", $$0);
        }

        @Override
        public void m_6311_(GuiGraphics p_281612_, int p_281353_, int p_283181_, int p_282820_, int p_282420_, int p_281855_, int p_283204_, int p_283025_, boolean p_283396_, float p_282938_) {
            Object $$10 = this.f_101695_.m_78361_();
            Object $$11 = this.f_101695_.m_78358_();
            long $$12 = this.f_101695_.m_78366_();
            if ($$12 != -1L) {
                $$11 = (String)$$11 + " (" + f_101646_.format(new Date($$12)) + ")";
            }
            if (StringUtils.isEmpty((CharSequence)$$10)) {
                $$10 = I18n.m_118938_("selectWorld.world", new Object[0]) + " " + (p_281353_ + 1);
            }
            Component $$13 = this.f_101695_.m_78376_();
            p_281612_.m_280056_(this.f_101693_.f_91062_, (String)$$10, p_282820_ + 32 + 3, p_283181_ + 1, 0xFFFFFF, false);
            p_281612_.m_280056_(this.f_101693_.f_91062_, (String)$$11, p_282820_ + 32 + 3, p_283181_ + this.f_101693_.f_91062_.f_92710_ + 3, -8355712, false);
            p_281612_.m_280614_(this.f_101693_.f_91062_, $$13, p_282820_ + 32 + 3, p_283181_ + this.f_101693_.f_91062_.f_92710_ + this.f_101693_.f_91062_.f_92710_ + 3, -8355712, false);
            RenderSystem.enableBlend();
            p_281612_.m_280163_(this.f_101698_.m_289196_(), p_282820_, p_283181_, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            if (this.f_101693_.f_91066_.m_231828_().m_231551_().booleanValue() || p_283396_) {
                ResourceLocation $$19;
                p_281612_.m_280509_(p_282820_, p_283181_, p_282820_ + 32, p_283181_ + 32, -1601138544);
                int $$14 = p_283204_ - p_282820_;
                boolean $$15 = $$14 < 32;
                ResourceLocation $$16 = $$15 ? f_290682_ : f_291405_;
                ResourceLocation $$17 = $$15 ? f_291467_ : f_290779_;
                ResourceLocation $$18 = $$15 ? f_291416_ : f_291432_;
                ResourceLocation resourceLocation = $$19 = $$15 ? f_290451_ : f_291750_;
                if (this.f_101695_ instanceof LevelSummary.SymlinkLevelSummary) {
                    p_281612_.m_292816_($$18, p_282820_, p_283181_, 32, 32);
                    p_281612_.m_292816_($$19, p_282820_, p_283181_, 32, 32);
                    return;
                }
                if (this.f_101695_.m_78375_()) {
                    p_281612_.m_292816_($$18, p_282820_, p_283181_, 32, 32);
                    if ($$15) {
                        this.f_101694_.m_257959_(this.f_101693_.f_91062_.m_92923_(f_101653_, 175));
                    }
                } else if (this.f_101695_.m_193020_()) {
                    p_281612_.m_292816_($$18, p_282820_, p_283181_, 32, 32);
                    if ($$15) {
                        this.f_101694_.m_257959_(this.f_101693_.f_91062_.m_92923_(f_194113_, 175));
                    }
                } else if (this.f_101695_.m_78372_()) {
                    p_281612_.m_292816_($$19, p_282820_, p_283181_, 32, 32);
                    if (this.f_101695_.m_78373_()) {
                        p_281612_.m_292816_($$18, p_282820_, p_283181_, 32, 32);
                        if ($$15) {
                            this.f_101694_.m_257959_((List<FormattedCharSequence>)ImmutableList.of((Object)f_101649_.m_7532_(), (Object)f_101650_.m_7532_()));
                        }
                    } else if (!SharedConstants.m_183709_().m_132498_()) {
                        p_281612_.m_292816_($$17, p_282820_, p_283181_, 32, 32);
                        if ($$15) {
                            this.f_101694_.m_257959_((List<FormattedCharSequence>)ImmutableList.of((Object)f_101651_.m_7532_(), (Object)f_101652_.m_7532_()));
                        }
                    }
                } else {
                    p_281612_.m_292816_($$16, p_282820_, p_283181_, 32, 32);
                }
            }
        }

        @Override
        public boolean m_6375_(double p_101706_, double p_101707_, int p_101708_) {
            if (this.f_101695_.m_164916_()) {
                return true;
            }
            WorldSelectionList.this.m_6987_(this);
            if (p_101706_ - (double)WorldSelectionList.this.m_5747_() <= 32.0) {
                this.m_101704_();
                return true;
            }
            if (Util.m_137550_() - this.f_101699_ < 250L) {
                this.m_101704_();
                return true;
            }
            this.f_101699_ = Util.m_137550_();
            return true;
        }

        public void m_101704_() {
            if (this.f_101695_.m_164916_()) {
                return;
            }
            if (this.f_101695_ instanceof LevelSummary.SymlinkLevelSummary) {
                this.f_101693_.m_91152_(NoticeWithLinkScreen.m_293051_(this.f_101694_));
                return;
            }
            LevelSummary.BackupStatus $$0 = this.f_101695_.m_164914_();
            if ($$0.m_164931_()) {
                String $$1 = "selectWorld.backupQuestion." + $$0.m_164933_();
                String $$2 = "selectWorld.backupWarning." + $$0.m_164933_();
                MutableComponent $$3 = Component.m_237115_($$1);
                if ($$0.m_164932_()) {
                    $$3.m_130944_(ChatFormatting.BOLD, ChatFormatting.RED);
                }
                MutableComponent $$4 = Component.m_237110_($$2, this.f_101695_.m_78370_(), SharedConstants.m_183709_().m_132493_());
                this.f_101693_.m_91152_(new BackupConfirmScreen(this.f_101694_, (p_296223_, p_296224_) -> {
                    if (p_296223_) {
                        String $$2 = this.f_101695_.m_78358_();
                        try (LevelStorageSource.LevelStorageAccess $$3 = this.f_101693_.m_91392_().m_289864_($$2);){
                            EditWorldScreen.m_101258_($$3);
                        }
                        catch (IOException $$4) {
                            SystemToast.m_94852_(this.f_101693_, $$2);
                            f_101645_.error("Failed to backup level {}", (Object)$$2, (Object)$$4);
                        }
                        catch (ContentValidationException $$5) {
                            f_101645_.warn("{}", (Object)$$5.getMessage());
                            this.f_101693_.m_91152_(NoticeWithLinkScreen.m_293051_(this.f_101694_));
                        }
                    }
                    this.m_101744_();
                }, $$3, $$4, false));
            } else if (this.f_101695_.m_78373_()) {
                this.f_101693_.m_91152_(new ConfirmScreen(p_101741_ -> {
                    if (p_101741_) {
                        try {
                            this.m_101744_();
                        }
                        catch (Exception $$1) {
                            f_101645_.error("Failure to open 'future world'", (Throwable)$$1);
                            this.f_101693_.m_91152_(new AlertScreen(() -> this.f_101693_.m_91152_(this.f_101694_), Component.m_237115_("selectWorld.futureworld.error.title"), Component.m_237115_("selectWorld.futureworld.error.text")));
                        }
                    } else {
                        this.f_101693_.m_91152_(this.f_101694_);
                    }
                }, Component.m_237115_("selectWorld.versionQuestion"), Component.m_237110_("selectWorld.versionWarning", this.f_101695_.m_78370_()), Component.m_237115_("selectWorld.versionJoinButton"), CommonComponents.f_130656_));
            } else {
                this.m_101744_();
            }
        }

        public void m_101738_() {
            this.f_101693_.m_91152_(new ConfirmScreen(p_170322_ -> {
                if (p_170322_) {
                    this.f_101693_.m_91152_(new ProgressScreen(true));
                    this.m_170323_();
                }
                this.f_101693_.m_91152_(this.f_101694_);
            }, Component.m_237115_("selectWorld.deleteQuestion"), Component.m_237110_("selectWorld.deleteWarning", this.f_101695_.m_78361_()), Component.m_237115_("selectWorld.deleteButton"), CommonComponents.f_130656_));
        }

        public void m_170323_() {
            LevelStorageSource $$0 = this.f_101693_.m_91392_();
            String $$1 = this.f_101695_.m_78358_();
            try (LevelStorageSource.LevelStorageAccess $$2 = $$0.m_78260_($$1);){
                $$2.m_78311_();
            }
            catch (IOException $$3) {
                SystemToast.m_94866_(this.f_101693_, $$1);
                f_101645_.error("Failed to delete world {}", (Object)$$1, (Object)$$3);
            }
            WorldSelectionList.this.m_233206_();
        }

        public void m_101739_() {
            if (this.f_101695_ instanceof LevelSummary.SymlinkLevelSummary) {
                this.f_101693_.m_91152_(NoticeWithLinkScreen.m_293051_(this.f_101694_));
                return;
            }
            this.m_101745_();
            String $$0 = this.f_101695_.m_78358_();
            try {
                LevelStorageSource.LevelStorageAccess $$1 = this.f_101693_.m_91392_().m_289864_($$0);
                this.f_101693_.m_91152_(new EditWorldScreen(p_233244_ -> {
                    try {
                        $$1.close();
                    }
                    catch (IOException $$3) {
                        f_101645_.error("Failed to unlock level {}", (Object)$$0, (Object)$$3);
                    }
                    if (p_233244_) {
                        WorldSelectionList.this.m_233206_();
                    }
                    this.f_101693_.m_91152_(this.f_101694_);
                }, $$1));
            }
            catch (IOException $$2) {
                SystemToast.m_94852_(this.f_101693_, $$0);
                f_101645_.error("Failed to access level {}", (Object)$$0, (Object)$$2);
                WorldSelectionList.this.m_233206_();
            }
            catch (ContentValidationException $$3) {
                f_101645_.warn("{}", (Object)$$3.getMessage());
                this.f_101693_.m_91152_(NoticeWithLinkScreen.m_293051_(this.f_101694_));
            }
        }

        public void m_101743_() {
            if (this.f_101695_ instanceof LevelSummary.SymlinkLevelSummary) {
                this.f_101693_.m_91152_(NoticeWithLinkScreen.m_293051_(this.f_101694_));
                return;
            }
            this.m_101745_();
            try (LevelStorageSource.LevelStorageAccess $$0 = this.f_101693_.m_91392_().m_289864_(this.f_101695_.m_78358_());){
                Pair<LevelSettings, WorldCreationContext> $$1 = this.f_101693_.m_231466_().m_246225_($$0);
                LevelSettings $$2 = (LevelSettings)$$1.getFirst();
                WorldCreationContext $$3 = (WorldCreationContext)$$1.getSecond();
                Path $$4 = CreateWorldScreen.m_100906_($$0.m_78283_(LevelResource.f_78180_), this.f_101693_);
                if ($$3.f_244272_().m_247070_()) {
                    this.f_101693_.m_91152_(new ConfirmScreen(p_275882_ -> this.f_101693_.m_91152_(p_275882_ ? CreateWorldScreen.m_275847_(this.f_101693_, this.f_101694_, $$2, $$3, $$4) : this.f_101694_), Component.m_237115_("selectWorld.recreate.customized.title"), Component.m_237115_("selectWorld.recreate.customized.text"), CommonComponents.f_130659_, CommonComponents.f_130656_));
                } else {
                    this.f_101693_.m_91152_(CreateWorldScreen.m_275847_(this.f_101693_, this.f_101694_, $$2, $$3, $$4));
                }
            }
            catch (ContentValidationException $$5) {
                f_101645_.warn("{}", (Object)$$5.getMessage());
                this.f_101693_.m_91152_(NoticeWithLinkScreen.m_293051_(this.f_101694_));
            }
            catch (Exception $$6) {
                f_101645_.error("Unable to recreate world", (Throwable)$$6);
                this.f_101693_.m_91152_(new AlertScreen(() -> this.f_101693_.m_91152_(this.f_101694_), Component.m_237115_("selectWorld.recreate.error.title"), Component.m_237115_("selectWorld.recreate.error.text")));
            }
        }

        private void m_101744_() {
            this.f_101693_.m_91106_().m_120367_(SimpleSoundInstance.m_263171_(SoundEvents.f_12490_, 1.0f));
            if (this.f_101693_.m_91392_().m_78255_(this.f_101695_.m_78358_())) {
                this.m_101745_();
                this.f_101693_.m_231466_().m_233133_(this.f_101694_, this.f_101695_.m_78358_());
            }
        }

        private void m_101745_() {
            this.f_101693_.m_91346_(new GenericDirtMessageScreen(Component.m_237115_("selectWorld.data_read")));
        }

        private void m_101746_() {
            boolean $$0;
            boolean bl = $$0 = this.f_101697_ != null && Files.isRegularFile(this.f_101697_, new LinkOption[0]);
            if ($$0) {
                try (InputStream $$1 = Files.newInputStream(this.f_101697_, new OpenOption[0]);){
                    this.f_101698_.m_289201_(NativeImage.m_85058_($$1));
                }
                catch (Throwable $$2) {
                    f_101645_.error("Invalid icon for world {}", (Object)this.f_101695_.m_78358_(), (Object)$$2);
                    this.f_101697_ = null;
                }
            } else {
                this.f_101698_.m_289218_();
            }
        }

        @Override
        public void close() {
            this.f_101698_.close();
        }

        public String m_170324_() {
            return this.f_101695_.m_78361_();
        }

        @Override
        public boolean m_214209_() {
            return !this.f_101695_.m_164916_();
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        public abstract boolean m_214209_();

        @Override
        public void close() {
        }
    }
}

