/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.packs;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class PackSelectionScreen
extends Screen {
    static final Logger f_99969_ = LogUtils.getLogger();
    private static final int f_169993_ = 200;
    private static final Component f_99970_ = Component.m_237115_("pack.dropInfo").m_130940_(ChatFormatting.GRAY);
    private static final Component f_99971_ = Component.m_237115_("pack.folderInfo");
    private static final int f_169994_ = 20;
    private static final ResourceLocation f_99972_ = new ResourceLocation("textures/misc/unknown_pack.png");
    private final PackSelectionModel f_99973_;
    @Nullable
    private Watcher f_99975_;
    private long f_99976_;
    private TransferableSelectionList f_99977_;
    private TransferableSelectionList f_99978_;
    private final Path f_99979_;
    private Button f_99980_;
    private final Map<String, ResourceLocation> f_99981_ = Maps.newHashMap();

    public PackSelectionScreen(PackRepository p_275398_, Consumer<PackRepository> p_275659_, Path p_275522_, Component p_275337_) {
        super(p_275337_);
        this.f_99973_ = new PackSelectionModel(this::m_100040_, this::m_99989_, p_275398_, p_275659_);
        this.f_99979_ = p_275522_;
        this.f_99975_ = Watcher.m_245748_(p_275522_);
    }

    @Override
    public void m_7379_() {
        this.f_99973_.m_99923_();
        this.m_100039_();
    }

    private void m_100039_() {
        if (this.f_99975_ != null) {
            try {
                this.f_99975_.close();
                this.f_99975_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void m_7856_() {
        this.f_99977_ = new TransferableSelectionList(this.f_96541_, this, 200, this.f_96544_, Component.m_237115_("pack.available.title"));
        this.f_99977_.m_93507_(this.f_96543_ / 2 - 4 - 200);
        this.m_7787_(this.f_99977_);
        this.f_99978_ = new TransferableSelectionList(this.f_96541_, this, 200, this.f_96544_, Component.m_237115_("pack.selected.title"));
        this.f_99978_.m_93507_(this.f_96543_ / 2 + 4);
        this.m_7787_(this.f_99978_);
        this.m_142416_(Button.m_253074_(Component.m_237115_("pack.openFolder"), p_100004_ -> Util.m_137581_().m_137648_(this.f_99979_.toUri())).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 48, 150, 20).m_257505_(Tooltip.m_257550_(f_99971_)).m_253136_());
        this.f_99980_ = this.m_142416_(Button.m_253074_(CommonComponents.f_130655_, p_100036_ -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 48, 150, 20).m_253136_());
        this.m_100041_();
    }

    @Override
    public void m_86600_() {
        if (this.f_99975_ != null) {
            try {
                if (this.f_99975_.m_100046_()) {
                    this.f_99976_ = 20L;
                }
            }
            catch (IOException $$0) {
                f_99969_.warn("Failed to poll for directory {} changes, stopping", (Object)this.f_99979_);
                this.m_100039_();
            }
        }
        if (this.f_99976_ > 0L && --this.f_99976_ == 0L) {
            this.m_100041_();
        }
    }

    private void m_100040_() {
        this.m_100013_(this.f_99978_, this.f_99973_.m_99918_());
        this.m_100013_(this.f_99977_, this.f_99973_.m_99913_());
        this.f_99980_.f_93623_ = !this.f_99978_.m_6702_().isEmpty();
    }

    private void m_100013_(TransferableSelectionList p_100014_, Stream<PackSelectionModel.Entry> p_100015_) {
        p_100014_.m_6702_().clear();
        TransferableSelectionList.PackEntry $$2 = (TransferableSelectionList.PackEntry)p_100014_.m_93511_();
        String $$3 = $$2 == null ? "" : $$2.m_264411_();
        p_100014_.m_6987_(null);
        p_100015_.forEach(p_280875_ -> {
            TransferableSelectionList.PackEntry $$3 = new TransferableSelectionList.PackEntry(this.f_96541_, p_100014_, (PackSelectionModel.Entry)p_280875_);
            p_100014_.m_6702_().add($$3);
            if (p_280875_.m_264249_().equals($$3)) {
                p_100014_.m_6987_($$3);
            }
        });
    }

    public void m_264285_(TransferableSelectionList p_265419_) {
        TransferableSelectionList $$1 = this.f_99978_ == p_265419_ ? this.f_99977_ : this.f_99978_;
        this.m_264158_(ComponentPath.m_264492_($$1.m_264567_(), new ContainerEventHandler[]{$$1, this}));
    }

    public void m_264462_() {
        this.f_99978_.m_6987_(null);
        this.f_99977_.m_6987_(null);
    }

    private void m_100041_() {
        this.f_99973_.m_99926_();
        this.m_100040_();
        this.f_99976_ = 0L;
        this.f_99981_.clear();
    }

    @Override
    public void m_88315_(GuiGraphics p_281318_, int p_99996_, int p_99997_, float p_99998_) {
        super.m_88315_(p_281318_, p_99996_, p_99997_, p_99998_);
        this.f_99977_.m_88315_(p_281318_, p_99996_, p_99997_, p_99998_);
        this.f_99978_.m_88315_(p_281318_, p_99996_, p_99997_, p_99998_);
        p_281318_.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        p_281318_.m_280653_(this.f_96547_, f_99970_, this.f_96543_ / 2, 20, 0xFFFFFF);
    }

    @Override
    public void m_280273_(GuiGraphics p_299682_, int p_301154_, int p_300727_, float p_298616_) {
        this.m_280039_(p_299682_);
    }

    protected static void m_99999_(Minecraft p_100000_, List<Path> p_100001_, Path p_100002_) {
        MutableBoolean $$3 = new MutableBoolean();
        p_100001_.forEach(p_170009_ -> {
            try (Stream<Path> $$3 = Files.walk(p_170009_, new FileVisitOption[0]);){
                $$3.forEach(p_170005_ -> {
                    try {
                        Util.m_137563_(p_170009_.getParent(), p_100002_, p_170005_);
                    }
                    catch (IOException $$4) {
                        f_99969_.warn("Failed to copy datapack file  from {} to {}", new Object[]{p_170005_, p_100002_, $$4});
                        $$3.setTrue();
                    }
                });
            }
            catch (IOException $$4) {
                f_99969_.warn("Failed to copy datapack file from {} to {}", p_170009_, (Object)p_100002_);
                $$3.setTrue();
            }
        });
        if ($$3.isTrue()) {
            SystemToast.m_94875_(p_100000_, p_100002_.toString());
        }
    }

    @Override
    public void m_7400_(List<Path> p_100029_) {
        String $$1 = PackSelectionScreen.m_293618_(p_100029_).collect(Collectors.joining(", "));
        this.f_96541_.m_91152_(new ConfirmScreen(p_296193_ -> {
            if (p_296193_) {
                ArrayList<Path> $$2 = new ArrayList<Path>(p_100029_.size());
                HashSet<Path> $$3 = new HashSet<Path>(p_100029_);
                PackDetector<Path> $$4 = new PackDetector<Path>(this.f_96541_.m_294312_()){

                    @Override
                    protected Path m_292901_(Path p_298689_) {
                        return p_298689_;
                    }

                    @Override
                    protected Path m_293354_(Path p_298650_) {
                        return p_298650_;
                    }

                    @Override
                    protected /* synthetic */ Object m_293354_(Path path) throws IOException {
                        return this.m_293354_(path);
                    }

                    @Override
                    protected /* synthetic */ Object m_292901_(Path path) throws IOException {
                        return this.m_292901_(path);
                    }
                };
                ArrayList<ForbiddenSymlinkInfo> $$5 = new ArrayList<ForbiddenSymlinkInfo>();
                for (Path $$6 : p_100029_) {
                    try {
                        Path $$7 = (Path)$$4.m_293433_($$6, $$5);
                        if ($$7 == null) {
                            f_99969_.warn("Path {} does not seem like pack", (Object)$$6);
                            continue;
                        }
                        $$2.add($$7);
                        $$3.remove($$7);
                    }
                    catch (IOException $$8) {
                        f_99969_.warn("Failed to check {} for packs", (Object)$$6, (Object)$$8);
                    }
                }
                if (!$$5.isEmpty()) {
                    this.f_96541_.m_91152_(NoticeWithLinkScreen.m_295935_(this));
                    return;
                }
                if (!$$2.isEmpty()) {
                    PackSelectionScreen.m_99999_(this.f_96541_, $$2, this.f_99979_);
                    this.m_100041_();
                }
                if (!$$3.isEmpty()) {
                    String $$9 = PackSelectionScreen.m_293618_($$3).collect(Collectors.joining(", "));
                    this.f_96541_.m_91152_(new AlertScreen(() -> this.f_96541_.m_91152_(this), Component.m_237115_("pack.dropRejected.title"), Component.m_237110_("pack.dropRejected.message", $$9)));
                    return;
                }
            }
            this.f_96541_.m_91152_(this);
        }, Component.m_237115_("pack.dropConfirm"), Component.m_237113_($$1)));
    }

    private static Stream<String> m_293618_(Collection<Path> p_300507_) {
        return p_300507_.stream().map(Path::getFileName).map(Path::toString);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ResourceLocation m_100016_(TextureManager p_100017_, Pack p_100018_) {
        try (PackResources $$2 = p_100018_.m_10445_();){
            ResourceLocation resourceLocation;
            block16: {
                IoSupplier<InputStream> $$3 = $$2.m_8017_("pack.png");
                if ($$3 == null) {
                    ResourceLocation resourceLocation2 = f_99972_;
                    return resourceLocation2;
                }
                String $$4 = p_100018_.m_10446_();
                ResourceLocation $$5 = new ResourceLocation("minecraft", "pack/" + Util.m_137483_($$4, ResourceLocation::m_135828_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)$$4) + "/icon");
                InputStream $$6 = $$3.m_247737_();
                try {
                    NativeImage $$7 = NativeImage.m_85058_($$6);
                    p_100017_.m_118495_($$5, new DynamicTexture($$7));
                    resourceLocation = $$5;
                    if ($$6 == null) break block16;
                }
                catch (Throwable throwable) {
                    if ($$6 != null) {
                        try {
                            $$6.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                $$6.close();
            }
            return resourceLocation;
        }
        catch (Exception $$8) {
            f_99969_.warn("Failed to load icon from pack {}", (Object)p_100018_.m_10446_(), (Object)$$8);
            return f_99972_;
        }
    }

    private ResourceLocation m_99989_(Pack p_99990_) {
        return this.f_99981_.computeIfAbsent(p_99990_.m_10446_(), p_280879_ -> this.m_100016_(this.f_96541_.m_91097_(), p_99990_));
    }

    static class Watcher
    implements AutoCloseable {
        private final WatchService f_100042_;
        private final Path f_100043_;

        public Watcher(Path p_250327_) throws IOException {
            this.f_100043_ = p_250327_;
            this.f_100042_ = p_250327_.getFileSystem().newWatchService();
            try {
                this.m_100049_(p_250327_);
                try (DirectoryStream<Path> $$1 = Files.newDirectoryStream(p_250327_);){
                    for (Path $$2 : $$1) {
                        if (!Files.isDirectory($$2, LinkOption.NOFOLLOW_LINKS)) continue;
                        this.m_100049_($$2);
                    }
                }
            }
            catch (Exception $$3) {
                this.f_100042_.close();
                throw $$3;
            }
        }

        @Nullable
        public static Watcher m_245748_(Path p_252119_) {
            try {
                return new Watcher(p_252119_);
            }
            catch (IOException $$1) {
                f_99969_.warn("Failed to initialize pack directory {} monitoring", (Object)p_252119_, (Object)$$1);
                return null;
            }
        }

        private void m_100049_(Path p_100050_) throws IOException {
            p_100050_.register(this.f_100042_, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        public boolean m_100046_() throws IOException {
            WatchKey $$1;
            boolean $$0 = false;
            while (($$1 = this.f_100042_.poll()) != null) {
                List<WatchEvent<?>> $$2 = $$1.pollEvents();
                for (WatchEvent<?> $$3 : $$2) {
                    Path $$4;
                    $$0 = true;
                    if ($$1.watchable() != this.f_100043_ || $$3.kind() != StandardWatchEventKinds.ENTRY_CREATE || !Files.isDirectory($$4 = this.f_100043_.resolve((Path)$$3.context()), LinkOption.NOFOLLOW_LINKS)) continue;
                    this.m_100049_($$4);
                }
                $$1.reset();
            }
            return $$0;
        }

        @Override
        public void close() throws IOException {
            this.f_100042_.close();
        }
    }
}

