/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.achievement;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class StatsScreen
extends Screen
implements StatsUpdateListener {
    static final ResourceLocation f_290494_ = new ResourceLocation("container/slot");
    static final ResourceLocation f_290590_ = new ResourceLocation("statistics/header");
    static final ResourceLocation f_290511_ = new ResourceLocation("statistics/sort_up");
    static final ResourceLocation f_290818_ = new ResourceLocation("statistics/sort_down");
    private static final Component f_96897_ = Component.m_237115_("multiplayer.downloadingStats");
    static final Component f_291420_ = Component.m_237115_("stats.none");
    protected final Screen f_96896_;
    private GeneralStatisticsList f_96898_;
    ItemStatisticsList f_96899_;
    private MobsStatisticsList f_96900_;
    final StatsCounter f_96901_;
    @Nullable
    private ObjectSelectionList<?> f_96902_;
    private boolean f_96903_ = true;
    private static final int f_169490_ = 18;
    private static final int f_169491_ = 20;
    private static final int f_169492_ = 1;
    private static final int f_169493_ = 1;
    private static final int f_169494_ = 2;
    private static final int f_169495_ = 2;
    private static final int f_169484_ = 40;
    private static final int f_169485_ = 5;
    private static final int f_169486_ = 0;
    private static final int f_169487_ = -1;
    private static final int f_169488_ = 1;

    public StatsScreen(Screen p_96906_, StatsCounter p_96907_) {
        super(Component.m_237115_("gui.stats"));
        this.f_96896_ = p_96906_;
        this.f_96901_ = p_96907_;
    }

    @Override
    protected void m_7856_() {
        this.f_96903_ = true;
        this.f_96541_.m_91403_().m_295327_(new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
    }

    public void m_96972_() {
        this.f_96898_ = new GeneralStatisticsList(this.f_96541_);
        this.f_96899_ = new ItemStatisticsList(this.f_96541_);
        this.f_96900_ = new MobsStatisticsList(this.f_96541_);
    }

    public void m_96975_() {
        this.m_142416_(Button.m_253074_(Component.m_237115_("stat.generalButton"), p_96963_ -> this.m_96924_(this.f_96898_)).m_252987_(this.f_96543_ / 2 - 120, this.f_96544_ - 52, 80, 20).m_253136_());
        Button $$0 = this.m_142416_(Button.m_253074_(Component.m_237115_("stat.itemsButton"), p_96959_ -> this.m_96924_(this.f_96899_)).m_252987_(this.f_96543_ / 2 - 40, this.f_96544_ - 52, 80, 20).m_253136_());
        Button $$1 = this.m_142416_(Button.m_253074_(Component.m_237115_("stat.mobsButton"), p_96949_ -> this.m_96924_(this.f_96900_)).m_252987_(this.f_96543_ / 2 + 40, this.f_96544_ - 52, 80, 20).m_253136_());
        this.m_142416_(Button.m_253074_(CommonComponents.f_130655_, p_280843_ -> this.f_96541_.m_91152_(this.f_96896_)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 28, 200, 20).m_253136_());
        if (this.f_96899_.m_6702_().isEmpty()) {
            $$0.f_93623_ = false;
        }
        if (this.f_96900_.m_6702_().isEmpty()) {
            $$1.f_93623_ = false;
        }
    }

    @Override
    public void m_88315_(GuiGraphics p_281866_, int p_96914_, int p_96915_, float p_96916_) {
        if (this.f_96903_) {
            this.m_280273_(p_281866_, p_96914_, p_96915_, p_96916_);
            p_281866_.m_280653_(this.f_96547_, f_96897_, this.f_96543_ / 2, this.f_96544_ / 2, 0xFFFFFF);
            p_281866_.m_280137_(this.f_96547_, f_97124_[(int)(Util.m_137550_() / 150L % (long)f_97124_.length)], this.f_96543_ / 2, this.f_96544_ / 2 + this.f_96547_.f_92710_ * 2, 0xFFFFFF);
        } else {
            super.m_88315_(p_281866_, p_96914_, p_96915_, p_96916_);
            this.m_96983_().m_88315_(p_281866_, p_96914_, p_96915_, p_96916_);
            p_281866_.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        }
    }

    @Override
    public void m_280273_(GuiGraphics p_299638_, int p_297645_, int p_299202_, float p_301378_) {
        this.m_280039_(p_299638_);
    }

    @Override
    public void m_7819_() {
        if (this.f_96903_) {
            this.m_96972_();
            this.m_96975_();
            this.m_96924_(this.f_96898_);
            this.f_96903_ = false;
        }
    }

    @Override
    public boolean m_7043_() {
        return !this.f_96903_;
    }

    @Nullable
    public ObjectSelectionList<?> m_96983_() {
        return this.f_96902_;
    }

    public void m_96924_(@Nullable ObjectSelectionList<?> p_96925_) {
        if (this.f_96902_ != null) {
            this.m_169411_(this.f_96902_);
        }
        if (p_96925_ != null) {
            this.m_7787_(p_96925_);
            this.f_96902_ = p_96925_;
        }
    }

    static String m_96946_(Stat<ResourceLocation> p_96947_) {
        return "stat." + p_96947_.m_12867_().toString().replace(':', '.');
    }

    int m_96908_(int p_96909_) {
        return 115 + 40 * p_96909_;
    }

    void m_280600_(GuiGraphics p_282402_, int p_283228_, int p_283232_, Item p_282368_) {
        this.m_280288_(p_282402_, p_283228_ + 1, p_283232_ + 1, f_290494_);
        p_282402_.m_280203_(p_282368_.m_7968_(), p_283228_ + 2, p_283232_ + 2);
    }

    void m_280288_(GuiGraphics p_281402_, int p_283145_, int p_283100_, ResourceLocation p_299088_) {
        p_281402_.m_295520_(p_299088_, p_283145_, p_283100_, 0, 18, 18);
    }

    class GeneralStatisticsList
    extends ObjectSelectionList<Entry> {
        public GeneralStatisticsList(Minecraft p_96995_) {
            super(p_96995_, StatsScreen.this.f_96543_, StatsScreen.this.f_96544_, 32, StatsScreen.this.f_96544_ - 64, 10);
            ObjectArrayList $$1 = new ObjectArrayList(Stats.f_12988_.iterator());
            $$1.sort(Comparator.comparing(p_96997_ -> I18n.m_118938_(StatsScreen.m_96946_(p_96997_), new Object[0])));
            for (Stat $$2 : $$1) {
                this.m_7085_(new Entry($$2));
            }
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final Stat<ResourceLocation> f_97001_;
            private final Component f_97002_;

            Entry(Stat<ResourceLocation> p_97005_) {
                this.f_97001_ = p_97005_;
                this.f_97002_ = Component.m_237115_(StatsScreen.m_96946_(p_97005_));
            }

            private String m_169513_() {
                return this.f_97001_.m_12860_(StatsScreen.this.f_96901_.m_13015_(this.f_97001_));
            }

            @Override
            public void m_6311_(GuiGraphics p_283043_, int p_97012_, int p_97013_, int p_97014_, int p_97015_, int p_97016_, int p_97017_, int p_97018_, boolean p_97019_, float p_97020_) {
                p_283043_.m_280430_(StatsScreen.this.f_96547_, this.f_97002_, p_97014_ + 2, p_97013_ + 1, p_97012_ % 2 == 0 ? 0xFFFFFF : 0x909090);
                String $$10 = this.m_169513_();
                p_283043_.m_280488_(StatsScreen.this.f_96547_, $$10, p_97014_ + 2 + 213 - StatsScreen.this.f_96547_.m_92895_($$10), p_97013_ + 1, p_97012_ % 2 == 0 ? 0xFFFFFF : 0x909090);
            }

            @Override
            public Component m_142172_() {
                return Component.m_237110_("narrator.select", Component.m_237119_().m_7220_(this.f_97002_).m_7220_(CommonComponents.f_263701_).m_130946_(this.m_169513_()));
            }
        }
    }

    class ItemStatisticsList
    extends ObjectSelectionList<ItemRow> {
        protected final List<StatType<Block>> f_97021_;
        protected final List<StatType<Item>> f_97022_;
        private final ResourceLocation[] f_291724_;
        protected int f_97023_;
        protected final Comparator<ItemRow> f_97025_;
        @Nullable
        protected StatType<?> f_97026_;
        protected int f_97027_;

        public ItemStatisticsList(Minecraft p_97032_) {
            super(p_97032_, StatsScreen.this.f_96543_, StatsScreen.this.f_96544_, 32, StatsScreen.this.f_96544_ - 64, 20);
            this.f_291724_ = new ResourceLocation[]{new ResourceLocation("statistics/block_mined"), new ResourceLocation("statistics/item_broken"), new ResourceLocation("statistics/item_crafted"), new ResourceLocation("statistics/item_used"), new ResourceLocation("statistics/item_picked_up"), new ResourceLocation("statistics/item_dropped")};
            this.f_97023_ = -1;
            this.f_97025_ = new ItemRowComparator();
            this.f_97021_ = Lists.newArrayList();
            this.f_97021_.add(Stats.f_12949_);
            this.f_97022_ = Lists.newArrayList((Object[])new StatType[]{Stats.f_12983_, Stats.f_12981_, Stats.f_12982_, Stats.f_12984_, Stats.f_12985_});
            this.m_93473_(true, 20);
            Set $$1 = Sets.newIdentityHashSet();
            for (Item $$2 : BuiltInRegistries.f_257033_) {
                boolean $$3 = false;
                for (StatType<Item> statType : this.f_97022_) {
                    if (!statType.m_12897_($$2) || StatsScreen.this.f_96901_.m_13015_(statType.m_12902_($$2)) <= 0) continue;
                    $$3 = true;
                }
                if (!$$3) continue;
                $$1.add($$2);
            }
            for (Block $$5 : BuiltInRegistries.f_256975_) {
                boolean $$6 = false;
                for (StatType<FeatureElement> statType : this.f_97021_) {
                    if (!statType.m_12897_($$5) || StatsScreen.this.f_96901_.m_13015_(statType.m_12902_($$5)) <= 0) continue;
                    $$6 = true;
                }
                if (!$$6) continue;
                $$1.add($$5.m_5456_());
            }
            $$1.remove(Items.f_41852_);
            for (Item $$8 : $$1) {
                this.m_7085_(new ItemRow($$8));
            }
        }

        @Override
        protected void m_7415_(GuiGraphics p_282214_, int p_97050_, int p_97051_) {
            if (!this.f_93386_.f_91067_.m_91560_()) {
                this.f_97023_ = -1;
            }
            for (int $$3 = 0; $$3 < this.f_291724_.length; ++$$3) {
                ResourceLocation $$4 = this.f_97023_ == $$3 ? f_290494_ : f_290590_;
                StatsScreen.this.m_280288_(p_282214_, p_97050_ + StatsScreen.this.m_96908_($$3) - 18, p_97051_ + 1, $$4);
            }
            if (this.f_97026_ != null) {
                int $$5 = StatsScreen.this.m_96908_(this.m_97058_(this.f_97026_)) - 36;
                ResourceLocation $$6 = this.f_97027_ == 1 ? f_290511_ : f_290818_;
                StatsScreen.this.m_280288_(p_282214_, p_97050_ + $$5, p_97051_ + 1, $$6);
            }
            for (int $$7 = 0; $$7 < this.f_291724_.length; ++$$7) {
                int $$8 = this.f_97023_ == $$7 ? 1 : 0;
                StatsScreen.this.m_280288_(p_282214_, p_97050_ + StatsScreen.this.m_96908_($$7) - 18 + $$8, p_97051_ + 1 + $$8, this.f_291724_[$$7]);
            }
        }

        @Override
        public int m_5759_() {
            return 375;
        }

        @Override
        protected int m_5756_() {
            return this.f_93388_ / 2 + 140;
        }

        @Override
        protected void m_6205_(int p_97036_, int p_97037_) {
            this.f_97023_ = -1;
            for (int $$2 = 0; $$2 < this.f_291724_.length; ++$$2) {
                int $$3 = p_97036_ - StatsScreen.this.m_96908_($$2);
                if ($$3 < -36 || $$3 > 0) continue;
                this.f_97023_ = $$2;
                break;
            }
            if (this.f_97023_ >= 0) {
                this.m_97038_(this.m_97033_(this.f_97023_));
                this.f_93386_.m_91106_().m_120367_(SimpleSoundInstance.m_263171_(SoundEvents.f_12490_, 1.0f));
            }
        }

        private StatType<?> m_97033_(int p_97034_) {
            return p_97034_ < this.f_97021_.size() ? this.f_97021_.get(p_97034_) : this.f_97022_.get(p_97034_ - this.f_97021_.size());
        }

        private int m_97058_(StatType<?> p_97059_) {
            int $$1 = this.f_97021_.indexOf(p_97059_);
            if ($$1 >= 0) {
                return $$1;
            }
            int $$2 = this.f_97022_.indexOf(p_97059_);
            if ($$2 >= 0) {
                return $$2 + this.f_97021_.size();
            }
            return -1;
        }

        @Override
        protected void m_7154_(GuiGraphics p_283203_, int p_97046_, int p_97047_) {
            if (p_97047_ < this.f_93390_ || p_97047_ > this.f_93391_) {
                return;
            }
            ItemRow $$3 = (ItemRow)this.m_168795_();
            int $$4 = (this.f_93388_ - this.m_5759_()) / 2;
            if ($$3 != null) {
                if (p_97046_ < $$4 + 40 || p_97046_ > $$4 + 40 + 20) {
                    return;
                }
                Item $$5 = $$3.m_169519_();
                p_283203_.m_280557_(StatsScreen.this.f_96547_, this.m_97040_($$5), p_97046_, p_97047_);
            } else {
                Component $$6 = null;
                int $$7 = p_97046_ - $$4;
                for (int $$8 = 0; $$8 < this.f_291724_.length; ++$$8) {
                    int $$9 = StatsScreen.this.m_96908_($$8);
                    if ($$7 < $$9 - 18 || $$7 > $$9) continue;
                    $$6 = this.m_97033_($$8).m_12905_();
                    break;
                }
                if ($$6 != null) {
                    p_283203_.m_280557_(StatsScreen.this.f_96547_, $$6, p_97046_, p_97047_);
                }
            }
        }

        protected Component m_97040_(Item p_97041_) {
            return p_97041_.m_41466_();
        }

        protected void m_97038_(StatType<?> p_97039_) {
            if (p_97039_ != this.f_97026_) {
                this.f_97026_ = p_97039_;
                this.f_97027_ = -1;
            } else if (this.f_97027_ == -1) {
                this.f_97027_ = 1;
            } else {
                this.f_97026_ = null;
                this.f_97027_ = 0;
            }
            this.m_6702_().sort(this.f_97025_);
        }

        class ItemRowComparator
        implements Comparator<ItemRow> {
            ItemRowComparator() {
            }

            @Override
            public int compare(ItemRow p_169524_, ItemRow p_169525_) {
                int $$11;
                int $$10;
                Item $$2 = p_169524_.m_169519_();
                Item $$3 = p_169525_.m_169519_();
                if (ItemStatisticsList.this.f_97026_ == null) {
                    boolean $$4 = false;
                    boolean $$5 = false;
                } else if (ItemStatisticsList.this.f_97021_.contains(ItemStatisticsList.this.f_97026_)) {
                    StatType<?> $$6 = ItemStatisticsList.this.f_97026_;
                    int $$7 = $$2 instanceof BlockItem ? StatsScreen.this.f_96901_.m_13017_($$6, ((BlockItem)$$2).m_40614_()) : -1;
                    int $$8 = $$3 instanceof BlockItem ? StatsScreen.this.f_96901_.m_13017_($$6, ((BlockItem)$$3).m_40614_()) : -1;
                } else {
                    StatType<?> $$9 = ItemStatisticsList.this.f_97026_;
                    $$10 = StatsScreen.this.f_96901_.m_13017_($$9, $$2);
                    $$11 = StatsScreen.this.f_96901_.m_13017_($$9, $$3);
                }
                if ($$10 == $$11) {
                    return ItemStatisticsList.this.f_97027_ * Integer.compare(Item.m_41393_($$2), Item.m_41393_($$3));
                }
                return ItemStatisticsList.this.f_97027_ * Integer.compare($$10, $$11);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((ItemRow)object, (ItemRow)object2);
            }
        }

        class ItemRow
        extends ObjectSelectionList.Entry<ItemRow> {
            private final Item f_169514_;

            ItemRow(Item p_169517_) {
                this.f_169514_ = p_169517_;
            }

            public Item m_169519_() {
                return this.f_169514_;
            }

            @Override
            public void m_6311_(GuiGraphics p_283614_, int p_97082_, int p_97083_, int p_97084_, int p_97085_, int p_97086_, int p_97087_, int p_97088_, boolean p_97089_, float p_97090_) {
                StatsScreen.this.m_280600_(p_283614_, p_97084_ + 40, p_97083_, this.f_169514_);
                for (int $$10 = 0; $$10 < StatsScreen.this.f_96899_.f_97021_.size(); ++$$10) {
                    Stat<?> $$12;
                    if (this.f_169514_ instanceof BlockItem) {
                        Stat<Block> $$11 = StatsScreen.this.f_96899_.f_97021_.get($$10).m_12902_(((BlockItem)this.f_169514_).m_40614_());
                    } else {
                        $$12 = null;
                    }
                    this.m_97091_(p_283614_, $$12, p_97084_ + StatsScreen.this.m_96908_($$10), p_97083_, p_97082_ % 2 == 0);
                }
                for (int $$13 = 0; $$13 < StatsScreen.this.f_96899_.f_97022_.size(); ++$$13) {
                    this.m_97091_(p_283614_, StatsScreen.this.f_96899_.f_97022_.get($$13).m_12902_(this.f_169514_), p_97084_ + StatsScreen.this.m_96908_($$13 + StatsScreen.this.f_96899_.f_97021_.size()), p_97083_, p_97082_ % 2 == 0);
                }
            }

            protected void m_97091_(GuiGraphics p_282544_, @Nullable Stat<?> p_97093_, int p_97094_, int p_97095_, boolean p_97096_) {
                Component $$5 = p_97093_ == null ? f_291420_ : Component.m_237113_(p_97093_.m_12860_(StatsScreen.this.f_96901_.m_13015_(p_97093_)));
                p_282544_.m_280430_(StatsScreen.this.f_96547_, $$5, p_97094_ - StatsScreen.this.f_96547_.m_92852_($$5), p_97095_ + 5, p_97096_ ? 0xFFFFFF : 0x909090);
            }

            @Override
            public Component m_142172_() {
                return Component.m_237110_("narrator.select", this.f_169514_.m_41466_());
            }
        }
    }

    class MobsStatisticsList
    extends ObjectSelectionList<MobRow> {
        public MobsStatisticsList(Minecraft p_97100_) {
            super(p_97100_, StatsScreen.this.f_96543_, StatsScreen.this.f_96544_, 32, StatsScreen.this.f_96544_ - 64, ((StatsScreen)StatsScreen.this).f_96547_.f_92710_ * 4);
            for (EntityType entityType : BuiltInRegistries.f_256780_) {
                if (StatsScreen.this.f_96901_.m_13015_(Stats.f_12986_.m_12902_(entityType)) <= 0 && StatsScreen.this.f_96901_.m_13015_(Stats.f_12987_.m_12902_(entityType)) <= 0) continue;
                this.m_7085_(new MobRow(entityType));
            }
        }

        class MobRow
        extends ObjectSelectionList.Entry<MobRow> {
            private final Component f_97105_;
            private final Component f_97106_;
            private final boolean f_97107_;
            private final Component f_97108_;
            private final boolean f_97109_;

            public MobRow(EntityType<?> p_97112_) {
                this.f_97105_ = p_97112_.m_20676_();
                int $$1 = StatsScreen.this.f_96901_.m_13015_(Stats.f_12986_.m_12902_(p_97112_));
                if ($$1 == 0) {
                    this.f_97106_ = Component.m_237110_("stat_type.minecraft.killed.none", this.f_97105_);
                    this.f_97107_ = false;
                } else {
                    this.f_97106_ = Component.m_237110_("stat_type.minecraft.killed", $$1, this.f_97105_);
                    this.f_97107_ = true;
                }
                int $$2 = StatsScreen.this.f_96901_.m_13015_(Stats.f_12987_.m_12902_(p_97112_));
                if ($$2 == 0) {
                    this.f_97108_ = Component.m_237110_("stat_type.minecraft.killed_by.none", this.f_97105_);
                    this.f_97109_ = false;
                } else {
                    this.f_97108_ = Component.m_237110_("stat_type.minecraft.killed_by", this.f_97105_, $$2);
                    this.f_97109_ = true;
                }
            }

            @Override
            public void m_6311_(GuiGraphics p_283265_, int p_97115_, int p_97116_, int p_97117_, int p_97118_, int p_97119_, int p_97120_, int p_97121_, boolean p_97122_, float p_97123_) {
                p_283265_.m_280430_(StatsScreen.this.f_96547_, this.f_97105_, p_97117_ + 2, p_97116_ + 1, 0xFFFFFF);
                p_283265_.m_280430_(StatsScreen.this.f_96547_, this.f_97106_, p_97117_ + 2 + 10, p_97116_ + 1 + ((StatsScreen)StatsScreen.this).f_96547_.f_92710_, this.f_97107_ ? 0x909090 : 0x606060);
                p_283265_.m_280430_(StatsScreen.this.f_96547_, this.f_97108_, p_97117_ + 2 + 10, p_97116_ + 1 + ((StatsScreen)StatsScreen.this).f_96547_.f_92710_ * 2, this.f_97109_ ? 0x909090 : 0x606060);
            }

            @Override
            public Component m_142172_() {
                return Component.m_237110_("narrator.select", CommonComponents.m_267603_(this.f_97106_, this.f_97108_));
            }
        }
    }
}

