/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.TabOrderedElement;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.ScreenNarrationCollector;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.slf4j.Logger;

public abstract class Screen
extends AbstractContainerEventHandler
implements Renderable {
    private static final Logger f_96536_ = LogUtils.getLogger();
    private static final Set<String> f_96537_ = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private static final Component f_169367_ = Component.m_237115_("narrator.screen.usage");
    public static final ResourceLocation f_279548_ = new ResourceLocation("textures/gui/options_background.png");
    protected final Component f_96539_;
    private final List<GuiEventListener> f_96540_ = Lists.newArrayList();
    private final List<NarratableEntry> f_169368_ = Lists.newArrayList();
    @Nullable
    protected Minecraft f_96541_;
    private boolean f_267454_;
    public int f_96543_;
    public int f_96544_;
    private final List<Renderable> f_169369_ = Lists.newArrayList();
    protected Font f_96547_;
    @Nullable
    private URI f_96538_;
    private static final long f_169370_;
    private static final long f_169371_;
    private static final long f_169372_ = 750L;
    private static final long f_169373_ = 200L;
    private static final long f_169374_ = 200L;
    private final ScreenNarrationCollector f_169375_ = new ScreenNarrationCollector();
    private long f_169376_ = Long.MIN_VALUE;
    private long f_169377_ = Long.MAX_VALUE;
    @Nullable
    private NarratableEntry f_169365_;
    @Nullable
    private DeferredTooltipRendering f_262730_;
    protected final Executor f_289574_ = p_289626_ -> this.f_96541_.execute(() -> {
        if (this.f_96541_.f_91080_ == this) {
            p_289626_.run();
        }
    });

    protected Screen(Component p_96550_) {
        this.f_96539_ = p_96550_;
    }

    public Component m_96636_() {
        return this.f_96539_;
    }

    public Component m_142562_() {
        return this.m_96636_();
    }

    public final void m_280264_(GuiGraphics p_282345_, int p_283456_, int p_283586_, float p_282339_) {
        this.m_88315_(p_282345_, p_283456_, p_283586_, p_282339_);
        if (this.f_262730_ != null) {
            p_282345_.m_280547_(this.f_96547_, this.f_262730_.f_262736_(), this.f_262730_.f_262758_(), p_283456_, p_283586_);
            this.f_262730_ = null;
        }
    }

    @Override
    public void m_88315_(GuiGraphics p_281549_, int p_281550_, int p_282878_, float p_282465_) {
        this.m_280273_(p_281549_, p_281550_, p_282878_, p_282465_);
        for (Renderable $$4 : this.f_169369_) {
            $$4.m_88315_(p_281549_, p_281550_, p_282878_, p_282465_);
        }
    }

    @Override
    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        FocusNavigationEvent.TabNavigation $$3;
        if (p_96552_ == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (super.m_7933_(p_96552_, p_96553_, p_96554_)) {
            return true;
        }
        switch (p_96552_) {
            case 263: {
                Record record = this.m_264409_(ScreenDirection.LEFT);
                break;
            }
            case 262: {
                Record record = this.m_264409_(ScreenDirection.RIGHT);
                break;
            }
            case 265: {
                Record record = this.m_264409_(ScreenDirection.UP);
                break;
            }
            case 264: {
                Record record = this.m_264409_(ScreenDirection.DOWN);
                break;
            }
            case 258: {
                Record record = this.m_264442_();
                break;
            }
            default: {
                Record record = $$3 = null;
            }
        }
        if ($$3 != null) {
            ComponentPath $$4 = super.m_264064_($$3);
            if ($$4 == null && $$3 instanceof FocusNavigationEvent.TabNavigation) {
                this.m_264131_();
                $$4 = super.m_264064_($$3);
            }
            if ($$4 != null) {
                this.m_264158_($$4);
            }
        }
        return false;
    }

    private FocusNavigationEvent.TabNavigation m_264442_() {
        boolean $$0 = !Screen.m_96638_();
        return new FocusNavigationEvent.TabNavigation($$0);
    }

    private FocusNavigationEvent.ArrowNavigation m_264409_(ScreenDirection p_265049_) {
        return new FocusNavigationEvent.ArrowNavigation(p_265049_);
    }

    protected void m_264313_(GuiEventListener p_265756_) {
        ComponentPath $$1 = ComponentPath.m_264334_(this, p_265756_.m_264064_(new FocusNavigationEvent.InitialFocus()));
        if ($$1 != null) {
            this.m_264158_($$1);
        }
    }

    private void m_264131_() {
        ComponentPath $$0 = this.m_264435_();
        if ($$0 != null) {
            $$0.m_264432_(false);
        }
    }

    @VisibleForTesting
    protected void m_264158_(ComponentPath p_265308_) {
        this.m_264131_();
        p_265308_.m_264432_(true);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(null);
    }

    protected <T extends GuiEventListener & Renderable> T m_142416_(T p_169406_) {
        this.f_169369_.add(p_169406_);
        return this.m_7787_(p_169406_);
    }

    protected <T extends Renderable> T m_169394_(T p_254514_) {
        this.f_169369_.add(p_254514_);
        return p_254514_;
    }

    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T p_96625_) {
        this.f_96540_.add(p_96625_);
        this.f_169368_.add(p_96625_);
        return p_96625_;
    }

    protected void m_169411_(GuiEventListener p_169412_) {
        if (p_169412_ instanceof Renderable) {
            this.f_169369_.remove((Renderable)((Object)p_169412_));
        }
        if (p_169412_ instanceof NarratableEntry) {
            this.f_169368_.remove((NarratableEntry)((Object)p_169412_));
        }
        this.f_96540_.remove(p_169412_);
    }

    protected void m_169413_() {
        this.f_169369_.clear();
        this.f_96540_.clear();
        this.f_169368_.clear();
    }

    public static List<Component> m_280152_(Minecraft p_281881_, ItemStack p_282833_) {
        return p_282833_.m_41651_(p_281881_.f_91074_, p_281881_.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_);
    }

    protected void m_6697_(String p_96587_, boolean p_96588_) {
    }

    public boolean m_5561_(@Nullable Style p_96592_) {
        if (p_96592_ == null) {
            return false;
        }
        ClickEvent $$1 = p_96592_.m_131182_();
        if (Screen.m_96638_()) {
            if (p_96592_.m_131189_() != null) {
                this.m_6697_(p_96592_.m_131189_(), false);
            }
        } else if ($$1 != null) {
            block24: {
                if ($$1.m_130622_() == ClickEvent.Action.OPEN_URL) {
                    if (!this.f_96541_.f_91066_.m_231815_().m_231551_().booleanValue()) {
                        return false;
                    }
                    try {
                        URI $$2 = new URI($$1.m_130623_());
                        String $$3 = $$2.getScheme();
                        if ($$3 == null) {
                            throw new URISyntaxException($$1.m_130623_(), "Missing protocol");
                        }
                        if (!f_96537_.contains($$3.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException($$1.m_130623_(), "Unsupported protocol: " + $$3.toLowerCase(Locale.ROOT));
                        }
                        if (this.f_96541_.f_91066_.m_231816_().m_231551_().booleanValue()) {
                            this.f_96538_ = $$2;
                            this.f_96541_.m_91152_(new ConfirmLinkScreen(this::m_96622_, $$1.m_130623_(), false));
                            break block24;
                        }
                        this.m_96589_($$2);
                    }
                    catch (URISyntaxException $$4) {
                        f_96536_.error("Can't open url for {}", (Object)$$1, (Object)$$4);
                    }
                } else if ($$1.m_130622_() == ClickEvent.Action.OPEN_FILE) {
                    URI $$5 = new File($$1.m_130623_()).toURI();
                    this.m_96589_($$5);
                } else if ($$1.m_130622_() == ClickEvent.Action.SUGGEST_COMMAND) {
                    this.m_6697_(SharedConstants.m_136190_($$1.m_130623_()), true);
                } else if ($$1.m_130622_() == ClickEvent.Action.RUN_COMMAND) {
                    String $$6 = SharedConstants.m_136190_($$1.m_130623_());
                    if ($$6.startsWith("/")) {
                        if (!this.f_96541_.f_91074_.f_108617_.m_246979_($$6.substring(1))) {
                            f_96536_.error("Not allowed to run command with signed argument from click event: '{}'", (Object)$$6);
                        }
                    } else {
                        f_96536_.error("Failed to run command without '/' prefix from click event: '{}'", (Object)$$6);
                    }
                } else if ($$1.m_130622_() == ClickEvent.Action.COPY_TO_CLIPBOARD) {
                    this.f_96541_.f_91068_.m_90911_($$1.m_130623_());
                } else {
                    f_96536_.error("Don't know how to handle {}", (Object)$$1);
                }
            }
            return true;
        }
        return false;
    }

    public final void m_6575_(Minecraft p_96607_, int p_96608_, int p_96609_) {
        this.f_96541_ = p_96607_;
        this.f_96547_ = p_96607_.f_91062_;
        this.f_96543_ = p_96608_;
        this.f_96544_ = p_96609_;
        if (!this.f_267454_) {
            this.m_7856_();
        } else {
            this.m_267719_();
        }
        this.f_267454_ = true;
        this.m_169407_(false);
        this.m_169378_(f_169370_);
    }

    protected void m_232761_() {
        this.m_169413_();
        this.m_264131_();
        this.m_7856_();
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return this.f_96540_;
    }

    protected void m_7856_() {
    }

    public void m_86600_() {
    }

    public void m_7861_() {
    }

    public void m_274333_() {
    }

    public void m_280273_(GuiGraphics p_283688_, int p_299421_, int p_298679_, float p_297268_) {
        if (this.f_96541_.f_91073_ != null) {
            this.m_293900_(p_283688_);
        } else {
            this.m_280039_(p_283688_);
        }
    }

    public void m_293900_(GuiGraphics p_300203_) {
        p_300203_.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
    }

    public void m_280039_(GuiGraphics p_282281_) {
        p_282281_.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        int $$1 = 32;
        p_282281_.m_280398_(f_279548_, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, 32, 32);
        p_282281_.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean m_7043_() {
        return true;
    }

    private void m_96622_(boolean p_96623_) {
        if (p_96623_) {
            this.m_96589_(this.f_96538_);
        }
        this.f_96538_ = null;
        this.f_96541_.m_91152_(this);
    }

    private void m_96589_(URI p_96590_) {
        Util.m_137581_().m_137648_(p_96590_);
    }

    public static boolean m_96637_() {
        if (Minecraft.f_91002_) {
            return InputConstants.m_84830_(Minecraft.m_91087_().m_91268_().m_85439_(), 343) || InputConstants.m_84830_(Minecraft.m_91087_().m_91268_().m_85439_(), 347);
        }
        return InputConstants.m_84830_(Minecraft.m_91087_().m_91268_().m_85439_(), 341) || InputConstants.m_84830_(Minecraft.m_91087_().m_91268_().m_85439_(), 345);
    }

    public static boolean m_96638_() {
        return InputConstants.m_84830_(Minecraft.m_91087_().m_91268_().m_85439_(), 340) || InputConstants.m_84830_(Minecraft.m_91087_().m_91268_().m_85439_(), 344);
    }

    public static boolean m_96639_() {
        return InputConstants.m_84830_(Minecraft.m_91087_().m_91268_().m_85439_(), 342) || InputConstants.m_84830_(Minecraft.m_91087_().m_91268_().m_85439_(), 346);
    }

    public static boolean m_96628_(int p_96629_) {
        return p_96629_ == 88 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean m_96630_(int p_96631_) {
        return p_96631_ == 86 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean m_96632_(int p_96633_) {
        return p_96633_ == 67 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    public static boolean m_96634_(int p_96635_) {
        return p_96635_ == 65 && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }

    protected void m_267719_() {
        this.m_232761_();
    }

    public void m_6574_(Minecraft p_96575_, int p_96576_, int p_96577_) {
        this.f_96543_ = p_96576_;
        this.f_96544_ = p_96577_;
        this.m_267719_();
    }

    public static void m_96579_(Runnable p_96580_, String p_96581_, String p_96582_) {
        try {
            p_96580_.run();
        }
        catch (Throwable $$3) {
            CrashReport $$4 = CrashReport.m_127521_($$3, p_96581_);
            CrashReportCategory $$5 = $$4.m_127514_("Affected screen");
            $$5.m_128165_("Screen name", () -> p_96582_);
            throw new ReportedException($$4);
        }
    }

    protected boolean m_96583_(String p_96584_, char p_96585_, int p_96586_) {
        int $$3 = p_96584_.indexOf(58);
        int $$4 = p_96584_.indexOf(47);
        if (p_96585_ == ':') {
            return ($$4 == -1 || p_96586_ <= $$4) && $$3 == -1;
        }
        if (p_96585_ == '/') {
            return p_96586_ > $$3;
        }
        return p_96585_ == '_' || p_96585_ == '-' || p_96585_ >= 'a' && p_96585_ <= 'z' || p_96585_ >= '0' && p_96585_ <= '9' || p_96585_ == '.';
    }

    @Override
    public boolean m_5953_(double p_96595_, double p_96596_) {
        return true;
    }

    public void m_7400_(List<Path> p_96591_) {
    }

    private void m_169380_(long p_169381_, boolean p_169382_) {
        this.f_169377_ = Util.m_137550_() + p_169381_;
        if (p_169382_) {
            this.f_169376_ = Long.MIN_VALUE;
        }
    }

    private void m_169378_(long p_169379_) {
        this.f_169376_ = Util.m_137550_() + p_169379_;
    }

    public void m_169414_() {
        this.m_169380_(750L, false);
    }

    public void m_169415_() {
        this.m_169380_(200L, true);
    }

    public void m_169416_() {
        this.m_169380_(200L, true);
    }

    private boolean m_169419_() {
        return this.f_96541_.m_240477_().m_93316_();
    }

    public void m_169417_() {
        long $$0;
        if (this.m_169419_() && ($$0 = Util.m_137550_()) > this.f_169377_ && $$0 > this.f_169376_) {
            this.m_169409_(true);
            this.f_169377_ = Long.MAX_VALUE;
        }
    }

    public void m_169407_(boolean p_169408_) {
        if (this.m_169419_()) {
            this.m_169409_(p_169408_);
        }
    }

    private void m_169409_(boolean p_169410_) {
        this.f_169375_.m_169186_(this::m_142228_);
        String $$1 = this.f_169375_.m_169188_(!p_169410_);
        if (!$$1.isEmpty()) {
            this.f_96541_.m_240477_().m_93319_($$1);
        }
    }

    protected boolean m_264396_() {
        return true;
    }

    protected void m_142228_(NarrationElementOutput p_169396_) {
        p_169396_.m_169146_(NarratedElementType.TITLE, this.m_142562_());
        if (this.m_264396_()) {
            p_169396_.m_169146_(NarratedElementType.USAGE, f_169367_);
        }
        this.m_142227_(p_169396_);
    }

    protected void m_142227_(NarrationElementOutput p_169403_) {
        List $$1 = this.f_169368_.stream().filter(NarratableEntry::m_142518_).collect(Collectors.toList());
        Collections.sort($$1, Comparator.comparingInt(TabOrderedElement::m_267579_));
        NarratableSearchResult $$2 = Screen.m_169400_($$1, this.f_169365_);
        if ($$2 != null) {
            if ($$2.f_169422_.m_169123_()) {
                this.f_169365_ = $$2.f_169420_;
            }
            if ($$1.size() > 1) {
                p_169403_.m_169146_(NarratedElementType.POSITION, Component.m_237110_("narrator.position.screen", $$2.f_169421_ + 1, $$1.size()));
                if ($$2.f_169422_ == NarratableEntry.NarrationPriority.FOCUSED) {
                    p_169403_.m_169146_(NarratedElementType.USAGE, this.m_301494_());
                }
            }
            $$2.f_169420_.m_142291_(p_169403_.m_142047_());
        }
    }

    protected Component m_301494_() {
        return Component.m_237115_("narration.component_list.usage");
    }

    @Nullable
    public static NarratableSearchResult m_169400_(List<? extends NarratableEntry> p_169401_, @Nullable NarratableEntry p_169402_) {
        NarratableSearchResult $$2 = null;
        NarratableSearchResult $$3 = null;
        int $$5 = p_169401_.size();
        for (int $$4 = 0; $$4 < $$5; ++$$4) {
            NarratableEntry $$6 = p_169401_.get($$4);
            NarratableEntry.NarrationPriority $$7 = $$6.m_142684_();
            if ($$7.m_169123_()) {
                if ($$6 == p_169402_) {
                    $$3 = new NarratableSearchResult($$6, $$4, $$7);
                    continue;
                }
                return new NarratableSearchResult($$6, $$4, $$7);
            }
            if ($$7.compareTo($$2 != null ? $$2.f_169422_ : NarratableEntry.NarrationPriority.NONE) <= 0) continue;
            $$2 = new NarratableSearchResult($$6, $$4, $$7);
        }
        return $$2 != null ? $$2 : $$3;
    }

    public void m_169418_() {
        this.m_169380_(f_169371_, false);
    }

    public void m_257959_(List<FormattedCharSequence> p_259937_) {
        this.m_262861_(p_259937_, DefaultTooltipPositioner.f_262752_, true);
    }

    public void m_262861_(List<FormattedCharSequence> p_262939_, ClientTooltipPositioner p_263078_, boolean p_263107_) {
        if (this.f_262730_ == null || p_263107_) {
            this.f_262730_ = new DeferredTooltipRendering(p_262939_, p_263078_);
        }
    }

    protected void m_257404_(Component p_259986_) {
        this.m_257959_(Tooltip.m_257868_(this.f_96541_, p_259986_));
    }

    public void m_262791_(Tooltip p_262992_, ClientTooltipPositioner p_262980_, boolean p_262988_) {
        this.m_262861_(p_262992_.m_257408_(this.f_96541_), p_262980_, p_262988_);
    }

    protected static void m_202376_(AbstractWidget ... p_202377_) {
        for (AbstractWidget $$1 : p_202377_) {
            $$1.f_93624_ = false;
        }
    }

    @Override
    public ScreenRectangle m_264198_() {
        return new ScreenRectangle(0, 0, this.f_96543_, this.f_96544_);
    }

    @Nullable
    public Music m_278176_() {
        return null;
    }

    static {
        f_169371_ = f_169370_ = TimeUnit.SECONDS.toMillis(2L);
    }

    record DeferredTooltipRendering(List<FormattedCharSequence> f_262736_, ClientTooltipPositioner f_262758_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DeferredTooltipRendering.class, "tooltip;positioner", "f_262736_", "f_262758_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DeferredTooltipRendering.class, "tooltip;positioner", "f_262736_", "f_262758_"}, this);
        }

        @Override
        public final boolean equals(Object p_263099_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DeferredTooltipRendering.class, "tooltip;positioner", "f_262736_", "f_262758_"}, this, p_263099_);
        }
    }

    public static class NarratableSearchResult {
        public final NarratableEntry f_169420_;
        public final int f_169421_;
        public final NarratableEntry.NarrationPriority f_169422_;

        public NarratableSearchResult(NarratableEntry p_169424_, int p_169425_, NarratableEntry.NarrationPriority p_169426_) {
            this.f_169420_ = p_169424_;
            this.f_169421_ = p_169425_;
            this.f_169422_ = p_169426_;
        }
    }
}

