/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.debugchart.BandwidthDebugChart;
import net.minecraft.client.gui.components.debugchart.FpsDebugChart;
import net.minecraft.client.gui.components.debugchart.PingDebugChart;
import net.minecraft.client.gui.components.debugchart.TpsDebugChart;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.SampleLogger;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DebugScreenOverlay {
    private static final int f_168988_ = 0xE0E0E0;
    private static final int f_168989_ = 2;
    private static final int f_168990_ = 2;
    private static final int f_168991_ = 2;
    private static final Map<Heightmap.Types, String> f_94029_ = Util.m_137469_(new EnumMap(Heightmap.Types.class), p_94070_ -> {
        p_94070_.put(Heightmap.Types.WORLD_SURFACE_WG, "SW");
        p_94070_.put(Heightmap.Types.WORLD_SURFACE, "S");
        p_94070_.put(Heightmap.Types.OCEAN_FLOOR_WG, "OW");
        p_94070_.put(Heightmap.Types.OCEAN_FLOOR, "O");
        p_94070_.put(Heightmap.Types.MOTION_BLOCKING, "M");
        p_94070_.put(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft f_94030_;
    private final AllocationRateCalculator f_232506_;
    private final Font f_94031_;
    private HitResult f_94032_;
    private HitResult f_94033_;
    @Nullable
    private ChunkPos f_94034_;
    @Nullable
    private LevelChunk f_94035_;
    @Nullable
    private CompletableFuture<LevelChunk> f_94036_;
    private boolean f_291101_;
    private boolean f_291871_;
    private boolean f_290551_;
    private boolean f_291005_;
    private final SampleLogger f_291039_ = new SampleLogger();
    private final SampleLogger f_291524_ = new SampleLogger();
    private final SampleLogger f_290653_ = new SampleLogger();
    private final SampleLogger f_290862_ = new SampleLogger();
    private final FpsDebugChart f_291857_;
    private final TpsDebugChart f_291179_;
    private final PingDebugChart f_291349_;
    private final BandwidthDebugChart f_291508_;

    public DebugScreenOverlay(Minecraft p_94039_) {
        this.f_94030_ = p_94039_;
        this.f_232506_ = new AllocationRateCalculator();
        this.f_94031_ = p_94039_.f_91062_;
        this.f_291857_ = new FpsDebugChart(this.f_94031_, this.f_291039_);
        this.f_291179_ = new TpsDebugChart(this.f_94031_, this.f_291524_);
        this.f_291349_ = new PingDebugChart(this.f_94031_, this.f_290653_);
        this.f_291508_ = new BandwidthDebugChart(this.f_94031_, this.f_290862_);
    }

    public void m_94040_() {
        this.f_94036_ = null;
        this.f_94035_ = null;
    }

    public void m_94056_(GuiGraphics p_281427_) {
        this.f_94030_.m_91307_().m_6180_("debug");
        Entity $$1 = this.f_94030_.m_91288_();
        this.f_94032_ = $$1.m_19907_(20.0, 0.0f, false);
        this.f_94033_ = $$1.m_19907_(20.0, 0.0f, true);
        p_281427_.m_286007_(() -> {
            this.m_280186_(p_281427_);
            this.m_280532_(p_281427_);
            if (this.f_290551_) {
                int $$1 = p_281427_.m_280182_();
                int $$2 = $$1 / 2;
                this.f_291857_.m_293623_(p_281427_, 0, this.f_291857_.m_295014_($$2));
                if (this.f_94030_.m_91092_() != null) {
                    int $$3 = this.f_291179_.m_295014_($$2);
                    this.f_291179_.m_293623_(p_281427_, $$1 - $$3, $$3);
                }
            }
            if (this.f_291005_) {
                int $$4 = p_281427_.m_280182_();
                int $$5 = $$4 / 2;
                if (!this.f_94030_.m_91090_()) {
                    this.f_291508_.m_293623_(p_281427_, 0, this.f_291508_.m_295014_($$5));
                }
                int $$6 = this.f_291349_.m_295014_($$5);
                this.f_291349_.m_293623_(p_281427_, $$4 - $$6, $$6);
            }
        });
        this.f_94030_.m_91307_().m_7238_();
    }

    protected void m_280186_(GuiGraphics p_281525_) {
        List<String> $$1 = this.m_94075_();
        $$1.add("");
        boolean $$2 = this.f_94030_.m_91092_() != null;
        $$1.add("Debug charts: [F3+1] Profiler " + (this.f_291871_ ? "visible" : "hidden") + "; [F3+2] " + ($$2 ? "FPS + TPS " : "FPS ") + (this.f_290551_ ? "visible" : "hidden") + "; [F3+3] " + (!this.f_94030_.m_91090_() ? "Bandwidth + Ping" : "Ping") + (this.f_291005_ ? " visible" : " hidden"));
        $$1.add("For help: press F3 + Q");
        this.m_286013_(p_281525_, $$1, true);
    }

    protected void m_280532_(GuiGraphics p_281261_) {
        List<String> $$1 = this.m_94078_();
        this.m_286013_(p_281261_, $$1, false);
    }

    private void m_286013_(GuiGraphics p_286519_, List<String> p_286665_, boolean p_286644_) {
        int $$3 = this.f_94031_.f_92710_;
        for (int $$4 = 0; $$4 < p_286665_.size(); ++$$4) {
            String $$5 = p_286665_.get($$4);
            if (Strings.isNullOrEmpty((String)$$5)) continue;
            int $$6 = this.f_94031_.m_92895_($$5);
            int $$7 = p_286644_ ? 2 : p_286519_.m_280182_() - 2 - $$6;
            int $$8 = 2 + $$3 * $$4;
            p_286519_.m_280509_($$7 - 1, $$8 - 1, $$7 + $$6 + 1, $$8 + $$3 - 1, -1873784752);
        }
        for (int $$9 = 0; $$9 < p_286665_.size(); ++$$9) {
            String $$10 = p_286665_.get($$9);
            if (Strings.isNullOrEmpty((String)$$10)) continue;
            int $$11 = this.f_94031_.m_92895_($$10);
            int $$12 = p_286644_ ? 2 : p_286519_.m_280182_() - 2 - $$11;
            int $$13 = 2 + $$3 * $$9;
            p_286519_.m_280056_(this.f_94031_, $$10, $$12, $$13, 0xE0E0E0, false);
        }
    }

    protected List<String> m_94075_() {
        PostChain $$40;
        Level $$16;
        String $$14;
        String $$6;
        IntegratedServer $$0 = this.f_94030_.m_91092_();
        ClientPacketListener $$1 = this.f_94030_.m_91403_();
        Connection $$2 = $$1.m_104910_();
        float $$3 = $$2.m_129543_();
        float $$4 = $$2.m_129542_();
        if ($$0 != null) {
            String $$5 = String.format(Locale.ROOT, "Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf($$0.m_129903_()), Float.valueOf($$3), Float.valueOf($$4));
        } else {
            $$6 = String.format(Locale.ROOT, "\"%s\" server, %.0f tx, %.0f rx", $$1.m_295034_(), Float.valueOf($$3), Float.valueOf($$4));
        }
        BlockPos $$7 = this.f_94030_.m_91288_().m_20183_();
        if (this.f_94030_.m_91299_()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.m_183709_().m_132493_() + " (" + this.f_94030_.m_91388_() + "/" + ClientBrandRetriever.getClientModName() + ")", this.f_94030_.f_90977_, $$6, this.f_94030_.f_91060_.m_109820_(), this.f_94030_.f_91060_.m_109822_(), "P: " + this.f_94030_.f_91061_.m_107403_() + ". T: " + this.f_94030_.f_91073_.m_104813_(), this.f_94030_.f_91073_.m_46464_(), "", String.format(Locale.ROOT, "Chunk-relative: %d %d %d", $$7.m_123341_() & 0xF, $$7.m_123342_() & 0xF, $$7.m_123343_() & 0xF)});
        }
        Entity $$8 = this.f_94030_.m_91288_();
        Direction $$9 = $$8.m_6350_();
        switch ($$9) {
            case NORTH: {
                String $$10 = "Towards negative Z";
                break;
            }
            case SOUTH: {
                String $$11 = "Towards positive Z";
                break;
            }
            case WEST: {
                String $$12 = "Towards negative X";
                break;
            }
            case EAST: {
                String $$13 = "Towards positive X";
                break;
            }
            default: {
                $$14 = "Invalid";
            }
        }
        ChunkPos $$15 = new ChunkPos($$7);
        if (!Objects.equals(this.f_94034_, $$15)) {
            this.f_94034_ = $$15;
            this.m_94040_();
        }
        LongSets.EmptySet $$17 = ($$16 = this.m_94083_()) instanceof ServerLevel ? ((ServerLevel)$$16).m_8902_() : LongSets.EMPTY_SET;
        ArrayList $$18 = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.m_183709_().m_132493_() + " (" + this.f_94030_.m_91388_() + "/" + ClientBrandRetriever.getClientModName() + (String)("release".equalsIgnoreCase(this.f_94030_.m_91389_()) ? "" : "/" + this.f_94030_.m_91389_()) + ")", this.f_94030_.f_90977_, $$6, this.f_94030_.f_91060_.m_109820_(), this.f_94030_.f_91060_.m_109822_(), "P: " + this.f_94030_.f_91061_.m_107403_() + ". T: " + this.f_94030_.f_91073_.m_104813_(), this.f_94030_.f_91073_.m_46464_()});
        String $$19 = this.m_94082_();
        if ($$19 != null) {
            $$18.add($$19);
        }
        $$18.add(this.f_94030_.f_91073_.m_46472_().m_135782_() + " FC: " + $$17.size());
        $$18.add("");
        $$18.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.f_94030_.m_91288_().m_20185_(), this.f_94030_.m_91288_().m_20186_(), this.f_94030_.m_91288_().m_20189_()));
        $$18.add(String.format(Locale.ROOT, "Block: %d %d %d [%d %d %d]", $$7.m_123341_(), $$7.m_123342_(), $$7.m_123343_(), $$7.m_123341_() & 0xF, $$7.m_123342_() & 0xF, $$7.m_123343_() & 0xF));
        $$18.add(String.format(Locale.ROOT, "Chunk: %d %d %d [%d %d in r.%d.%d.mca]", $$15.f_45578_, SectionPos.m_123171_($$7.m_123342_()), $$15.f_45579_, $$15.m_45613_(), $$15.m_45614_(), $$15.m_45610_(), $$15.m_45612_()));
        $$18.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", $$9, $$14, Float.valueOf(Mth.m_14177_($$8.m_146908_())), Float.valueOf(Mth.m_14177_($$8.m_146909_()))));
        LevelChunk $$20 = this.m_94085_();
        if ($$20.m_6430_()) {
            $$18.add("Waiting for chunk...");
        } else {
            int $$21 = this.f_94030_.f_91073_.m_7726_().m_7827_().m_75831_($$7, 0);
            int $$22 = this.f_94030_.f_91073_.m_45517_(LightLayer.SKY, $$7);
            int $$23 = this.f_94030_.f_91073_.m_45517_(LightLayer.BLOCK, $$7);
            $$18.add("Client Light: " + $$21 + " (" + $$22 + " sky, " + $$23 + " block)");
            LevelChunk $$24 = this.m_94084_();
            StringBuilder $$25 = new StringBuilder("CH");
            for (Heightmap.Types $$26 : Heightmap.Types.values()) {
                if (!$$26.m_64297_()) continue;
                $$25.append(" ").append(f_94029_.get($$26)).append(": ").append($$20.m_5885_($$26, $$7.m_123341_(), $$7.m_123343_()));
            }
            $$18.add($$25.toString());
            $$25.setLength(0);
            $$25.append("SH");
            for (Heightmap.Types $$27 : Heightmap.Types.values()) {
                if (!$$27.m_64298_()) continue;
                $$25.append(" ").append(f_94029_.get($$27)).append(": ");
                if ($$24 != null) {
                    $$25.append($$24.m_5885_($$27, $$7.m_123341_(), $$7.m_123343_()));
                    continue;
                }
                $$25.append("??");
            }
            $$18.add($$25.toString());
            if ($$7.m_123342_() >= this.f_94030_.f_91073_.m_141937_() && $$7.m_123342_() < this.f_94030_.f_91073_.m_151558_()) {
                $$18.add("Biome: " + DebugScreenOverlay.m_205374_(this.f_94030_.f_91073_.m_204166_($$7)));
                if ($$24 != null) {
                    float $$28 = $$16.m_46940_();
                    long $$29 = $$24.m_6319_();
                    DifficultyInstance $$30 = new DifficultyInstance($$16.m_46791_(), $$16.m_46468_(), $$29, $$28);
                    $$18.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf($$30.m_19056_()), Float.valueOf($$30.m_19057_()), this.f_94030_.f_91073_.m_46468_() / 24000L));
                } else {
                    $$18.add("Local Difficulty: ??");
                }
            }
            if ($$24 != null && $$24.m_187675_()) {
                $$18.add("Blending: Old");
            }
        }
        ServerLevel $$31 = this.m_94081_();
        if ($$31 != null) {
            ServerChunkCache $$32 = $$31.m_7726_();
            ChunkGenerator $$33 = $$32.m_8481_();
            RandomState $$34 = $$32.m_214994_();
            $$33.m_213600_($$18, $$34, $$7);
            Climate.Sampler $$35 = $$34.m_224579_();
            BiomeSource $$36 = $$33.m_62218_();
            $$36.m_207301_($$18, $$7, $$35);
            NaturalSpawner.SpawnState $$37 = $$32.m_8485_();
            if ($$37 != null) {
                Object2IntMap<MobCategory> $$38 = $$37.m_47148_();
                int $$39 = $$37.m_47126_();
                $$18.add("SC: " + $$39 + ", " + Stream.of(MobCategory.values()).map(p_94068_ -> Character.toUpperCase(p_94068_.m_21607_().charAt(0)) + ": " + $$38.getInt(p_94068_)).collect(Collectors.joining(", ")));
            } else {
                $$18.add("SC: N/A");
            }
        }
        if (($$40 = this.f_94030_.f_91063_.m_109149_()) != null) {
            $$18.add("Shader: " + $$40.m_110022_());
        }
        $$18.add(this.f_94030_.m_91106_().m_120408_() + String.format(Locale.ROOT, " (Mood %d%%)", Math.round(this.f_94030_.f_91074_.m_108762_() * 100.0f)));
        return $$18;
    }

    private static String m_205374_(Holder<Biome> p_205375_) {
        return (String)p_205375_.m_203439_().map(p_205377_ -> p_205377_.m_135782_().toString(), p_205367_ -> "[unregistered " + p_205367_ + "]");
    }

    @Nullable
    private ServerLevel m_94081_() {
        IntegratedServer $$0 = this.f_94030_.m_91092_();
        if ($$0 != null) {
            return $$0.m_129880_(this.f_94030_.f_91073_.m_46472_());
        }
        return null;
    }

    @Nullable
    private String m_94082_() {
        ServerLevel $$0 = this.m_94081_();
        if ($$0 != null) {
            return $$0.m_46464_();
        }
        return null;
    }

    private Level m_94083_() {
        return (Level)DataFixUtils.orElse(Optional.ofNullable(this.f_94030_.m_91092_()).flatMap(p_288242_ -> Optional.ofNullable(p_288242_.m_129880_(this.f_94030_.f_91073_.m_46472_()))), (Object)this.f_94030_.f_91073_);
    }

    @Nullable
    private LevelChunk m_94084_() {
        if (this.f_94036_ == null) {
            ServerLevel $$0 = this.m_94081_();
            if ($$0 == null) {
                return null;
            }
            this.f_94036_ = $$0.m_7726_().m_8431_(this.f_94034_.f_45578_, this.f_94034_.f_45579_, ChunkStatus.f_62326_, false).thenApply(p_205369_ -> (LevelChunk)p_205369_.map(p_205371_ -> (LevelChunk)p_205371_, p_205363_ -> null));
        }
        return this.f_94036_.getNow(null);
    }

    private LevelChunk m_94085_() {
        if (this.f_94035_ == null) {
            this.f_94035_ = this.f_94030_.f_91073_.m_6325_(this.f_94034_.f_45578_, this.f_94034_.f_45579_);
        }
        return this.f_94035_;
    }

    protected List<String> m_94078_() {
        Entity $$11;
        long $$0 = Runtime.getRuntime().maxMemory();
        long $$1 = Runtime.getRuntime().totalMemory();
        long $$2 = Runtime.getRuntime().freeMemory();
        long $$3 = $$1 - $$2;
        ArrayList $$4 = Lists.newArrayList((Object[])new String[]{String.format(Locale.ROOT, "Java: %s %dbit", System.getProperty("java.version"), this.f_94030_.m_91103_() ? 64 : 32), String.format(Locale.ROOT, "Mem: % 2d%% %03d/%03dMB", $$3 * 100L / $$0, DebugScreenOverlay.m_94050_($$3), DebugScreenOverlay.m_94050_($$0)), String.format(Locale.ROOT, "Allocation rate: %03dMB /s", DebugScreenOverlay.m_94050_(this.f_232506_.m_232516_($$3))), String.format(Locale.ROOT, "Allocated: % 2d%% %03dMB", $$1 * 100L / $$0, DebugScreenOverlay.m_94050_($$1)), "", String.format(Locale.ROOT, "CPU: %s", GlUtil.m_84819_()), "", String.format(Locale.ROOT, "Display: %dx%d (%s)", Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_(), GlUtil.m_84818_()), GlUtil.m_84820_(), GlUtil.m_84821_()});
        if (this.f_94030_.m_91299_()) {
            return $$4;
        }
        if (this.f_94032_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos $$5 = ((BlockHitResult)this.f_94032_).m_82425_();
            BlockState $$6 = this.f_94030_.f_91073_.m_8055_($$5);
            $$4.add("");
            $$4.add(ChatFormatting.UNDERLINE + "Targeted Block: " + $$5.m_123341_() + ", " + $$5.m_123342_() + ", " + $$5.m_123343_());
            $$4.add(String.valueOf(BuiltInRegistries.f_256975_.m_7981_($$6.m_60734_())));
            for (Map.Entry $$7 : $$6.m_61148_().entrySet()) {
                $$4.add(this.m_94071_($$7));
            }
            $$6.m_204343_().map(p_205365_ -> "#" + p_205365_.f_203868_()).forEach($$4::add);
        }
        if (this.f_94033_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos $$8 = ((BlockHitResult)this.f_94033_).m_82425_();
            FluidState $$9 = this.f_94030_.f_91073_.m_6425_($$8);
            $$4.add("");
            $$4.add(ChatFormatting.UNDERLINE + "Targeted Fluid: " + $$8.m_123341_() + ", " + $$8.m_123342_() + ", " + $$8.m_123343_());
            $$4.add(String.valueOf(BuiltInRegistries.f_257020_.m_7981_($$9.m_76152_())));
            for (Map.Entry $$10 : $$9.m_61148_().entrySet()) {
                $$4.add(this.m_94071_($$10));
            }
            $$9.m_205075_().map(p_205379_ -> "#" + p_205379_.f_203868_()).forEach($$4::add);
        }
        if (($$11 = this.f_94030_.f_91076_) != null) {
            $$4.add("");
            $$4.add(ChatFormatting.UNDERLINE + "Targeted Entity");
            $$4.add(String.valueOf(BuiltInRegistries.f_256780_.m_7981_($$11.m_6095_())));
        }
        return $$4;
    }

    private String m_94071_(Map.Entry<Property<?>, Comparable<?>> p_94072_) {
        Property<?> $$1 = p_94072_.getKey();
        Comparable<?> $$2 = p_94072_.getValue();
        Object $$3 = Util.m_137453_($$1, $$2);
        if (Boolean.TRUE.equals($$2)) {
            $$3 = ChatFormatting.GREEN + (String)$$3;
        } else if (Boolean.FALSE.equals($$2)) {
            $$3 = ChatFormatting.RED + (String)$$3;
        }
        return $$1.m_61708_() + ": " + (String)$$3;
    }

    private static long m_94050_(long p_94051_) {
        return p_94051_ / 1024L / 1024L;
    }

    public boolean m_294516_() {
        return this.f_291101_ && !this.f_94030_.f_91066_.f_92062_;
    }

    public boolean m_295669_() {
        return this.m_294516_() && this.f_291871_;
    }

    public boolean m_295643_() {
        return this.m_294516_() && this.f_291005_;
    }

    public void m_293034_() {
        this.f_291101_ = !this.f_291101_;
    }

    public void m_295292_() {
        boolean bl = this.f_291005_ = !this.f_291101_ || !this.f_291005_;
        if (this.f_291005_) {
            this.f_291101_ = true;
            this.f_290551_ = false;
        }
    }

    public void m_294611_() {
        boolean bl = this.f_290551_ = !this.f_291101_ || !this.f_290551_;
        if (this.f_290551_) {
            this.f_291101_ = true;
            this.f_291005_ = false;
        }
    }

    public void m_293481_() {
        boolean bl = this.f_291871_ = !this.f_291101_ || !this.f_291871_;
        if (this.f_291871_) {
            this.f_291101_ = true;
        }
    }

    public void m_294107_(long p_300948_) {
        this.f_291039_.m_293076_(p_300948_);
    }

    public void m_295254_(long p_298156_) {
        this.f_291524_.m_293076_(p_298156_);
    }

    public SampleLogger m_294664_() {
        return this.f_290653_;
    }

    public SampleLogger m_293273_() {
        return this.f_290862_;
    }

    public void m_294940_() {
        this.f_291101_ = false;
        this.f_291524_.m_295384_();
        this.f_290653_.m_295384_();
        this.f_290862_.m_295384_();
    }

    static class AllocationRateCalculator {
        private static final int f_232507_ = 500;
        private static final List<GarbageCollectorMXBean> f_232508_ = ManagementFactory.getGarbageCollectorMXBeans();
        private long f_232509_ = 0L;
        private long f_232510_ = -1L;
        private long f_232511_ = -1L;
        private long f_232512_ = 0L;

        AllocationRateCalculator() {
        }

        long m_232516_(long p_232517_) {
            long $$1 = System.currentTimeMillis();
            if ($$1 - this.f_232509_ < 500L) {
                return this.f_232512_;
            }
            long $$2 = AllocationRateCalculator.m_232515_();
            if (this.f_232509_ != 0L && $$2 == this.f_232511_) {
                double $$3 = (double)TimeUnit.SECONDS.toMillis(1L) / (double)($$1 - this.f_232509_);
                long $$4 = p_232517_ - this.f_232510_;
                this.f_232512_ = Math.round((double)$$4 * $$3);
            }
            this.f_232509_ = $$1;
            this.f_232510_ = p_232517_;
            this.f_232511_ = $$2;
            return this.f_232512_;
        }

        private static long m_232515_() {
            long $$0 = 0L;
            for (GarbageCollectorMXBean $$1 : f_232508_) {
                $$0 += $$1.getCollectionCount();
            }
            return $$0;
        }
    }
}

